/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.system;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.BaseProcessHandler;
import com.intellij.execution.process.CapturingProcessHandler;
import com.intellij.execution.process.ColoredProcessHandler;
import com.intellij.execution.process.ElevationService;
import com.intellij.execution.process.KillableProcessHandler;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.OSProcessUtil;
import com.intellij.execution.process.ProcessInfo;
import com.intellij.execution.process.UnixProcessManager;
import com.intellij.execution.process.WinRunnerMediator;
import com.intellij.execution.util.ExecUtil;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.Alarm;
import com.intellij.util.io.BaseOutputReader;
import com.jetbrains.cidr.CidrUtilsExecutionBundle;
import com.jetbrains.cidr.NamedPipe;
import com.jetbrains.cidr.execution.CidrRunProcessUtil;
import com.jetbrains.cidr.system.CidrProcessBuilder;
import com.jetbrains.cidr.system.HostMachine;
import com.jetbrains.cidr.system.HostUtilKt;
import com.jetbrains.cidr.toolchains.OSType;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LocalHost
implements HostMachine {
    public static final LocalHost INSTANCE = new LocalHost();
    private static final Logger LOG = Logger.getInstance(LocalHost.class);
    private static final int SUDO_KILL_DELAY_MILLIS = 1000;

    @Override
    public boolean isRemote() {
        return false;
    }

    @Override
    public boolean hasRemoteFS() {
        return false;
    }

    @Override
    @NotNull
    public OSType getOSType() {
        OSType oSType = OSType.getCurrent();
        if (oSType == null) {
            LocalHost.$$$reportNull$$$0(0);
        }
        return oSType;
    }

    @Override
    @NotNull
    public CidrProcessBuilder createProcessBuilder() {
        return new CidrProcessBuilder(){

            @Override
            @NotNull
            protected BaseProcessHandler<?> build(@NotNull GeneralCommandLine cl, @NotNull CidrProcessBuilder.Parameters params) throws ExecutionException {
                if (cl == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (params == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (params.getUseExternalConsole() && SystemInfo.isWindows) {
                    WinRunnerMediator.withExternalConsole((GeneralCommandLine)cl);
                }
                Object processHandler = params.isElevated() ? (Registry.is((String)"cidr.elevation.daemon.enabled", (boolean)true) ? ElevationService.getInstance().createProcessHandler(cl) : LocalHost.createElevatedProcess(cl)) : (params.isEmulateTerminal() ? new TerminalEmulatorOSProcessHandler(cl) : (params.isColored() ? new ParameterizedColoredProcessHandler(cl, params) : (params.isCapturedOutput() ? new ParameterizedCapturingProcessHandler(cl, params) : new ParameterizedOSProcessHandler(cl, params))));
                CidrRunProcessUtil.setHasPty(processHandler, params.isPty());
                Object object = processHandler;
                if (object == null) {
                    1.$$$reportNull$$$0(2);
                }
                return object;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 2 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "cl";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "params";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/jetbrains/cidr/system/LocalHost$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/jetbrains/cidr/system/LocalHost$1";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "build";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "build";
                        break;
                    }
                    case 2: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 2 -> new IllegalStateException(string);
                };
            }
        };
    }

    private static void runSudoKill(@NotNull Process process) {
        if (process == null) {
            LocalHost.$$$reportNull$$$0(1);
        }
        if (process.isAlive()) {
            long pid = process.pid();
            GeneralCommandLine killCommand = new GeneralCommandLine(new String[]{"kill", Long.toString(pid)});
            try {
                ExecUtil.sudo((GeneralCommandLine)killCommand, (String)CidrUtilsExecutionBundle.message("sudo.prompt", new Object[0]));
            }
            catch (ExecutionException | IOException e) {
                LOG.error("Can't kill the process " + pid, e);
            }
        }
    }

    @NotNull
    private static OSProcessHandler createElevatedProcess(GeneralCommandLine cl) throws ExecutionException {
        try {
            cl = ExecUtil.sudoCommand((GeneralCommandLine)cl, (String)CidrUtilsExecutionBundle.message("sudo.prompt", new Object[0]));
        }
        catch (IOException e) {
            throw new ExecutionException(CidrUtilsExecutionBundle.message("sudo.error", cl), (Throwable)e);
        }
        Object processHandler = SystemInfo.isWindows ? new OSProcessHandler(cl) : new KillableProcessHandler(cl){
            final Alarm sudoKillAlarm = new Alarm();

            private void scheduleSudoKill() {
                this.sudoKillAlarm.addRequest(() -> LocalHost.runSudoKill(this.getProcess()), 1000, ModalityState.any());
            }

            protected void doDestroyProcess() {
                this.scheduleSudoKill();
                super.doDestroyProcess();
            }

            public void killProcess() {
                this.scheduleSudoKill();
                super.killProcess();
            }

            protected void onOSProcessTerminated(int exitCode) {
                this.sudoKillAlarm.cancelAllRequests();
                super.onOSProcessTerminated(exitCode);
            }
        };
        Object object = processHandler;
        if (object == null) {
            LocalHost.$$$reportNull$$$0(2);
        }
        return object;
    }

    public void destroyProcess(@NotNull BaseProcessHandler handler) {
        if (handler == null) {
            LocalHost.$$$reportNull$$$0(3);
        }
        handler.destroyProcess();
    }

    public void killProcessTree(@NotNull BaseProcessHandler handler) {
        if (handler == null) {
            LocalHost.$$$reportNull$$$0(4);
        }
        OSProcessUtil.killProcessTree((Process)handler.getProcess());
    }

    @Override
    @NotNull
    public List<ProcessInfo> getProcessList() {
        List<ProcessInfo> list = Arrays.asList(OSProcessUtil.getProcessList());
        if (list == null) {
            LocalHost.$$$reportNull$$$0(5);
        }
        return list;
    }

    @Override
    public int sendSignal(int pid, @NotNull String signalName) {
        if (signalName == null) {
            LocalHost.$$$reportNull$$$0(6);
        }
        if (this.getOSType() == OSType.WIN) {
            throw new UnsupportedOperationException("Not supported for Windows OS, use winbreak instead");
        }
        return UnixProcessManager.sendSignal((int)pid, (String)signalName);
    }

    @Override
    @NotNull
    public Path getPath(String first, String ... more) {
        Path path = Paths.get(first, more);
        if (path == null) {
            LocalHost.$$$reportNull$$$0(7);
        }
        return path;
    }

    @Override
    @NotNull
    public @NotNull String @NotNull [] toCanonicalPath(@NotNull List<@NonNls String> paths, boolean resolveSymlink) {
        if (paths == null) {
            LocalHost.$$$reportNull$$$0(8);
        }
        String[] result2 = new String[paths.size()];
        for (int i = 0; i < paths.size(); ++i) {
            result2[i] = FileUtil.toCanonicalPath((String)paths.get(i), (boolean)resolveSymlink);
        }
        if (result2 == null) {
            LocalHost.$$$reportNull$$$0(9);
        }
        return result2;
    }

    @Override
    @NotNull
    public Path getTempDirectory() {
        Path path = Paths.get(FileUtil.getTempDirectory(), new String[0]);
        if (path == null) {
            LocalHost.$$$reportNull$$$0(10);
        }
        return path;
    }

    @Override
    @NotNull
    public Path createTempDirectory(@NotNull String prefix, @Nullable String suffix) throws IOException {
        if (prefix == null) {
            LocalHost.$$$reportNull$$$0(11);
        }
        Path path = FileUtil.createTempDirectory((String)prefix, (String)suffix).toPath();
        if (path == null) {
            LocalHost.$$$reportNull$$$0(12);
        }
        return path;
    }

    @Override
    @NotNull
    public NamedPipe openNamedPipe() throws ExecutionException {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public File resolvePath(@NotNull Path file) {
        if (file == null) {
            LocalHost.$$$reportNull$$$0(13);
        }
        File file2 = file.toFile();
        if (file2 == null) {
            LocalHost.$$$reportNull$$$0(14);
        }
        return file2;
    }

    @Override
    @NotNull
    public File resolvePath(@NotNull File file) {
        if (file == null) {
            LocalHost.$$$reportNull$$$0(15);
        }
        File file2 = file;
        if (file2 == null) {
            LocalHost.$$$reportNull$$$0(16);
        }
        return file2;
    }

    @Override
    @NotNull
    public List<String> resolveAndCache(@NotNull List<String> paths) {
        if (paths == null) {
            LocalHost.$$$reportNull$$$0(17);
        }
        List<String> list = paths;
        if (list == null) {
            LocalHost.$$$reportNull$$$0(18);
        }
        return list;
    }

    @Override
    @NotNull
    public String getHostId() {
        return "__localhost_machine__";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 3, 4, 6, 8, 11, 13, 15, 17 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/system/LocalHost";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "process";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "signalName";
                break;
            }
            case 8: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paths";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getOSType";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 11: 
            case 13: 
            case 15: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/system/LocalHost";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createElevatedProcess";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getProcessList";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getPath";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "toCanonicalPath";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getTempDirectory";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "createTempDirectory";
                break;
            }
            case 14: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "resolvePath";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveAndCache";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "runSudoKill";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "destroyProcess";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "killProcessTree";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "sendSignal";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "toCanonicalPath";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createTempDirectory";
                break;
            }
            case 13: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "resolvePath";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "resolveAndCache";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 3, 4, 6, 8, 11, 13, 15, 17 -> new IllegalArgumentException(string);
        };
    }

    @FunctionalInterface
    static interface EnvironmentProducer {
        public Map<String, String> getEnvironment() throws IOException;
    }

    public static class TerminalEmulatorOSProcessHandler
    extends OSProcessHandler {
        public TerminalEmulatorOSProcessHandler(@NotNull Process process, @NotNull GeneralCommandLine commandLine) {
            if (process == null) {
                TerminalEmulatorOSProcessHandler.$$$reportNull$$$0(0);
            }
            if (commandLine == null) {
                TerminalEmulatorOSProcessHandler.$$$reportNull$$$0(1);
            }
            super(process, commandLine.getCommandLineString(), commandLine.getCharset());
        }

        public TerminalEmulatorOSProcessHandler(@NotNull GeneralCommandLine commandLine) throws ExecutionException {
            if (commandLine == null) {
                TerminalEmulatorOSProcessHandler.$$$reportNull$$$0(2);
            }
            super(commandLine);
        }

        @NotNull
        protected BaseOutputReader.Options readerOptions() {
            BaseOutputReader.Options options = BaseOutputReader.Options.forTerminalPtyProcess();
            if (options == null) {
                TerminalEmulatorOSProcessHandler.$$$reportNull$$$0(3);
            }
            return options;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "process";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "commandLine";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/system/LocalHost$TerminalEmulatorOSProcessHandler";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/system/LocalHost$TerminalEmulatorOSProcessHandler";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "readerOptions";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3 -> new IllegalStateException(string);
            };
        }
    }

    public static class ParameterizedOSProcessHandler
    extends OSProcessHandler {
        @NotNull
        private final CidrProcessBuilder.Parameters myParameters;

        public ParameterizedOSProcessHandler(@NotNull GeneralCommandLine commandLine, @NotNull CidrProcessBuilder.Parameters parameters) throws ExecutionException {
            if (commandLine == null) {
                ParameterizedOSProcessHandler.$$$reportNull$$$0(0);
            }
            if (parameters == null) {
                ParameterizedOSProcessHandler.$$$reportNull$$$0(1);
            }
            super(commandLine);
            this.myParameters = parameters;
        }

        public ParameterizedOSProcessHandler(@NotNull Process process, @NotNull GeneralCommandLine commandLine, @NotNull CidrProcessBuilder.Parameters parameters) throws ExecutionException {
            if (process == null) {
                ParameterizedOSProcessHandler.$$$reportNull$$$0(2);
            }
            if (commandLine == null) {
                ParameterizedOSProcessHandler.$$$reportNull$$$0(3);
            }
            if (parameters == null) {
                ParameterizedOSProcessHandler.$$$reportNull$$$0(4);
            }
            super(process, commandLine.getCommandLineString(), commandLine.getCharset());
            this.myParameters = parameters;
        }

        @NotNull
        protected BaseOutputReader.Options readerOptions() {
            BaseOutputReader.Options options = HostUtilKt.readerOptions(this.myParameters, super.readerOptions());
            if (options == null) {
                ParameterizedOSProcessHandler.$$$reportNull$$$0(5);
            }
            return options;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 5 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "commandLine";
                    break;
                }
                case 1: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parameters";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "process";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/system/LocalHost$ParameterizedOSProcessHandler";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/system/LocalHost$ParameterizedOSProcessHandler";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "readerOptions";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 5: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 5 -> new IllegalStateException(string);
            };
        }
    }

    public static class ParameterizedCapturingProcessHandler
    extends CapturingProcessHandler {
        @NotNull
        private final CidrProcessBuilder.Parameters myParameters;

        public ParameterizedCapturingProcessHandler(@NotNull GeneralCommandLine commandLine, @NotNull CidrProcessBuilder.Parameters parameters) throws ExecutionException {
            if (commandLine == null) {
                ParameterizedCapturingProcessHandler.$$$reportNull$$$0(0);
            }
            if (parameters == null) {
                ParameterizedCapturingProcessHandler.$$$reportNull$$$0(1);
            }
            super(commandLine);
            this.myParameters = parameters;
        }

        public ParameterizedCapturingProcessHandler(@NotNull Process process, @NotNull GeneralCommandLine commandLine, @NotNull CidrProcessBuilder.Parameters parameters) throws ExecutionException {
            if (process == null) {
                ParameterizedCapturingProcessHandler.$$$reportNull$$$0(2);
            }
            if (commandLine == null) {
                ParameterizedCapturingProcessHandler.$$$reportNull$$$0(3);
            }
            if (parameters == null) {
                ParameterizedCapturingProcessHandler.$$$reportNull$$$0(4);
            }
            super(process, commandLine.getCharset(), commandLine.getCommandLineString());
            this.myParameters = parameters;
        }

        @NotNull
        protected BaseOutputReader.Options readerOptions() {
            BaseOutputReader.Options options = HostUtilKt.readerOptions(this.myParameters, super.readerOptions());
            if (options == null) {
                ParameterizedCapturingProcessHandler.$$$reportNull$$$0(5);
            }
            return options;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 5 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "commandLine";
                    break;
                }
                case 1: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parameters";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "process";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/system/LocalHost$ParameterizedCapturingProcessHandler";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/system/LocalHost$ParameterizedCapturingProcessHandler";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "readerOptions";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 5: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 5 -> new IllegalStateException(string);
            };
        }
    }

    public static class ParameterizedColoredProcessHandler
    extends ColoredProcessHandler {
        @NotNull
        private final CidrProcessBuilder.Parameters myParameters;

        public ParameterizedColoredProcessHandler(@NotNull GeneralCommandLine commandLine, @NotNull CidrProcessBuilder.Parameters parameters) throws ExecutionException {
            if (commandLine == null) {
                ParameterizedColoredProcessHandler.$$$reportNull$$$0(0);
            }
            if (parameters == null) {
                ParameterizedColoredProcessHandler.$$$reportNull$$$0(1);
            }
            super(commandLine);
            this.myParameters = parameters;
        }

        public ParameterizedColoredProcessHandler(@NotNull Process process, @NotNull GeneralCommandLine commandLine, @NotNull CidrProcessBuilder.Parameters parameters) throws ExecutionException {
            if (process == null) {
                ParameterizedColoredProcessHandler.$$$reportNull$$$0(2);
            }
            if (commandLine == null) {
                ParameterizedColoredProcessHandler.$$$reportNull$$$0(3);
            }
            if (parameters == null) {
                ParameterizedColoredProcessHandler.$$$reportNull$$$0(4);
            }
            super(process, commandLine.getCommandLineString(), commandLine.getCharset());
            this.myParameters = parameters;
        }

        @NotNull
        protected BaseOutputReader.Options readerOptions() {
            BaseOutputReader.Options options = HostUtilKt.readerOptions(this.myParameters, super.readerOptions());
            if (options == null) {
                ParameterizedColoredProcessHandler.$$$reportNull$$$0(5);
            }
            return options;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 5 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "commandLine";
                    break;
                }
                case 1: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parameters";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "process";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/system/LocalHost$ParameterizedColoredProcessHandler";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/system/LocalHost$ParameterizedColoredProcessHandler";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "readerOptions";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 5: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 5 -> new IllegalStateException(string);
            };
        }
    }
}

