/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.backend.lldb;

import com.jetbrains.cidr.execution.debugger.CidrDebuggerLog;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\bH\u0002J\u000e\u0010\u0010\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\bJ\u000e\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\bR6\u0010\u0003\u001a*\u0012&\u0012$\u0012\u0004\u0012\u00020\u0006\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\b0\u00070\u0005j\u0002`\n0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/jetbrains/cidr/execution/debugger/backend/lldb/LLDBErrorBeautifier;", "", "()V", "myReplacers", "", "Lkotlin/Pair;", "Ljava/util/regex/Pattern;", "Lkotlin/Function2;", "", "Ljava/util/regex/Matcher;", "Lcom/jetbrains/cidr/execution/debugger/backend/lldb/Replacer;", "logPatchedMessage", "", "context", "message", "newMessage", "patchEvaluateMessage", "patchLoadValueMessage", "errorMessage", "intellij.cidr.debugger"})
public final class LLDBErrorBeautifier {
    @NotNull
    private final List<Pair<Pattern, Function2<String, Matcher, String>>> myReplacers;

    public LLDBErrorBeautifier() {
        List replacers = new ArrayList();
        Collection collection = replacers;
        Pattern pattern = Pattern.compile("^warning: Stopped in a C\\+\\+ method, but 'this' isn't available; pretending we are in a generic context\nerror:");
        Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"compile(...)");
        Pair pair = new Pair((Object)pattern, (Object)1.INSTANCE);
        collection.add(pair);
        collection = replacers;
        Pattern pattern2 = Pattern.compile("^error: invalid use of 'this' outside of a non-static member function\\s*$");
        Intrinsics.checkNotNullExpressionValue((Object)pattern2, (String)"compile(...)");
        pair = new Pair((Object)pattern2, (Object)2.INSTANCE);
        collection.add(pair);
        collection = replacers;
        Pattern pattern3 = Pattern.compile("^error: Couldn't materialize: couldn't get the value of variable (\\w+): variable not available");
        Intrinsics.checkNotNullExpressionValue((Object)pattern3, (String)"compile(...)");
        pair = new Pair((Object)pattern3, (Object)3.INSTANCE);
        collection.add(pair);
        collection = replacers;
        Pattern pattern4 = Pattern.compile("^error: no member named '(.+)' in '(.+)'\\s*$");
        Intrinsics.checkNotNullExpressionValue((Object)pattern4, (String)"compile(...)");
        pair = new Pair((Object)pattern4, (Object)4.INSTANCE);
        collection.add(pair);
        collection = replacers;
        Pattern pattern5 = Pattern.compile("^error: use of undeclared identifier '(.+)'\\s*$");
        Intrinsics.checkNotNullExpressionValue((Object)pattern5, (String)"compile(...)");
        pair = new Pair((Object)pattern5, (Object)5.INSTANCE);
        collection.add(pair);
        this.myReplacers = replacers;
    }

    @NotNull
    public final String patchEvaluateMessage(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        for (Pair<Pattern, Function2<String, Matcher, String>> replacer : this.myReplacers) {
            Matcher matcher = ((Pattern)replacer.getFirst()).matcher(message);
            if (!matcher.find()) continue;
            Function2 function2 = (Function2)replacer.getSecond();
            Intrinsics.checkNotNull((Object)matcher);
            String newMessage = (String)function2.invoke((Object)message, (Object)matcher);
            this.logPatchedMessage("evaluation", message, newMessage);
            return newMessage;
        }
        return message;
    }

    @NotNull
    public final String patchLoadValueMessage(@NotNull String errorMessage) {
        Intrinsics.checkNotNullParameter((Object)errorMessage, (String)"errorMessage");
        if (Intrinsics.areEqual((Object)errorMessage, (Object)"variable not available")) {
            return "Variable is not available";
        }
        return errorMessage;
    }

    private final void logPatchedMessage(String context, String message, String newMessage) {
        CidrDebuggerLog.LOG.debug("Masking " + context + " error message '" + message + "' as '" + newMessage + "'");
    }
}

