/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.backend.gdb;

import com.jetbrains.cidr.execution.debugger.CidrDebuggerLog;
import com.jetbrains.cidr.execution.debugger.backend.LLValue;
import com.jetbrains.cidr.execution.debugger.backend.features.RawViewSupport;
import com.jetbrains.cidr.execution.debugger.backend.gdb.GDBDriver;
import com.jetbrains.cidr.execution.debugger.backend.gdb.GdbNode;
import com.jetbrains.cidr.execution.debugger.backend.gdb.GdbNodePath;
import com.jetbrains.cidr.execution.debugger.backend.gdb.GdbRawViewSupportKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u001e\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u0011J\b\u0010\u0012\u001a\u00020\fH\u0016J\u0010\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u000e\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u000fJ\u0010\u0010\u0016\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\fH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R&\u0010\u0007\u001a\u001a\u0012\u0004\u0012\u00020\t\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/jetbrains/cidr/execution/debugger/backend/gdb/GdbRawViewSupport;", "Lcom/jetbrains/cidr/execution/debugger/backend/features/RawViewSupport;", "driver", "Lcom/jetbrains/cidr/execution/debugger/backend/gdb/GDBDriver;", "(Lcom/jetbrains/cidr/execution/debugger/backend/gdb/GDBDriver;)V", "getDriver", "()Lcom/jetbrains/cidr/execution/debugger/backend/gdb/GDBDriver;", "myRaw", "Ljava/util/concurrent/ConcurrentHashMap;", "Lcom/jetbrains/cidr/execution/debugger/backend/gdb/GdbNodePath;", "", "Lcom/jetbrains/cidr/execution/debugger/backend/gdb/GdbNode;", "", "getRawChildrenNames", "", "", "value", "Lcom/jetbrains/cidr/execution/debugger/backend/LLValue;", "isEnabled", "isRawViewEnabled", "isRawViewEnabledForExpression", "expr", "isRawViewSupported", "setRawViewEnabled", "", "enabled", "intellij.cidr.debugger"})
@SourceDebugExtension(value={"SMAP\nGdbRawViewSupport.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GdbRawViewSupport.kt\ncom/jetbrains/cidr/execution/debugger/backend/gdb/GdbRawViewSupport\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,158:1\n135#2,9:159\n215#2:168\n216#2:170\n144#2:171\n1#3:169\n*S KotlinDebug\n*F\n+ 1 GdbRawViewSupport.kt\ncom/jetbrains/cidr/execution/debugger/backend/gdb/GdbRawViewSupport\n*L\n68#1:159,9\n68#1:168\n68#1:170\n68#1:171\n68#1:169\n*E\n"})
public final class GdbRawViewSupport
implements RawViewSupport {
    @NotNull
    private final GDBDriver driver;
    @NotNull
    private final ConcurrentHashMap<GdbNodePath, Map<GdbNode, Boolean>> myRaw;

    public GdbRawViewSupport(@NotNull GDBDriver driver) {
        Intrinsics.checkNotNullParameter((Object)driver, (String)"driver");
        this.driver = driver;
        this.myRaw = new ConcurrentHashMap();
    }

    @NotNull
    public final GDBDriver getDriver() {
        return this.driver;
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    @Override
    public boolean isRawViewSupported(@NotNull LLValue value) {
        Intrinsics.checkNotNullParameter((Object)((Object)value), (String)"value");
        Pair pair = GdbRawViewSupportKt.access$pathToValue(value);
        GdbNodePath parentPath = (GdbNodePath)pair.component1();
        GdbNode leaf = (GdbNode)pair.component2();
        if (leaf == null) {
            return false;
        }
        Map<GdbNode, Boolean> map = this.myRaw.get(parentPath);
        if (map != null ? Intrinsics.areEqual((Object)map.get(leaf), (Object)true) : false) {
            return true;
        }
        Object t = this.driver.executeCommand(() -> GdbRawViewSupport.isRawViewSupported$lambda$0(this, value));
        Intrinsics.checkNotNullExpressionValue(t, (String)"executeCommand(...)");
        return (Boolean)t;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isRawViewEnabled(@NotNull LLValue value) {
        Intrinsics.checkNotNullParameter((Object)((Object)value), (String)"value");
        Pair pair = GdbRawViewSupportKt.access$pathToValue(value);
        GdbNodePath parentPath = (GdbNodePath)pair.component1();
        GdbNode leaf = (GdbNode)pair.component2();
        if (leaf == null) return false;
        Map<GdbNode, Boolean> map = this.myRaw.get(parentPath);
        if (map == null) return false;
        boolean bl = Intrinsics.areEqual((Object)map.get(leaf), (Object)true);
        if (!bl) return false;
        return true;
    }

    @Override
    public void setRawViewEnabled(@NotNull LLValue value, boolean enabled) {
        Intrinsics.checkNotNullParameter((Object)((Object)value), (String)"value");
        Pair pair = GdbRawViewSupportKt.access$pathToValue(value);
        GdbNodePath parentPath = (GdbNodePath)pair.component1();
        GdbNode leaf = (GdbNode)pair.component2();
        if (leaf == null) {
            CidrDebuggerLog.LOG.debug("Cannot build path to value " + value);
            return;
        }
        this.driver.executeCommand(() -> GdbRawViewSupport.setRawViewEnabled$lambda$1(this, value, enabled, parentPath, leaf));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Collection<String> getRawChildrenNames(@NotNull LLValue value) {
        Collection collection;
        Intrinsics.checkNotNullParameter((Object)((Object)value), (String)"value");
        Pair pair = GdbRawViewSupportKt.access$pathToValue(value);
        GdbNodePath parentPath = (GdbNodePath)pair.component1();
        GdbNode leaf = (GdbNode)pair.component2();
        if (leaf == null) {
            return CollectionsKt.emptyList();
        }
        GdbNodePath valuePath = parentPath.append(leaf);
        Map<GdbNode, Boolean> map = this.myRaw.get(valuePath);
        if (map != null) {
            void $this$mapNotNullTo$iv$iv;
            Map<GdbNode, Boolean> $this$mapNotNull$iv = map;
            boolean $i$f$mapNotNull = false;
            Map<GdbNode, Boolean> map2 = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.entrySet().iterator();
            while (iterator2.hasNext()) {
                String string;
                Map.Entry element$iv$iv$iv;
                Map.Entry element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl = false;
                Map.Entry entry = element$iv$iv;
                boolean bl2 = false;
                GdbNode node = (GdbNode)entry.getKey();
                boolean raw = (Boolean)entry.getValue();
                if (raw) {
                    GdbNode.ChildNode childNode = node instanceof GdbNode.ChildNode ? (GdbNode.ChildNode)node : null;
                    string = childNode != null ? childNode.getChildName() : null;
                } else {
                    string = null;
                }
                if (string == null) continue;
                String it$iv$iv = string;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            collection = (List)destination$iv$iv;
        } else {
            collection = CollectionsKt.emptyList();
        }
        return collection;
    }

    public final boolean isRawViewEnabledForExpression(@NotNull String expr) {
        Intrinsics.checkNotNullParameter((Object)expr, (String)"expr");
        Map<GdbNode, Boolean> map = this.myRaw.get(GdbNodePath.Companion.getROOT());
        return map != null ? Intrinsics.areEqual((Object)map.get(new GdbNode.Watch(expr)), (Object)true) : false;
    }

    private static final Boolean isRawViewSupported$lambda$0(GdbRawViewSupport this$0, LLValue $value) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)((Object)$value), (String)"$value");
        GDBDriver.LLValueLoadedData lLValueLoadedData = this$0.driver.doLoadVariable($value);
        Intrinsics.checkNotNullExpressionValue((Object)lLValueLoadedData, (String)"doLoadVariable(...)");
        GDBDriver.LLValueLoadedData data = lLValueLoadedData;
        return data.isCidrVar && data.isDynamic;
    }

    private static final Void setRawViewEnabled$lambda$1(GdbRawViewSupport this$0, LLValue $value, boolean $enabled, GdbNodePath $parentPath, GdbNode $leaf) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)((Object)$value), (String)"$value");
        Intrinsics.checkNotNullParameter((Object)$parentPath, (String)"$parentPath");
        GDBDriver.LLValueLoadedData lLValueLoadedData = this$0.driver.doLoadVariable($value);
        Intrinsics.checkNotNullExpressionValue((Object)lLValueLoadedData, (String)"doLoadVariable(...)");
        GDBDriver.LLValueLoadedData data = lLValueLoadedData;
        if (!data.isCidrVar) {
            CidrDebuggerLog.LOG.debug("Cannot enable raw view for non-cidr valaue " + $value);
            return null;
        }
        this$0.driver.setCidrVarRawEnabled(data.id, $enabled);
        this$0.myRaw.putIfAbsent($parentPath, new ConcurrentHashMap());
        Map<GdbNode, Boolean> map = this$0.myRaw.get($parentPath);
        if (map != null) {
            map.put($leaf, $enabled);
        }
        this$0.driver.markCidrValueForReload($value);
        return null;
    }
}

