/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.backend.bin;

import com.intellij.util.system.CpuArch;
import com.intellij.util.system.OS;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u0004\u0018\u00010\u00072\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u0006H\u0007JB\u0010\f\u001a\u001a\u0012\u0004\u0012\u00020\u0005\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u00040\u00042\u0006\u0010\r\u001a\u00020\u000e2\u0018\u0010\u000f\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00100\u0004H\u0002J\u001a\u0010\b\u001a\u0004\u0018\u00010\u00072\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u0006H\u0007J\u001a\u0010\t\u001a\u0004\u0018\u00010\u00072\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u0006H\u0007R&\u0010\u0003\u001a\u001a\u0012\u0004\u0012\u00020\u0005\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\b\u001a\u001a\u0012\u0004\u0012\u00020\u0005\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\t\u001a\u001a\u0012\u0004\u0012\u00020\u0005\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/jetbrains/cidr/execution/debugger/backend/bin/UrlProvider;", "", "()V", "gdb", "", "Lcom/intellij/util/system/OS;", "Lcom/intellij/util/system/CpuArch;", "Ljava/net/URL;", "lldb", "lldbFrontend", "os", "arch", "generateUrls", "name", "", "osArchs", "", "intellij.cidr.debugger"})
@SourceDebugExtension(value={"SMAP\nUrlProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UrlProvider.kt\ncom/jetbrains/cidr/execution/debugger/backend/bin/UrlProvider\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,69:1\n125#2:70\n152#2,2:71\n154#2:79\n1271#3,2:73\n1285#3,4:75\n*S KotlinDebug\n*F\n+ 1 UrlProvider.kt\ncom/jetbrains/cidr/execution/debugger/backend/bin/UrlProvider\n*L\n40#1:70\n40#1:71,2\n40#1:79\n52#1:73,2\n52#1:75,4\n*E\n"})
public final class UrlProvider {
    @NotNull
    public static final UrlProvider INSTANCE = new UrlProvider();
    @NotNull
    private static final Map<OS, Map<CpuArch, URL>> gdb;
    @NotNull
    private static final Map<OS, Map<CpuArch, URL>> lldb;
    @NotNull
    private static final Map<OS, Map<CpuArch, URL>> lldbFrontend;

    private UrlProvider() {
    }

    @JvmStatic
    @Nullable
    public static final URL gdb(@NotNull OS os, @NotNull CpuArch arch) {
        Intrinsics.checkNotNullParameter((Object)os, (String)"os");
        Intrinsics.checkNotNullParameter((Object)arch, (String)"arch");
        Map<CpuArch, URL> map = gdb.get(os);
        return map != null ? map.get(arch) : null;
    }

    @JvmStatic
    @Nullable
    public static final URL lldb(@NotNull OS os, @NotNull CpuArch arch) {
        Intrinsics.checkNotNullParameter((Object)os, (String)"os");
        Intrinsics.checkNotNullParameter((Object)arch, (String)"arch");
        Map<CpuArch, URL> map = lldb.get(os);
        return map != null ? map.get(arch) : null;
    }

    @JvmStatic
    @Nullable
    public static final URL lldbFrontend(@NotNull OS os, @NotNull CpuArch arch) {
        Intrinsics.checkNotNullParameter((Object)os, (String)"os");
        Intrinsics.checkNotNullParameter((Object)arch, (String)"arch");
        Map<CpuArch, URL> map = lldbFrontend.get(os);
        return map != null ? map.get(arch) : null;
    }

    /*
     * WARNING - void declaration
     */
    private final Map<OS, Map<CpuArch, URL>> generateUrls(String name, Map<OS, ? extends List<? extends CpuArch>> osArchs) {
        void $this$mapTo$iv$iv;
        Properties properties;
        Properties $this$generateUrls_u24lambda_u242 = properties = new Properties();
        boolean bl = false;
        $this$generateUrls_u24lambda_u242.load(UrlProvider.class.getClassLoader().getResourceAsStream("bin." + name + ".properties"));
        Properties properties2 = properties;
        String urlBase = properties2.getProperty("urlBase");
        Map<OS, ? extends List<? extends CpuArch>> $this$map$iv = osArchs;
        boolean $i$f$map = false;
        Map<OS, ? extends List<? extends CpuArch>> map = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator2.next();
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            OS os = (OS)entry.getKey();
            List archs = (List)entry.getValue();
            UrlProvider urlProvider = INSTANCE;
            OS oS = os;
            boolean bl3 = false;
            String osName = switch (WhenMappings.$EnumSwitchMapping$0[os.ordinal()]) {
                case 1 -> "linux";
                case 2 -> "mac";
                case 3 -> "win";
                default -> throw new IllegalArgumentException(os.name() + " os is not supported");
            };
            String string = properties2.getProperty(osName + "@hash");
            if (string == null) {
                string = properties2.getProperty("hash");
            }
            String version = string;
            Iterable $this$associateWith$iv = archs;
            boolean $i$f$associateWith = false;
            LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
            Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
            boolean $i$f$associateWithTo = false;
            for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
                void arch;
                void $this$generateUrls_u24lambda_u246_u24lambda_u245;
                CpuArch cpuArch = (CpuArch)element$iv$iv;
                Object t = element$iv$iv;
                Map map2 = result$iv;
                boolean bl4 = false;
                void $this$generateUrls_u24lambda_u246_u24lambda_u245_u24lambda_u244_u24lambda_u243 = $this$generateUrls_u24lambda_u246_u24lambda_u245;
                boolean bl5 = false;
                String archName = switch (WhenMappings.$EnumSwitchMapping$1[arch.ordinal()]) {
                    case 1 -> "aarch64";
                    case 2 -> "x86";
                    case 3 -> "x64";
                    default -> throw new IllegalArgumentException(arch.name() + " arch is not supported");
                };
                String string2 = name.toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
                String string3 = name.toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
                URL uRL = new URL(urlBase + string2 + "/" + version + "/" + string3 + "-" + version + "-" + osName + "-" + archName + (os == OS.Windows ? ".zip" : ".tar.gz"));
                map2.put(t, uRL);
            }
            collection.add(TuplesKt.to((Object)oS, (Object)result$iv));
        }
        return MapsKt.toMap((Iterable)((List)destination$iv$iv));
    }

    static {
        Object[] objectArray = new CpuArch[]{CpuArch.X86_64, CpuArch.ARM64};
        List commonArchs = CollectionsKt.listOf((Object[])objectArray);
        boolean bl = false;
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)OS.Linux, (Object)commonArchs), TuplesKt.to((Object)OS.macOS, (Object)commonArchs), TuplesKt.to((Object)OS.Windows, (Object)commonArchs)};
        gdb = INSTANCE.generateUrls("gdb", MapsKt.mapOf((Pair[])pairArray));
        pairArray = new Pair[]{TuplesKt.to((Object)OS.Linux, (Object)commonArchs), TuplesKt.to((Object)OS.macOS, (Object)commonArchs), TuplesKt.to((Object)OS.Windows, (Object)CollectionsKt.plus((Collection)commonArchs, (Object)CpuArch.X86))};
        Map osArchs = MapsKt.mapOf((Pair[])pairArray);
        boolean bl2 = false;
        lldb = INSTANCE.generateUrls("LLDB", osArchs);
        lldbFrontend = INSTANCE.generateUrls("LLDBFrontend", osArchs);
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[OS.values().length];
            try {
                nArray[OS.Linux.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OS.macOS.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OS.Windows.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[CpuArch.values().length];
            try {
                nArray[CpuArch.ARM64.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CpuArch.X86.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CpuArch.X86_64.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

