/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunConfigurationWithSuppressedDefaultDebugAction;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.console.ConsoleViewWrapperBase;
import com.intellij.execution.runners.DefaultProgramRunnerKt;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.runners.RunConfigurationWithSuppressedDefaultRunAction;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ExecutionConsoleEx;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.ui.RunnerLayoutUi;
import com.intellij.openapi.project.Project;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugProcessStarter;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebugSessionListener;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.impl.XDebugProcessConfiguratorStarter;
import com.intellij.xdebugger.impl.ui.XDebugSessionData;
import com.jetbrains.cidr.execution.CidrCommandLineState;
import com.jetbrains.cidr.execution.CidrRunProfile;
import com.jetbrains.cidr.statistics.CidrTestingFrameworkCounterUsagesCollector;
import com.jetbrains.cidr.statistics.CidrTestingFrameworkProjectUsagesCollector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CidrRunner
implements ProgramRunner<RunnerSettings> {
    public final void execute(@NotNull ExecutionEnvironment environment) throws ExecutionException {
        if (environment == null) {
            CidrRunner.$$$reportNull$$$0(0);
        }
        ExecutionManager.getInstance((Project)environment.getProject()).startRunProfile(environment, state -> this.doExecute((RunProfileState)state, environment));
    }

    @Nullable
    @RequiresEdt
    protected RunContentDescriptor doExecute(@NotNull RunProfileState state, @NotNull ExecutionEnvironment environment) throws ExecutionException {
        if (state == null) {
            CidrRunner.$$$reportNull$$$0(1);
        }
        if (environment == null) {
            CidrRunner.$$$reportNull$$$0(2);
        }
        ThreadingAssertions.assertEventDispatchThread();
        return DefaultProgramRunnerKt.executeState((RunProfileState)state, (ExecutionEnvironment)environment, (ProgramRunner)this);
    }

    public boolean canRun(@NotNull String executorId, @NotNull RunProfile profile) {
        if (executorId == null) {
            CidrRunner.$$$reportNull$$$0(3);
        }
        if (profile == null) {
            CidrRunner.$$$reportNull$$$0(4);
        }
        if (profile instanceof RunConfigurationWithSuppressedDefaultRunAction && "Run".equals(executorId)) {
            return false;
        }
        if (profile instanceof RunConfigurationWithSuppressedDefaultDebugAction && "Debug".equals(executorId)) {
            return false;
        }
        return profile instanceof CidrRunProfile;
    }

    protected static void triggerUsage(@Nullable RunnerAndConfigurationSettings configuration) {
        RunConfiguration runConfiguration;
        String frameworkId;
        if (configuration != null && (frameworkId = CidrTestingFrameworkProjectUsagesCollector.getFrameworkId(runConfiguration = configuration.getConfiguration())) != null) {
            CidrTestingFrameworkCounterUsagesCollector.TEST_RUN.log(runConfiguration.getProject(), (Object)frameworkId);
        }
    }

    public XDebugSession startDebugSession(final CidrCommandLineState state, ExecutionEnvironment env, final boolean muteBreakpoints, final XDebugSessionListener ... listeners) throws ExecutionException {
        XDebugSession session = XDebuggerManager.getInstance((Project)env.getProject()).startSession(env, (XDebugProcessStarter)new XDebugProcessConfiguratorStarter(){

            @NotNull
            public XDebugProcess start(@NotNull XDebugSession session) throws ExecutionException {
                if (session == null) {
                    1.$$$reportNull$$$0(0);
                }
                for (XDebugSessionListener l : listeners) {
                    session.addSessionListener(l);
                }
                XDebugProcess xDebugProcess = state.startDebugProcess(session);
                if (xDebugProcess == null) {
                    1.$$$reportNull$$$0(1);
                }
                return xDebugProcess;
            }

            public void configure(XDebugSessionData data) {
                if (muteBreakpoints) {
                    data.setBreakpointsMuted(true);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "session";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/jetbrains/cidr/execution/CidrRunner$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/jetbrains/cidr/execution/CidrRunner$1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "start";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "start";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1 -> new IllegalStateException(string);
                };
            }
        });
        CidrRunner.configureDebugSessionUI(session);
        state.afterDebugSessionStarted(session);
        return session;
    }

    private static void configureDebugSessionUI(@NotNull XDebugSession session) {
        RunnerLayoutUi runnerLayoutUi;
        ConsoleView consoleView;
        if (session == null) {
            CidrRunner.$$$reportNull$$$0(5);
        }
        if ((consoleView = session.getConsoleView()) instanceof ConsoleViewWrapperBase && (runnerLayoutUi = session.getUI()) != null) {
            ((ExecutionConsoleEx)consoleView).buildUi(runnerLayoutUi);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executorId";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profile";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/cidr/execution/CidrRunner";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "execute";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "doExecute";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "canRun";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "configureDebugSessionUI";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

