/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dts.util;

import com.intellij.dts.clion.DtsCLionUtil;
import com.intellij.dts.lang.DtsTokenSets;
import com.intellij.dts.lang.psi.DtsTypes;
import com.intellij.dts.util.DtsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.TokenType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresReadLockAbsence;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequenceScope;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\t2\b\b\u0002\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\fJ)\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0012\u0010\u0012\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00110\u0013\"\u00020\u0011\u00a2\u0006\u0002\u0010\u0014J+\u0010\u0015\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0012\u0010\u0012\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00110\u0013\"\u00020\u0011H\u0007\u00a2\u0006\u0002\u0010\u0014J\u000e\u0010\u0016\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\u0018J\u0010\u0010\u0019\u001a\u00020\f2\u0006\u0010\n\u001a\u00020\tH\u0002J(\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\t2\b\b\u0002\u0010\u001b\u001a\u00020\f2\b\b\u0002\u0010\u001c\u001a\u00020\fJ\u001a\u0010\u001d\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u001b\u001a\u00020\fH\u0002J\u001b\u0010\u001e\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u001b\u001a\u00020\fH\u0082\u0010J\"\u0010\u001f\u001a\b\u0012\u0004\u0012\u0002H!0 \"\u0004\b\u0000\u0010!2\u000e\u0010\"\u001a\n\u0012\u0006\u0012\u0004\u0018\u0001H!0#J\u001c\u0010$\u001a\u0010\u0012\u0004\u0012\u00020\u0011\u0012\u0006\u0012\u0004\u0018\u00010\u00110%2\u0006\u0010&\u001a\u00020\u0011J\u0018\u0010'\u001a\u00020\f2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u001b\u001a\u00020\fH\u0002R\u0016\u0010\u0003\u001a\u0004\u0018\u00010\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006("}, d2={"Lcom/intellij/dts/util/DtsUtil;", "", "()V", "clionUtil", "Lcom/intellij/dts/clion/DtsCLionUtil;", "getClionUtil", "()Lcom/intellij/dts/clion/DtsCLionUtil;", "children", "Lkotlin/sequences/Sequence;", "Lcom/intellij/psi/PsiElement;", "element", "forward", "", "unfiltered", "findFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "first", "", "more", "", "(Ljava/lang/String;[Ljava/lang/String;)Lcom/intellij/openapi/vfs/VirtualFile;", "findFileAndRefresh", "isCMakeAvailable", "project", "Lcom/intellij/openapi/project/Project;", "isProductiveElement", "iterateLeafs", "filter", "strict", "nextElement", "nextLeaf", "singleResult", "", "T", "callback", "Lkotlin/Function0;", "splitName", "Lkotlin/Pair;", "name", "validLeaf", "intellij.dts"})
@SourceDebugExtension(value={"SMAP\nDtsUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DtsUtil.kt\ncom/intellij/dts/util/DtsUtil\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,155:1\n163#2,6:156\n*S KotlinDebug\n*F\n+ 1 DtsUtil.kt\ncom/intellij/dts/util/DtsUtil\n*L\n34#1:156,6\n*E\n"})
public final class DtsUtil {
    @NotNull
    public static final DtsUtil INSTANCE = new DtsUtil();

    private DtsUtil() {
    }

    private final DtsCLionUtil getClionUtil() {
        return (DtsCLionUtil)ArraysKt.firstOrNull((Object[])DtsCLionUtil.Companion.getEP_NAME().getExtensions());
    }

    public final boolean isCMakeAvailable(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        DtsCLionUtil dtsCLionUtil = this.getClionUtil();
        return dtsCLionUtil != null ? dtsCLionUtil.isCMakeAvailable(project) : false;
    }

    @NotNull
    public final Pair<String, String> splitName(@NotNull String name) {
        Pair pair;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        if (StringsKt.contains$default((CharSequence)name, (CharSequence)"@", (boolean)false, (int)2, null)) {
            int n;
            block4: {
                CharSequence $this$indexOfLast$iv = name;
                boolean $i$f$indexOfLast = false;
                int n2 = $this$indexOfLast$iv.length() + -1;
                if (0 <= n2) {
                    do {
                        int index$iv = n2--;
                        char it = $this$indexOfLast$iv.charAt(index$iv);
                        boolean bl = false;
                        if (!(it == '@')) continue;
                        n = index$iv;
                        break block4;
                    } while (0 <= n2);
                }
                n = -1;
            }
            int splitIndex = n;
            String string = name.substring(0, splitIndex);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            String actualName = string;
            String string2 = name.substring(splitIndex + 1);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            String unitAddress = string2;
            pair = new Pair((Object)actualName, (Object)unitAddress);
        } else {
            pair = new Pair((Object)name, null);
        }
        return pair;
    }

    @NotNull
    public final Sequence<PsiElement> children(@NotNull PsiElement element, boolean forward, boolean unfiltered) {
        PsiElement psiElement;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (forward) {
            psiElement = element.getFirstChild();
        } else {
            psiElement = element.getLastChild();
            if (psiElement == null) {
                return SequencesKt.emptySequence();
            }
        }
        PsiElement start = psiElement;
        Intrinsics.checkNotNull((Object)start);
        Sequence siblings = PsiTreeUtilKt.siblings$default((PsiElement)start, (boolean)forward, (boolean)false, (int)2, null);
        if (unfiltered) {
            return siblings;
        }
        return SequencesKt.filter((Sequence)siblings, (Function1)((Function1)new Function1<PsiElement, Boolean>((Object)this){

            @NotNull
            public final Boolean invoke(@NotNull PsiElement p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return DtsUtil.access$isProductiveElement((DtsUtil)this.receiver, p0);
            }
        }));
    }

    public static /* synthetic */ Sequence children$default(DtsUtil dtsUtil, PsiElement psiElement, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        if ((n & 4) != 0) {
            bl2 = false;
        }
        return dtsUtil.children(psiElement, bl, bl2);
    }

    private final boolean isProductiveElement(PsiElement element) {
        IElementType type = PsiTreeUtilKt.getElementType((PsiElement)element);
        return !Intrinsics.areEqual((Object)type, (Object)TokenType.WHITE_SPACE) && !DtsTokenSets.INSTANCE.getComments().contains(type) && !Intrinsics.areEqual((Object)type, (Object)DtsTypes.INCLUDE_STATEMENT) && !DtsTokenSets.INSTANCE.getPpStatements().contains(type);
    }

    @NotNull
    public final <T> List<T> singleResult(@NotNull Function0<? extends T> callback) {
        List<Object> list;
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        Object result = callback.invoke();
        if (result == null) {
            List list2 = Collections.emptyList();
            Intrinsics.checkNotNull(list2);
            list = list2;
        } else {
            List<Object> list3 = Collections.singletonList(result);
            Intrinsics.checkNotNull(list3);
            list = list3;
        }
        return list;
    }

    @RequiresReadLockAbsence
    @Nullable
    public final VirtualFile findFileAndRefresh(@NotNull String first, String ... more) {
        VirtualFile virtualFile;
        Intrinsics.checkNotNullParameter((Object)first, (String)"first");
        Intrinsics.checkNotNullParameter((Object)more, (String)"more");
        ThreadingAssertions.assertNoReadAccess();
        try {
            virtualFile = VfsUtil.findFile((Path)Path.of(first, Arrays.copyOf(more, more.length)), (boolean)true);
        }
        catch (InvalidPathException invalidPathException) {
            virtualFile = null;
        }
        return virtualFile;
    }

    @Nullable
    public final VirtualFile findFile(@NotNull String first, String ... more) {
        VirtualFile virtualFile;
        Intrinsics.checkNotNullParameter((Object)first, (String)"first");
        Intrinsics.checkNotNullParameter((Object)more, (String)"more");
        try {
            virtualFile = VfsUtil.findFile((Path)Path.of(first, Arrays.copyOf(more, more.length)), (boolean)false);
        }
        catch (InvalidPathException invalidPathException) {
            virtualFile = null;
        }
        return virtualFile;
    }

    private final PsiElement nextElement(PsiElement element, boolean filter) {
        PsiElement nextSibling;
        PsiElement firstChild;
        boolean notEmpty;
        boolean valid = !filter || this.isProductiveElement(element);
        boolean bl = notEmpty = element.getTextLength() != 0;
        if (valid && notEmpty && (firstChild = element.getFirstChild()) != null) {
            return firstChild;
        }
        PsiElement psiElement = nextSibling = element.getNextSibling();
        if (psiElement != null) {
            return psiElement;
        }
        PsiElement parent2 = PsiTreeUtil.findFirstParent((PsiElement)element, arg_0 -> DtsUtil.nextElement$lambda$1(nextElement.parent.1.INSTANCE, arg_0));
        if (!(parent2 instanceof PsiFile)) {
            PsiElement psiElement2 = parent2;
            return psiElement2 != null ? psiElement2.getNextSibling() : null;
        }
        return null;
    }

    private final boolean validLeaf(PsiElement element, boolean filter) {
        boolean valid = !filter || this.isProductiveElement(element);
        boolean notEmpty = element.getTextLength() != 0;
        boolean isLeaf = element.getFirstChild() == null;
        return valid && notEmpty && isLeaf;
    }

    private final PsiElement nextLeaf(PsiElement element, boolean filter) {
        while (this_.nextElement(element, filter) != null) {
            PsiElement next;
            if (this_.validLeaf(next, filter)) {
                return next;
            }
            DtsUtil dtsUtil = this_;
            boolean bl = filter;
            DtsUtil this_ = dtsUtil;
            element = next;
            filter = bl;
        }
        return null;
    }

    @NotNull
    public final Sequence<PsiElement> iterateLeafs(@NotNull PsiElement element, boolean filter, boolean strict) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return SequencesKt.sequence((Function2)((Function2)new Function2<SequenceScope<? super PsiElement>, Continuation<? super Unit>, Object>(strict, element, filter, null){
            Object L$1;
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ boolean $strict;
            final /* synthetic */ PsiElement $element;
            final /* synthetic */ boolean $filter;
            {
                this.$strict = $strict;
                this.$element = $element;
                this.$filter = $filter;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var4_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        $this$sequence = (SequenceScope)this.L$0;
                        v0 = current = this.$strict != false || DtsUtil.access$validLeaf(DtsUtil.INSTANCE, this.$element, this.$filter) == false ? DtsUtil.access$nextLeaf(DtsUtil.INSTANCE, this.$element, this.$filter) : this.$element;
lbl7:
                        // 2 sources

                        while (current != null) {
                            this.L$0 = $this$sequence;
                            this.L$1 = current;
                            this.label = 1;
                            v1 = $this$sequence.yield((Object)current, (Continuation)this);
                            if (v1 == var4_2) {
                                return var4_2;
                            }
                            ** GOTO lbl21
                        }
                        break;
                    }
                    case 1: {
                        current = (PsiElement)this.L$1;
                        $this$sequence = (SequenceScope)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
lbl21:
                        // 2 sources

                        current = DtsUtil.access$nextLeaf(DtsUtil.INSTANCE, current, this.$filter);
                        ** GOTO lbl7
                    }
                }
                return Unit.INSTANCE;
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            @Nullable
            public final Object invoke(@NotNull SequenceScope<? super PsiElement> p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
    }

    public static /* synthetic */ Sequence iterateLeafs$default(DtsUtil dtsUtil, PsiElement psiElement, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        if ((n & 4) != 0) {
            bl2 = true;
        }
        return dtsUtil.iterateLeafs(psiElement, bl, bl2);
    }

    private static final boolean nextElement$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ boolean access$isProductiveElement(DtsUtil $this, PsiElement element) {
        return $this.isProductiveElement(element);
    }

    public static final /* synthetic */ boolean access$validLeaf(DtsUtil $this, PsiElement element, boolean filter) {
        return $this.validLeaf(element, filter);
    }

    public static final /* synthetic */ PsiElement access$nextLeaf(DtsUtil $this, PsiElement element, boolean filter) {
        return $this.nextLeaf(element, filter);
    }
}

