/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dts.lang.resolve.files;

import com.intellij.dts.lang.psi.FileInclude;
import com.intellij.dts.zephyr.DtsZephyrBoard;
import com.intellij.dts.zephyr.DtsZephyrProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\tH\u0016R\u0018\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0096\u0004\u00a2\u0006\n\n\u0002\u0010\u0007\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000b"}, d2={"Lcom/intellij/dts/lang/resolve/files/DtsOverlayFile;", "Lcom/intellij/dts/lang/psi/FileInclude;", "()V", "offset", "", "getOffset", "()Ljava/lang/Integer;", "Ljava/lang/Integer;", "resolve", "Lcom/intellij/psi/PsiFile;", "anchor", "intellij.dts"})
public final class DtsOverlayFile
implements FileInclude {
    @NotNull
    public static final DtsOverlayFile INSTANCE = new DtsOverlayFile();
    @Nullable
    private static final Integer offset;

    private DtsOverlayFile() {
    }

    @Override
    @Nullable
    public Integer getOffset() {
        return offset;
    }

    @Override
    @Nullable
    public PsiFile resolve(@NotNull PsiFile anchor) {
        Intrinsics.checkNotNullParameter((Object)anchor, (String)"anchor");
        VirtualFile context = anchor.getOriginalFile().getVirtualFile();
        if (context == null || !context.isValid()) {
            return null;
        }
        String name = context.getNameWithoutExtension() + ".dts";
        Project project = anchor.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        DtsZephyrBoard dtsZephyrBoard = DtsZephyrProvider.Companion.of(project).getBoard();
        if (dtsZephyrBoard == null) {
            return null;
        }
        DtsZephyrBoard board = dtsZephyrBoard;
        List candidates = new ArrayList();
        VfsUtilCore.processFilesRecursively((VirtualFile)board.getFile(), arg_0 -> DtsOverlayFile.resolve$lambda$0((Function1)new Function1<VirtualFile, Boolean>(name, (List<VirtualFile>)candidates){
            final /* synthetic */ String $name;
            final /* synthetic */ List<VirtualFile> $candidates;
            {
                this.$name = $name;
                this.$candidates = $candidates;
                super(1);
            }

            @NotNull
            public final Boolean invoke(VirtualFile virtualFile) {
                if (Intrinsics.areEqual((Object)virtualFile.getName(), (Object)this.$name)) {
                    Intrinsics.checkNotNull((Object)virtualFile);
                    this.$candidates.add(virtualFile);
                }
                return true;
            }
        }, arg_0));
        return (PsiFile)SequencesKt.firstOrNull((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)candidates), (Function1)((Function1)new Function1<VirtualFile, PsiFile>(anchor){
            final /* synthetic */ PsiFile $anchor;
            {
                this.$anchor = $anchor;
                super(1);
            }

            @Nullable
            public final PsiFile invoke(@NotNull VirtualFile virtualFile) {
                Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
                return this.$anchor.getManager().findFile(virtualFile);
            }
        })));
    }

    private static final boolean resolve$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }
}

