/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dts.inspections.fixes;

import com.intellij.dts.DtsBundle;
import com.intellij.dts.completion.insert.DtsInsertMetaData;
import com.intellij.dts.completion.insert.DtsInsertSession;
import com.intellij.dts.completion.insert.InsertMetaDataBackendKt;
import com.intellij.dts.completion.insert.InsertPropertyKt;
import com.intellij.dts.lang.psi.DtsEntry;
import com.intellij.dts.lang.psi.DtsNode;
import com.intellij.dts.lang.psi.DtsPsiFactory;
import com.intellij.dts.lang.symbols.DtsPropertySymbol;
import com.intellij.dts.zephyr.binding.DtsZephyrPropertyBinding;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.util.containers.UtilKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0014J\b\u0010\u000e\u001a\u00020\u000fH\u0016J \u0010\u0010\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\f\u001a\u00020\rH\u0002R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/dts/inspections/fixes/DtsCreatePropertyFix;", "Lcom/intellij/modcommand/PsiUpdateModCommandQuickFix;", "properties", "", "Lcom/intellij/dts/zephyr/binding/DtsZephyrPropertyBinding;", "(Ljava/util/List;)V", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "element", "Lcom/intellij/psi/PsiElement;", "updater", "Lcom/intellij/modcommand/ModPsiUpdater;", "getFamilyName", "", "moveCursor", "symbol", "Lcom/intellij/dts/lang/symbols/DtsPropertySymbol;", "intellij.dts"})
public final class DtsCreatePropertyFix
extends PsiUpdateModCommandQuickFix {
    @NotNull
    private final List<DtsZephyrPropertyBinding> properties;

    public DtsCreatePropertyFix(@NotNull List<DtsZephyrPropertyBinding> properties) {
        Intrinsics.checkNotNullParameter(properties, (String)"properties");
        this.properties = properties;
    }

    @NotNull
    public String getFamilyName() {
        return DtsBundle.Companion.message("inspections.fix.create_property", new Object[0]);
    }

    private final void moveCursor(PsiElement element, DtsPropertySymbol symbol, ModPsiUpdater updater) {
        DtsInsertMetaData metaData2 = InsertMetaDataBackendKt.dtsInsertMetaData((Function1<? super DtsInsertSession, Unit>)((Function1)new Function1<DtsInsertSession, Unit>(symbol){
            final /* synthetic */ DtsPropertySymbol $symbol;
            {
                this.$symbol = $symbol;
                super(1);
            }

            public final void invoke(@NotNull DtsInsertSession $this$dtsInsertMetaData) {
                Intrinsics.checkNotNullParameter((Object)$this$dtsInsertMetaData, (String)"$this$dtsInsertMetaData");
                DtsInsertSession.write$default($this$dtsInsertMetaData, this.$symbol.getName(), false, 2, null);
                InsertPropertyKt.writePropertyValue($this$dtsInsertMetaData, this.$symbol);
            }
        }));
        updater.moveCaretTo(PsiTreeUtilKt.getStartOffset((PsiElement)element) + metaData2.getOffset());
    }

    protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)updater, (String)"updater");
        if (!(element instanceof DtsNode) || this.properties.isEmpty()) {
            return;
        }
        Pair pair = UtilKt.headTail(this.properties);
        DtsZephyrPropertyBinding head = (DtsZephyrPropertyBinding)pair.component1();
        List tail = (List)pair.component2();
        DtsPropertySymbol symbol = new DtsPropertySymbol(head);
        DtsEntry entry = ((DtsNode)element).addDtsProperty(DtsPsiFactory.INSTANCE.createProperty(project, symbol));
        this.moveCursor(entry, symbol, updater);
        for (DtsZephyrPropertyBinding binding : tail) {
            ((DtsNode)element).addDtsProperty(DtsPsiFactory.INSTANCE.createProperty(project, new DtsPropertySymbol(binding)));
        }
    }
}

