/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dts.inspections;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.dts.inspections.DtsInspectionsUtilKt;
import com.intellij.dts.inspections.DtsLabelNameInspectionKt;
import com.intellij.dts.lang.psi.DtsTypes;
import com.intellij.dts.lang.psi.DtsVisitorKt;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.tree.IElementType;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u00a8\u0006\r"}, d2={"Lcom/intellij/dts/inspections/DtsLabelNameInspection;", "Lcom/intellij/codeInspection/LocalInspectionTool;", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "checkLabel", "", "label", "Lcom/intellij/psi/PsiElement;", "intellij.dts"})
public final class DtsLabelNameInspection
extends LocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        IElementType iElementType = DtsTypes.LABEL;
        Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"LABEL");
        return DtsVisitorKt.dtsVisitor(iElementType, (Function1<? super PsiElement, Unit>)((Function1)new Function1<PsiElement, Unit>(this, holder){
            final /* synthetic */ DtsLabelNameInspection this$0;
            final /* synthetic */ ProblemsHolder $holder;
            {
                this.this$0 = $receiver;
                this.$holder = $holder;
                super(1);
            }

            public final void invoke(@NotNull PsiElement it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                DtsLabelNameInspection.access$checkLabel(this.this$0, it, this.$holder);
            }
        }));
    }

    private final void checkLabel(PsiElement label, ProblemsHolder holder) {
        String string = label.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        char[] cArray = new char[]{':'};
        String name = StringsKt.trimEnd((String)string, (char[])cArray);
        if (!DtsLabelNameInspectionKt.access$getStartRx$p().matches((CharSequence)StringsKt.substring((String)name, (IntRange)new IntRange(0, 0)))) {
            DtsInspectionsUtilKt.registerProblem$default(holder, label, "inspections.label_name.bad_first_char", Character.valueOf(name.charAt(0)), TextRange.from((int)0, (int)name.length()), null, 16, null);
            return;
        }
        DtsInspectionsUtilKt.firstNotMatching(name, DtsLabelNameInspectionKt.access$getRx$p(), (Function1<? super Character, Unit>)((Function1)new Function1<Character, Unit>(holder, label, name){
            final /* synthetic */ ProblemsHolder $holder;
            final /* synthetic */ PsiElement $label;
            final /* synthetic */ String $name;
            {
                this.$holder = $holder;
                this.$label = $label;
                this.$name = $name;
                super(1);
            }

            public final void invoke(char it) {
                DtsInspectionsUtilKt.registerProblem$default(this.$holder, this.$label, "inspections.label_name.bad_char", Character.valueOf(it), TextRange.from((int)0, (int)this.$name.length()), null, 16, null);
            }
        }));
    }

    public static final /* synthetic */ void access$checkLabel(DtsLabelNameInspection $this, PsiElement label, ProblemsHolder holder) {
        $this.checkLabel(label, holder);
    }
}

