/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dts.highlighting;

import com.intellij.dts.highlighting.DtsHighlightAnnotatorKt;
import com.intellij.dts.highlighting.DtsTextAttributes;
import com.intellij.dts.lang.psi.DtsCompilerDirective;
import com.intellij.dts.lang.psi.DtsPHandle;
import com.intellij.dts.lang.psi.DtsProperty;
import com.intellij.dts.lang.psi.DtsSubNode;
import com.intellij.dts.lang.psi.DtsTypes;
import com.intellij.dts.util.DtsUtil;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.ExternallyAnnotated;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtilKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\u0014B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\tH\u0016J\u0018\u0010\n\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J \u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00122\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002\u00a8\u0006\u0015"}, d2={"Lcom/intellij/dts/highlighting/DtsHighlightAnnotator;", "Lcom/intellij/lang/annotation/Annotator;", "()V", "annotate", "", "element", "Lcom/intellij/psi/PsiElement;", "holder", "Lcom/intellij/dts/highlighting/DtsHighlightAnnotator$Holder;", "Lcom/intellij/lang/annotation/AnnotationHolder;", "annotateLabel", "annotateName", "annotateNodeName", "nodeName", "", "startOffset", "", "annotatePHandle", "Lcom/intellij/dts/lang/psi/DtsPHandle;", "annotateStringEscape", "Holder", "intellij.dts"})
public final class DtsHighlightAnnotator
implements Annotator {
    private final void annotateStringEscape(PsiElement element, Holder holder) {
        Regex regex = DtsHighlightAnnotatorKt.access$getStringEscapeRx$p();
        String string = element.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        for (MatchResult match : Regex.findAll$default((Regex)regex, (CharSequence)string, (int)0, (int)2, null)) {
            TextRange range = new TextRange(element.getTextOffset() + match.getRange().getFirst(), element.getTextOffset() + match.getRange().getLast() + 1);
            holder.newAnnotation(range, DtsTextAttributes.STRING_ESCAPE);
        }
    }

    private final void annotateNodeName(String nodeName, int startOffset, Holder holder) {
        CharSequence nameRange;
        Pair<String, String> pair = DtsUtil.INSTANCE.splitName(nodeName);
        String name = (String)pair.component1();
        String addr = (String)pair.component2();
        if (((CharSequence)name).length() > 0) {
            TextRange textRange = TextRange.from((int)startOffset, (int)name.length());
            Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"from(...)");
            nameRange = textRange;
            holder.newAnnotation((TextRange)nameRange, DtsTextAttributes.NODE_NAME);
        }
        if (!((nameRange = (CharSequence)addr) == null || nameRange.length() == 0)) {
            TextRange textRange = TextRange.from((int)(startOffset + name.length() + 1), (int)addr.length());
            Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"from(...)");
            TextRange addrRange = textRange;
            holder.newAnnotation(addrRange, DtsTextAttributes.NODE_UNIT_ADDR);
        }
    }

    private final void annotateName(PsiElement element, Holder holder) {
        PsiElement parent2 = element.getParent();
        if (parent2 instanceof DtsProperty) {
            TextRange textRange = element.getTextRange();
            Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getTextRange(...)");
            holder.newAnnotation(textRange, DtsTextAttributes.PROPERTY_NAME);
        } else if (parent2 instanceof DtsSubNode) {
            String string = element.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            this.annotateNodeName(string, PsiTreeUtilKt.getStartOffset((PsiElement)element), holder);
        } else if (parent2 instanceof DtsCompilerDirective) {
            IElementType iElementType = ((DtsCompilerDirective)parent2).getDtsDirectiveType();
            if (Intrinsics.areEqual((Object)iElementType, (Object)DtsTypes.DELETE_PROP)) {
                TextRange textRange = element.getTextRange();
                Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getTextRange(...)");
                holder.newAnnotation(textRange, DtsTextAttributes.PROPERTY_NAME);
            } else if (Intrinsics.areEqual((Object)iElementType, (Object)DtsTypes.DELETE_NODE)) {
                String string = element.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                this.annotateNodeName(string, PsiTreeUtilKt.getStartOffset((PsiElement)element), holder);
            }
        }
    }

    private final void annotateLabel(PsiElement element, Holder holder) {
        TextRange textRange = TextRange.from((int)element.getTextOffset(), (int)(element.getTextLength() - 1));
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"from(...)");
        TextRange range = textRange;
        holder.newAnnotation(range, DtsTextAttributes.LABEL);
    }

    private final void annotatePHandle(DtsPHandle element, Holder holder) {
        block2: {
            PsiElement it;
            PsiElement psiElement = element.getDtsPHandleLabel();
            if (psiElement != null) {
                it = psiElement;
                boolean bl = false;
                TextRange textRange = it.getTextRange();
                Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getTextRange(...)");
                holder.newAnnotation(textRange, DtsTextAttributes.LABEL);
            }
            PsiElement psiElement2 = element.getDtsPHandlePath();
            if (psiElement2 == null) break block2;
            it = psiElement2;
            boolean bl = false;
            int offset = PsiTreeUtilKt.getStartOffset((PsiElement)it) + 1;
            String string = it.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            String[] stringArray = new String[]{"/"};
            for (String segment : StringsKt.split$default((CharSequence)StringsKt.removePrefix((String)string, (CharSequence)"/"), (String[])stringArray, (boolean)false, (int)0, (int)6, null)) {
                this.annotateNodeName(segment, offset, holder);
                offset += segment.length() + 1;
            }
        }
    }

    public final void annotate(@NotNull PsiElement element, @NotNull Holder holder) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        if (element instanceof ExternallyAnnotated) {
            return;
        }
        if (element instanceof DtsPHandle) {
            this.annotatePHandle((DtsPHandle)element, holder);
            return;
        }
        IElementType iElementType = PsiTreeUtilKt.getElementType((PsiElement)element);
        if (Intrinsics.areEqual((Object)iElementType, (Object)DtsTypes.LABEL)) {
            this.annotateLabel(element, holder);
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)DtsTypes.NAME)) {
            this.annotateName(element, holder);
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)DtsTypes.STRING_LITERAL) ? true : Intrinsics.areEqual((Object)iElementType, (Object)DtsTypes.CHAR_LITERAL)) {
            this.annotateStringEscape(element, holder);
        }
    }

    public void annotate(@NotNull PsiElement element, @NotNull AnnotationHolder holder) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        this.annotate(element, (arg_0, arg_1) -> DtsHighlightAnnotator.annotate$lambda$2(holder, arg_0, arg_1));
    }

    private static final void annotate$lambda$2(AnnotationHolder $holder, TextRange range, DtsTextAttributes attr) {
        Intrinsics.checkNotNullParameter((Object)$holder, (String)"$holder");
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        Intrinsics.checkNotNullParameter((Object)((Object)attr), (String)"attr");
        $holder.newSilentAnnotation(HighlightSeverity.INFORMATION).range(range).textAttributes(attr.getAttribute()).create();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00e6\u0080\u0001\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\b\u00c0\u0006\u0001"}, d2={"Lcom/intellij/dts/highlighting/DtsHighlightAnnotator$Holder;", "", "newAnnotation", "", "range", "Lcom/intellij/openapi/util/TextRange;", "attr", "Lcom/intellij/dts/highlighting/DtsTextAttributes;", "intellij.dts"})
    public static interface Holder {
        public void newAnnotation(@NotNull TextRange var1, @NotNull DtsTextAttributes var2);
    }
}

