/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dts.formatting;

import com.intellij.dts.formatting.DtsIndentingBuilder;
import com.intellij.dts.formatting.DtsSpacingBuilder;
import com.intellij.dts.formatting.DtsWrappingBuilder;
import com.intellij.formatting.Block;
import com.intellij.formatting.ChildAttributes;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Spacing;
import com.intellij.lang.ASTNode;
import com.intellij.psi.TokenType;
import com.intellij.psi.formatter.common.AbstractBlock;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\u0000\u00a2\u0006\u0002\u0010\tJ\u000e\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0014J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\u001c\u0010\u0015\u001a\u0004\u0018\u00010\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0018\u001a\u00020\fH\u0016J\b\u0010\u0019\u001a\u00020\u001aH\u0016R\u0010\u0010\b\u001a\u0004\u0018\u00010\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/intellij/dts/formatting/DtsBlock;", "Lcom/intellij/psi/formatter/common/AbstractBlock;", "node", "Lcom/intellij/lang/ASTNode;", "wrappingBuilder", "Lcom/intellij/dts/formatting/DtsWrappingBuilder;", "spacingBuilder", "Lcom/intellij/dts/formatting/DtsSpacingBuilder;", "parent", "(Lcom/intellij/lang/ASTNode;Lcom/intellij/dts/formatting/DtsWrappingBuilder;Lcom/intellij/dts/formatting/DtsSpacingBuilder;Lcom/intellij/dts/formatting/DtsBlock;)V", "buildChildren", "", "Lcom/intellij/formatting/Block;", "getChildAttributes", "Lcom/intellij/formatting/ChildAttributes;", "newChildIndex", "", "getDebugName", "", "getIndent", "Lcom/intellij/formatting/Indent;", "getSpacing", "Lcom/intellij/formatting/Spacing;", "child1", "child2", "isLeaf", "", "Companion", "intellij.dts"})
public final class DtsBlock
extends AbstractBlock {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DtsWrappingBuilder wrappingBuilder;
    @NotNull
    private final DtsSpacingBuilder spacingBuilder;
    @Nullable
    private final DtsBlock parent;
    @NotNull
    private static final DtsIndentingBuilder indentingBuilder = new DtsIndentingBuilder();

    public DtsBlock(@NotNull ASTNode node, @NotNull DtsWrappingBuilder wrappingBuilder, @NotNull DtsSpacingBuilder spacingBuilder, @Nullable DtsBlock parent2) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)wrappingBuilder, (String)"wrappingBuilder");
        Intrinsics.checkNotNullParameter((Object)spacingBuilder, (String)"spacingBuilder");
        super(node, wrappingBuilder.getWrap((Block)parent2, node), wrappingBuilder.getAlignment((Block)parent2, node));
        this.wrappingBuilder = wrappingBuilder;
        this.spacingBuilder = spacingBuilder;
        this.parent = parent2;
    }

    @Nullable
    public Spacing getSpacing(@Nullable Block child1, @NotNull Block child2) {
        Intrinsics.checkNotNullParameter((Object)child2, (String)"child2");
        return this.spacingBuilder.getSpacing((Block)this, child1, child2);
    }

    @NotNull
    public Indent getIndent() {
        Indent indent = indentingBuilder.getIndenting((Block)this.parent, (Block)this);
        if (indent == null) {
            Indent indent2 = Indent.getNoneIndent();
            indent = indent2;
            Intrinsics.checkNotNullExpressionValue((Object)indent2, (String)"getNoneIndent(...)");
        }
        return indent;
    }

    @NotNull
    public ChildAttributes getChildAttributes(int newChildIndex) {
        return new ChildAttributes(indentingBuilder.getChildIndenting((Block)this, newChildIndex), null);
    }

    @NotNull
    public String getDebugName() {
        return "Dts" + (this.isLeaf() ? "Leaf" : "") + "Block(" + this.getNode().getElementType() + ")";
    }

    public boolean isLeaf() {
        return this.getNode().getFirstChildNode() == null;
    }

    @NotNull
    protected List<Block> buildChildren() {
        DtsWrappingBuilder childWrappingBuilder = DtsWrappingBuilder.Companion.childBuilder((Block)this, this.wrappingBuilder);
        ASTNode[] aSTNodeArray = this.getNode().getChildren(null);
        Intrinsics.checkNotNullExpressionValue((Object)aSTNodeArray, (String)"getChildren(...)");
        return SequencesKt.toMutableList((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)ArraysKt.asSequence((Object[])aSTNodeArray), (Function1)((Function1)new Function1<ASTNode, Boolean>((Object)Companion){

            @NotNull
            public final Boolean invoke(@NotNull ASTNode p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return ((Companion)this.receiver).isValidForBlock(p0);
            }
        })), (Function1)((Function1)new Function1<ASTNode, DtsBlock>(childWrappingBuilder, this){
            final /* synthetic */ DtsWrappingBuilder $childWrappingBuilder;
            final /* synthetic */ DtsBlock this$0;
            {
                this.$childWrappingBuilder = $childWrappingBuilder;
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final DtsBlock invoke(ASTNode it) {
                Intrinsics.checkNotNull((Object)it);
                return new DtsBlock(it, this.$childWrappingBuilder, DtsBlock.access$getSpacingBuilder$p(this.this$0), this.this$0);
            }
        })));
    }

    public static final /* synthetic */ DtsSpacingBuilder access$getSpacingBuilder$p(DtsBlock $this) {
        return $this.spacingBuilder;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/intellij/dts/formatting/DtsBlock$Companion;", "", "()V", "indentingBuilder", "Lcom/intellij/dts/formatting/DtsIndentingBuilder;", "isValidForBlock", "", "node", "Lcom/intellij/lang/ASTNode;", "intellij.dts"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean isValidForBlock(@NotNull ASTNode node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            if (Intrinsics.areEqual((Object)node.getElementType(), (Object)TokenType.WHITE_SPACE)) {
                return false;
            }
            return !node.getTextRange().isEmpty();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

