/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dts.completion.insert;

import com.intellij.codeInsight.AutoPopupController;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.dts.completion.insert.DtsInsertBackend;
import com.intellij.dts.completion.insert.InsertBackendImplKt;
import com.intellij.dts.util.DtsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u0011\u001a\u00020\u0010H\u0016J\u0010\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\nH\u0016J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0015H\u0002J\u0010\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u0015H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/intellij/dts/completion/insert/InsertBackendImpl;", "Lcom/intellij/dts/completion/insert/DtsInsertBackend;", "context", "Lcom/intellij/codeInsight/completion/InsertionContext;", "(Lcom/intellij/codeInsight/completion/InsertionContext;)V", "getContext", "()Lcom/intellij/codeInsight/completion/InsertionContext;", "lineEmpty", "", "nextChar", "", "Ljava/lang/Character;", "offset", "", "startOffset", "moveCaret", "", "openAutocomplete", "shouldWrite", "char", "skipWhitespace", "", "text", "write", "intellij.dts"})
final class InsertBackendImpl
implements DtsInsertBackend {
    @NotNull
    private final InsertionContext context;
    @Nullable
    private final Character nextChar;
    private final boolean lineEmpty;
    private final int startOffset;
    private int offset;

    public InsertBackendImpl(@NotNull InsertionContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
        this.offset = this.startOffset = this.context.getSelectionEndOffset();
        PsiElement start = this.context.getFile().findElementAt(this.startOffset);
        if (start == null) {
            this.nextChar = null;
            this.lineEmpty = true;
        } else {
            this.lineEmpty = InsertBackendImplKt.access$isLineBlank(start);
            PsiElement nextElement2 = (PsiElement)SequencesKt.firstOrNull((Sequence)DtsUtil.iterateLeafs$default(DtsUtil.INSTANCE, start, false, false, 2, null));
            Object object = nextElement2;
            this.nextChar = object != null && (object = object.getText()) != null ? StringsKt.firstOrNull((CharSequence)((CharSequence)object)) : null;
        }
    }

    @NotNull
    public final InsertionContext getContext() {
        return this.context;
    }

    @Override
    public int shouldWrite(char c) {
        Character c2 = this.nextChar;
        char c3 = c;
        boolean sameCharacter = c2 != null && c2.charValue() == c3;
        return sameCharacter && !this.lineEmpty ? 3 : (sameCharacter ? 2 : (!this.lineEmpty ? 1 : 0));
    }

    private final String skipWhitespace(String text2) {
        char c;
        int start = this.offset;
        int n = text2.length();
        for (int i = 0; i < n && (c = text2.charAt(i)) == ' '; ++i) {
            String string = this.context.getDocument().getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            Character c2 = StringsKt.getOrNull((CharSequence)string, (int)this.offset);
            int n2 = 32;
            if (c2 == null || c2.charValue() != n2) break;
            n2 = this.offset;
            this.offset = n2 + 1;
        }
        String string = text2.substring(this.offset - start);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        return string;
    }

    @Override
    public void write(@NotNull String text2) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        String trimmed = this.skipWhitespace(text2);
        this.context.getDocument().insertString(this.offset, (CharSequence)trimmed);
        this.offset += trimmed.length();
    }

    @Override
    public void moveCaret(int offset) {
        this.context.getEditor().getCaretModel().moveToOffset(this.startOffset + offset);
    }

    @Override
    public void openAutocomplete() {
        AutoPopupController.getInstance((Project)this.context.getProject()).scheduleAutoPopup(this.context.getEditor(), CompletionType.BASIC, null);
    }
}

