/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dts.completion;

import com.intellij.dts.lang.psi.DtsContainer;
import com.intellij.dts.lang.psi.DtsNode;
import com.intellij.dts.lang.psi.DtsStatement;
import com.intellij.dts.util.DtsTreeUtil;
import com.intellij.openapi.util.Key;
import com.intellij.patterns.PatternCondition;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.util.ProcessingContext;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\rH\u0016R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u000e"}, d2={"Lcom/intellij/dts/completion/InsideContainer;", "Lcom/intellij/patterns/PatternCondition;", "Lcom/intellij/psi/PsiElement;", "()V", "key", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/dts/lang/psi/DtsContainer;", "getKey", "()Lcom/intellij/openapi/util/Key;", "accepts", "", "element", "context", "Lcom/intellij/util/ProcessingContext;", "intellij.dts"})
final class InsideContainer
extends PatternCondition<PsiElement> {
    @NotNull
    public static final InsideContainer INSTANCE = new InsideContainer();
    @NotNull
    private static final Key<DtsContainer> key = new Key("container");

    private InsideContainer() {
        super("inside container");
    }

    @NotNull
    public final Key<DtsContainer> getKey() {
        return key;
    }

    public boolean accepts(@NotNull PsiElement element, @NotNull ProcessingContext context) {
        DtsContainer dtsContainer;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        PsiElement parent2 = element.getParent();
        if (parent2 instanceof DtsContainer) {
            dtsContainer = (DtsContainer)parent2;
        } else if (parent2 instanceof DtsStatement) {
            DtsNode dtsNode = DtsTreeUtil.INSTANCE.parentNode(parent2);
            dtsContainer = dtsNode != null ? dtsNode.getDtsContent() : null;
        } else {
            PsiElement psiElement;
            dtsContainer = parent2 instanceof PsiErrorElement ? ((psiElement = ((PsiErrorElement)parent2).getParent()) instanceof DtsContainer ? (DtsContainer)psiElement : null) : null;
        }
        if (dtsContainer == null) {
            return false;
        }
        DtsContainer container = dtsContainer;
        context.put(key, (Object)container);
        return true;
    }
}

