/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.clion.west.execution;

import com.intellij.clion.west.execution.WestRunConfiguration;
import com.intellij.clion.west.settings.WestSettings;
import com.intellij.clion.west.settings.WestSettingsKt;
import com.intellij.execution.configurations.CommandLineState;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.openapi.project.Project;
import com.jetbrains.cidr.cpp.cmake.model.CMakeConfiguration;
import com.jetbrains.cidr.cpp.cmake.workspace.CMakeProfileInfo;
import com.jetbrains.cidr.cpp.cmake.workspace.CMakeWorkspace;
import com.jetbrains.cidr.cpp.execution.CLionLauncher;
import com.jetbrains.cidr.cpp.toolchains.CPPEnvironment;
import com.jetbrains.cidr.execution.CidrLauncher;
import com.jetbrains.cidr.lang.toolchains.CidrToolEnvironment;
import com.jetbrains.cidr.lang.workspace.OCRunConfiguration;
import java.io.File;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0014\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u0010H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0013"}, d2={"Lcom/intellij/clion/west/execution/WestLauncher;", "Lcom/jetbrains/cidr/cpp/execution/CLionLauncher;", "executionEnvironment", "Lcom/intellij/execution/runners/ExecutionEnvironment;", "configuration", "Lcom/intellij/clion/west/execution/WestRunConfiguration;", "buildConfiguration", "Lcom/jetbrains/cidr/cpp/cmake/model/CMakeConfiguration;", "(Lcom/intellij/execution/runners/ExecutionEnvironment;Lcom/intellij/clion/west/execution/WestRunConfiguration;Lcom/jetbrains/cidr/cpp/cmake/model/CMakeConfiguration;)V", "getConfiguration", "()Lcom/intellij/clion/west/execution/WestRunConfiguration;", "createProcess", "Lcom/intellij/execution/process/ProcessHandler;", "state", "Lcom/intellij/execution/configurations/CommandLineState;", "getRunFileAndEnvironment", "Lkotlin/Pair;", "Ljava/io/File;", "Lcom/jetbrains/cidr/cpp/toolchains/CPPEnvironment;", "intellij.clion.west"})
public final class WestLauncher
extends CLionLauncher {
    @NotNull
    private final WestRunConfiguration configuration;
    @NotNull
    private final CMakeConfiguration buildConfiguration;

    public WestLauncher(@NotNull ExecutionEnvironment executionEnvironment, @NotNull WestRunConfiguration configuration, @NotNull CMakeConfiguration buildConfiguration) {
        Intrinsics.checkNotNullParameter((Object)executionEnvironment, (String)"executionEnvironment");
        Intrinsics.checkNotNullParameter((Object)((Object)configuration), (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)buildConfiguration, (String)"buildConfiguration");
        super(executionEnvironment, (OCRunConfiguration)configuration);
        this.configuration = configuration;
        this.buildConfiguration = buildConfiguration;
    }

    @NotNull
    public WestRunConfiguration getConfiguration() {
        return this.configuration;
    }

    @NotNull
    public Pair<File, CPPEnvironment> getRunFileAndEnvironment() {
        CMakeProfileInfo profileInfo = CMakeWorkspace.Companion.getInstance(this.getProject()).getProfileInfoFor(this.buildConfiguration);
        CPPEnvironment environment = profileInfo.getEnvironmentSafe(false);
        String executable = WestSettingsKt.calculateWestExecutablePath(this.getProject());
        return TuplesKt.to((Object)new File(executable), (Object)environment);
    }

    @NotNull
    public ProcessHandler createProcess(@NotNull CommandLineState state) {
        String parameters;
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Pair<File, CPPEnvironment> pair = this.getRunFileAndEnvironment();
        File runFile = (File)pair.component1();
        CPPEnvironment cppEnvironment = (CPPEnvironment)pair.component2();
        WestSettings westSettings = WestSettings.Companion.getInstance(this.getProject());
        String[] stringArray = new String[]{runFile.getPath(), "flash", "--build-dir=" + westSettings.getState().getBuildDir()};
        String[] it = stringArray = new GeneralCommandLine(stringArray).withWorkingDirectory(CMakeWorkspace.Companion.getInstance(this.getProject()).getProjectPath());
        boolean bl = false;
        String string = parameters = this.getConfiguration().getOptions().getAdditionalOptions();
        boolean bl2 = string != null ? !StringsKt.isBlank((CharSequence)string) : false;
        if (bl2) {
            String[] stringArray2 = new String[]{parameters};
            it.addParameters(stringArray2);
        }
        cppEnvironment.prepare((GeneralCommandLine)it, CidrToolEnvironment.PrepareFor.RUN);
        String[] stringArray3 = stringArray;
        Intrinsics.checkNotNullExpressionValue((Object)stringArray3, (String)"also(...)");
        String[] cl = stringArray3;
        File projectBaseDir = this.getProjectBaseDir();
        state.setConsoleBuilder(this.createConsoleBuilder(state, (CidrToolEnvironment)cppEnvironment, projectBaseDir, this.getConfiguration().isEmulateTerminal()));
        ProcessHandler handler = this.createProcessHandler(cppEnvironment, (GeneralCommandLine)cl, false, this.getConfiguration().isElevated(), false, this.getConfiguration().isEmulateTerminal());
        CidrLauncher.configProcessHandler((ProcessHandler)handler, (boolean)false, (boolean)true, (Project)this.getProject());
        return handler;
    }
}

