/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.vuejs.lang.typescript.service.volar;

import com.intellij.javascript.nodejs.util.NodePackageRef;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.typescript.lsp.LspServerDownloader;
import com.intellij.lang.typescript.lsp.LspServerPackageDescriptor;
import com.intellij.lang.typescript.resolve.TypeScriptCompilerEvaluationFacade;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.vuejs.lang.typescript.service.volar.VolarLspServerPackageDescriptor;
import org.jetbrains.vuejs.options.VueSettingsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0014J\b\u0010\u0007\u001a\u00020\u0004H\u0002J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\n"}, d2={"Lorg/jetbrains/vuejs/lang/typescript/service/volar/VolarExecutableDownloader;", "Lcom/intellij/lang/typescript/lsp/LspServerDownloader;", "()V", "getExecutableForDefaultKey", "", "project", "Lcom/intellij/openapi/project/Project;", "getNewEvalExecutable", "getSelectedPackageRef", "Lcom/intellij/javascript/nodejs/util/NodePackageRef;", "intellij.vuejs"})
@ApiStatus.Experimental
public final class VolarExecutableDownloader
extends LspServerDownloader {
    @NotNull
    public static final VolarExecutableDownloader INSTANCE = new VolarExecutableDownloader();

    private VolarExecutableDownloader() {
        super((LspServerPackageDescriptor)VolarLspServerPackageDescriptor.INSTANCE);
    }

    @NotNull
    public NodePackageRef getSelectedPackageRef(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return VueSettingsKt.getVueSettings(project).getPackageRef();
    }

    @Nullable
    protected String getExecutableForDefaultKey(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (TypeScriptCompilerEvaluationFacade.Companion.getInstance(project) != null) {
            return this.getNewEvalExecutable();
        }
        return super.getExecutableForDefaultKey(project);
    }

    private final String getNewEvalExecutable() {
        String string = Registry.stringValue((String)"vue.language.server.default.version");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"stringValue(...)");
        String registryValue = string;
        String version = StringsKt.startsWith$default((String)registryValue, (String)"1", (boolean)false, (int)2, null) ? "tsc-vue1" : "tsc-vue";
        File file = new File(TypeScriptUtil.getTypeScriptCompilerFolderFile(), "typescript/node_modules/" + version + "/" + this.getPackageDescriptor().getDefaultPackageRelativePath());
        String path = file.getAbsolutePath();
        Intrinsics.checkNotNull((Object)path);
        return path;
    }
}

