/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.vuejs.lang.html.parser;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.LighterASTNode;
import com.intellij.lang.LighterLazyParseableNode;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.PsiBuilderFactory;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.psi.ParsingDiagnostics;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.ILazyParseableElementType;
import com.intellij.psi.tree.ILightLazyParseableElementType;
import com.intellij.util.diff.FlyweightCapableTreeStructure;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.vuejs.lang.LangMode;
import org.jetbrains.vuejs.lang.VueScriptLangs;
import org.jetbrains.vuejs.lang.html.VueFileElementType;
import org.jetbrains.vuejs.lang.html.VueFileTypeKt;
import org.jetbrains.vuejs.lang.html.VueLanguage;
import org.jetbrains.vuejs.lang.html.parser.VueParser;
import org.jetbrains.vuejs.lang.html.parser.VueParserDefinition;
import org.jetbrains.vuejs.lang.html.parser.VueParsing;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0007B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\b"}, d2={"Lorg/jetbrains/vuejs/lang/html/parser/VueElementTypes;", "", "()V", "VUE_EMBEDDED_CONTENT", "Lcom/intellij/psi/tree/IElementType;", "getVUE_EMBEDDED_CONTENT", "()Lcom/intellij/psi/tree/IElementType;", "EmbeddedVueContentElementType", "intellij.vuejs"})
public final class VueElementTypes {
    @NotNull
    public static final VueElementTypes INSTANCE = new VueElementTypes();
    @NotNull
    private static final IElementType VUE_EMBEDDED_CONTENT = (IElementType)new EmbeddedVueContentElementType();

    private VueElementTypes() {
    }

    @NotNull
    public final IElementType getVUE_EMBEDDED_CONTENT() {
        return VUE_EMBEDDED_CONTENT;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0014J\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\u0006\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lorg/jetbrains/vuejs/lang/html/parser/VueElementTypes$EmbeddedVueContentElementType;", "Lcom/intellij/psi/tree/ILazyParseableElementType;", "Lcom/intellij/psi/tree/ILightLazyParseableElementType;", "()V", "doParseContents", "Lcom/intellij/lang/ASTNode;", "chameleon", "psi", "Lcom/intellij/psi/PsiElement;", "parseContents", "Lcom/intellij/util/diff/FlyweightCapableTreeStructure;", "Lcom/intellij/lang/LighterASTNode;", "Lcom/intellij/lang/LighterLazyParseableNode;", "intellij.vuejs"})
    public static final class EmbeddedVueContentElementType
    extends ILazyParseableElementType
    implements ILightLazyParseableElementType {
        public EmbeddedVueContentElementType() {
            super("VUE_EMBEDDED_CONTENT", (Language)VueLanguage.Companion.getINSTANCE());
        }

        @NotNull
        public FlyweightCapableTreeStructure<LighterASTNode> parseContents(@NotNull LighterLazyParseableNode chameleon) {
            Intrinsics.checkNotNullParameter((Object)chameleon, (String)"chameleon");
            PsiFile psiFile = chameleon.getContainingFile();
            if (psiFile == null) {
                throw new IllegalStateException(chameleon.toString());
            }
            PsiFile file = psiFile;
            boolean htmlCompatMode = !VueFileTypeKt.isVueFile(file);
            Project project = file.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            Lexer lexer = VueParserDefinition.Util.INSTANCE.createLexer(project, null, htmlCompatMode, (LangMode)((Object)file.getUserData(VueScriptLangs.INSTANCE.getLANG_MODE())));
            PsiBuilder psiBuilder = PsiBuilderFactory.getInstance().createBuilder(file.getProject(), chameleon, lexer, this.getLanguage(), chameleon.getText());
            Intrinsics.checkNotNullExpressionValue((Object)psiBuilder, (String)"createBuilder(...)");
            PsiBuilder builder = psiBuilder;
            builder.putUserData(VueScriptLangs.INSTANCE.getLANG_MODE(), file.getUserData(VueScriptLangs.INSTANCE.getLANG_MODE()));
            builder.putUserData((Key)VueParsing.Companion.getHTML_COMPAT_MODE(), (Object)htmlCompatMode);
            new VueParser().parseWithoutBuildingTree((IElementType)VueFileElementType.Companion.getINSTANCE(), builder);
            FlyweightCapableTreeStructure flyweightCapableTreeStructure = builder.getLightTree();
            Intrinsics.checkNotNullExpressionValue((Object)flyweightCapableTreeStructure, (String)"getLightTree(...)");
            return flyweightCapableTreeStructure;
        }

        @NotNull
        protected ASTNode doParseContents(@NotNull ASTNode chameleon, @NotNull PsiElement psi) {
            Intrinsics.checkNotNullParameter((Object)chameleon, (String)"chameleon");
            Intrinsics.checkNotNullParameter((Object)psi, (String)"psi");
            PsiFile psiFile = psi.getContainingFile();
            if (psiFile == null) {
                throw new IllegalStateException(chameleon.toString());
            }
            PsiFile file = psiFile;
            boolean htmlCompatMode = !VueFileTypeKt.isVueFile(file);
            Project project = file.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            Lexer lexer = VueParserDefinition.Util.INSTANCE.createLexer(project, null, htmlCompatMode, (LangMode)((Object)file.getUserData(VueScriptLangs.INSTANCE.getLANG_MODE())));
            PsiBuilder psiBuilder = PsiBuilderFactory.getInstance().createBuilder(file.getProject(), chameleon, lexer, this.getLanguage(), chameleon.getChars());
            Intrinsics.checkNotNullExpressionValue((Object)psiBuilder, (String)"createBuilder(...)");
            PsiBuilder builder = psiBuilder;
            long startTime = System.nanoTime();
            builder.putUserData(VueScriptLangs.INSTANCE.getLANG_MODE(), file.getUserData(VueScriptLangs.INSTANCE.getLANG_MODE()));
            builder.putUserData((Key)VueParsing.Companion.getHTML_COMPAT_MODE(), (Object)htmlCompatMode);
            ASTNode aSTNode = new VueParser().parse((IElementType)VueFileElementType.Companion.getINSTANCE(), builder);
            Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"parse(...)");
            ASTNode node = aSTNode;
            ASTNode result2 = node.getFirstChildNode();
            ParsingDiagnostics.registerParse((PsiBuilder)builder, (Language)this.getLanguage(), (long)(System.nanoTime() - startTime));
            Intrinsics.checkNotNull((Object)result2);
            return result2;
        }
    }
}

