/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.vuejs.inspections;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.html.webSymbols.elements.WebSymbolElementDescriptor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.XmlElementVisitor;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlToken;
import com.intellij.webSymbols.PsiSourcedWebSymbol;
import com.intellij.webSymbols.WebSymbol;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.util.XmlTagUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.vuejs.VueBundle;
import org.jetbrains.vuejs.codeInsight.VueUtilKt;
import org.jetbrains.vuejs.inspections.quickfixes.VueImportComponentQuickFix;
import org.jetbrains.vuejs.lang.html.VueFileTypeKt;
import org.jetbrains.vuejs.model.VueModelVisitor;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rH\u0016\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/vuejs/inspections/VueMissingComponentImportInspection;", "Lcom/intellij/codeInspection/LocalInspectionTool;", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "session", "Lcom/intellij/codeInspection/LocalInspectionToolSession;", "isAvailableForFile", "file", "Lcom/intellij/psi/PsiFile;", "intellij.vuejs"})
public final class VueMissingComponentImportInspection
extends LocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        return (PsiElementVisitor)new XmlElementVisitor(holder){
            final /* synthetic */ ProblemsHolder $holder;
            {
                this.$holder = $holder;
            }

            public void visitXmlTag(@NotNull XmlTag tag) {
                Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
                XmlElementDescriptor descriptor = tag.getDescriptor();
                if (!(descriptor instanceof WebSymbolElementDescriptor)) {
                    return;
                }
                WebSymbol symbol = ((WebSymbolElementDescriptor)descriptor).getSymbol();
                if (!(symbol instanceof PsiSourcedWebSymbol) || symbol.getProperties().get("x-vue-proximity") != VueModelVisitor.Proximity.OUT_OF_SCOPE || Intrinsics.areEqual(symbol.getProperties().get("x-vue-composition-component"), (Object)true)) {
                    return;
                }
                PsiElement psiElement = ((PsiSourcedWebSymbol)symbol).getSource();
                if (psiElement == null) {
                    return;
                }
                PsiElement elementToImport = psiElement;
                XmlToken xmlToken = XmlTagUtil.getStartTagNameElement((XmlTag)tag);
                if (xmlToken == null) {
                    return;
                }
                XmlToken tagNameToken = xmlToken;
                String tagName = tagNameToken.getText();
                PsiElement psiElement2 = (PsiElement)tagNameToken;
                Object[] objectArray = new Object[1];
                Intrinsics.checkNotNull((Object)tagName);
                objectArray[0] = tagName;
                String string = VueBundle.message("vue.inspection.message.missing.component.import", objectArray);
                objectArray = new LocalQuickFix[]{new VueImportComponentQuickFix((PsiElement)tagNameToken, VueUtilKt.toAsset(tagName, true), elementToImport)};
                this.$holder.registerProblem(psiElement2, string, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, (LocalQuickFix[])objectArray);
            }
        };
    }

    public boolean isAvailableForFile(@NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return VueFileTypeKt.isVueFile(file);
    }
}

