/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rml.dfa.utils.measurements;

import com.intellij.rml.dfa.DfaEvaluationStatus;
import com.intellij.rml.dfa.utils.FormatHelperKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0003\u0003\u0004\u0005B\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002\u0082\u0001\u0003\u0006\u0007\b\u00a8\u0006\t"}, d2={"Lcom/intellij/rml/dfa/utils/measurements/DfaSingleMeasurementResult;", "", "()V", "Invalid", "Numeric", "Status", "Lcom/intellij/rml/dfa/utils/measurements/DfaSingleMeasurementResult$Invalid;", "Lcom/intellij/rml/dfa/utils/measurements/DfaSingleMeasurementResult$Numeric;", "Lcom/intellij/rml/dfa/utils/measurements/DfaSingleMeasurementResult$Status;", "intellij.rml.dfa"})
public abstract class DfaSingleMeasurementResult {
    private DfaSingleMeasurementResult() {
    }

    public /* synthetic */ DfaSingleMeasurementResult(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016\u00a8\u0006\u0005"}, d2={"Lcom/intellij/rml/dfa/utils/measurements/DfaSingleMeasurementResult$Invalid;", "Lcom/intellij/rml/dfa/utils/measurements/DfaSingleMeasurementResult;", "()V", "toString", "", "intellij.rml.dfa"})
    public static final class Invalid
    extends DfaSingleMeasurementResult {
        @NotNull
        public static final Invalid INSTANCE = new Invalid();

        private Invalid() {
            super(null);
        }

        @NotNull
        public String toString() {
            return "N/A";
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0004\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001:\u0002\u000b\fB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\u00002\u0006\u0010\b\u001a\u00020\u0003H\u0016J\b\u0010\t\u001a\u00020\nH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\r"}, d2={"Lcom/intellij/rml/dfa/utils/measurements/DfaSingleMeasurementResult$Numeric;", "Lcom/intellij/rml/dfa/utils/measurements/DfaSingleMeasurementResult;", "value", "", "(Ljava/lang/Number;)V", "getValue", "()Ljava/lang/Number;", "createWith", "number", "toString", "", "ExecutionDuration", "MemoryConsumption", "intellij.rml.dfa"})
    public static class Numeric
    extends DfaSingleMeasurementResult {
        @NotNull
        private final Number value;

        public Numeric(@NotNull Number value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            super(null);
            this.value = value;
        }

        @NotNull
        public final Number getValue() {
            return this.value;
        }

        @NotNull
        public Numeric createWith(@NotNull Number number) {
            Intrinsics.checkNotNullParameter((Object)number, (String)"number");
            return new Numeric(number);
        }

        @NotNull
        public String toString() {
            return FormatHelperKt.formatNumber$default(this.value.longValue(), 0, 2, null);
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0010\u0004\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0010\u0010\t\u001a\u00020\u00002\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001J\b\u0010\u0012\u001a\u00020\u0013H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0014"}, d2={"Lcom/intellij/rml/dfa/utils/measurements/DfaSingleMeasurementResult$Numeric$ExecutionDuration;", "Lcom/intellij/rml/dfa/utils/measurements/DfaSingleMeasurementResult$Numeric;", "millis", "", "(J)V", "getMillis", "()J", "component1", "copy", "createWith", "number", "", "equals", "", "other", "", "hashCode", "", "toString", "", "intellij.rml.dfa"})
        public static final class ExecutionDuration
        extends Numeric {
            private final long millis;

            public ExecutionDuration(long millis) {
                super(millis);
                this.millis = millis;
            }

            public final long getMillis() {
                return this.millis;
            }

            @Override
            @NotNull
            public ExecutionDuration createWith(@NotNull Number number) {
                Intrinsics.checkNotNullParameter((Object)number, (String)"number");
                return new ExecutionDuration(number.longValue());
            }

            @Override
            @NotNull
            public String toString() {
                return FormatHelperKt.formatDuration$default(this.millis, 0, 2, null);
            }

            public final long component1() {
                return this.millis;
            }

            @NotNull
            public final ExecutionDuration copy(long millis) {
                return new ExecutionDuration(millis);
            }

            public static /* synthetic */ ExecutionDuration copy$default(ExecutionDuration executionDuration, long l, int n, Object object) {
                if ((n & 1) != 0) {
                    l = executionDuration.millis;
                }
                return executionDuration.copy(l);
            }

            public int hashCode() {
                return Long.hashCode(this.millis);
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof ExecutionDuration)) {
                    return false;
                }
                ExecutionDuration executionDuration = (ExecutionDuration)other;
                return this.millis == executionDuration.millis;
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0010\u0004\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0010\u0010\t\u001a\u00020\u00002\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001J\b\u0010\u0012\u001a\u00020\u0013H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0014"}, d2={"Lcom/intellij/rml/dfa/utils/measurements/DfaSingleMeasurementResult$Numeric$MemoryConsumption;", "Lcom/intellij/rml/dfa/utils/measurements/DfaSingleMeasurementResult$Numeric;", "bytes", "", "(J)V", "getBytes", "()J", "component1", "copy", "createWith", "number", "", "equals", "", "other", "", "hashCode", "", "toString", "", "intellij.rml.dfa"})
        public static final class MemoryConsumption
        extends Numeric {
            private final long bytes;

            public MemoryConsumption(long bytes) {
                super(bytes);
                this.bytes = bytes;
            }

            public final long getBytes() {
                return this.bytes;
            }

            @Override
            @NotNull
            public MemoryConsumption createWith(@NotNull Number number) {
                Intrinsics.checkNotNullParameter((Object)number, (String)"number");
                return new MemoryConsumption(number.longValue());
            }

            @Override
            @NotNull
            public String toString() {
                return FormatHelperKt.formatMemorySize$default(this.bytes, 0, 2, null);
            }

            public final long component1() {
                return this.bytes;
            }

            @NotNull
            public final MemoryConsumption copy(long bytes) {
                return new MemoryConsumption(bytes);
            }

            public static /* synthetic */ MemoryConsumption copy$default(MemoryConsumption memoryConsumption, long l, int n, Object object) {
                if ((n & 1) != 0) {
                    l = memoryConsumption.bytes;
                }
                return memoryConsumption.copy(l);
            }

            public int hashCode() {
                return Long.hashCode(this.bytes);
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof MemoryConsumption)) {
                    return false;
                }
                MemoryConsumption memoryConsumption = (MemoryConsumption)other;
                return this.bytes == memoryConsumption.bytes;
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\b\u0010\u000f\u001a\u00020\u0010H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"Lcom/intellij/rml/dfa/utils/measurements/DfaSingleMeasurementResult$Status;", "Lcom/intellij/rml/dfa/utils/measurements/DfaSingleMeasurementResult;", "value", "Lcom/intellij/rml/dfa/DfaEvaluationStatus;", "(Lcom/intellij/rml/dfa/DfaEvaluationStatus;)V", "getValue", "()Lcom/intellij/rml/dfa/DfaEvaluationStatus;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "intellij.rml.dfa"})
    public static final class Status
    extends DfaSingleMeasurementResult {
        @NotNull
        private final DfaEvaluationStatus value;

        public Status(@NotNull DfaEvaluationStatus value) {
            Intrinsics.checkNotNullParameter((Object)((Object)value), (String)"value");
            super(null);
            this.value = value;
        }

        @NotNull
        public final DfaEvaluationStatus getValue() {
            return this.value;
        }

        @NotNull
        public String toString() {
            return this.value.toString();
        }

        @NotNull
        public final DfaEvaluationStatus component1() {
            return this.value;
        }

        @NotNull
        public final Status copy(@NotNull DfaEvaluationStatus value) {
            Intrinsics.checkNotNullParameter((Object)((Object)value), (String)"value");
            return new Status(value);
        }

        public static /* synthetic */ Status copy$default(Status status, DfaEvaluationStatus dfaEvaluationStatus, int n, Object object) {
            if ((n & 1) != 0) {
                dfaEvaluationStatus = status.value;
            }
            return status.copy(dfaEvaluationStatus);
        }

        public int hashCode() {
            return this.value.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Status)) {
                return false;
            }
            Status status = (Status)other;
            return this.value == status.value;
        }
    }
}

