/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rml.dfa.impl.translator;

import com.intellij.rml.dfa.AnalysisOptions;
import com.intellij.rml.dfa.DfaAnalysisKind;
import com.intellij.rml.dfa.DfaInternalException;
import com.intellij.rml.dfa.DfaNotImplementedException;
import com.intellij.rml.dfa.analyzes.input.InputRelations;
import com.intellij.rml.dfa.analyzes.input.InputRelationsGlobal;
import com.intellij.rml.dfa.analyzes.input.InputRelationsPredefined;
import com.intellij.rml.dfa.analyzes.input.O;
import com.intellij.rml.dfa.analyzes.input.P;
import com.intellij.rml.dfa.analyzes.input.S;
import com.intellij.rml.dfa.analyzes.input.V;
import com.intellij.rml.dfa.attributes.Attribute;
import com.intellij.rml.dfa.attributes.DfaTuple;
import com.intellij.rml.dfa.impl.translator.InlineTranslatorExtension;
import com.intellij.rml.dfa.impl.translator.IrConstantsCollector;
import com.intellij.rml.dfa.impl.translator.IrToRmlTranslatorKt;
import com.intellij.rml.dfa.impl.translator.IrTranslationContextImpl;
import com.intellij.rml.dfa.ir.IrLocationKt;
import com.intellij.rml.dfa.ir.IrProject;
import com.intellij.rml.dfa.ir.ast.IrAssignmentOfConditionStmt;
import com.intellij.rml.dfa.ir.ast.IrAssignmentStmt;
import com.intellij.rml.dfa.ir.ast.IrAttributeHolder;
import com.intellij.rml.dfa.ir.ast.IrAttributeWrapper;
import com.intellij.rml.dfa.ir.ast.IrCastStmt;
import com.intellij.rml.dfa.ir.ast.IrComparisonCondition;
import com.intellij.rml.dfa.ir.ast.IrCondition;
import com.intellij.rml.dfa.ir.ast.IrConstant;
import com.intellij.rml.dfa.ir.ast.IrConstantCondition;
import com.intellij.rml.dfa.ir.ast.IrConstantExpr;
import com.intellij.rml.dfa.ir.ast.IrCustomEvaluationCondition;
import com.intellij.rml.dfa.ir.ast.IrCustomEvaluationStmt;
import com.intellij.rml.dfa.ir.ast.IrEqualityKind;
import com.intellij.rml.dfa.ir.ast.IrExpr;
import com.intellij.rml.dfa.ir.ast.IrFieldDecl;
import com.intellij.rml.dfa.ir.ast.IrFieldID;
import com.intellij.rml.dfa.ir.ast.IrFunctionDecl;
import com.intellij.rml.dfa.ir.ast.IrFunctionID;
import com.intellij.rml.dfa.ir.ast.IrGetReferenceStmt;
import com.intellij.rml.dfa.ir.ast.IrGlobalVarDecl;
import com.intellij.rml.dfa.ir.ast.IrIdentifier;
import com.intellij.rml.dfa.ir.ast.IrInstanceofCondition;
import com.intellij.rml.dfa.ir.ast.IrIntConstant;
import com.intellij.rml.dfa.ir.ast.IrJoinStatement;
import com.intellij.rml.dfa.ir.ast.IrLoadRefStmt;
import com.intellij.rml.dfa.ir.ast.IrLoadStmt;
import com.intellij.rml.dfa.ir.ast.IrLocalVarDeclarationStmt;
import com.intellij.rml.dfa.ir.ast.IrMapGetStmt;
import com.intellij.rml.dfa.ir.ast.IrMapSetStmt;
import com.intellij.rml.dfa.ir.ast.IrNewArrayStmt;
import com.intellij.rml.dfa.ir.ast.IrNewRecordInstanceStmt;
import com.intellij.rml.dfa.ir.ast.IrObjectID;
import com.intellij.rml.dfa.ir.ast.IrParameterDecl;
import com.intellij.rml.dfa.ir.ast.IrRecordCopyStmt;
import com.intellij.rml.dfa.ir.ast.IrRecordDecl;
import com.intellij.rml.dfa.ir.ast.IrRecordID;
import com.intellij.rml.dfa.ir.ast.IrRecordType;
import com.intellij.rml.dfa.ir.ast.IrRecursiveVisitor;
import com.intellij.rml.dfa.ir.ast.IrRequirementStmt;
import com.intellij.rml.dfa.ir.ast.IrReturnStmt;
import com.intellij.rml.dfa.ir.ast.IrStatement;
import com.intellij.rml.dfa.ir.ast.IrStatementsVisitor;
import com.intellij.rml.dfa.ir.ast.IrStaticCallStmt;
import com.intellij.rml.dfa.ir.ast.IrStoreRefStmt;
import com.intellij.rml.dfa.ir.ast.IrStoreStmt;
import com.intellij.rml.dfa.ir.ast.IrStringConstant;
import com.intellij.rml.dfa.ir.ast.IrTopLevelDecl;
import com.intellij.rml.dfa.ir.ast.IrType;
import com.intellij.rml.dfa.ir.ast.IrUncontrolledVarStmt;
import com.intellij.rml.dfa.ir.ast.IrUnknownCallStmt;
import com.intellij.rml.dfa.ir.ast.IrUnknownExpr;
import com.intellij.rml.dfa.ir.ast.IrUnsupportedCondition;
import com.intellij.rml.dfa.ir.ast.IrValueConstant;
import com.intellij.rml.dfa.ir.ast.IrVarDereferenceStmt;
import com.intellij.rml.dfa.ir.ast.IrVarID;
import com.intellij.rml.dfa.ir.ast.IrVarInvalidationStmt;
import com.intellij.rml.dfa.ir.ast.IrVarMayBeNilAssumptionStmt;
import com.intellij.rml.dfa.ir.ast.IrVarRefExpr;
import com.intellij.rml.dfa.ir.ast.IrVirtualCallStmt;
import com.intellij.rml.dfa.ir.cfg.IrCFGBlock;
import com.intellij.rml.dfa.ir.cfg.IrCfg;
import com.intellij.rml.dfa.ir.cfg.IrConditionalJump;
import com.intellij.rml.dfa.ir.cfg.IrJump;
import com.intellij.rml.dfa.ir.cfg.IrUnconditionalJump;
import com.intellij.rml.dfa.rml.DfaConstants;
import com.intellij.rml.dfa.rml.dsl.lang.RmlRelation1;
import com.intellij.rml.dfa.rml.dsl.lang.RmlRelation2;
import com.intellij.rml.dfa.rml.dsl.lang.RmlRelation3;
import com.intellij.rml.dfa.translator.ComparisonTranslationHelperKt;
import com.intellij.rml.dfa.translator.IrTranslationContext;
import com.intellij.rml.dfa.translator.IrTranslatorExtension;
import com.intellij.rml.dfa.translator.LocalTuplesInfo;
import com.intellij.rml.dfa.utils.RMLOptions;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0092\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u00011B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u0015\u001a\u00020\u0016J \u0010\u0017\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0011H\u0002J\u0018\u0010\u001d\u001a\u00020\r2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0010\u001a\u00020 H\u0002J\u0016\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u000e\u0010\"\u001a\u00020#2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0014\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010%\u001a\u00020&J\u0016\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010(\u001a\u00020)H\u0002J\u0016\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010+\u001a\u00020,H\u0002J\f\u0010-\u001a\u00020\b*\u00020.H\u0002J\f\u0010/\u001a\u000200*\u00020.H\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lcom/intellij/rml/dfa/impl/translator/IrToRmlTranslator;", "", "project", "Lcom/intellij/rml/dfa/ir/IrProject;", "options", "Lcom/intellij/rml/dfa/utils/RMLOptions;", "(Lcom/intellij/rml/dfa/ir/IrProject;Lcom/intellij/rml/dfa/utils/RMLOptions;)V", "groupInstructions", "", "translators", "", "Lcom/intellij/rml/dfa/translator/IrTranslatorExtension;", "addConstants", "", "function", "Lcom/intellij/rml/dfa/ir/ast/IrFunctionDecl;", "ctx", "Lcom/intellij/rml/dfa/translator/IrTranslationContext;", "getPredefinedTuples", "", "Lcom/intellij/rml/dfa/attributes/DfaTuple;", "analysisKind", "Lcom/intellij/rml/dfa/DfaAnalysisKind;", "processCondition", "condition", "Lcom/intellij/rml/dfa/ir/ast/IrCondition;", "objectAttr", "Lcom/intellij/rml/dfa/ir/ast/IrObjectID;", "context", "translateBlock", "cfgBlock", "Lcom/intellij/rml/dfa/ir/cfg/IrCFGBlock;", "Lcom/intellij/rml/dfa/impl/translator/IrTranslationContextImpl;", "translateFunctionGlobal", "translateFunctionLocal", "Lcom/intellij/rml/dfa/translator/LocalTuplesInfo;", "translateGlobalDecl", "decl", "Lcom/intellij/rml/dfa/ir/ast/IrTopLevelDecl;", "translateGlobalVarDecl", "varDecl", "Lcom/intellij/rml/dfa/ir/ast/IrGlobalVarDecl;", "translateRecordDecl", "recordDecl", "Lcom/intellij/rml/dfa/ir/ast/IrRecordDecl;", "isNullable", "Lcom/intellij/rml/dfa/ir/ast/IrType;", "name", "Lcom/intellij/rml/dfa/ir/ast/IrRecordID;", "BaseInstructionTranslator", "intellij.rml.dfa.impl"})
public final class IrToRmlTranslator {
    @NotNull
    private final List<IrTranslatorExtension> translators;
    private final boolean groupInstructions;

    /*
     * WARNING - void declaration
     */
    public IrToRmlTranslator(@NotNull IrProject project, @NotNull RMLOptions options) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        Object object = new IrTranslatorExtension[]{new BaseInstructionTranslator(project), new InlineTranslatorExtension()};
        Object object2 = object = CollectionsKt.mutableListOf((Object[])object);
        IrToRmlTranslator irToRmlTranslator = this;
        boolean bl = false;
        IrTranslatorExtension irTranslatorExtension = options.get(AnalysisOptions.INSTANCE.getTranslatorExtension());
        if (irTranslatorExtension != null) {
            void list;
            IrTranslatorExtension it = irTranslatorExtension;
            boolean bl2 = false;
            ((Collection)list).add(it);
        }
        irToRmlTranslator.translators = object;
        this.groupInstructions = options.get(AnalysisOptions.INSTANCE.getGroupInstructionsInOneStatement());
    }

    @NotNull
    public final List<DfaTuple> translateGlobalDecl(@NotNull IrTopLevelDecl decl) {
        List<DfaTuple> list;
        Intrinsics.checkNotNullParameter((Object)decl, (String)"decl");
        IrTopLevelDecl irTopLevelDecl = decl;
        if (irTopLevelDecl instanceof IrFunctionDecl) {
            list = this.translateFunctionGlobal((IrFunctionDecl)decl);
        } else if (irTopLevelDecl instanceof IrGlobalVarDecl) {
            list = this.translateGlobalVarDecl((IrGlobalVarDecl)decl);
        } else if (irTopLevelDecl instanceof IrRecordDecl) {
            list = this.translateRecordDecl((IrRecordDecl)decl);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return list;
    }

    private final IrRecordID name(IrType $this$name) {
        return $this$name instanceof IrRecordType ? ((IrRecordType)$this$name).getRecord() : new IrRecordID(DfaConstants.INSTANCE.getPrimitiveType());
    }

    private final boolean isNullable(IrType $this$isNullable) {
        return $this$isNullable instanceof IrRecordType && ((IrRecordType)$this$isNullable).isNullable();
    }

    private final List<DfaTuple> translateRecordDecl(IrRecordDecl recordDecl) {
        IrTranslationContextImpl context = new IrTranslationContextImpl(null, this.groupInstructions, 1, null);
        IrRecordDecl $this$translateRecordDecl_u24lambda_u242 = recordDecl;
        boolean bl = false;
        for (IrRecordID superRecord : $this$translateRecordDecl_u24lambda_u242.getSuperRecords()) {
            IrTranslationContext.addTuple$default(context, InputRelationsGlobal.INSTANCE.getSubtype(), $this$translateRecordDecl_u24lambda_u242.getName(), superRecord, null, 8, null);
        }
        for (IrFieldDecl field : $this$translateRecordDecl_u24lambda_u242.getFields()) {
            IrTranslationContext.addTuple$default(context, InputRelationsGlobal.INSTANCE.getField(), field.getName(), $this$translateRecordDecl_u24lambda_u242.getName(), null, 8, null);
            IrType type = field.getType();
            if (type == null) continue;
            IrTranslationContext.addTuple$default(context, InputRelationsGlobal.INSTANCE.getFieldType(), field.getName(), this.name(type), IrToRmlTranslatorKt.boolAttr(this.isNullable(type)), null, 16, null);
        }
        if ($this$translateRecordDecl_u24lambda_u242.isMap()) {
            IrTranslationContext.addTuple$default(context, InputRelationsGlobal.INSTANCE.getMapRecord(), $this$translateRecordDecl_u24lambda_u242.getName(), null, 4, null);
        }
        IrTranslationContext.addTuple$default(context, InputRelationsGlobal.INSTANCE.getUnknownInstance(), new IrValueConstant("unknown instance of " + $this$translateRecordDecl_u24lambda_u242.getName(), null, 2, null), $this$translateRecordDecl_u24lambda_u242.getName(), null, 8, null);
        return context.getTuples();
    }

    private final List<DfaTuple> translateGlobalVarDecl(IrGlobalVarDecl varDecl) {
        IrTranslationContextImpl context = new IrTranslationContextImpl(null, this.groupInstructions, 1, null);
        IrTranslationContext.addTuple$default(context, InputRelationsGlobal.INSTANCE.getGlobalVar(), varDecl.getName(), null, 4, null);
        IrType type = varDecl.getType();
        if (varDecl.isPrivateOrConst()) {
            IrTranslationContext.addTuple$default(context, InputRelationsGlobal.INSTANCE.getPrivateGlobalVar(), varDecl.getName(), null, 4, null);
        }
        if (type != null) {
            IrTranslationContext.addTuple$default(context, InputRelationsGlobal.INSTANCE.getGlobalVarType(), varDecl.getName(), this.name(type), IrToRmlTranslatorKt.boolAttr(this.isNullable(type)), null, 16, null);
        }
        return context.getTuples();
    }

    private final List<DfaTuple> translateFunctionGlobal(IrFunctionDecl function2) {
        IrType returnType;
        IrTranslationContextImpl context = new IrTranslationContextImpl(null, this.groupInstructions, 1, null);
        if (function2.isPrivate()) {
            IrTranslationContext.addTuple$default(context, InputRelationsGlobal.INSTANCE.getPrivateFunction(), function2.getName(), null, 4, null);
        }
        if (function2.isStaticInitializerFunction()) {
            IrTranslationContext.addTuple$default(context, InputRelationsGlobal.INSTANCE.getStaticInitializerFunction(), function2.getName(), null, 4, null);
        }
        if ((returnType = function2.getReturnType()) != null) {
            IrTranslationContext.addTuple$default(context, InputRelationsGlobal.INSTANCE.getFunctionReturnType(), function2.getName(), this.name(returnType), IrToRmlTranslatorKt.boolAttr(this.isNullable(returnType)), null, 16, null);
        }
        for (IrTranslatorExtension translator : this.translators) {
            translator.translateGlobal(function2, context);
        }
        int n = function2.getParameters().size();
        for (int index = 0; index < n; ++index) {
            Iterator<Integer> iterator = function2.getParametersMayBeAliased().get(index).iterator();
            while (iterator.hasNext()) {
                int alias = ((Number)iterator.next()).intValue();
                IrTranslationContext.addTuple$default(context, InputRelationsGlobal.INSTANCE.getAliasedParameters(), function2.getName(), new IrAttributeWrapper(index), new IrAttributeWrapper(alias), null, 16, null);
            }
        }
        return context.getTuples();
    }

    @NotNull
    public final LocalTuplesInfo translateFunctionLocal(@NotNull IrFunctionDecl function2) {
        Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
        IrTranslationContextImpl context = new IrTranslationContextImpl(function2, this.groupInstructions);
        IrCfg cfg2 = function2.getBody();
        for (IrCFGBlock block : cfg2.getBlocks()) {
            context.nextStatement(false);
            context.startBlock(block);
            this.translateBlock(block, context);
            IrJump jump = cfg2.getJumps().get(block);
            if (jump instanceof IrConditionalJump) {
                this.processCondition(((IrConditionalJump)jump).getCondition(), IrTranslationContextImpl.objectID$default(context, ((IrConditionalJump)jump).getCondition(), block, 0, 4, null), context);
            }
            context.endBlock(block);
        }
        for (IrCFGBlock block : cfg2.getBlocks()) {
            int fromStmt = context.exitStmt(block);
            IrJump jump = cfg2.getJumps().get(block);
            if (jump instanceof IrConditionalJump) {
                Object[] objectArray = new IrCFGBlock[]{((IrConditionalJump)jump).getTrueBranch(), ((IrConditionalJump)jump).getFalseBranch()};
                for (IrCFGBlock branch : SetsKt.setOf((Object[])objectArray)) {
                    int toStmt = context.startStmt(branch);
                    IrAttributeWrapper isTrueBranch = IrToRmlTranslatorKt.boolAttr(Intrinsics.areEqual((Object)branch, (Object)((IrConditionalJump)jump).getTrueBranch()));
                    IrTranslationContext.addTuple$default(context, InputRelations.INSTANCE.getConditionalJump(), new IrAttributeWrapper(fromStmt), new IrAttributeWrapper(toStmt), IrTranslationContextImpl.objectID$default(context, ((IrConditionalJump)jump).getCondition(), block, 0, 4, null), isTrueBranch, null, 32, null);
                }
                continue;
            }
            if (jump instanceof IrUnconditionalJump) {
                int toStmt = context.startStmt(((IrUnconditionalJump)jump).getNextBlock());
                IrTranslationContext.addTuple$default(context, InputRelations.INSTANCE.getUnconditionalJump(), new IrAttributeWrapper(fromStmt), new IrAttributeWrapper(toStmt), null, 8, null);
                continue;
            }
            if (jump != null) continue;
        }
        IrTranslationContext.addTuple$default(context, InputRelations.INSTANCE.getStartStmt(), function2.getName(), new IrAttributeWrapper(context.startStmt(cfg2.getStartBlock())), null, 8, null);
        IrTranslationContext.addTuple$default(context, InputRelations.INSTANCE.getExitStmt(), function2.getName(), new IrAttributeWrapper(context.exitStmt(cfg2.getExitBlock())), null, 8, null);
        IrTranslationContext.addTuple$default(context, InputRelations.INSTANCE.getCurFunction(), function2.getName(), null, 4, null);
        this.addConstants(function2, context);
        Iterator<Object> iterator = function2.getParameters().iterator();
        int n = 0;
        while (iterator.hasNext()) {
            int index = n++;
            IrParameterDecl parameter = (IrParameterDecl)iterator.next();
            IrTranslationContext.addTuple$default(context, InputRelations.INSTANCE.getParameter(), new IrAttributeWrapper(index), parameter.getName(), null, 8, null);
            IrType paramType = parameter.getType();
            if (paramType == null) continue;
            IrTranslationContext.addTuple$default(context, InputRelations.INSTANCE.getParameterType(), parameter.getName(), this.name(paramType), IrToRmlTranslatorKt.boolAttr(this.isNullable(paramType)), null, 16, null);
        }
        return new LocalTuplesInfo(context.getTuples(), context.getLocations(), context.getLocationObjects());
    }

    /*
     * WARNING - void declaration
     */
    private final void processCondition(IrCondition condition, IrObjectID objectAttr, IrTranslationContext context) {
        IrCondition irCondition = condition;
        if (irCondition instanceof IrComparisonCondition) {
            void $this$processCondition_u24lambda_u243;
            List list;
            IrExpr left2 = ((IrComparisonCondition)condition).getLeft();
            IrExpr right2 = ((IrComparisonCondition)condition).getRight();
            List list2 = list = CollectionsKt.createListBuilder();
            IrTranslationContext irTranslationContext = context;
            boolean bl = false;
            if (left2 instanceof IrVarRefExpr) {
                $this$processCondition_u24lambda_u243.add(left2);
            }
            if (right2 instanceof IrVarRefExpr) {
                $this$processCondition_u24lambda_u243.add(right2);
            }
            irTranslationContext.beforeReadExprs(CollectionsKt.build((List)list));
            if (left2 instanceof IrVarRefExpr && right2 instanceof IrConstantExpr) {
                IrTranslationContext.addTuple$default(context, InputRelations.INSTANCE.getComparisonWithConstCondition(), objectAttr, new IrAttributeWrapper(DfaConstants.INSTANCE.getTrueValue()), ((IrVarRefExpr)left2).getVariable(), ((IrConstantExpr)right2).getConst(), ((IrComparisonCondition)condition).getKind(), null, 64, null);
                IrTranslationContext.addTuple$default(context, InputRelations.INSTANCE.getComparisonWithConstCondition(), objectAttr, new IrAttributeWrapper(DfaConstants.INSTANCE.getFalseValue()), ((IrVarRefExpr)left2).getVariable(), ((IrConstantExpr)right2).getConst(), ((IrComparisonCondition)condition).getKind().invert(), null, 64, null);
            } else if (left2 instanceof IrConstantExpr && right2 instanceof IrVarRefExpr) {
                IrTranslationContext.addTuple$default(context, InputRelations.INSTANCE.getComparisonWithConstCondition(), objectAttr, new IrAttributeWrapper(DfaConstants.INSTANCE.getTrueValue()), ((IrVarRefExpr)right2).getVariable(), ((IrConstantExpr)left2).getConst(), ((IrComparisonCondition)condition).getKind().flip(), null, 64, null);
                IrTranslationContext.addTuple$default(context, InputRelations.INSTANCE.getComparisonWithConstCondition(), objectAttr, new IrAttributeWrapper(DfaConstants.INSTANCE.getFalseValue()), ((IrVarRefExpr)right2).getVariable(), ((IrConstantExpr)left2).getConst(), ((IrComparisonCondition)condition).getKind().flip().invert(), null, 64, null);
            } else if (left2 instanceof IrVarRefExpr && right2 instanceof IrVarRefExpr) {
                IrTranslationContext.addTuple$default(context, InputRelations.INSTANCE.getComparisonWithVarCondition(), objectAttr, new IrAttributeWrapper(DfaConstants.INSTANCE.getTrueValue()), ((IrVarRefExpr)left2).getVariable(), ((IrVarRefExpr)right2).getVariable(), ((IrComparisonCondition)condition).getKind(), null, 64, null);
                IrTranslationContext.addTuple$default(context, InputRelations.INSTANCE.getComparisonWithVarCondition(), objectAttr, new IrAttributeWrapper(DfaConstants.INSTANCE.getFalseValue()), ((IrVarRefExpr)left2).getVariable(), ((IrVarRefExpr)right2).getVariable(), ((IrComparisonCondition)condition).getKind().invert(), null, 64, null);
            } else {
                if (left2 instanceof IrConstantExpr && right2 instanceof IrConstantExpr) {
                    throw new DfaInternalException("Use IrConstantCondition when both operands of IrComparisonCondition are constant");
                }
                IrTranslationContext.addTuple$default(context, InputRelations.INSTANCE.getUnsupportedCondition(), objectAttr, null, 4, null);
            }
        } else if (irCondition instanceof IrConstantCondition) {
            IrTranslationContext.addTuple$default(context, InputRelations.INSTANCE.getConstantCondition(), objectAttr, IrToRmlTranslatorKt.boolAttr(((IrConstantCondition)condition).getBranch()), null, 8, null);
        } else if (irCondition instanceof IrUnsupportedCondition) {
            IrTranslationContext.addTuple$default(context, InputRelations.INSTANCE.getUnsupportedCondition(), objectAttr, null, 4, null);
        } else {
            if (irCondition instanceof IrCustomEvaluationCondition) {
                throw new DfaNotImplementedException(null, 1, null);
            }
            if (irCondition instanceof IrInstanceofCondition) {
                IrIdentifier[] irIdentifierArray = new IrIdentifier[]{((IrInstanceofCondition)condition).getVariable()};
                context.beforeRead(condition, irIdentifierArray);
                IrTranslationContext.addTuple$default(context, InputRelations.INSTANCE.getInstanceofCondition(), objectAttr, ((IrInstanceofCondition)condition).getVariable(), this.name(((IrInstanceofCondition)condition).getType()), IrToRmlTranslatorKt.boolAttr(this.isNullable(((IrInstanceofCondition)condition).getType())), null, 32, null);
            }
        }
    }

    private final void addConstants(IrFunctionDecl function2, IrTranslationContext ctx) {
        IrConstantsCollector collector = new IrConstantsCollector();
        Set intConstants = CollectionsKt.toSet((Iterable)collector.collectConstants(function2));
        Iterator iterator = intConstants.iterator();
        while (iterator.hasNext()) {
            int intConstant = ((Number)iterator.next()).intValue();
            IrTranslationContext.addTuple$default(ctx, InputRelations.INSTANCE.getIntegerConstant(), new IrIntConstant(intConstant), null, 4, null);
        }
    }

    private final void translateBlock(IrCFGBlock cfgBlock, IrTranslationContextImpl ctx) {
        Iterator<IrStatement> iterator = cfgBlock.getInstructions().iterator();
        int n = 0;
        while (iterator.hasNext()) {
            int i = n++;
            IrStatement inst = iterator.next();
            if (i > 0 && !this.groupInstructions) {
                IrTranslationContext.nextStatement$default(ctx, false, 1, null);
            }
            for (IrTranslatorExtension translator : this.translators) {
                translator.translate(inst, ctx);
            }
        }
    }

    @NotNull
    public final List<DfaTuple> getPredefinedTuples(@NotNull DfaAnalysisKind analysisKind) {
        Intrinsics.checkNotNullParameter((Object)((Object)analysisKind), (String)"analysisKind");
        IrTranslationContextImpl context = new IrTranslationContextImpl(null, this.groupInstructions, 1, null);
        for (Attribute attribute : DfaConstants.INSTANCE.getAllConstants()) {
            IrTranslationContext.addTuple$default(context, InputRelationsPredefined.INSTANCE.getPredefinedConstant(), new IrValueConstant(attribute), null, 4, null);
        }
        IrTranslationContext.addTuple$default(context, InputRelationsPredefined.INSTANCE.getBoolToInt(), new IrAttributeWrapper(DfaConstants.INSTANCE.getFalseValue()), new IrIntConstant(0), null, 8, null);
        IrTranslationContext.addTuple$default(context, InputRelationsPredefined.INSTANCE.getBoolToInt(), new IrAttributeWrapper(DfaConstants.INSTANCE.getTrueValue()), new IrIntConstant(1), null, 8, null);
        if (analysisKind == DfaAnalysisKind.Interprocedural) {
            for (int i = 0; i < 100; ++i) {
                IrTranslationContext.addTuple$default(context, InputRelationsPredefined.INSTANCE.getPlaceholderValue(), new IrAttributeWrapper(i), new IrValueConstant(DfaConstants.INSTANCE.placeholder(i)), null, 8, null);
                IrTranslationContext.addTuple$default(context, InputRelationsPredefined.INSTANCE.getIncrement(), new IrAttributeWrapper(i), new IrAttributeWrapper(i + 1), null, 8, null);
            }
            IrTranslationContext.addTuple$default(context, InputRelationsPredefined.INSTANCE.getAliasingContext(), new IrAttributeWrapper(DfaConstants.INSTANCE.getAliasingContext()), null, 4, null);
            IrTranslationContext.addTuple$default(context, InputRelationsPredefined.INSTANCE.getEmptyMethod(), new IrFunctionID(DfaConstants.INSTANCE.getCurFunction()), null, 4, null);
            IrTranslationContext.addTuple$default(context, InputRelationsPredefined.INSTANCE.getNotInitializedConstant(), new IrValueConstant(DfaConstants.INSTANCE.getNotInitializedConst()), null, 4, null);
            IrTranslationContext.addTuple$default(context, InputRelationsPredefined.INSTANCE.getUnknownField(), new IrFieldID(DfaConstants.INSTANCE.getUnknownField()), null, 4, null);
            IrTranslationContext.addTuple$default(context, InputRelationsPredefined.INSTANCE.getPrimitiveType(), new IrRecordID(DfaConstants.INSTANCE.getPrimitiveType()), null, 4, null);
            IrTranslationContext.addTuple$default(context, InputRelationsPredefined.INSTANCE.getMapKeysField(), new IrFieldID(DfaConstants.INSTANCE.getMapKeys()), null, 4, null);
        }
        ComparisonTranslationHelperKt.processComparisonBasicRelations((Function2<? super RmlRelation1<P>, ? super IrEqualityKind, Unit>)((Function2)new Function2<RmlRelation1<P>, IrEqualityKind, Unit>(context){
            final /* synthetic */ IrTranslationContextImpl $context;
            {
                this.$context = $context;
                super(2);
            }

            public final void invoke(@NotNull RmlRelation1<P> relation, @NotNull IrEqualityKind attr) {
                Intrinsics.checkNotNullParameter(relation, (String)"relation");
                Intrinsics.checkNotNullParameter((Object)attr, (String)"attr");
                IrTranslationContext.addTuple$default(this.$context, relation, attr, null, 4, null);
            }
        }), (Function3<? super RmlRelation2<P, P>, ? super IrEqualityKind, ? super IrEqualityKind, Unit>)((Function3)new Function3<RmlRelation2<P, P>, IrEqualityKind, IrEqualityKind, Unit>(context){
            final /* synthetic */ IrTranslationContextImpl $context;
            {
                this.$context = $context;
                super(3);
            }

            public final void invoke(@NotNull RmlRelation2<P, P> relation, @NotNull IrEqualityKind attr1, @NotNull IrEqualityKind attr2) {
                Intrinsics.checkNotNullParameter(relation, (String)"relation");
                Intrinsics.checkNotNullParameter((Object)attr1, (String)"attr1");
                Intrinsics.checkNotNullParameter((Object)attr2, (String)"attr2");
                IrTranslationContext.addTuple$default(this.$context, relation, attr1, attr2, null, 8, null);
            }
        }));
        for (IrTranslatorExtension translator : this.translators) {
            translator.translatePredefined(context);
        }
        return context.getTuples();
    }

    public static final /* synthetic */ void access$processCondition(IrToRmlTranslator $this, IrCondition condition, IrObjectID objectAttr, IrTranslationContext context) {
        $this.processCondition(condition, objectAttr, context);
    }

    public static final /* synthetic */ IrRecordID access$name(IrToRmlTranslator $this, IrType $receiver) {
        return $this.name($receiver);
    }

    public static final /* synthetic */ boolean access$isNullable(IrToRmlTranslator $this, IrType $receiver) {
        return $this.isNullable($receiver);
    }

    public static final /* synthetic */ boolean access$getGroupInstructions$p(IrToRmlTranslator $this) {
        return $this.groupInstructions;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\r"}, d2={"Lcom/intellij/rml/dfa/impl/translator/IrToRmlTranslator$BaseInstructionTranslator;", "Lcom/intellij/rml/dfa/translator/IrTranslatorExtension;", "project", "Lcom/intellij/rml/dfa/ir/IrProject;", "(Lcom/intellij/rml/dfa/impl/translator/IrToRmlTranslator;Lcom/intellij/rml/dfa/ir/IrProject;)V", "getProject", "()Lcom/intellij/rml/dfa/ir/IrProject;", "translate", "", "instruction", "Lcom/intellij/rml/dfa/ir/ast/IrStatement;", "context", "Lcom/intellij/rml/dfa/translator/IrTranslationContext;", "intellij.rml.dfa.impl"})
    private final class BaseInstructionTranslator
    implements IrTranslatorExtension {
        @NotNull
        private final IrProject project;

        public BaseInstructionTranslator(IrProject project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            this.project = project;
        }

        @NotNull
        public final IrProject getProject() {
            return this.project;
        }

        @Override
        public void translate(@NotNull IrStatement instruction, @NotNull IrTranslationContext context) {
            Intrinsics.checkNotNullParameter((Object)instruction, (String)"instruction");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            instruction.accept(new IrStatementsVisitor(context, IrToRmlTranslator.this, this){
                final /* synthetic */ IrTranslationContext $context;
                final /* synthetic */ IrToRmlTranslator this$0;
                final /* synthetic */ BaseInstructionTranslator this$1;
                {
                    this.$context = $context;
                    this.this$0 = $receiver;
                    this.this$1 = $receiver2;
                }

                public void visitStatement(@NotNull IrStatement stmt) {
                    Intrinsics.checkNotNullParameter((Object)stmt, (String)"stmt");
                }

                public void visitLocalVarDeclarationStmt(@NotNull IrLocalVarDeclarationStmt stmt) {
                    Intrinsics.checkNotNullParameter((Object)stmt, (String)"stmt");
                    if (stmt.isTempVar()) {
                        IrTranslationContext.addTuple$default(this.$context, InputRelations.INSTANCE.getTempVariable(), stmt.getName(), null, 4, null);
                    } else {
                        this.$context.addStatement(InputRelations.INSTANCE.getDeclarator(), (IrAttributeHolder)stmt.getName(), stmt.getLocation());
                    }
                }

                private final void processAssignment(IrVarID resultAttr, IrExpr expr, IrStatement stmt) {
                    IrExpr irExpr = expr;
                    if (irExpr instanceof IrVarRefExpr) {
                        this.$context.beforeRead((IrVarRefExpr)expr);
                        this.$context.addStatement(InputRelations.INSTANCE.getAssignmentFromVar(), (IrAttributeHolder)resultAttr, (IrAttributeHolder)((IrVarRefExpr)expr).getVariable(), stmt.getLocation());
                    } else if (irExpr instanceof IrConstantExpr) {
                        this.$context.addStatement(InputRelations.INSTANCE.getAssignmentFromConstant(), (IrAttributeHolder)resultAttr, (IrAttributeHolder)((IrConstantExpr)expr).getConst(), stmt.getLocation());
                    } else if (Intrinsics.areEqual((Object)irExpr, (Object)IrUnknownExpr.INSTANCE)) {
                        this.$context.addStatement(InputRelations.INSTANCE.getAssignmentFromExpression(), (IrAttributeHolder)resultAttr, stmt.getLocation());
                    }
                }

                public void visitAssignmentStmt(@NotNull IrAssignmentStmt stmt) {
                    Intrinsics.checkNotNullParameter((Object)stmt, (String)"stmt");
                    IrIdentifier[] irIdentifierArray = new IrIdentifier[]{stmt.getResult()};
                    this.$context.beforeWrite(stmt, irIdentifierArray);
                    this.processAssignment(stmt.getResult(), stmt.getValue(), stmt);
                    irIdentifierArray = new IrIdentifier[]{stmt.getResult()};
                    this.$context.afterWrite(stmt, irIdentifierArray);
                }

                public void visitAssignmentOfConditionStmt(@NotNull IrAssignmentOfConditionStmt stmt) {
                    Intrinsics.checkNotNullParameter((Object)stmt, (String)"stmt");
                    IrObjectID condAttr = this.$context.objectID(stmt.getCondition());
                    IrToRmlTranslator.access$processCondition(this.this$0, stmt.getCondition(), condAttr, this.$context);
                    IrIdentifier[] irIdentifierArray = new IrIdentifier[]{stmt.getResult()};
                    this.$context.beforeWrite(stmt, irIdentifierArray);
                    this.$context.addStatement(InputRelations.INSTANCE.getAssignmentFromCondition(), (IrAttributeHolder)stmt.getResult(), (IrAttributeHolder)condAttr, stmt.getLocation());
                    irIdentifierArray = new IrIdentifier[]{stmt.getResult()};
                    this.$context.afterWrite(stmt, irIdentifierArray);
                }

                public void visitLoadStmt(@NotNull IrLoadStmt stmt) {
                    Intrinsics.checkNotNullParameter((Object)stmt, (String)"stmt");
                    IrIdentifier[] irIdentifierArray = new IrIdentifier[]{stmt.getResult()};
                    this.$context.beforeWrite(stmt, irIdentifierArray);
                    irIdentifierArray = new IrIdentifier[]{stmt.getReceiver(), stmt.getField()};
                    this.$context.beforeRead(stmt, irIdentifierArray);
                    this.$context.addStatement(InputRelations.INSTANCE.getLoad(), (IrAttributeHolder)stmt.getResult(), (IrAttributeHolder)stmt.getReceiver(), (IrAttributeHolder)stmt.getField(), stmt.getLocation());
                    this.$context.addStatement(InputRelations.INSTANCE.getFieldRead(), (IrAttributeHolder)stmt.getReceiver(), (IrAttributeHolder)stmt.getField(), (IrAttributeHolder)this.$context.objectID(stmt), stmt.getLocation());
                    IrRecordID irRecordID = stmt.getReceiverDeclaredRecord();
                    if (irRecordID != null) {
                        IrRecordID irRecordID2 = irRecordID;
                        IrTranslationContext irTranslationContext = this.$context;
                        IrRecordID it = irRecordID2;
                        boolean bl = false;
                        irTranslationContext.addStatement(InputRelations.INSTANCE.getRecordUse(), (IrAttributeHolder)it, stmt.getLocation());
                    }
                    this.$context.addStatement(InputRelations.INSTANCE.getVarDereference(), (IrAttributeHolder)stmt.getReceiver(), (IrAttributeHolder)this.$context.objectID(stmt), stmt.getLocation());
                    irIdentifierArray = new IrIdentifier[]{stmt.getResult()};
                    this.$context.afterWrite(stmt, irIdentifierArray);
                }

                public void visitStoreStmt(@NotNull IrStoreStmt stmt) {
                    Intrinsics.checkNotNullParameter((Object)stmt, (String)"stmt");
                    IrIdentifier[] expr = stmt.getValue();
                    Object[] objectArray = new IrIdentifier[]{stmt.getField()};
                    this.$context.beforeWrite(stmt, (IrIdentifier[])objectArray);
                    if (expr instanceof IrVarRefExpr) {
                        objectArray = new Pair[]{TuplesKt.to((Object)stmt, (Object)stmt.getReceiver()), TuplesKt.to((Object)expr, (Object)((IrVarRefExpr)expr).getVariable())};
                        this.$context.beforeRead(CollectionsKt.listOf((Object[])objectArray));
                    } else {
                        objectArray = new IrIdentifier[]{stmt.getReceiver()};
                        this.$context.beforeRead(stmt, (IrIdentifier[])objectArray);
                    }
                    IrVarID receiverAttr = stmt.getReceiver();
                    IrIdentifier[] irIdentifierArray = expr;
                    if (irIdentifierArray instanceof IrVarRefExpr) {
                        this.$context.addStatement(InputRelations.INSTANCE.getStoreVar(), (IrAttributeHolder)receiverAttr, (IrAttributeHolder)stmt.getField(), (IrAttributeHolder)((IrVarRefExpr)expr).getVariable(), stmt.getLocation());
                    } else if (irIdentifierArray instanceof IrConstantExpr) {
                        this.$context.addStatement(InputRelations.INSTANCE.getStoreConst(), (IrAttributeHolder)receiverAttr, (IrAttributeHolder)stmt.getField(), (IrAttributeHolder)((IrConstantExpr)expr).getConst(), stmt.getLocation());
                    } else if (Intrinsics.areEqual((Object)irIdentifierArray, (Object)IrUnknownExpr.INSTANCE)) {
                        this.$context.addStatement(InputRelations.INSTANCE.getStoreExpr(), (IrAttributeHolder)receiverAttr, (IrAttributeHolder)stmt.getField(), stmt.getLocation());
                    }
                    IrRecordID irRecordID = stmt.getReceiverDeclaredRecord();
                    if (irRecordID != null) {
                        IrRecordID irRecordID2 = irRecordID;
                        IrTranslationContext irTranslationContext = this.$context;
                        IrRecordID it = irRecordID2;
                        boolean bl = false;
                        irTranslationContext.addStatement(InputRelations.INSTANCE.getRecordUse(), (IrAttributeHolder)it, stmt.getLocation());
                    }
                    this.$context.addStatement(InputRelations.INSTANCE.getVarDereference(), (IrAttributeHolder)stmt.getReceiver(), (IrAttributeHolder)this.$context.objectID(stmt), stmt.getLocation());
                    irIdentifierArray = new IrIdentifier[]{stmt.getField()};
                    this.$context.afterWrite(stmt, irIdentifierArray);
                }

                public void visitRecordCopyStmt(@NotNull IrRecordCopyStmt stmt) {
                    Intrinsics.checkNotNullParameter((Object)stmt, (String)"stmt");
                    IrTranslationContext.nextStatement$default(this.$context, false, 1, null);
                    IrIdentifier[] irIdentifierArray = new IrIdentifier[]{stmt.getSource(), stmt.getDest()};
                    this.$context.beforeRead(stmt, irIdentifierArray);
                    this.$context.addStatement(InputRelations.INSTANCE.getCopy(), (IrAttributeHolder)stmt.getDest(), (IrAttributeHolder)stmt.getSource(), (IrAttributeHolder)stmt.getRecord(), stmt.getLocation());
                    IrTranslationContext.nextStatement$default(this.$context, false, 1, null);
                }

                public void visitMapGetStmt(@NotNull IrMapGetStmt stmt) {
                    Intrinsics.checkNotNullParameter((Object)stmt, (String)"stmt");
                    IrVarID irVarID = stmt.getResult();
                    if (irVarID == null) {
                        return;
                    }
                    IrVarID resultAttr = irVarID;
                    IrExpr expr = stmt.getKey();
                    Object[] objectArray = new IrIdentifier[]{resultAttr};
                    this.$context.beforeWrite(stmt, (IrIdentifier[])objectArray);
                    if (expr instanceof IrVarRefExpr) {
                        objectArray = new Pair[]{TuplesKt.to((Object)expr, (Object)((IrVarRefExpr)expr).getVariable()), TuplesKt.to((Object)stmt, (Object)stmt.getMap())};
                        this.$context.beforeRead(CollectionsKt.listOf((Object[])objectArray));
                    } else {
                        objectArray = new IrIdentifier[]{stmt.getMap()};
                        this.$context.beforeRead(stmt, (IrIdentifier[])objectArray);
                    }
                    objectArray = expr;
                    if (objectArray instanceof IrVarRefExpr) {
                        this.$context.addStatement(InputRelations.INSTANCE.getMapGetVar(), (IrAttributeHolder)resultAttr, (IrAttributeHolder)stmt.getMap(), (IrAttributeHolder)((IrVarRefExpr)expr).getVariable(), stmt.getLocation());
                    } else if (objectArray instanceof IrConstantExpr) {
                        this.$context.addStatement(InputRelations.INSTANCE.getMapGetConst(), (IrAttributeHolder)resultAttr, (IrAttributeHolder)stmt.getMap(), (IrAttributeHolder)((IrConstantExpr)expr).getConst(), stmt.getLocation());
                    } else if (Intrinsics.areEqual((Object)objectArray, (Object)IrUnknownExpr.INSTANCE)) {
                        this.$context.addStatement(InputRelations.INSTANCE.getMapGetExpr(), (IrAttributeHolder)resultAttr, (IrAttributeHolder)stmt.getMap(), stmt.getLocation());
                    }
                    this.$context.addStatement(InputRelations.INSTANCE.getVarDereference(), (IrAttributeHolder)stmt.getMap(), (IrAttributeHolder)this.$context.objectID(stmt), stmt.getLocation());
                    objectArray = new IrIdentifier[]{resultAttr};
                    this.$context.afterWrite(stmt, (IrIdentifier[])objectArray);
                }

                public void visitMapSetStmt(@NotNull IrMapSetStmt stmt) {
                    Object[] objectArray;
                    Intrinsics.checkNotNullParameter((Object)stmt, (String)"stmt");
                    IrTranslationContext.nextStatement$default(this.$context, false, 1, null);
                    IrExpr expr = stmt.getKey();
                    if (expr instanceof IrVarRefExpr) {
                        objectArray = new Pair[]{TuplesKt.to((Object)stmt, (Object)stmt.getMap()), TuplesKt.to((Object)stmt, (Object)stmt.getValue()), TuplesKt.to((Object)expr, (Object)((IrVarRefExpr)expr).getVariable())};
                        this.$context.beforeRead(CollectionsKt.listOf((Object[])objectArray));
                    } else {
                        objectArray = new IrIdentifier[]{stmt.getMap(), stmt.getValue()};
                        this.$context.beforeRead(stmt, (IrIdentifier[])objectArray);
                    }
                    objectArray = expr;
                    if (objectArray instanceof IrVarRefExpr) {
                        this.$context.addStatement(InputRelations.INSTANCE.getMapSetVar(), (IrAttributeHolder)stmt.getMap(), (IrAttributeHolder)((IrVarRefExpr)expr).getVariable(), (IrAttributeHolder)stmt.getValue(), stmt.getLocation());
                    } else if (objectArray instanceof IrConstantExpr) {
                        this.$context.addStatement(InputRelations.INSTANCE.getMapSetConst(), (IrAttributeHolder)stmt.getMap(), (IrAttributeHolder)((IrConstantExpr)expr).getConst(), (IrAttributeHolder)stmt.getValue(), stmt.getLocation());
                    } else if (Intrinsics.areEqual((Object)objectArray, (Object)IrUnknownExpr.INSTANCE)) {
                        this.$context.addStatement(InputRelations.INSTANCE.getMapSetExpr(), (IrAttributeHolder)stmt.getMap(), (IrAttributeHolder)stmt.getValue(), stmt.getLocation());
                    }
                    this.$context.addStatement(InputRelations.INSTANCE.getVarDereference(), (IrAttributeHolder)stmt.getMap(), (IrAttributeHolder)this.$context.objectID(stmt), stmt.getLocation());
                    IrTranslationContext.nextStatement$default(this.$context, false, 1, null);
                }

                public void visitRequirementStmt(@NotNull IrRequirementStmt stmt) {
                    Intrinsics.checkNotNullParameter((Object)stmt, (String)"stmt");
                    this.$context.addStatement(InputRelations.INSTANCE.getAssert(), (IrAttributeHolder)this.$context.objectID(stmt.getCondition()), stmt.getLocation());
                }

                public void visitNewRecordInstanceStmt(@NotNull IrNewRecordInstanceStmt stmt) {
                    Intrinsics.checkNotNullParameter((Object)stmt, (String)"stmt");
                    IrVarID result = stmt.getResult();
                    if (result != null) {
                        IrIdentifier[] irIdentifierArray = new IrIdentifier[]{result};
                        this.$context.beforeWrite(stmt, irIdentifierArray);
                    }
                    IrValueConstant constant = this.$context.valueConst(stmt);
                    this.$context.addStatement(InputRelations.INSTANCE.getNewRecordInstanceCreation(), (IrAttributeHolder)constant, (IrAttributeHolder)stmt.getRecord(), stmt.getLocation());
                    if (result != null) {
                        this.$context.addStatement(InputRelations.INSTANCE.getAssignmentFromConstant(), (IrAttributeHolder)result, (IrAttributeHolder)constant, stmt.getLocation());
                        IrIdentifier[] irIdentifierArray = new IrIdentifier[]{result};
                        this.$context.afterWrite(stmt, irIdentifierArray);
                    }
                }

                public void visitNewArrayStmt(@NotNull IrNewArrayStmt stmt) {
                    IrExpr expr;
                    IrIdentifier[] irIdentifierArray;
                    Intrinsics.checkNotNullParameter((Object)stmt, (String)"stmt");
                    IrVarID result = stmt.getResult();
                    IrValueConstant constant = this.$context.valueConst(stmt);
                    if (result != null) {
                        irIdentifierArray = new IrIdentifier[]{result};
                        this.$context.beforeWrite(stmt, irIdentifierArray);
                    }
                    if ((expr = stmt.getLength()) instanceof IrVarRefExpr) {
                        this.$context.beforeRead((IrVarRefExpr)expr);
                        this.$context.addStatement(InputRelations.INSTANCE.getNewArrayVarLengthExpr(), (IrAttributeHolder)constant, (IrAttributeHolder)((IrVarRefExpr)expr).getVariable(), stmt.getLocation());
                    } else if (expr instanceof IrConstantExpr) {
                        this.$context.addStatement(InputRelations.INSTANCE.getNewArrayConstLengthExpr(), (IrAttributeHolder)constant, (IrAttributeHolder)((IrConstantExpr)expr).getConst(), stmt.getLocation());
                    } else if (Intrinsics.areEqual((Object)expr, (Object)IrUnknownExpr.INSTANCE)) {
                        // empty if block
                    }
                    if (result != null) {
                        this.$context.addStatement(InputRelations.INSTANCE.getAssignmentFromConstant(), (IrAttributeHolder)result, (IrAttributeHolder)constant, stmt.getLocation());
                        irIdentifierArray = new IrIdentifier[]{result};
                        this.$context.afterWrite(stmt, irIdentifierArray);
                    }
                }

                public void visitLoadRefStmt(@NotNull IrLoadRefStmt stmt) {
                    Intrinsics.checkNotNullParameter((Object)stmt, (String)"stmt");
                    throw new DfaNotImplementedException(null, 1, null);
                }

                public void visitStoreRefStmt(@NotNull IrStoreRefStmt stmt) {
                    Intrinsics.checkNotNullParameter((Object)stmt, (String)"stmt");
                    throw new DfaNotImplementedException(null, 1, null);
                }

                public void visitGetReferenceStmt(@NotNull IrGetReferenceStmt stmt) {
                    Intrinsics.checkNotNullParameter((Object)stmt, (String)"stmt");
                    throw new DfaNotImplementedException(null, 1, null);
                }

                public void visitStaticCallStmt(@NotNull IrStaticCallStmt stmt) {
                    Intrinsics.checkNotNullParameter((Object)stmt, (String)"stmt");
                    IrTranslationContext.nextStatement$default(this.$context, false, 1, null);
                    IrVarID result = stmt.getResult();
                    if (result != null) {
                        IrIdentifier[] irIdentifierArray = new IrIdentifier[]{result};
                        this.$context.beforeWrite(stmt, irIdentifierArray);
                    }
                    IrObjectID callAttr = this.$context.objectID(stmt);
                    this.$context.addStatement(InputRelations.INSTANCE.getCallExpression(), (IrAttributeHolder)stmt.getCallee(), (IrAttributeHolder)callAttr, stmt.getLocation());
                    this.processCallArguments(stmt.getArguments(), callAttr);
                    if (result != null) {
                        this.$context.addStatement(InputRelations.INSTANCE.getAssignmentFromCall(), (IrAttributeHolder)result, (IrAttributeHolder)callAttr, stmt.getLocation());
                        IrIdentifier[] irIdentifierArray = new IrIdentifier[]{result};
                        this.$context.afterWrite(stmt, irIdentifierArray);
                    }
                    IrTranslationContext.nextStatement$default(this.$context, false, 1, null);
                }

                public void visitVirtualCallStmt(@NotNull IrVirtualCallStmt stmt) {
                    Intrinsics.checkNotNullParameter((Object)stmt, (String)"stmt");
                    IrTranslationContext.nextStatement$default(this.$context, false, 1, null);
                    IrVarID result = stmt.getResult();
                    if (result != null) {
                        IrIdentifier[] irIdentifierArray = new IrIdentifier[]{result};
                        this.$context.beforeWrite(stmt, irIdentifierArray);
                    }
                    IrObjectID callAttr = this.$context.objectID(stmt);
                    for (IrFunctionID callee : this.this$1.getProject().getTargetsOfVirtualCall(stmt)) {
                        this.$context.addStatement(InputRelations.INSTANCE.getCallExpression(), (IrAttributeHolder)callee, (IrAttributeHolder)callAttr, stmt.getLocation());
                    }
                    this.processCallArguments(CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)stmt.getReceiver()), (Iterable)stmt.getArguments()), callAttr);
                    if (result != null) {
                        this.$context.addStatement(InputRelations.INSTANCE.getAssignmentFromCall(), (IrAttributeHolder)result, (IrAttributeHolder)callAttr, stmt.getLocation());
                        IrIdentifier[] irIdentifierArray = new IrIdentifier[]{result};
                        this.$context.afterWrite(stmt, irIdentifierArray);
                    }
                    this.$context.addStatement(InputRelations.INSTANCE.getVarDereference(), (IrAttributeHolder)stmt.getReceiver().getVariable(), (IrAttributeHolder)this.$context.objectID(stmt), stmt.getLocation());
                    IrRecordID irRecordID = stmt.getReceiverDeclaredRecord();
                    if (irRecordID != null) {
                        IrRecordID irRecordID2 = irRecordID;
                        IrTranslationContext irTranslationContext = this.$context;
                        IrRecordID it = irRecordID2;
                        boolean bl = false;
                        irTranslationContext.addStatement(InputRelations.INSTANCE.getRecordUse(), (IrAttributeHolder)it, stmt.getLocation());
                    }
                    IrTranslationContext.nextStatement$default(this.$context, false, 1, null);
                }

                public void visitUnknownCallStmt(@NotNull IrUnknownCallStmt stmt) {
                    Intrinsics.checkNotNullParameter((Object)stmt, (String)"stmt");
                    IrTranslationContext.nextStatement$default(this.$context, false, 1, null);
                    IrVarID result = stmt.getResult();
                    if (result != null) {
                        IrIdentifier[] irIdentifierArray = new IrIdentifier[]{result};
                        this.$context.beforeWrite(stmt, irIdentifierArray);
                    }
                    IrObjectID callAttr = this.$context.objectID(stmt);
                    if (stmt.isLibraryCall()) {
                        this.$context.addStatement(InputRelations.INSTANCE.getExternalCall(), (IrAttributeHolder)callAttr, stmt.getLocation());
                    } else {
                        this.$context.addStatement(InputRelations.INSTANCE.getUnknownCall(), (IrAttributeHolder)callAttr, stmt.getLocation());
                    }
                    this.processCallArguments(stmt.getArguments(), callAttr);
                    if (result != null) {
                        this.$context.addStatement(InputRelations.INSTANCE.getAssignmentFromCall(), (IrAttributeHolder)result, (IrAttributeHolder)callAttr, stmt.getLocation());
                        IrIdentifier[] irIdentifierArray = new IrIdentifier[]{result};
                        this.$context.afterWrite(stmt, irIdentifierArray);
                    }
                    IrTranslationContext.nextStatement$default(this.$context, false, 1, null);
                }

                private final void processCallArguments(List<? extends IrExpr> arguments, IrObjectID callAttr) {
                    Iterator<? extends IrExpr> iterator = arguments.iterator();
                    int n = 0;
                    while (iterator.hasNext()) {
                        int index = n++;
                        IrExpr argument = iterator.next();
                        IrAttributeWrapper indexAttr = new IrAttributeWrapper(index);
                        IrExpr irExpr = argument;
                        if (irExpr instanceof IrVarRefExpr) {
                            this.$context.beforeRead((IrVarRefExpr)argument);
                            this.$context.addTuple(InputRelations.INSTANCE.getCallVarArgument(), (IrAttributeHolder)callAttr, (IrAttributeHolder)indexAttr, (IrAttributeHolder)((IrVarRefExpr)argument).getVariable(), ((IrVarRefExpr)argument).getLocation());
                            continue;
                        }
                        if (irExpr instanceof IrConstantExpr) {
                            IrTranslationContext.addTuple$default(this.$context, InputRelations.INSTANCE.getCallConstArgument(), callAttr, indexAttr, ((IrConstantExpr)argument).getConst(), null, 16, null);
                            continue;
                        }
                        if (!Intrinsics.areEqual((Object)irExpr, (Object)IrUnknownExpr.INSTANCE)) continue;
                        IrTranslationContext.addTuple$default(this.$context, InputRelations.INSTANCE.getCallExprArgument(), callAttr, indexAttr, null, 8, null);
                    }
                }

                public void visitReturnStmt(@NotNull IrReturnStmt stmt) {
                    Intrinsics.checkNotNullParameter((Object)stmt, (String)"stmt");
                    IrExpr expr = stmt.getValue();
                    if (expr instanceof IrVarRefExpr) {
                        this.$context.beforeRead((IrVarRefExpr)expr);
                        this.$context.addStatement(InputRelations.INSTANCE.getReturnVarStmt(), (IrAttributeHolder)((IrVarRefExpr)expr).getVariable(), (IrAttributeHolder)this.$context.objectID(stmt), stmt.getLocation());
                    } else if (expr instanceof IrConstantExpr) {
                        this.$context.addStatement(InputRelations.INSTANCE.getReturnConstStmt(), (IrAttributeHolder)((IrConstantExpr)expr).getConst(), (IrAttributeHolder)this.$context.objectID(stmt), stmt.getLocation());
                    } else if (Intrinsics.areEqual((Object)expr, (Object)IrUnknownExpr.INSTANCE)) {
                        this.$context.addStatement(InputRelations.INSTANCE.getReturnExpressionStmt(), (IrAttributeHolder)this.$context.objectID(stmt), stmt.getLocation());
                    }
                }

                public void visitCastStmt(@NotNull IrCastStmt stmt) {
                    Intrinsics.checkNotNullParameter((Object)stmt, (String)"stmt");
                    IrIdentifier[] irIdentifierArray = new IrIdentifier[]{stmt.getVariable()};
                    this.$context.beforeRead(stmt, irIdentifierArray);
                    this.$context.addStatement(InputRelations.INSTANCE.getCastStmt(), (IrAttributeHolder)stmt.getVariable(), (IrAttributeHolder)IrToRmlTranslator.access$name(this.this$0, stmt.getType()), (IrAttributeHolder)IrToRmlTranslatorKt.boolAttr(IrToRmlTranslator.access$isNullable(this.this$0, stmt.getType())), (IrAttributeHolder)this.$context.objectID(stmt), stmt.getLocation());
                    irIdentifierArray = new IrIdentifier[]{stmt.getVariable()};
                    this.$context.addWriteIdentifier(irIdentifierArray);
                }

                public void visitJoinStmt(@NotNull IrJoinStatement stmt) {
                    Intrinsics.checkNotNullParameter((Object)stmt, (String)"stmt");
                    Object object = new IrIdentifier[]{stmt.getResult()};
                    this.$context.beforeWrite(stmt, (IrIdentifier[])object);
                    object = stmt.getExprs().iterator();
                    int n = 0;
                    while (object.hasNext()) {
                        int index = n++;
                        IrExpr expr = (IrExpr)object.next();
                        this.processAssignment(stmt.getResult(), expr, stmt);
                        IrIdentifier[] irIdentifierArray = new IrIdentifier[]{stmt.getResult()};
                        this.$context.afterWrite(stmt, irIdentifierArray);
                        if (index != 0 || stmt.getExprs().size() <= 1) continue;
                        if (IrToRmlTranslator.access$getGroupInstructions$p(this.this$0)) {
                            irIdentifierArray = new IrIdentifier[]{stmt.getResult()};
                            this.$context.beforeWrite(stmt, irIdentifierArray);
                        } else {
                            IrTranslationContext.nextStatement$default(this.$context, false, 1, null);
                        }
                        this.$context.addStatement(InputRelations.INSTANCE.getNotKillingAssignmentStmt(), (IrAttributeHolder)stmt.getResult(), stmt.getLocation());
                    }
                }

                public void visitUncontrolledVarStmt(@NotNull IrUncontrolledVarStmt stmt) {
                    Intrinsics.checkNotNullParameter((Object)stmt, (String)"stmt");
                    IrIdentifier[] irIdentifierArray = new IrIdentifier[]{stmt.getVariable()};
                    this.$context.beforeWrite(stmt, irIdentifierArray);
                    this.$context.addStatement(InputRelations.INSTANCE.getUncontrolledVarStmt(), (IrAttributeHolder)stmt.getVariable(), stmt.getLocation());
                    irIdentifierArray = new IrIdentifier[]{stmt.getVariable()};
                    this.$context.afterWrite(stmt, irIdentifierArray);
                }

                public void visitVarInvalidationStmt(@NotNull IrVarInvalidationStmt stmt) {
                    Intrinsics.checkNotNullParameter((Object)stmt, (String)"stmt");
                    IrIdentifier[] irIdentifierArray = new IrIdentifier[]{stmt.getVariable()};
                    this.$context.beforeWrite(stmt, irIdentifierArray);
                    this.$context.addStatement(InputRelations.INSTANCE.getVarInvalidationStmt(), (IrAttributeHolder)stmt.getVariable(), stmt.getLocation());
                    irIdentifierArray = new IrIdentifier[]{stmt.getVariable()};
                    this.$context.afterWrite(stmt, irIdentifierArray);
                }

                public void visitVarDereferenceStmt(@NotNull IrVarDereferenceStmt stmt) {
                    Intrinsics.checkNotNullParameter((Object)stmt, (String)"stmt");
                    IrIdentifier[] irIdentifierArray = new IrIdentifier[]{stmt.getVariable()};
                    this.$context.beforeWrite(stmt, irIdentifierArray);
                    irIdentifierArray = new IrIdentifier[]{stmt.getVariable()};
                    this.$context.beforeRead(stmt, irIdentifierArray);
                    RmlRelation3<S, V, O> rel = stmt.getRequireNotNullAfterDereference() ? InputRelations.INSTANCE.getVarDereference() : InputRelations.INSTANCE.getSoftVarDereference();
                    this.$context.addStatement(rel, (IrAttributeHolder)stmt.getVariable(), (IrAttributeHolder)this.$context.objectID(stmt), stmt.getLocation());
                    IrIdentifier[] irIdentifierArray2 = new IrIdentifier[]{stmt.getVariable()};
                    this.$context.addWriteIdentifier(irIdentifierArray2);
                }

                public void visitCustomEvaluationStmt(@NotNull IrCustomEvaluationStmt stmt) {
                    Intrinsics.checkNotNullParameter((Object)stmt, (String)"stmt");
                    throw new DfaNotImplementedException(null, 1, null);
                }

                public void visitVarMayBeNilAssumptionInstruction(@NotNull IrVarMayBeNilAssumptionStmt stmt) {
                    Intrinsics.checkNotNullParameter((Object)stmt, (String)"stmt");
                    IrIdentifier[] irIdentifierArray = new IrIdentifier[]{stmt.getVariable()};
                    this.$context.beforeRead(stmt, irIdentifierArray);
                    this.$context.addStatement(InputRelations.INSTANCE.getNullableVar(), (IrAttributeHolder)stmt.getVariable(), stmt.getLocation());
                }
            });
            instruction.accept(new IrRecursiveVisitor(context, IrToRmlTranslator.this){
                final /* synthetic */ IrTranslationContext $context;
                final /* synthetic */ IrToRmlTranslator this$0;
                {
                    this.$context = $context;
                    this.this$0 = $receiver;
                }

                public void visitConstant(@NotNull IrConstant irConstant) {
                    IrType type;
                    Intrinsics.checkNotNullParameter((Object)irConstant, (String)"const");
                    IrType irType = type = irConstant instanceof IrStringConstant ? ((IrStringConstant)irConstant).getType() : null;
                    if (type != null) {
                        this.$context.addTuple(InputRelations.INSTANCE.getConstantType(), (IrAttributeHolder)irConstant, (IrAttributeHolder)IrToRmlTranslator.access$name(this.this$0, type), IrLocationKt.getIrEmptyLocation());
                    }
                }
            });
        }
    }
}

