/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rml.dfa.impl.ir.cfg;

import com.intellij.rml.dfa.DfaInternalException;
import com.intellij.rml.dfa.impl.ir.cfg.IrCFGBlockImpl;
import com.intellij.rml.dfa.impl.ir.cfg.IrCfgRegionBuilderImpl;
import com.intellij.rml.dfa.ir.ast.IrCondition;
import com.intellij.rml.dfa.ir.cfg.IrCFGBlock;
import com.intellij.rml.dfa.ir.cfg.IrCfg;
import com.intellij.rml.dfa.ir.cfg.IrCfgBuilder;
import com.intellij.rml.dfa.ir.cfg.IrConditionalJump;
import com.intellij.rml.dfa.ir.cfg.IrJump;
import com.intellij.rml.dfa.ir.cfg.IrUnconditionalJump;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u000f\u001a\u00020\u0005H\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0013H\u0016J\b\u0010\u0015\u001a\u00020\u0005H\u0016J(\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0018\u0010\u001c\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0018\u0010\u001f\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u00052\u0006\u0010 \u001a\u00020\u0005H\u0016R\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\u0007R\u001c\u0010\f\u001a\u0004\u0018\u00010\u0005X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u0007\"\u0004\b\u000e\u0010\t\u00a8\u0006!"}, d2={"Lcom/intellij/rml/dfa/impl/ir/cfg/IrCfgBuilderImpl;", "Lcom/intellij/rml/dfa/impl/ir/cfg/IrCfgRegionBuilderImpl;", "Lcom/intellij/rml/dfa/ir/cfg/IrCfgBuilder;", "()V", "exitBlock", "Lcom/intellij/rml/dfa/ir/cfg/IrCFGBlock;", "getExitBlock", "()Lcom/intellij/rml/dfa/ir/cfg/IrCFGBlock;", "setExitBlock", "(Lcom/intellij/rml/dfa/ir/cfg/IrCFGBlock;)V", "lastAddedBlock", "getLastAddedBlock", "startBlock", "getStartBlock", "setStartBlock", "addBlock", "addSubgraph", "", "cfg", "Lcom/intellij/rml/dfa/ir/cfg/IrCfg;", "build", "createBlock", "setConditionalJump", "from", "trueBranch", "falseBranch", "condition", "Lcom/intellij/rml/dfa/ir/ast/IrCondition;", "setJump", "jump", "Lcom/intellij/rml/dfa/ir/cfg/IrJump;", "setUnconditionalJump", "to", "intellij.rml.dfa.impl"})
public final class IrCfgBuilderImpl
extends IrCfgRegionBuilderImpl
implements IrCfgBuilder {
    @Nullable
    private IrCFGBlock startBlock;
    @Nullable
    private IrCFGBlock exitBlock;

    @Override
    @NotNull
    public IrCFGBlock getLastAddedBlock() {
        return this.getLastBlock();
    }

    @Override
    @Nullable
    public IrCFGBlock getStartBlock() {
        return this.startBlock;
    }

    @Override
    public void setStartBlock(@Nullable IrCFGBlock irCFGBlock) {
        this.startBlock = irCFGBlock;
    }

    @Override
    @Nullable
    public IrCFGBlock getExitBlock() {
        return this.exitBlock;
    }

    @Override
    public void setExitBlock(@Nullable IrCFGBlock irCFGBlock) {
        this.exitBlock = irCFGBlock;
    }

    @Override
    public void addSubgraph(@NotNull IrCfg cfg2) {
        Intrinsics.checkNotNullParameter((Object)cfg2, (String)"cfg");
        CollectionsKt.addAll((Collection)this.getBlocks(), (Iterable)cfg2.getBlocks());
        this.getJumps().putAll(cfg2.getJumps());
        this.setUnconditionalJump(this.getLastBlock(), cfg2.getStartBlock());
        this.createBlock();
        this.setUnconditionalJump(cfg2.getExitBlock(), this.getLastBlock());
    }

    @Override
    @NotNull
    public IrCFGBlock addBlock() {
        if (this.getLastBlock().getInstructions().isEmpty()) {
            return this.getLastBlock();
        }
        IrCFGBlockImpl newExitBlock = new IrCFGBlockImpl(null, 1, null);
        this.getJumps().put(this.getLastBlock(), new IrUnconditionalJump(newExitBlock));
        ((Collection)this.getBlocks()).add(newExitBlock);
        this.setLastBlock(newExitBlock);
        return newExitBlock;
    }

    @Override
    @NotNull
    public IrCFGBlock createBlock() {
        IrCFGBlockImpl irCFGBlockImpl;
        IrCFGBlockImpl it = irCFGBlockImpl = new IrCFGBlockImpl(null, 1, null);
        boolean bl = false;
        ((Collection)this.getBlocks()).add(it);
        this.setLastBlock(it);
        return irCFGBlockImpl;
    }

    @Override
    public void setJump(@NotNull IrCFGBlock from, @NotNull IrJump jump) {
        Intrinsics.checkNotNullParameter((Object)from, (String)"from");
        Intrinsics.checkNotNullParameter((Object)jump, (String)"jump");
        if (this.getJumps().containsKey(from)) {
            throw new DfaInternalException("Jump from block \n" + from + "\n already exists");
        }
        this.getJumps().put(from, jump);
    }

    @Override
    public void setUnconditionalJump(@NotNull IrCFGBlock from, @NotNull IrCFGBlock to) {
        Intrinsics.checkNotNullParameter((Object)from, (String)"from");
        Intrinsics.checkNotNullParameter((Object)to, (String)"to");
        this.setJump(from, new IrUnconditionalJump(to));
    }

    @Override
    public void setConditionalJump(@NotNull IrCFGBlock from, @NotNull IrCFGBlock trueBranch, @NotNull IrCFGBlock falseBranch, @NotNull IrCondition condition) {
        Intrinsics.checkNotNullParameter((Object)from, (String)"from");
        Intrinsics.checkNotNullParameter((Object)trueBranch, (String)"trueBranch");
        Intrinsics.checkNotNullParameter((Object)falseBranch, (String)"falseBranch");
        Intrinsics.checkNotNullParameter((Object)condition, (String)"condition");
        this.setJump(from, new IrConditionalJump(condition, trueBranch, falseBranch));
    }

    @Override
    @NotNull
    public IrCfg build() {
        IrCFGBlock irCFGBlock;
        Set set = CollectionsKt.toSet((Iterable)this.getBlocks());
        Map<IrCFGBlock, IrJump> map2 = this.getJumps();
        IrCFGBlock irCFGBlock2 = this.getStartBlock();
        if (irCFGBlock2 == null) {
            irCFGBlock2 = (IrCFGBlock)CollectionsKt.first(this.getBlocks());
        }
        if ((irCFGBlock = this.getExitBlock()) == null) {
            irCFGBlock = this.getLastBlock();
        }
        return new IrCfg(set, map2, irCFGBlock2, irCFGBlock);
    }
}

