/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rml.dfa.impl.ir;

import com.intellij.rml.dfa.ir.IrProject;
import com.intellij.rml.dfa.ir.IrProjectFactory;
import com.intellij.rml.dfa.ir.ast.IrFunctionDecl;
import com.intellij.rml.dfa.ir.ast.IrFunctionID;
import com.intellij.rml.dfa.ir.ast.IrRecordDecl;
import com.intellij.rml.dfa.ir.ast.IrRecordID;
import com.intellij.rml.dfa.ir.ast.IrRecursiveVisitor;
import com.intellij.rml.dfa.ir.ast.IrStaticCallStmt;
import com.intellij.rml.dfa.ir.ast.IrTopLevelDecl;
import com.intellij.rml.dfa.ir.ast.IrVirtualCallStmt;
import com.intellij.rml.dfa.ir.ast.IrVisitor;
import com.intellij.rml.dfa.utils.FormatHelperKt;
import com.intellij.rml.dfa.utils.graph.Graph;
import com.intellij.rml.dfa.utils.graph.GraphBuilder;
import com.intellij.rml.dfa.utils.graph.GraphKt;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001b\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0010\u0010\u001d\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0016\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00032\u0006\u0010\u001f\u001a\u00020 H\u0016J\u001c\u0010!\u001a\u00020\u00012\u0012\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040#H\u0016J4\u0010$\u001a\u00020\u001a2\u0006\u0010%\u001a\u00020\u00142\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00140'2\u0006\u0010(\u001a\u00020\n2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\u000b0*H\u0002J4\u0010+\u001a\u00020\u001a2\u0006\u0010%\u001a\u00020\u00142\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00140'2\u0006\u0010(\u001a\u00020\n2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\u000b0*H\u0002R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00150\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00140\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R.\u0010\u0017\u001a\"\u0012\u0012\u0012\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0014\u0012\u0004\u0012\u00020\n0\u0018\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\u00030\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lcom/intellij/rml/dfa/impl/ir/IrProjectImpl;", "Lcom/intellij/rml/dfa/ir/IrProject;", "declarations", "", "Lcom/intellij/rml/dfa/ir/ast/IrTopLevelDecl;", "loggingEnabled", "", "(Ljava/util/List;Z)V", "allFunctions", "Lcom/intellij/util/containers/MultiMap;", "", "Lcom/intellij/rml/dfa/ir/ast/IrFunctionID;", "callGraph", "Lcom/intellij/rml/dfa/utils/graph/Graph;", "getCallGraph", "()Lcom/intellij/rml/dfa/utils/graph/Graph;", "getDeclarations", "()Ljava/util/List;", "recordIdToDecl", "", "Lcom/intellij/rml/dfa/ir/ast/IrRecordID;", "Lcom/intellij/rml/dfa/ir/ast/IrRecordDecl;", "recordsHierarchy", "virtualResolveCache", "Lkotlin/Pair;", "accept", "", "visitor", "Lcom/intellij/rml/dfa/ir/ast/IrVisitor;", "acceptChildren", "getTargetsOfVirtualCall", "callStmt", "Lcom/intellij/rml/dfa/ir/ast/IrVirtualCallStmt;", "mutate", "mutator", "Lkotlin/Function1;", "processSubRecords", "record", "processed", "", "signature", "targets", "", "processSuperRecords", "intellij.rml.dfa.impl"})
@SourceDebugExtension(value={"SMAP\nIrProjectImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IrProjectImpl.kt\ncom/intellij/rml/dfa/impl/ir/IrProjectImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,104:1\n800#2,11:105\n800#2,11:116\n1549#2:127\n1620#2,3:128\n1#3:131\n372#4,7:132\n*S KotlinDebug\n*F\n+ 1 IrProjectImpl.kt\ncom/intellij/rml/dfa/impl/ir/IrProjectImpl\n*L\n73#1:105,11\n83#1:116,11\n28#1:127\n28#1:128,3\n56#1:132,7\n*E\n"})
public final class IrProjectImpl
implements IrProject {
    @NotNull
    private final List<IrTopLevelDecl> declarations;
    @NotNull
    private final MultiMap<String, IrFunctionID> allFunctions;
    @NotNull
    private final Map<IrRecordID, IrRecordDecl> recordIdToDecl;
    @NotNull
    private final MultiMap<IrRecordID, IrRecordID> recordsHierarchy;
    @NotNull
    private final Map<Pair<IrRecordID, String>, List<IrFunctionID>> virtualResolveCache;
    @NotNull
    private final Graph<IrFunctionID> callGraph;

    /*
     * WARNING - void declaration
     */
    public IrProjectImpl(@NotNull List<? extends IrTopLevelDecl> declarations, boolean loggingEnabled) {
        void $this$filterIsInstanceTo$iv$iv;
        Intrinsics.checkNotNullParameter(declarations, (String)"declarations");
        this.declarations = declarations;
        this.allFunctions = new MultiMap();
        this.recordIdToDecl = new LinkedHashMap();
        this.recordsHierarchy = new MultiMap();
        this.virtualResolveCache = new LinkedHashMap();
        MultiMap calls = new MultiMap();
        Iterable $this$filterIsInstance$iv = this.getDeclarations();
        boolean $i$f$filterIsInstance232 = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : iterable) {
            if (!(element$iv$iv instanceof IrRecordDecl)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        for (IrRecordDecl record : (List)destination$iv$iv) {
            this.recordIdToDecl.put(record.getName(), record);
            for (IrRecordID irRecordID : record.getSuperRecords()) {
                this.recordsHierarchy.putValue((Object)irRecordID, (Object)record.getName());
            }
            for (Map.Entry entry : record.getVirtualMethods().entrySet()) {
                String signature = (String)entry.getKey();
                IrFunctionID function2 = (IrFunctionID)entry.getValue();
                this.allFunctions.putValue((Object)signature, (Object)function2);
            }
        }
        Iterable $this$filterIsInstance$iv2 = this.getDeclarations();
        boolean $i$f$filterIsInstance = false;
        Iterable $i$f$filterIsInstance232 = $this$filterIsInstance$iv2;
        Collection collection = new ArrayList();
        boolean $i$f$filterIsInstanceTo2 = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof IrFunctionDecl)) continue;
            collection.add(element$iv$iv);
        }
        FormatHelperKt.mapWithLogging((List)collection, loggingEnabled, "Building Call Graph", (Function1)new Function1<IrFunctionDecl, Unit>((MultiMap<IrFunctionID, IrFunctionID>)calls, this){
            final /* synthetic */ MultiMap<IrFunctionID, IrFunctionID> $calls;
            final /* synthetic */ IrProjectImpl this$0;
            {
                this.$calls = $calls;
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(final @NotNull IrFunctionDecl function2) {
                Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
                function2.accept(new IrRecursiveVisitor(){

                    @Override
                    public void visitStaticCallStmt(@NotNull IrStaticCallStmt stmt) {
                        Intrinsics.checkNotNullParameter((Object)stmt, (String)"stmt");
                        $calls.putValue((Object)function2.getName(), (Object)stmt.getCallee());
                    }

                    @Override
                    public void visitVirtualCallStmt(@NotNull IrVirtualCallStmt stmt) {
                        Intrinsics.checkNotNullParameter((Object)stmt, (String)"stmt");
                        $calls.putValues((Object)function2.getName(), (Collection)this$0.getTargetsOfVirtualCall(stmt));
                    }
                });
            }
        });
        this.callGraph = GraphKt.buildGraph((Function1)new Function1<GraphBuilder<IrFunctionID>, Unit>((MultiMap<IrFunctionID, IrFunctionID>)calls){
            final /* synthetic */ MultiMap<IrFunctionID, IrFunctionID> $calls;
            {
                this.$calls = $calls;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull GraphBuilder<IrFunctionID> $this$buildGraph) {
                void $this$filterIsInstanceTo$iv$iv;
                Intrinsics.checkNotNullParameter($this$buildGraph, (String)"$this$buildGraph");
                Iterable $this$filterIsInstance$iv = this.getDeclarations();
                boolean $i$f$filterIsInstance = false;
                Iterable iterable = $this$filterIsInstance$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterIsInstanceTo = false;
                for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                    if (!(element$iv$iv instanceof IrFunctionDecl)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                for (IrFunctionDecl function2 : (List)destination$iv$iv) {
                    $this$buildGraph.addNode(function2.getName());
                }
                for (IrFunctionID caller : this.$calls.keySet()) {
                    for (IrFunctionID callee : this.$calls.get((Object)caller)) {
                        Intrinsics.checkNotNull((Object)caller);
                        Intrinsics.checkNotNull((Object)callee);
                        $this$buildGraph.addEdge(caller, callee);
                    }
                }
            }
        });
    }

    @Override
    @NotNull
    public List<IrTopLevelDecl> getDeclarations() {
        return this.declarations;
    }

    @Override
    @NotNull
    public Graph<IrFunctionID> getCallGraph() {
        return this.callGraph;
    }

    @Override
    public void accept(@NotNull IrVisitor visitor) {
        Intrinsics.checkNotNullParameter((Object)visitor, (String)"visitor");
        visitor.visitProject(this);
    }

    @Override
    public void acceptChildren(@NotNull IrVisitor visitor) {
        Intrinsics.checkNotNullParameter((Object)visitor, (String)"visitor");
        for (IrTopLevelDecl declaration : this.getDeclarations()) {
            declaration.accept(visitor);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public IrProject mutate(@NotNull Function1<? super IrTopLevelDecl, ? extends IrTopLevelDecl> mutator) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(mutator, (String)"mutator");
        Iterable iterable = this.getDeclarations();
        IrProjectFactory irProjectFactory = IrProjectFactory.Companion.getInstance();
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            destination$iv$iv.add(mutator.invoke(item$iv$iv));
        }
        return IrProjectFactory.getProject$default(irProjectFactory, (List)destination$iv$iv, false, 2, null);
    }

    private final void processSuperRecords(IrRecordID record, Set<IrRecordID> processed, String signature, List<IrFunctionID> targets) {
        for (IrRecordID superRecord : ((IrRecordDecl)MapsKt.getValue(this.recordIdToDecl, (Object)record)).getSuperRecords()) {
            if (processed.contains(superRecord)) continue;
            ((Collection)processed).add(superRecord);
            IrFunctionID target = ((IrRecordDecl)MapsKt.getValue(this.recordIdToDecl, (Object)superRecord)).getVirtualMethods().get(signature);
            if (target == null) {
                this.processSuperRecords(superRecord, processed, signature, targets);
                continue;
            }
            ((Collection)targets).add(target);
        }
    }

    private final void processSubRecords(IrRecordID record, Set<IrRecordID> processed, String signature, List<IrFunctionID> targets) {
        ((Collection)processed).add(record);
        IrFunctionID irFunctionID = ((IrRecordDecl)MapsKt.getValue(this.recordIdToDecl, (Object)record)).getVirtualMethods().get(signature);
        if (irFunctionID != null) {
            IrFunctionID it = irFunctionID;
            boolean bl = false;
            ((Collection)targets).add(it);
        }
        for (IrRecordID subRecord : this.recordsHierarchy.get((Object)record)) {
            if (processed.contains(subRecord)) continue;
            Intrinsics.checkNotNull((Object)subRecord);
            this.processSubRecords(subRecord, processed, signature, targets);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<IrFunctionID> getTargetsOfVirtualCall(@NotNull IrVirtualCallStmt callStmt) {
        Object object;
        void $this$getOrPut$iv;
        Intrinsics.checkNotNullParameter((Object)callStmt, (String)"callStmt");
        Map<Pair<IrRecordID, String>, List<IrFunctionID>> map2 = this.virtualResolveCache;
        Pair key$iv = TuplesKt.to((Object)callStmt.getReceiverDeclaredRecord(), (Object)callStmt.getSignature());
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            List list;
            boolean bl = false;
            IrRecordID record = callStmt.getReceiverDeclaredRecord();
            if (record != null) {
                List targets = new ArrayList();
                this.processSuperRecords(record, new LinkedHashSet(), callStmt.getSignature(), targets);
                this.processSubRecords(record, new LinkedHashSet(), callStmt.getSignature(), targets);
                list = targets;
            } else {
                Collection collection = this.allFunctions.get((Object)callStmt.getSignature());
                Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"get(...)");
                list = CollectionsKt.toList((Iterable)collection);
            }
            List answer$iv = list;
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        return (List)object;
    }
}

