/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rml.dfa.impl.domains;

import com.intellij.rml.dfa.DfaInternalException;
import com.intellij.rml.dfa.analyzes.input.DomainTypesDescriptor;
import com.intellij.rml.dfa.impl.domains.DomainType;
import com.intellij.rml.dfa.ir.ast.IrIdentifier;
import com.intellij.rml.dfa.ir.ast.RmlIrCompatibleDomainType;
import com.intellij.rml.dfa.rml.dsl.lang.RmlDomainType;
import com.intellij.rml.dfa.utils.RMLOptions;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.reflect.KClassifier;
import kotlin.reflect.KType;
import kotlin.reflect.KTypeProjection;
import kotlin.reflect.full.KClasses;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0012J\u001a\u0010\u0013\u001a\u00020\u00142\u0012\u0010\u0016\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u000f0\u000eJ\u000e\u0010\u0017\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\u0019J\u000e\u0010\u0017\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\u0012J\u001a\u0010\u0017\u001a\u00020\t2\u0012\u0010\u0016\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u000f0\u000eJ\u0012\u0010\u001a\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0015\u001a\u00020\u0012H\u0002J\u0006\u0010\u001b\u001a\u00020\u0019J\"\u0010\u001c\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00100\u000e2\u0012\u0010\u0016\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u000f0\u000eR\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR.\u0010\f\u001a\"\u0012\u0010\u0012\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u000f0\u000e\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00100\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\t0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/intellij/rml/dfa/impl/domains/DomainTypeManager;", "", "descriptor", "Lcom/intellij/rml/dfa/analyzes/input/DomainTypesDescriptor;", "options", "Lcom/intellij/rml/dfa/utils/RMLOptions;", "(Lcom/intellij/rml/dfa/analyzes/input/DomainTypesDescriptor;Lcom/intellij/rml/dfa/utils/RMLOptions;)V", "availableDomainTypes", "", "Lcom/intellij/rml/dfa/impl/domains/DomainType;", "getAvailableDomainTypes", "()Ljava/util/List;", "nameToIrType", "", "Lkotlin/reflect/KClass;", "Lcom/intellij/rml/dfa/rml/dsl/lang/RmlDomainType;", "Lcom/intellij/rml/dfa/ir/ast/IrIdentifier;", "nameToType", "", "containsDomainType", "", "name", "type", "getDomainType", "idx", "", "getDomainTypeOrNull", "getDomainTypesCount", "getIrCompatibleType", "intellij.rml.dfa.impl"})
public final class DomainTypeManager {
    @NotNull
    private final List<DomainType> availableDomainTypes;
    @NotNull
    private final Map<String, DomainType> nameToType;
    @NotNull
    private final Map<KClass<? extends RmlDomainType<?>>, KClass<? extends IrIdentifier>> nameToIrType;

    /*
     * WARNING - void declaration
     */
    public DomainTypeManager(@NotNull DomainTypesDescriptor descriptor, @NotNull RMLOptions options) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        this.availableDomainTypes = new ArrayList();
        this.nameToType = new LinkedHashMap();
        this.nameToIrType = new LinkedHashMap();
        DomainTypesDescriptor $this$_init__u24lambda_u240 = descriptor;
        boolean bl = false;
        Iterator<String> iterator = $this$_init__u24lambda_u240.getDomainTypeNames().iterator();
        boolean n = false;
        while (iterator.hasNext()) {
            void var6_7;
            void i = var6_7++;
            String name = iterator.next();
            Integer n2 = $this$_init__u24lambda_u240.getFixedBitLength().get(name);
            DomainType type = new DomainType(name, (int)i, $this$_init__u24lambda_u240.getIntegerDomainTypes().contains(name), Intrinsics.areEqual((Object)name, (Object)$this$_init__u24lambda_u240.getContextType()), n2 != null ? n2 : -1);
            type.installDomains((int)i, $this$_init__u24lambda_u240.getDomainTypeNames().size());
            this.availableDomainTypes.add(type);
            this.nameToType.put(name, type);
        }
        for (KClass kClass : $this$_init__u24lambda_u240.getDomainTypesClasses()) {
            if (!KClasses.isSubclassOf((KClass)kClass, (KClass)Reflection.getOrCreateKotlinClass(RmlIrCompatibleDomainType.class))) continue;
            List arguments = ((KType)CollectionsKt.first((List)kClass.getSupertypes())).getArguments();
            KType kType = ((KTypeProjection)arguments.get(1)).getType();
            Intrinsics.checkNotNull((Object)kType);
            KClassifier kClassifier = kType.getClassifier();
            Intrinsics.checkNotNull((Object)kClassifier, (String)"null cannot be cast to non-null type kotlin.reflect.KClass<out com.intellij.rml.dfa.ir.ast.IrIdentifier>");
            KClass irClass = (KClass)kClassifier;
            this.nameToIrType.put(kClass, (KClass<? extends IrIdentifier>)irClass);
        }
    }

    @NotNull
    public final List<DomainType> getAvailableDomainTypes() {
        return this.availableDomainTypes;
    }

    private final DomainType getDomainTypeOrNull(String name) {
        return this.nameToType.get(name);
    }

    @NotNull
    public final DomainType getDomainType(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        DomainType domainType = this.getDomainTypeOrNull(name);
        if (domainType == null) {
            throw new DfaInternalException(null, null, 3, null);
        }
        return domainType;
    }

    @NotNull
    public final DomainType getDomainType(@NotNull KClass<? extends RmlDomainType<?>> type) {
        Intrinsics.checkNotNullParameter(type, (String)"type");
        DomainType domainType = this.getDomainTypeOrNull(((RmlDomainType)KClasses.createInstance(type)).getDomainTypeName());
        if (domainType == null) {
            throw new DfaInternalException(null, null, 3, null);
        }
        return domainType;
    }

    @NotNull
    public final DomainType getDomainType(int idx) {
        return this.availableDomainTypes.get(idx);
    }

    public final boolean containsDomainType(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return this.nameToType.containsKey(name);
    }

    public final boolean containsDomainType(@NotNull KClass<? extends RmlDomainType<?>> type) {
        Intrinsics.checkNotNullParameter(type, (String)"type");
        return this.nameToType.containsKey(((RmlDomainType)KClasses.createInstance(type)).getDomainTypeName());
    }

    public final int getDomainTypesCount() {
        return this.availableDomainTypes.size();
    }

    @NotNull
    public final KClass<? extends IrIdentifier> getIrCompatibleType(@NotNull KClass<? extends RmlDomainType<?>> type) {
        Intrinsics.checkNotNullParameter(type, (String)"type");
        KClass<? extends IrIdentifier> kClass = this.nameToIrType.get(type);
        Intrinsics.checkNotNull(kClass);
        return kClass;
    }
}

