/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rml.dfa.devtools.impl.picasso.graph;

import com.intellij.openapi.project.Project;
import com.intellij.rml.dfa.attributes.Attribute;
import com.intellij.rml.dfa.devtools.DfaLocationsProvider;
import com.intellij.rml.dfa.devtools.impl.picasso.dot.DotCLI;
import com.intellij.rml.dfa.devtools.impl.picasso.graph.CallGraph;
import com.intellij.rml.dfa.devtools.impl.picasso.graph.FileId;
import com.intellij.rml.dfa.devtools.impl.picasso.graph.FunctionId;
import com.intellij.rml.dfa.ir.IrLocation;
import com.intellij.rml.dfa.utils.graph.Graph;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0006\u0010\u0010\u001a\u00020\u0011J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0006H\u0002J\u0006\u0010\u0015\u001a\u00020\u0016J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0014\u001a\u00020\u0006H\u0002J\u0012\u0010\u0019\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0014\u001a\u00020\u0006H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001a"}, d2={"Lcom/intellij/rml/dfa/devtools/impl/picasso/graph/DfaCallGraphGenerator;", "", "attachNodesToFile", "", "graph", "Lcom/intellij/rml/dfa/utils/graph/Graph;", "Lcom/intellij/rml/dfa/attributes/Attribute;", "project", "Lcom/intellij/openapi/project/Project;", "(ZLcom/intellij/rml/dfa/utils/graph/Graph;Lcom/intellij/openapi/project/Project;)V", "callGraph", "Lcom/intellij/rml/dfa/devtools/impl/picasso/graph/CallGraph;", "getGraph", "()Lcom/intellij/rml/dfa/utils/graph/Graph;", "getProject", "()Lcom/intellij/openapi/project/Project;", "addCalls", "", "addFunctionInfo", "Lcom/intellij/rml/dfa/devtools/impl/picasso/graph/FunctionId;", "attr", "generateFile", "", "getFileName", "", "getFilePath", "intellij.rml.dfa.devtools.impl"})
public final class DfaCallGraphGenerator {
    private final boolean attachNodesToFile;
    @NotNull
    private final Graph<Attribute> graph;
    @NotNull
    private final Project project;
    @NotNull
    private final CallGraph callGraph;

    public DfaCallGraphGenerator(boolean attachNodesToFile, @NotNull Graph<Attribute> graph2, @NotNull Project project) {
        Intrinsics.checkNotNullParameter(graph2, (String)"graph");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.attachNodesToFile = attachNodesToFile;
        this.graph = graph2;
        this.project = project;
        this.callGraph = new CallGraph();
    }

    @NotNull
    public final Graph<Attribute> getGraph() {
        return this.graph;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    public final void addCalls() {
        for (Pair<Attribute, Attribute> pair : this.graph.edges()) {
            Attribute from = (Attribute)pair.component1();
            Attribute to = (Attribute)pair.component2();
            FunctionId fromId = this.addFunctionInfo(from);
            FunctionId toId = this.addFunctionInfo(to);
            this.callGraph.addCall(fromId, toId);
        }
    }

    @NotNull
    public final byte[] generateFile() {
        String dot2 = this.callGraph.toDot(this.attachNodesToFile);
        return DotCLI.Companion.run(dot2, "svg");
    }

    private final FunctionId addFunctionInfo(Attribute attr) {
        String string = attr.getKey();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getKey(...)");
        FunctionId fromId = new FunctionId(string);
        String string2 = this.getFilePath(attr);
        if (string2 == null) {
            string2 = "UNKNOWN_FILE";
        }
        FileId fileId = new FileId(string2);
        this.callGraph.getOrPutFunction(fromId).setName(attr.toString());
        this.callGraph.attachToFile(fromId, fileId);
        this.callGraph.getOrPutFile(fileId).setName(this.getFileName(attr));
        return fromId;
    }

    private final String getFileName(Attribute attr) {
        String[] stringArray;
        Object object = this.getFilePath(attr);
        return object != null && (object = StringsKt.split$default((CharSequence)((CharSequence)object), (String[])(stringArray = new String[]{"/"}), (boolean)false, (int)0, (int)6, null)) != null ? (String)CollectionsKt.last((List)object) : null;
    }

    private final String getFilePath(Attribute attr) {
        DfaLocationsProvider dfaLocationsProvider = DfaLocationsProvider.Companion.getInstance(this.project);
        Intrinsics.checkNotNullExpressionValue((Object)dfaLocationsProvider, (String)"getInstance(...)");
        IrLocation irLocation = DfaLocationsProvider.getLocation$default(dfaLocationsProvider, attr, null, 2, null);
        return irLocation != null ? irLocation.getFilePath() : null;
    }
}

