/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rml.dfa.devtools.impl.panels;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.project.Project;
import com.intellij.rml.dfa.AnalysisPass;
import com.intellij.rml.dfa.attributes.Attribute;
import com.intellij.rml.dfa.devtools.DfaLocationsProvider;
import com.intellij.rml.dfa.devtools.impl.model.RunningInfo;
import com.intellij.rml.dfa.devtools.impl.panels.DfaPanelUtilsKt;
import com.intellij.rml.dfa.devtools.impl.panels.Node;
import com.intellij.rml.dfa.devtools.impl.summaries.SummaryInfo;
import com.intellij.rml.dfa.ir.IrLocation;
import com.intellij.rml.dfa.rml.DfaConstantsKt;
import com.intellij.rml.dfa.utils.FormatHelperKt;
import com.intellij.rml.dfa.utils.MetaInfo;
import java.io.File;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000e\n\u0000\b\u0010\u0018\u00002\u00020\u0001B;\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\r\u00a2\u0006\u0002\u0010\u000eJ\b\u0010\u0019\u001a\u00020\u001aH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0013\u0010\f\u001a\u0004\u0018\u00010\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0013\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006\u001b"}, d2={"Lcom/intellij/rml/dfa/devtools/impl/panels/FunctionNode;", "Lcom/intellij/rml/dfa/devtools/impl/panels/Node;", "function", "Lcom/intellij/rml/dfa/attributes/Attribute;", "pass", "Lcom/intellij/rml/dfa/AnalysisPass;", "isFakeFunction", "", "project", "Lcom/intellij/openapi/project/Project;", "summaryInfo", "Lcom/intellij/rml/dfa/devtools/impl/summaries/SummaryInfo;", "info", "Lcom/intellij/rml/dfa/devtools/impl/model/RunningInfo;", "(Lcom/intellij/rml/dfa/attributes/Attribute;Lcom/intellij/rml/dfa/AnalysisPass;ZLcom/intellij/openapi/project/Project;Lcom/intellij/rml/dfa/devtools/impl/summaries/SummaryInfo;Lcom/intellij/rml/dfa/devtools/impl/model/RunningInfo;)V", "getFunction", "()Lcom/intellij/rml/dfa/attributes/Attribute;", "getInfo", "()Lcom/intellij/rml/dfa/devtools/impl/model/RunningInfo;", "getPass", "()Lcom/intellij/rml/dfa/AnalysisPass;", "getProject", "()Lcom/intellij/openapi/project/Project;", "getSummaryInfo", "()Lcom/intellij/rml/dfa/devtools/impl/summaries/SummaryInfo;", "toString", "", "intellij.rml.dfa.devtools.impl"})
public class FunctionNode
extends Node {
    @NotNull
    private final Attribute function;
    @NotNull
    private final AnalysisPass pass;
    @NotNull
    private final Project project;
    @Nullable
    private final SummaryInfo summaryInfo;
    @Nullable
    private final RunningInfo info;

    public FunctionNode(final @NotNull Attribute function2, @NotNull AnalysisPass pass, boolean isFakeFunction, final @NotNull Project project, @Nullable SummaryInfo summaryInfo, @Nullable RunningInfo info) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
        Intrinsics.checkNotNullParameter((Object)((Object)pass), (String)"pass");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        String string = DfaConstantsKt.isGlobalFunction(function2) ? new File(function2.toString()).getName() : function2.toString();
        Intrinsics.checkNotNull((Object)string);
        Icon icon = DfaConstantsKt.isGlobalFunction(function2) ? AllIcons.Nodes.Type : (isFakeFunction ? AllIcons.Actions.GroupByModule : AllIcons.Nodes.Function);
        if (isFakeFunction) {
            object = CollectionsKt.emptyList();
        } else {
            object = summaryInfo;
            if (object == null || (object = ((SummaryInfo)object).getFunctionInfo()) == null) {
                object = CollectionsKt.emptyList();
            }
        }
        super(string, icon, (List<MetaInfo>)object, (Function0<Unit>)((Function0)new Function0<Unit>(){

            public final void invoke() {
                block0: {
                    DfaLocationsProvider dfaLocationsProvider = DfaLocationsProvider.Companion.getInstance(project);
                    Intrinsics.checkNotNullExpressionValue((Object)dfaLocationsProvider, (String)"getInstance(...)");
                    IrLocation irLocation = DfaLocationsProvider.getLocation$default(dfaLocationsProvider, function2, null, 2, null);
                    if (irLocation == null) break block0;
                    IrLocation irLocation2 = irLocation;
                    Project project2 = project;
                    IrLocation it = irLocation2;
                    boolean bl = false;
                    DfaPanelUtilsKt.openLocationInEditor(it, project2);
                }
            }
        }));
        this.function = function2;
        this.pass = pass;
        this.project = project;
        this.summaryInfo = summaryInfo;
        this.info = info;
    }

    public /* synthetic */ FunctionNode(Attribute attribute, AnalysisPass analysisPass, boolean bl, Project project, SummaryInfo summaryInfo, RunningInfo runningInfo, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x20) != 0) {
            runningInfo = null;
        }
        this(attribute, analysisPass, bl, project, summaryInfo, runningInfo);
    }

    @NotNull
    public final Attribute getFunction() {
        return this.function;
    }

    @NotNull
    public final AnalysisPass getPass() {
        return this.pass;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @Nullable
    public final SummaryInfo getSummaryInfo() {
        return this.summaryInfo;
    }

    @Nullable
    public final RunningInfo getInfo() {
        return this.info;
    }

    @Override
    @NotNull
    public String toString() {
        return this.info != null ? super.toString() + " - " + FormatHelperKt.formatDuration$default(this.info.getEnd() - this.info.getStart(), 0, 2, null) : super.toString();
    }
}

