/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rml.dfa.devtools.impl.panels;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.util.Key;
import com.intellij.rml.dfa.AnalysisPass;
import com.intellij.rml.dfa.DfaEvaluationStatus;
import com.intellij.rml.dfa.RMLAnalysisDescription;
import com.intellij.rml.dfa.attributes.Attribute;
import com.intellij.rml.dfa.devtools.impl.actions.DfaGraphActionsKt;
import com.intellij.rml.dfa.devtools.impl.actions.ShowDfaToolWindowActionKt;
import com.intellij.rml.dfa.devtools.impl.model.DfaRunningInfoModel;
import com.intellij.rml.dfa.devtools.impl.model.DfaStructuredTuplesModel;
import com.intellij.rml.dfa.devtools.impl.model.DfaSummaryPrinterModel;
import com.intellij.rml.dfa.devtools.impl.model.RelationCategory;
import com.intellij.rml.dfa.devtools.impl.model.RelationWithOrigin;
import com.intellij.rml.dfa.devtools.impl.model.RunningInfo;
import com.intellij.rml.dfa.devtools.impl.panels.DfaInspectPanel;
import com.intellij.rml.dfa.devtools.impl.panels.DfaPanelBase;
import com.intellij.rml.dfa.devtools.impl.panels.DfaPanelUtilsKt;
import com.intellij.rml.dfa.devtools.impl.panels.FunctionNode;
import com.intellij.rml.dfa.devtools.impl.panels.Node;
import com.intellij.rml.dfa.devtools.impl.summaries.SummaryInfo;
import com.intellij.rml.dfa.impl.DfaEvaluationEvent;
import com.intellij.rml.dfa.impl.DfaFunctionEvaluationEvent;
import com.intellij.rml.dfa.impl.DfaObserverProvider;
import com.intellij.rml.dfa.impl.providers.ProviderType;
import com.intellij.rml.dfa.impl.providers.RMLInstancesProvider;
import com.intellij.rml.dfa.impl.providers.RMLInstancesProviderBase;
import com.intellij.rml.dfa.impl.providers.RmlProviderDescriptor;
import com.intellij.rml.dfa.impl.relations.DfaRelationInfo;
import com.intellij.rml.dfa.impl.relations.RelationKind;
import com.intellij.rml.dfa.impl.rml.profiler.tree.IProfileNode;
import com.intellij.rml.dfa.impl.scripts.Script;
import com.intellij.rml.dfa.impl.summaries.DfaSummaryEvaluationObserver;
import com.intellij.rml.dfa.impl.summaries.DfaSummaryFunctionEvaluationEvent;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.treeStructure.Tree;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.collections.IntIterator;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u007f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006*\u0001\u001c\u0018\u0000 -2\u00020\u00012\u00020\u0002:\u0001-B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010 \u001a\u00020!H\u0016J\u001e\u0010\"\u001a\u00020#2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020%0\u000f2\u0006\u0010&\u001a\u00020\u0017H\u0002J\b\u0010'\u001a\u00020(H\u0016J<\u0010)\u001a\u00020#2\u0006\u0010*\u001a\u00020\r2\u001a\u0010\n\u001a\u0016\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\f\u0018\u00010\u000f2\u0006\u0010+\u001a\u00020\u000e2\u0006\u0010,\u001a\u00020\tH\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R:\u0010\n\u001a.\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\f\u0012\u0018\u0012\u0016\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\f\u0018\u00010\u000f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\t0\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00140\u0019X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001dR\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lcom/intellij/rml/dfa/devtools/impl/panels/DfaInspectPanel;", "Lcom/intellij/rml/dfa/devtools/impl/panels/DfaPanelBase;", "Lcom/intellij/rml/dfa/impl/DfaObserverProvider;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "analysisDescription", "Lcom/intellij/rml/dfa/RMLAnalysisDescription;", "applyModifications", "", "dependentFunctions", "", "Lkotlin/Pair;", "Lcom/intellij/rml/dfa/attributes/Attribute;", "Lcom/intellij/rml/dfa/AnalysisPass;", "", "expansionState", "lazyNodeName", "", "prevRowsCnt", "", "prevTuplesHash", "rootNode", "Ljavax/swing/tree/DefaultMutableTreeNode;", "scriptsOrder", "", "showProfileData", "tree", "com/intellij/rml/dfa/devtools/impl/panels/DfaInspectPanel$tree$1", "Lcom/intellij/rml/dfa/devtools/impl/panels/DfaInspectPanel$tree$1;", "treeModel", "Ljavax/swing/tree/DefaultTreeModel;", "getObserver", "Lcom/intellij/rml/dfa/impl/summaries/DfaSummaryEvaluationObserver;", "populateRelations", "", "structuredTuples", "Lcom/intellij/rml/dfa/devtools/impl/model/RelationWithOrigin;", "node", "preferredFocusedComponent", "Lcom/intellij/ui/treeStructure/Tree;", "rowAdded", "function", "pass", "isFakeFunction", "Companion", "intellij.rml.dfa.devtools.impl"})
@SourceDebugExtension(value={"SMAP\nDfaInspectPanel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DfaInspectPanel.kt\ncom/intellij/rml/dfa/devtools/impl/panels/DfaInspectPanel\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,235:1\n1045#2:236\n*S KotlinDebug\n*F\n+ 1 DfaInspectPanel.kt\ncom/intellij/rml/dfa/devtools/impl/panels/DfaInspectPanel\n*L\n211#1:236\n*E\n"})
public final class DfaInspectPanel
extends DfaPanelBase
implements DfaObserverProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    private int prevRowsCnt;
    private int prevTuplesHash;
    private boolean applyModifications;
    @NotNull
    private List<Boolean> expansionState;
    @NotNull
    private final Map<Pair<Attribute, AnalysisPass>, List<Pair<Attribute, AnalysisPass>>> dependentFunctions;
    @NotNull
    private final DefaultMutableTreeNode rootNode;
    @NotNull
    private final DefaultTreeModel treeModel;
    @NotNull
    private final tree.1 tree;
    @NotNull
    private final String lazyNodeName;
    private boolean showProfileData;
    private Map<String, Integer> scriptsOrder;
    private RMLAnalysisDescription analysisDescription;
    @NotNull
    private static final Key<DfaRelationInfo> TuplesKey;

    public DfaInspectPanel(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.applyModifications = true;
        this.expansionState = CollectionsKt.emptyList();
        this.dependentFunctions = new LinkedHashMap();
        this.rootNode = new DefaultMutableTreeNode();
        DefaultTreeModel defaultTreeModel = this.treeModel = new DefaultTreeModel(this.rootNode);
        this.tree = new Tree(this, defaultTreeModel){
            final /* synthetic */ DfaInspectPanel this$0;
            {
                this.this$0 = $receiver;
                super((TreeModel)$super_call_param$1);
            }

            @Nullable
            public Color getFileColorFor(@NotNull Object obj) {
                Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
                if (DfaInspectPanel.access$getShowProfileData$p(this.this$0)) {
                    RunningInfo info;
                    if (obj instanceof FunctionNode) {
                        DfaRunningInfoModel dfaRunningInfoModel = DfaRunningInfoModel.Companion.getInstance(DfaInspectPanel.access$getProject$p(this.this$0));
                        v1 = dfaRunningInfoModel != null ? dfaRunningInfoModel.getRunningInfo(((FunctionNode)obj).getFunction(), ((FunctionNode)obj).getPass()) : null;
                    } else {
                        v1 = info = null;
                    }
                    if (info != null) {
                        float time = (float)Math.min((double)(info.getEnd() - info.getStart()) / 5000.0, 1.0);
                        return new Color(time, 1.0f - time, 0.0f, 0.5f);
                    }
                }
                return null;
            }

            public boolean isFileColorsEnabled() {
                return true;
            }
        };
        this.lazyNodeName = "lazy";
        DfaPanelUtilsKt.installTree$default(this.tree, this.project, null, 4, null);
        this.tree.addTreeWillExpandListener(new TreeWillExpandListener(){

            @Override
            public void treeWillExpand(@NotNull TreeExpansionEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                Object node = event.getPath().getLastPathComponent();
                Object child = treeModel.getChild(node, 0);
                if (node instanceof DefaultMutableTreeNode && treeModel.getChildCount(node) == 1) {
                    Object functionNode;
                    DefaultMutableTreeNode defaultMutableTreeNode = child instanceof DefaultMutableTreeNode ? (DefaultMutableTreeNode)child : null;
                    if (Intrinsics.areEqual((Object)(defaultMutableTreeNode != null ? defaultMutableTreeNode.getUserObject() : null), (Object)lazyNodeName) && (functionNode = ((DefaultMutableTreeNode)node).getUserObject()) instanceof FunctionNode) {
                        Object object;
                        ((DefaultMutableTreeNode)node).remove(0);
                        List list = (List)dependentFunctions.get(TuplesKt.to((Object)((FunctionNode)functionNode).getFunction(), (Object)((Object)((FunctionNode)functionNode).getPass())));
                        if (list != null) {
                            List list2 = list;
                            DfaInspectPanel dfaInspectPanel = this;
                            List it = list2;
                            boolean bl = false;
                            DefaultMutableTreeNode dependentNode = new DefaultMutableTreeNode(new Node("Dependent functions (" + it.size() + ")", AllIcons.Hierarchy.Supertypes, null, null, 12, null));
                            ((DefaultMutableTreeNode)node).add(dependentNode);
                            for (Pair pair : it) {
                                RunningInfo runningInfo;
                                Attribute depFun = (Attribute)pair.component1();
                                AnalysisPass depPass = (AnalysisPass)((Object)pair.component2());
                                if (dfaInspectPanel.showProfileData) {
                                    DfaRunningInfoModel dfaRunningInfoModel = DfaRunningInfoModel.Companion.getInstance(dfaInspectPanel.project);
                                    runningInfo = dfaRunningInfoModel != null ? dfaRunningInfoModel.getRunningInfo(depFun, depPass) : null;
                                } else {
                                    runningInfo = null;
                                }
                                RunningInfo info = runningInfo;
                                Project project = ((FunctionNode)functionNode).getProject();
                                DefaultMutableTreeNode dependencyNode2 = new DefaultMutableTreeNode(new FunctionNode(depFun, depPass, info, project){
                                    final /* synthetic */ AnalysisPass $depPass;
                                    {
                                        this.$depPass = $depPass;
                                        super($depFun, $depPass, false, $super_call_param$1, null, $info);
                                    }

                                    @NotNull
                                    public String toString() {
                                        return super.toString() + " - " + this.$depPass;
                                    }
                                });
                                dependentNode.add(dependencyNode2);
                                dependencyNode2.add(new DefaultMutableTreeNode(dfaInspectPanel.lazyNodeName));
                            }
                        }
                        if ((object = DfaStructuredTuplesModel.Companion.getInstance(project)) == null || (object = ((DfaStructuredTuplesModel)object).getStructuredTuples(((FunctionNode)functionNode).getFunction(), ((FunctionNode)functionNode).getPass())) == null) {
                            return;
                        }
                        Object structuredTuples = object;
                        this.populateRelations((List)structuredTuples, (DefaultMutableTreeNode)node);
                        treeModel.nodeStructureChanged(rootNode);
                    }
                }
            }

            @Override
            public void treeWillCollapse(@Nullable TreeExpansionEvent event) {
            }
        });
        DialogPanel panel2 = BuilderKt.panel((Function1)((Function1)new Function1<Panel, Unit>(this){
            final /* synthetic */ DfaInspectPanel this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull Panel $this$panel) {
                Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
                Panel.row$default((Panel)$this$panel, null, (Function1)((Function1)new Function1<Row, Unit>(this.this$0){
                    final /* synthetic */ DfaInspectPanel this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull Row $this$row) {
                        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                        $this$row.button("Build CFG", (Function1)new Function1<ActionEvent, Unit>(this.this$0){
                            final /* synthetic */ DfaInspectPanel this$0;
                            {
                                this.this$0 = $receiver;
                                super(1);
                            }

                            public final void invoke(@NotNull ActionEvent it) {
                                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                                DfaGraphActionsKt.showAllFunctionsCFG(DfaInspectPanel.access$getProject$p(this.this$0));
                            }
                        });
                        $this$row.button("Build CallGraph", (Function1)new Function1<ActionEvent, Unit>(this.this$0){
                            final /* synthetic */ DfaInspectPanel this$0;
                            {
                                this.this$0 = $receiver;
                                super(1);
                            }

                            public final void invoke(@NotNull ActionEvent it) {
                                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                                DfaGraphActionsKt.showCallGraph(false, DfaInspectPanel.access$getProject$p(this.this$0));
                            }
                        });
                        $this$row.button("Print summaries", (Function1)new Function1<ActionEvent, Unit>(this.this$0){
                            final /* synthetic */ DfaInspectPanel this$0;
                            {
                                this.this$0 = $receiver;
                                super(1);
                            }

                            public final void invoke(@NotNull ActionEvent it) {
                                block0: {
                                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                                    DfaSummaryPrinterModel dfaSummaryPrinterModel = DfaSummaryPrinterModel.Companion.getInstance(DfaInspectPanel.access$getProject$p(this.this$0));
                                    if (dfaSummaryPrinterModel == null) break block0;
                                    DfaSummaryPrinterModel dfaSummaryPrinterModel2 = dfaSummaryPrinterModel;
                                    DfaInspectPanel dfaInspectPanel = this.this$0;
                                    DfaSummaryPrinterModel it2 = dfaSummaryPrinterModel2;
                                    boolean bl = false;
                                    DfaPanelUtilsKt.openSummaryInEditor(it2.getPrintedSummaries(), DfaInspectPanel.access$getProject$p(dfaInspectPanel));
                                }
                            }
                        });
                        JBCheckBox checkbox = (JBCheckBox)$this$row.checkBox("Show profile data").getComponent();
                        checkbox.addChangeListener(arg_0 -> panel.1.invoke$lambda$0(this.this$0, checkbox, arg_0));
                    }

                    private static final void invoke$lambda$0(DfaInspectPanel this$0, JBCheckBox $checkbox, ChangeEvent it) {
                        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                        Intrinsics.checkNotNullParameter((Object)$checkbox, (String)"$checkbox");
                        DfaInspectPanel.access$setShowProfileData$p(this$0, $checkbox.isSelected());
                    }
                }), (int)1, null);
                Panel.row$default((Panel)$this$panel, null, (Function1)((Function1)new Function1<Row, Unit>(this.this$0){
                    final /* synthetic */ DfaInspectPanel this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull Row $this$row) {
                        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                        $this$row.cell((JComponent)new JBScrollPane((Component)((Object)DfaInspectPanel.access$getTree$p(this.this$0)))).align(Align.FILL);
                    }
                }), (int)1, null).resizableRow();
            }
        }));
        this.add((Component)panel2);
    }

    @NotNull
    public Tree preferredFocusedComponent() {
        return this.tree;
    }

    @Override
    @NotNull
    public DfaSummaryEvaluationObserver getObserver() {
        return new DfaSummaryEvaluationObserver(this){
            final /* synthetic */ DfaInspectPanel this$0;
            {
                this.this$0 = $receiver;
            }

            /*
             * WARNING - void declaration
             */
            public void start(@NotNull DfaEvaluationEvent event) {
                void $this$associateTo$iv$iv;
                void $this$associate$iv;
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                int curHash = ((Object)event.getTuples()).hashCode();
                Iterable iterable = CollectionsKt.withIndex((Iterable)event.getScripts());
                DfaInspectPanel dfaInspectPanel = this.this$0;
                boolean $i$f$associate = false;
                int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
                void var6_7 = $this$associate$iv;
                Map destination$iv$iv = new LinkedHashMap<K, V>(capacity$iv);
                boolean $i$f$associateTo = false;
                for (T element$iv$iv : $this$associateTo$iv$iv) {
                    Map map2 = destination$iv$iv;
                    IndexedValue it = (IndexedValue)element$iv$iv;
                    boolean bl = false;
                    Pair pair = new Pair((Object)((Script)it.getValue()).getName(), (Object)it.getIndex());
                    map2.put(pair.getFirst(), pair.getSecond());
                }
                DfaInspectPanel.access$setScriptsOrder$p(dfaInspectPanel, destination$iv$iv);
                DfaInspectPanel.access$setAnalysisDescription$p(this.this$0, event.getDescription());
                if (DfaInspectPanel.access$getApplyModifications$p(this.this$0) || curHash != DfaInspectPanel.access$getPrevTuplesHash$p(this.this$0)) {
                    DfaInspectPanel.access$getDependentFunctions$p(this.this$0).clear();
                    DfaInspectPanel.access$setPrevTuplesHash$p(this.this$0, curHash);
                    DfaInspectPanel.access$setApplyModifications$p(this.this$0, true);
                    SwingUtilities.invokeLater(() -> getObserver.1.start$lambda$2(this.this$0));
                } else {
                    DfaInspectPanel.access$setApplyModifications$p(this.this$0, false);
                }
            }

            public void initialTasksCompleted(@NotNull DfaEvaluationEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                if (DfaInspectPanel.access$getApplyModifications$p(this.this$0)) {
                    DfaInspectPanel.access$rowAdded(this.this$0, new Attribute("Initial tasks"), null, AnalysisPass.InitialPass, true);
                }
            }

            public void intermediateTasksCompleted(@NotNull DfaEvaluationEvent event, @NotNull RMLInstancesProvider intermediateProvider, @NotNull RMLInstancesProvider intermediateSummaryProvider, long startTime) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                Intrinsics.checkNotNullParameter((Object)intermediateProvider, (String)"intermediateProvider");
                Intrinsics.checkNotNullParameter((Object)intermediateSummaryProvider, (String)"intermediateSummaryProvider");
                if (DfaInspectPanel.access$getApplyModifications$p(this.this$0)) {
                    DfaInspectPanel.access$rowAdded(this.this$0, new Attribute("Intermediate tasks"), null, AnalysisPass.IntermediatePass, true);
                }
            }

            /*
             * WARNING - void declaration
             */
            public void functionAnalysisFinished(@NotNull DfaFunctionEvaluationEvent event, long startTime) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                if (DfaInspectPanel.access$getApplyModifications$p(this.this$0)) {
                    List list;
                    AnalysisPass pass;
                    AnalysisPass analysisPass = pass = event instanceof DfaSummaryFunctionEvaluationEvent ? ((DfaSummaryFunctionEvaluationEvent)event).getPass() : AnalysisPass.Pass1;
                    if (event instanceof DfaSummaryFunctionEvaluationEvent) {
                        void $this$mapNotNullTo$iv$iv;
                        void $this$mapNotNull$iv;
                        void $this$filterTo$iv$iv;
                        Iterable $this$filter$iv;
                        RmlProviderDescriptor it;
                        Object object;
                        void $this$mapTo$iv$iv;
                        Iterable $this$map$iv = ((DfaSummaryFunctionEvaluationEvent)event).getInputProviders();
                        boolean $i$f$map = false;
                        Iterable iterable = $this$map$iv;
                        Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        boolean $i$f$mapTo = false;
                        for (T item$iv$iv : $this$mapTo$iv$iv) {
                            object = (RMLInstancesProviderBase)item$iv$iv;
                            Collection collection = destination$iv$iv;
                            boolean bl = false;
                            collection.add(it.getDescriptor());
                        }
                        $this$map$iv = (List)destination$iv$iv;
                        boolean $i$f$filter = false;
                        $this$mapTo$iv$iv = $this$filter$iv;
                        destination$iv$iv = new ArrayList<E>();
                        boolean $i$f$filterTo = false;
                        for (T element$iv$iv : $this$filterTo$iv$iv) {
                            it = (RmlProviderDescriptor)element$iv$iv;
                            boolean bl = false;
                            if (!(it.getType() == ProviderType.Summary)) continue;
                            destination$iv$iv.add(element$iv$iv);
                        }
                        $this$filter$iv = (List)destination$iv$iv;
                        boolean $i$f$mapNotNull = false;
                        $this$filterTo$iv$iv = $this$mapNotNull$iv;
                        destination$iv$iv = new ArrayList<E>();
                        boolean $i$f$mapNotNullTo = false;
                        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                        boolean $i$f$forEach = false;
                        object = $this$forEach$iv$iv$iv.iterator();
                        while (object.hasNext()) {
                            Pair pair;
                            E element$iv$iv$iv;
                            E element$iv$iv = element$iv$iv$iv = object.next();
                            boolean bl = false;
                            RmlProviderDescriptor desc = (RmlProviderDescriptor)element$iv$iv;
                            boolean bl2 = false;
                            if (desc.getFunction() != null) {
                                Attribute it2;
                                boolean bl3 = false;
                                pair = TuplesKt.to((Object)it2, (Object)((Object)desc.getPass()));
                            } else {
                                pair = null;
                            }
                            if (pair == null) continue;
                            Pair it$iv$iv = pair;
                            boolean bl4 = false;
                            destination$iv$iv.add(it$iv$iv);
                        }
                        list = (List)destination$iv$iv;
                    } else {
                        list = null;
                    }
                    List dependentFunctions = list;
                    DfaInspectPanel.access$rowAdded(this.this$0, event.getFunction(), dependentFunctions, pass, false);
                }
            }

            public void finish(@NotNull DfaEvaluationStatus status, @Nullable IProfileNode profilerTree) {
                Intrinsics.checkNotNullParameter((Object)((Object)status), (String)"status");
                if (DfaInspectPanel.access$getApplyModifications$p(this.this$0) && status == DfaEvaluationStatus.SUCCESS) {
                    DfaInspectPanel.access$setApplyModifications$p(this.this$0, false);
                    SwingUtilities.invokeLater(() -> getObserver.1.finish$lambda$9(this.this$0));
                }
            }

            /*
             * WARNING - void declaration
             */
            private static final void start$lambda$2(DfaInspectPanel this$0) {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                Iterable iterable = (Iterable)RangesKt.until((int)0, (int)DfaInspectPanel.access$getTree$p(this$0).getRowCount());
                DfaInspectPanel dfaInspectPanel = this$0;
                boolean $i$f$map = false;
                void var3_4 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                Iterator<T> iterator = $this$mapTo$iv$iv.iterator();
                while (iterator.hasNext()) {
                    void it;
                    int item$iv$iv;
                    int n = item$iv$iv = ((IntIterator)iterator).nextInt();
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(DfaInspectPanel.access$getTree$p(this$0).isExpanded((int)it));
                }
                DfaInspectPanel.access$setExpansionState$p(dfaInspectPanel, (List)destination$iv$iv);
                DfaInspectPanel.access$setPrevRowsCnt$p(this$0, DfaInspectPanel.access$getRootNode$p(this$0).getChildCount());
                DfaInspectPanel.access$getRootNode$p(this$0).removeAllChildren();
                DfaInspectPanel.access$getTreeModel$p(this$0).nodeStructureChanged(DfaInspectPanel.access$getRootNode$p(this$0));
            }

            /*
             * WARNING - void declaration
             */
            private static final void finish$lambda$9(DfaInspectPanel this$0) {
                Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                if (DfaInspectPanel.access$getPrevRowsCnt$p(this$0) == DfaInspectPanel.access$getRootNode$p(this$0).getChildCount()) {
                    void $this$filterTo$iv$iv;
                    Iterable $this$filter$iv = CollectionsKt.withIndex((Iterable)DfaInspectPanel.access$getExpansionState$p(this$0));
                    boolean $i$f$filter = false;
                    Iterable iterable = $this$filter$iv;
                    Collection destination$iv$iv = new ArrayList<E>();
                    boolean $i$f$filterTo = false;
                    for (T element$iv$iv : $this$filterTo$iv$iv) {
                        IndexedValue it = (IndexedValue)element$iv$iv;
                        boolean bl = false;
                        if (!((Boolean)it.getValue()).booleanValue()) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    Iterable $this$forEach$iv = (List)destination$iv$iv;
                    boolean $i$f$forEach = false;
                    for (E element$iv : $this$forEach$iv) {
                        IndexedValue it = (IndexedValue)element$iv;
                        boolean bl = false;
                        DfaInspectPanel.access$getTree$p(this$0).expandRow(it.getIndex());
                    }
                } else {
                    DfaInspectPanel.access$setPrevRowsCnt$p(this$0, 0);
                }
            }
        };
    }

    private final void rowAdded(Attribute function2, List<? extends Pair<? extends Attribute, ? extends AnalysisPass>> dependentFunctions, AnalysisPass pass, boolean isFakeFunction) {
        RunningInfo runningInfo;
        SummaryInfo summaryInfo;
        this.dependentFunctions.put((Pair<Attribute, AnalysisPass>)TuplesKt.to((Object)function2, (Object)((Object)pass)), dependentFunctions);
        DfaSummaryPrinterModel dfaSummaryPrinterModel = DfaSummaryPrinterModel.Companion.getInstance(this.project);
        SummaryInfo summaryInfo2 = summaryInfo = dfaSummaryPrinterModel != null ? dfaSummaryPrinterModel.getSummaryInfo(function2) : null;
        if (this.showProfileData) {
            DfaRunningInfoModel dfaRunningInfoModel = DfaRunningInfoModel.Companion.getInstance(this.project);
            runningInfo = dfaRunningInfoModel != null ? dfaRunningInfoModel.getRunningInfo(function2, pass) : null;
        } else {
            runningInfo = null;
        }
        RunningInfo runningInfo2 = runningInfo;
        DefaultMutableTreeNode node = new DefaultMutableTreeNode(new FunctionNode(function2, pass, isFakeFunction, this.project, summaryInfo, runningInfo2));
        node.add(new DefaultMutableTreeNode(this.lazyNodeName));
        SwingUtilities.invokeLater(() -> DfaInspectPanel.rowAdded$lambda$0(this, node));
    }

    private final void populateRelations(List<RelationWithOrigin> structuredTuples, DefaultMutableTreeNode node) {
        Function1[] function1Array = new Function1[]{populateRelations.1.INSTANCE, new Function1<RelationWithOrigin, Comparable<?>>(this){
            final /* synthetic */ DfaInspectPanel this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @Nullable
            public final Comparable<?> invoke(@NotNull RelationWithOrigin it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                Map map2 = DfaInspectPanel.access$getScriptsOrder$p(this.this$0);
                if (map2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"scriptsOrder");
                    map2 = null;
                }
                Map map3 = map2;
                return (Comparable)map3.get(it.getProducer());
            }
        }};
        for (RelationWithOrigin info : CollectionsKt.sortedWith((Iterable)structuredTuples, (Comparator)ComparisonsKt.compareBy((Function1[])function1Array))) {
            String string = info.getProducer();
            if (string == null) {
                string = "";
            }
            DefaultMutableTreeNode categoryNode = new DefaultMutableTreeNode(new Node(string, switch (WhenMappings.$EnumSwitchMapping$0[info.getCategory().ordinal()]) {
                case 1 -> AllIcons.Actions.StepOut;
                case 2 -> AllIcons.General.GearPlain;
                case 3 -> AllIcons.Actions.GroupByModule;
                default -> throw new NoWhenBranchMatchedException();
            }, null, null, 12, null));
            this.populateRelations(info.getSubgroups(), categoryNode);
            Iterable $this$sortedBy$iv = info.getRelations().values();
            boolean $i$f$sortedBy = false;
            for (DfaRelationInfo relationInfo : CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    DfaRelationInfo it = (DfaRelationInfo)a;
                    boolean bl = false;
                    Comparable comparable = (Comparable)((Object)it.getRelationName());
                    it = (DfaRelationInfo)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getRelationName())));
                }
            })) {
                Icon icon = switch (WhenMappings.$EnumSwitchMapping$1[relationInfo.getKind().ordinal()]) {
                    case 1 -> AllIcons.Nodes.Parameter;
                    case 2 -> AllIcons.Nodes.Interface;
                    case 3 -> AllIcons.Nodes.Record;
                    case 4 -> AllIcons.Nodes.Static;
                    case 5 -> AllIcons.Nodes.Annotationtype;
                    default -> throw new NoWhenBranchMatchedException();
                };
                Intrinsics.checkNotNull((Object)icon);
                Icon icon2 = icon;
                categoryNode.add(new DefaultMutableTreeNode(new Node(relationInfo.toString(), icon2, null, (Function0)new Function0<Unit>(this, relationInfo, info){
                    final /* synthetic */ DfaInspectPanel this$0;
                    final /* synthetic */ DfaRelationInfo $relationInfo;
                    final /* synthetic */ RelationWithOrigin $info;
                    {
                        this.this$0 = $receiver;
                        this.$relationInfo = $relationInfo;
                        this.$info = $info;
                        super(0);
                    }

                    public final void invoke() {
                        if (!DfaInspectPanel.access$getProject$p(this.this$0).isDisposed()) {
                            RMLAnalysisDescription rMLAnalysisDescription = DfaInspectPanel.access$getAnalysisDescription$p(this.this$0);
                            if (rMLAnalysisDescription == null) {
                                Intrinsics.throwUninitializedPropertyAccessException((String)"analysisDescription");
                                rMLAnalysisDescription = null;
                            }
                            DfaPanelUtilsKt.openRelationInEditor(rMLAnalysisDescription, this.$relationInfo, this.$info.getProducer(), DfaInspectPanel.access$getProject$p(this.this$0));
                        }
                    }
                }, 4, null)));
            }
            node.add(categoryNode);
        }
    }

    private static final void rowAdded$lambda$0(DfaInspectPanel this$0, DefaultMutableTreeNode $node) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$node, (String)"$node");
        this$0.rootNode.add($node);
        this$0.treeModel.nodeStructureChanged(this$0.rootNode);
    }

    public static final /* synthetic */ void access$setScriptsOrder$p(DfaInspectPanel $this, Map map2) {
        $this.scriptsOrder = map2;
    }

    public static final /* synthetic */ void access$setAnalysisDescription$p(DfaInspectPanel $this, RMLAnalysisDescription rMLAnalysisDescription) {
        $this.analysisDescription = rMLAnalysisDescription;
    }

    public static final /* synthetic */ boolean access$getApplyModifications$p(DfaInspectPanel $this) {
        return $this.applyModifications;
    }

    public static final /* synthetic */ int access$getPrevTuplesHash$p(DfaInspectPanel $this) {
        return $this.prevTuplesHash;
    }

    public static final /* synthetic */ void access$setPrevTuplesHash$p(DfaInspectPanel $this, int n) {
        $this.prevTuplesHash = n;
    }

    public static final /* synthetic */ void access$setApplyModifications$p(DfaInspectPanel $this, boolean bl) {
        $this.applyModifications = bl;
    }

    public static final /* synthetic */ void access$rowAdded(DfaInspectPanel $this, Attribute function2, List dependentFunctions, AnalysisPass pass, boolean isFakeFunction) {
        $this.rowAdded(function2, dependentFunctions, pass, isFakeFunction);
    }

    public static final /* synthetic */ tree.1 access$getTree$p(DfaInspectPanel $this) {
        return $this.tree;
    }

    public static final /* synthetic */ void access$setExpansionState$p(DfaInspectPanel $this, List list) {
        $this.expansionState = list;
    }

    public static final /* synthetic */ void access$setPrevRowsCnt$p(DfaInspectPanel $this, int n) {
        $this.prevRowsCnt = n;
    }

    public static final /* synthetic */ int access$getPrevRowsCnt$p(DfaInspectPanel $this) {
        return $this.prevRowsCnt;
    }

    public static final /* synthetic */ List access$getExpansionState$p(DfaInspectPanel $this) {
        return $this.expansionState;
    }

    public static final /* synthetic */ Map access$getScriptsOrder$p(DfaInspectPanel $this) {
        return $this.scriptsOrder;
    }

    public static final /* synthetic */ RMLAnalysisDescription access$getAnalysisDescription$p(DfaInspectPanel $this) {
        return $this.analysisDescription;
    }

    public static final /* synthetic */ void access$setShowProfileData$p(DfaInspectPanel $this, boolean bl) {
        $this.showProfileData = bl;
    }

    static {
        Key key = Key.create((String)"TuplesKey");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        TuplesKey = key;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\rR$\u0010\u0003\u001a\u0015\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u00050\u0004\u00a2\u0006\u0002\b\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u000e"}, d2={"Lcom/intellij/rml/dfa/devtools/impl/panels/DfaInspectPanel$Companion;", "", "()V", "TuplesKey", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/rml/dfa/impl/relations/DfaRelationInfo;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "getTuplesKey", "()Lcom/intellij/openapi/util/Key;", "getInstance", "Lcom/intellij/rml/dfa/devtools/impl/panels/DfaInspectPanel;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.rml.dfa.devtools.impl"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Key<DfaRelationInfo> getTuplesKey() {
            return TuplesKey;
        }

        @Nullable
        public final DfaInspectPanel getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            return (DfaInspectPanel)ShowDfaToolWindowActionKt.getPanel(project, "DFA", Reflection.getOrCreateKotlinClass(DfaInspectPanel.class));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[RelationCategory.values().length];
            try {
                nArray[RelationCategory.Visitor.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RelationCategory.Script.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RelationCategory.Global.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[RelationKind.values().length];
            try {
                nArray[RelationKind.Predefined.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RelationKind.Global.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RelationKind.Local.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RelationKind.Summary.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RelationKind.ForSecondPass.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

