/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rml.dfa.devtools.impl.model;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.rml.dfa.devtools.UtilsKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\b&\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002:\u0001\u0013B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\r\u0010\t\u001a\u00028\u0000H&\u00a2\u0006\u0002\u0010\nJ\u0015\u0010\u000b\u001a\u0004\u0018\u00018\u00002\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\u001b\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00028\u00002\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u0012R\u001a\u0010\u0006\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/rml/dfa/devtools/impl/model/AbstractPerModificationStorageService;", "T", "", "keyName", "", "(Ljava/lang/String;)V", "key", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/rml/dfa/devtools/impl/model/AbstractPerModificationStorageService$DataWithTimestamp;", "createNewModel", "()Ljava/lang/Object;", "load", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)Ljava/lang/Object;", "store", "", "data", "(Ljava/lang/Object;Lcom/intellij/openapi/project/Project;)V", "DataWithTimestamp", "intellij.rml.dfa.devtools.impl"})
public abstract class AbstractPerModificationStorageService<T> {
    @NotNull
    private final Key<DataWithTimestamp<T>> key;

    public AbstractPerModificationStorageService(@NotNull String keyName) {
        Intrinsics.checkNotNullParameter((Object)keyName, (String)"keyName");
        Key key = Key.create((String)keyName);
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        this.key = key;
    }

    public abstract T createNewModel();

    public final void store(T data, @NotNull Project project) {
        Long timestamp;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Long l = timestamp = UtilsKt.getModificationTimestamp(project);
        project.putUserData(this.key, new DataWithTimestamp<T>(data, l != null ? l : 0L));
    }

    @Nullable
    public final T load(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        DataWithTimestamp dataWithTimestamp = (DataWithTimestamp)project.getUserData(this.key);
        if (dataWithTimestamp != null) {
            DataWithTimestamp it = dataWithTimestamp;
            boolean bl = false;
            Long l = UtilsKt.getModificationTimestamp(project);
            if (l != null && it.getTimestamp() == l.longValue()) {
                return it.getData();
            }
            return null;
        }
        return null;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0007\b\u0002\u0018\u0000*\u0004\b\u0001\u0010\u00012\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00028\u0001\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0013\u0010\u0003\u001a\u00028\u0001\u00a2\u0006\n\n\u0002\u0010\t\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lcom/intellij/rml/dfa/devtools/impl/model/AbstractPerModificationStorageService$DataWithTimestamp;", "T", "", "data", "timestamp", "", "(Ljava/lang/Object;J)V", "getData", "()Ljava/lang/Object;", "Ljava/lang/Object;", "getTimestamp", "()J", "intellij.rml.dfa.devtools.impl"})
    private static final class DataWithTimestamp<T> {
        private final T data;
        private final long timestamp;

        public DataWithTimestamp(T data, long timestamp) {
            this.data = data;
            this.timestamp = timestamp;
        }

        public final T getData() {
            return this.data;
        }

        public final long getTimestamp() {
            return this.timestamp;
        }
    }
}

