/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rml.dfa.devtools.impl.actions;

import com.intellij.lang.Language;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.rml.dfa.AnalysisPass;
import com.intellij.rml.dfa.RMLAnalysisDescription;
import com.intellij.rml.dfa.attributes.Attribute;
import com.intellij.rml.dfa.devtools.DfaDebugProvider;
import com.intellij.rml.dfa.devtools.UtilsKt;
import com.intellij.rml.dfa.devtools.impl.model.DfaFunctionsModel;
import com.intellij.rml.dfa.devtools.impl.model.DfaStructuredTuplesModel;
import com.intellij.rml.dfa.devtools.impl.panels.DfaPanelUtilsKt;
import com.intellij.rml.dfa.devtools.impl.picasso.DfaCfgPictureGenerator;
import com.intellij.rml.dfa.devtools.impl.picasso.IrCfg2DotKt;
import com.intellij.rml.dfa.devtools.impl.picasso.dot.DotCLI;
import com.intellij.rml.dfa.devtools.impl.picasso.dot.DotGraph;
import com.intellij.rml.dfa.devtools.impl.picasso.graph.DfaCallGraphGenerator;
import com.intellij.rml.dfa.impl.relations.DfaRelationInfo;
import com.intellij.rml.dfa.impl.rml.profiler.DummyProfileManager;
import com.intellij.rml.dfa.impl.translator.IrTranslationUtilsKt;
import com.intellij.rml.dfa.impl.ui.DummyThreadCallback;
import com.intellij.rml.dfa.ir.IrProject;
import com.intellij.rml.dfa.ir.IrProjectFactory;
import com.intellij.rml.dfa.ir.ast.IrFunctionDecl;
import com.intellij.rml.dfa.ir.ast.IrTopLevelDecl;
import com.intellij.rml.dfa.test.IrSerializer;
import com.intellij.rml.dfa.utils.RMLOptions;
import com.intellij.rml.dfa.utils.graph.Graph;
import com.intellij.testFramework.BinaryLightVirtualFile;
import java.io.File;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u00004\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0016\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0016\u0010\u0007\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0002\u001a\u00020\u0003\u001a \u0010\n\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u000eH\u0002\u001a\u0010\u0010\u000f\u001a\u00020\u00012\u0006\u0010\u0010\u001a\u00020\u0011H\u0002\u00a8\u0006\u0012"}, d2={"showAllFunctionsCFG", "", "project", "Lcom/intellij/openapi/project/Project;", "showCallGraph", "attachNodesToFiles", "", "showFunctionCfg", "function", "Lcom/intellij/rml/dfa/attributes/Attribute;", "showFunctionIR", "producer", "Lcom/intellij/rml/dfa/ir/ast/IrFunctionDecl;", "options", "Lcom/intellij/rml/dfa/utils/RMLOptions;", "showSerializedIR", "file", "Lcom/intellij/psi/PsiFile;", "intellij.rml.dfa.devtools.impl"})
public final class DfaGraphActionsKt {
    public static final void showAllFunctionsCFG(@NotNull Project project) {
        RMLAnalysisDescription description;
        DfaFunctionsModel functionsModel;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        DfaFunctionsModel dfaFunctionsModel = functionsModel = DfaFunctionsModel.Companion.getInstance(project);
        RMLAnalysisDescription rMLAnalysisDescription = description = dfaFunctionsModel != null ? dfaFunctionsModel.getAnalysisDescription() : null;
        if (description != null) {
            DfaCfgPictureGenerator graphGenerator = new DfaCfgPictureGenerator(description, project);
            for (Attribute function2 : functionsModel.getAllFunctions()) {
                DfaStructuredTuplesModel dfaStructuredTuplesModel = DfaStructuredTuplesModel.Companion.getInstance(project);
                Map<String, DfaRelationInfo> functionInfo = dfaStructuredTuplesModel != null ? dfaStructuredTuplesModel.getFunctionInfo(function2, AnalysisPass.Pass1) : null;
                if (functionInfo == null) continue;
                String string = function2.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                graphGenerator.addTuples(functionInfo, string);
            }
            byte[] svgFile = graphGenerator.generateFile();
            FileEditorManager.getInstance((Project)project).openFile((VirtualFile)new BinaryLightVirtualFile("cfg.svg", svgFile), true);
        } else {
            DfaPanelUtilsKt.showNotAvailableMessage();
        }
    }

    public static final void showFunctionCfg(@NotNull Attribute function2, @NotNull Project project) {
        RMLAnalysisDescription description;
        Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        DfaFunctionsModel dfaFunctionsModel = DfaFunctionsModel.Companion.getInstance(project);
        RMLAnalysisDescription rMLAnalysisDescription = description = dfaFunctionsModel != null ? dfaFunctionsModel.getAnalysisDescription() : null;
        if (description != null) {
            Object object = DfaStructuredTuplesModel.Companion.getInstance(project);
            if (object == null || (object = ((DfaStructuredTuplesModel)object).getFunctionInfo(function2, AnalysisPass.Pass1)) == null) {
                return;
            }
            Object functionInfo = object;
            DfaCfgPictureGenerator dfaCfgPictureGenerator = new DfaCfgPictureGenerator(description, project);
            String string = function2.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            byte[] svgFile = dfaCfgPictureGenerator.addTuples((Map<String, DfaRelationInfo>)functionInfo, string).generateFile();
            FileEditorManager.getInstance((Project)project).openFile((VirtualFile)new BinaryLightVirtualFile("cfg.svg", svgFile), true);
        } else {
            DfaPanelUtilsKt.showNotAvailableMessage();
        }
    }

    public static final void showCallGraph(boolean attachNodesToFiles, @NotNull Project project) {
        Graph<Attribute> callGraph;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        DfaFunctionsModel dfaFunctionsModel = DfaFunctionsModel.Companion.getInstance(project);
        Graph<Attribute> graph2 = callGraph = dfaFunctionsModel != null ? dfaFunctionsModel.getCallGraph() : null;
        if (callGraph != null) {
            DfaCallGraphGenerator generator = new DfaCallGraphGenerator(attachNodesToFiles, callGraph, project);
            generator.addCalls();
            byte[] svgFile = generator.generateFile();
            FileEditorManager.getInstance((Project)project).openFile((VirtualFile)new BinaryLightVirtualFile("call-graph.svg", svgFile), true);
        } else {
            DfaPanelUtilsKt.showNotAvailableMessage();
        }
    }

    private static final void showFunctionIR(IrFunctionDecl producer, Project project, RMLOptions options) {
        IrTopLevelDecl decl = IrTranslationUtilsKt.performTransformStages(producer, new DummyProfileManager(), options, new DummyThreadCallback());
        if (!(decl instanceof IrFunctionDecl)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        String dot2 = DotGraph.build$default(IrCfg2DotKt.convert2dot(((IrFunctionDecl)decl).getBody()), 0, 1, null);
        byte[] svg = DotCLI.Companion.run(dot2, "svg");
        FileEditorManager.getInstance((Project)project).openFile((VirtualFile)new BinaryLightVirtualFile("cfg.svg", svg), true);
    }

    private static final void showSerializedIR(PsiFile file2) {
        Language language = file2.getLanguage();
        Intrinsics.checkNotNullExpressionValue((Object)language, (String)"getLanguage(...)");
        List<IrTopLevelDecl> input2 = DfaDebugProvider.Companion.getInstance(language).getIrForFile(file2);
        IrProject irProject = IrProjectFactory.getProject$default(IrProjectFactory.Companion.getInstance(), input2, false, 2, null);
        Project project = file2.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        UtilsKt.catchDFAExceptions(project, () -> DfaGraphActionsKt.showSerializedIR$lambda$1(irProject, file2));
    }

    private static final void showSerializedIR$lambda$1(IrProject $irProject, PsiFile $file) {
        block0: {
            VirtualFile dfaFile;
            Intrinsics.checkNotNullParameter((Object)$irProject, (String)"$irProject");
            Intrinsics.checkNotNullParameter((Object)$file, (String)"$file");
            IrSerializer serializer = new IrSerializer();
            serializer.serialize($irProject);
            File file2 = FileUtil.createTempFile((String)"tempFile", (String)".dfa", (boolean)true);
            Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"createTempFile(...)");
            File tempFile = file2;
            FilesKt.writeText$default((File)tempFile, (String)serializer.getResult(), null, (int)2, null);
            VirtualFile virtualFile = dfaFile = LocalFileSystem.getInstance().refreshAndFindFileByPath(tempFile.getAbsolutePath());
            if (virtualFile == null) break block0;
            VirtualFile it = virtualFile;
            boolean bl = false;
            FileEditorManager.getInstance((Project)$file.getProject()).openFile(it, true);
        }
    }

    public static final /* synthetic */ void access$showFunctionIR(IrFunctionDecl producer, Project project, RMLOptions options) {
        DfaGraphActionsKt.showFunctionIR(producer, project, options);
    }

    public static final /* synthetic */ void access$showSerializedIR(PsiFile file2) {
        DfaGraphActionsKt.showSerializedIR(file2);
    }
}

