/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rml.dfa.devtools;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.rml.dfa.DfaInternalException;
import com.intellij.rml.dfa.attributes.Attribute;
import com.intellij.rml.dfa.ir.DfaInvalidIrException;
import com.intellij.rml.dfa.ir.IrLocation;
import com.intellij.rml.dfa.ir.IrLocationKt;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000L\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\u001a\u0016\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u0015\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\b\u001a\n\u0010\t\u001a\u00020\n*\u00020\u000b\u001a\n\u0010\f\u001a\u00020\r*\u00020\u000e\u001a6\u0010\u000f\u001a\t\u0018\u0001H\u0010\u00a2\u0006\u0002\b\u0011\"\b\b\u0000\u0010\u0010*\u00020\u000e*\u00020\r2\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u0002H\u00100\u0015\u00a2\u0006\u0002\u0010\u0016\u001a\u0014\u0010\u0017\u001a\u0004\u0018\u00010\u0013*\u00020\r2\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0014\u0010\u0018\u001a\u0004\u0018\u00010\u0019*\u00020\r2\u0006\u0010\u0002\u001a\u00020\u0003\u00a8\u0006\u001a"}, d2={"catchDFAExceptions", "", "project", "Lcom/intellij/openapi/project/Project;", "block", "Ljava/lang/Runnable;", "getModificationTimestamp", "", "(Lcom/intellij/openapi/project/Project;)Ljava/lang/Long;", "getAttribute", "Lcom/intellij/rml/dfa/attributes/Attribute;", "Lcom/intellij/psi/PsiNamedElement;", "getLocation", "Lcom/intellij/rml/dfa/ir/IrLocation;", "Lcom/intellij/psi/PsiElement;", "getPsiElement", "T", "Lorg/jetbrains/annotations/Nullable;", "file", "Lcom/intellij/psi/PsiFile;", "elemClass", "Ljava/lang/Class;", "(Lcom/intellij/rml/dfa/ir/IrLocation;Lcom/intellij/psi/PsiFile;Ljava/lang/Class;)Lcom/intellij/psi/PsiElement;", "getPsiFile", "getText", "", "intellij.rml.dfa.devtools"})
@SourceDebugExtension(value={"SMAP\nUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Utils.kt\ncom/intellij/rml/dfa/devtools/UtilsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,88:1\n1#2:89\n*E\n"})
public final class UtilsKt {
    @Nullable
    public static final PsiFile getPsiFile(@NotNull IrLocation $this$getPsiFile, @NotNull Project project) {
        PsiFile psiFile;
        VirtualFile virtualFile;
        Intrinsics.checkNotNullParameter((Object)$this$getPsiFile, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Object object = VfsUtil.findFile((Path)Paths.get($this$getPsiFile.getFilePath(), new String[0]), (boolean)true);
        if (object == null) {
            VirtualFile virtualFile2 = ProjectUtil.guessProjectDir((Project)project);
            object = virtualFile2 != null ? virtualFile2.findFileByRelativePath($this$getPsiFile.getFilePath()) : null;
            if (object == null) {
                VirtualFile virtualFile3;
                String string = project.getBasePath();
                if (string != null) {
                    String it = string;
                    boolean bl = false;
                    virtualFile3 = VfsUtil.findFileByIoFile((File)new File(it, $this$getPsiFile.getFilePath()), (boolean)true);
                } else {
                    virtualFile3 = object = null;
                }
                if (virtualFile3 == null) {
                    VirtualFile virtualFile4;
                    object = ApplicationManager.getApplication().isUnitTestMode() ? ((virtualFile4 = ProjectUtil.guessProjectDir((Project)project)) != null && (virtualFile4 = virtualFile4.getParent()) != null ? virtualFile4.findFileByRelativePath($this$getPsiFile.getFilePath()) : null) : null;
                }
            }
        }
        VirtualFile virtualFile5 = virtualFile = object;
        if (virtualFile5 != null) {
            VirtualFile it = virtualFile5;
            boolean bl = false;
            psiFile = PsiManager.getInstance((Project)project).findFile(it);
        } else {
            psiFile = null;
        }
        return psiFile;
    }

    @Nullable
    public static final <T extends PsiElement> T getPsiElement(@NotNull IrLocation $this$getPsiElement, @NotNull PsiFile file2, @NotNull Class<T> elemClass) {
        Intrinsics.checkNotNullParameter((Object)$this$getPsiElement, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter(elemClass, (String)"elemClass");
        return (T)PsiTreeUtil.findElementOfClassAtRange((PsiFile)file2, (int)$this$getPsiElement.getOffset1(), (int)$this$getPsiElement.getOffset2(), elemClass);
    }

    @Nullable
    public static final String getText(@NotNull IrLocation $this$getText, @NotNull Project project) {
        String fileText;
        Intrinsics.checkNotNullParameter((Object)$this$getText, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        PsiFile psiFile = UtilsKt.getPsiFile($this$getText, project);
        String string = fileText = psiFile != null ? psiFile.getText() : null;
        return string != null ? StringsKt.substring((String)string, (IntRange)RangesKt.until((int)$this$getText.getOffset1(), (int)$this$getText.getOffset2())) : null;
    }

    @Nullable
    public static final Long getModificationTimestamp(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        PsiModificationTracker psiModificationTracker = PsiModificationTracker.getInstance((Project)project);
        return psiModificationTracker != null ? Long.valueOf(psiModificationTracker.getModificationCount()) : null;
    }

    @NotNull
    public static final IrLocation getLocation(@NotNull PsiElement $this$getLocation) {
        Intrinsics.checkNotNullParameter((Object)$this$getLocation, (String)"<this>");
        PsiFile file2 = $this$getLocation.getContainingFile();
        Document document = PsiDocumentManager.getInstance((Project)$this$getLocation.getProject()).getDocument(file2);
        if (document == null) {
            return IrLocationKt.getIrEmptyLocation();
        }
        Document doc = document;
        int line = doc.getLineNumber(PsiTreeUtilKt.getStartOffset((PsiElement)$this$getLocation));
        int column = PsiTreeUtilKt.getStartOffset((PsiElement)$this$getLocation) - doc.getLineStartOffset(line);
        String string = file2.getVirtualFile().getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        return new IrLocation(string, PsiTreeUtilKt.getStartOffset((PsiElement)$this$getLocation), PsiTreeUtilKt.getEndOffset((PsiElement)$this$getLocation), line + 1, column + 1);
    }

    @NotNull
    public static final Attribute getAttribute(@NotNull PsiNamedElement $this$getAttribute) {
        Intrinsics.checkNotNullParameter((Object)$this$getAttribute, (String)"<this>");
        IrLocation location = UtilsKt.getLocation((PsiElement)$this$getAttribute);
        Attribute attribute = new Attribute(location.toString(), $this$getAttribute.getName());
        return attribute;
    }

    public static final void catchDFAExceptions(@NotNull Project project, @NotNull Runnable block) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        try {
            block.run();
        }
        catch (DfaInvalidIrException e) {
            ApplicationManager.getApplication().invokeLater(() -> UtilsKt.catchDFAExceptions$lambda$3(e, project));
        }
        catch (DfaInternalException e) {
            e.printStackTrace();
            ApplicationManager.getApplication().invokeLater(() -> UtilsKt.catchDFAExceptions$lambda$4(project, e));
        }
    }

    private static final void catchDFAExceptions$lambda$3(DfaInvalidIrException $e, Project $project) {
        Editor editor;
        FileEditor fileEditor;
        VirtualFile file2;
        Intrinsics.checkNotNullParameter((Object)$e, (String)"$e");
        Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
        VirtualFile virtualFile = file2 = LocalFileSystem.getInstance().refreshAndFindFileByPath($e.getLocation().getFilePath());
        if (virtualFile != null) {
            VirtualFile it = virtualFile;
            boolean bl = false;
            FileEditor[] fileEditorArray = FileEditorManager.getInstance((Project)$project).openFile(file2, true);
            Intrinsics.checkNotNullExpressionValue((Object)fileEditorArray, (String)"openFile(...)");
            fileEditor = (FileEditor)ArraysKt.firstOrNull((Object[])fileEditorArray);
        } else {
            fileEditor = null;
        }
        FileEditor fileEditor2 = fileEditor;
        TextEditor textEditor = fileEditor2 instanceof TextEditor ? (TextEditor)fileEditor2 : null;
        Object object = editor = textEditor != null ? textEditor.getEditor() : null;
        if (editor != null) {
            editor.getSelectionModel().setSelection($e.getLocation().getOffset1(), $e.getLocation().getOffset2());
            editor.getCaretModel().moveToOffset($e.getLocation().getOffset1());
            editor.getScrollingModel().scrollToCaret(ScrollType.CENTER);
        }
        Messages.showWarningDialog((Project)$project, (String)$e.getMessage(), (String)"DFA invalid IR error");
    }

    private static final void catchDFAExceptions$lambda$4(Project $project, DfaInternalException $e) {
        Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
        Intrinsics.checkNotNullParameter((Object)$e, (String)"$e");
        Messages.showWarningDialog((Project)$project, (String)$e.getMessage(), (String)"DFA internal error");
    }
}

