/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.makefile.ui;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.cidr.cpp.external.system.project.ui.ExternalProjectStatusAndFixesProviderBase;
import com.jetbrains.cidr.cpp.external.system.project.ui.SelectAndLoadProjectActionBase;
import com.jetbrains.cidr.cpp.makefile.MakefileBundle;
import com.jetbrains.cidr.cpp.makefile.MakefileUtil;
import com.jetbrains.cidr.cpp.makefile.io.MkPathUtils;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0002\u000e\u000fB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\bH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\bH\u0016\u00a8\u0006\u0010"}, d2={"Lcom/jetbrains/cidr/cpp/makefile/ui/MakefileProjectStatusAndFixesProvider;", "Lcom/jetbrains/cidr/cpp/external/system/project/ui/ExternalProjectStatusAndFixesProviderBase;", "()V", "createLoadAction", "Lcom/intellij/openapi/actionSystem/AnAction;", "project", "Lcom/intellij/openapi/project/Project;", "buildFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "createSelectAndLoadAction", "rootDirectory", "isBuildFile", "", "file", "LoadMakefileAction", "SelectAndLoadMakeAction", "intellij.clion.makefile"})
public final class MakefileProjectStatusAndFixesProvider
extends ExternalProjectStatusAndFixesProviderBase {
    public boolean isBuildFile(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return MkPathUtils.isMakefile(file) || MkPathUtils.isMakefilePrototype(file);
    }

    @NotNull
    public AnAction createLoadAction(@NotNull Project project, @NotNull VirtualFile buildFile) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)buildFile, (String)"buildFile");
        return new LoadMakefileAction(project, buildFile);
    }

    @NotNull
    public AnAction createSelectAndLoadAction(@NotNull Project project, @NotNull VirtualFile rootDirectory) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)rootDirectory, (String)"rootDirectory");
        return (AnAction)new SelectAndLoadMakeAction(project, rootDirectory);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/cidr/cpp/makefile/ui/MakefileProjectStatusAndFixesProvider$LoadMakefileAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "project", "Lcom/intellij/openapi/project/Project;", "makefile", "Lcom/intellij/openapi/vfs/VirtualFile;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/vfs/VirtualFile;)V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "intellij.clion.makefile"})
    private static final class LoadMakefileAction
    extends AnAction {
        @NotNull
        private final Project project;
        @NotNull
        private final VirtualFile makefile;

        public LoadMakefileAction(@NotNull Project project, @NotNull VirtualFile makefile) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)makefile, (String)"makefile");
            super(MakefileBundle.message("action.Makefile.LoadMakefileProject.text", new Object[0]));
            this.project = project;
            this.makefile = makefile;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            VirtualFile virtualFile = this.makefile.getParent();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getParent(...)");
            MakefileUtil.linkMakefileProject$default(this.project, virtualFile, null, 4, null);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0005H\u0016J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\f"}, d2={"Lcom/jetbrains/cidr/cpp/makefile/ui/MakefileProjectStatusAndFixesProvider$SelectAndLoadMakeAction;", "Lcom/jetbrains/cidr/cpp/external/system/project/ui/SelectAndLoadProjectActionBase;", "project", "Lcom/intellij/openapi/project/Project;", "rootDirectory", "Lcom/intellij/openapi/vfs/VirtualFile;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/vfs/VirtualFile;)V", "isBuildFile", "", "file", "linkProject", "", "intellij.clion.makefile"})
    private static final class SelectAndLoadMakeAction
    extends SelectAndLoadProjectActionBase {
        public SelectAndLoadMakeAction(@NotNull Project project, @NotNull VirtualFile rootDirectory) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)rootDirectory, (String)"rootDirectory");
            String string = MakefileBundle.message("action.Makefile.SelectAndLoadMakefileProject.text", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            super(project, rootDirectory, string);
        }

        public boolean isBuildFile(@NotNull VirtualFile file) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            return MkPathUtils.isMakefile(file) || MkPathUtils.isMakefilePrototype(file);
        }

        public void linkProject(@NotNull Project project, @NotNull VirtualFile rootDirectory) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)rootDirectory, (String)"rootDirectory");
            MakefileUtil.linkMakefileProject$default(project, rootDirectory, null, 4, null);
        }
    }
}

