/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.datagrid;

import com.intellij.database.datagrid.ColumnHierarchyUtil;
import com.intellij.database.datagrid.HierarchicalColumnsDataGridModel;
import com.intellij.util.containers.JBTreeTraverser;
import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HierarchicalReader {
    private final List<HierarchicalColumnsDataGridModel.HierarchicalGridColumn> myRoots;
    private List<List<HierarchicalColumnsDataGridModel.HierarchicalGridColumn>> myCachedPathToLeafs;
    private List<HierarchicalColumnsDataGridModel.HierarchicalGridColumn> myCachedLeafs;
    private final Object2BooleanMap<int[]> myValidPathsCache;
    private int myDepthOfHierarchy;

    HierarchicalReader(@NotNull List<HierarchicalColumnsDataGridModel.HierarchicalGridColumn> roots) {
        if (roots == null) {
            HierarchicalReader.$$$reportNull$$$0(0);
        }
        this.myDepthOfHierarchy = -1;
        this.myRoots = roots;
        this.myValidPathsCache = new Object2BooleanOpenHashMap();
    }

    @NotNull
    public JBTreeTraverser<HierarchicalColumnsDataGridModel.HierarchicalGridColumn> hierarchy() {
        JBTreeTraverser jBTreeTraverser = JBTreeTraverser.from(c -> c.getChildren());
        if (jBTreeTraverser == null) {
            HierarchicalReader.$$$reportNull$$$0(1);
        }
        return jBTreeTraverser;
    }

    public boolean isValidPath(int[] path) {
        if (!this.myValidPathsCache.containsKey((Object)path)) {
            List<HierarchicalColumnsDataGridModel.HierarchicalGridColumn> leafs = this.getLeafs();
            boolean found = false;
            for (HierarchicalColumnsDataGridModel.HierarchicalGridColumn leaf : leafs) {
                int[] pathFromRoot = leaf.getPathFromRoot();
                if (!HierarchicalReader.arrayContains(pathFromRoot, path)) continue;
                found = true;
                break;
            }
            this.myValidPathsCache.put((Object)path, found);
        }
        return this.myValidPathsCache.getBoolean((Object)path);
    }

    private static boolean arrayContains(int[] arr1, int[] arr2) {
        if (arr2.length == 0 || arr1.length < arr2.length) {
            return false;
        }
        for (int i = 0; i <= arr1.length - arr2.length; ++i) {
            boolean found = true;
            for (int j = 0; j < arr2.length; ++j) {
                if (arr1[i + j] == arr2[j]) continue;
                found = false;
                break;
            }
            if (!found) continue;
            return true;
        }
        return false;
    }

    private List<List<HierarchicalColumnsDataGridModel.HierarchicalGridColumn>> getPathsToLeafs() {
        if (this.myCachedPathToLeafs == null) {
            this.myCachedPathToLeafs = ColumnHierarchyUtil.getPathsToLeafColumns((JBTreeTraverser)this.hierarchy().withRoots(this.myRoots));
        }
        return this.myCachedPathToLeafs;
    }

    public int getDepthOfHierarchy() {
        if (this.myDepthOfHierarchy == -1) {
            this.myDepthOfHierarchy = ColumnHierarchyUtil.getMaxDepth((JBTreeTraverser)this.hierarchy().withRoots(this.myRoots));
        }
        return this.myDepthOfHierarchy;
    }

    public int getLeafColumnsCount() {
        return this.getPathsToLeafs().size();
    }

    @NotNull
    public List<HierarchicalColumnsDataGridModel.HierarchicalGridColumn> getLeafs() {
        if (this.myCachedLeafs == null) {
            List<List<HierarchicalColumnsDataGridModel.HierarchicalGridColumn>> paths = this.getPathsToLeafs();
            this.myCachedLeafs = paths.stream().filter(path -> !path.isEmpty()).map(path -> (HierarchicalColumnsDataGridModel.HierarchicalGridColumn)path.get(path.size() - 1)).toList();
        }
        List<HierarchicalColumnsDataGridModel.HierarchicalGridColumn> list = this.myCachedLeafs;
        if (list == null) {
            HierarchicalReader.$$$reportNull$$$0(2);
        }
        return list;
    }

    public int @NotNull [] getColumnPath(int column) {
        if (column < 0) {
            int[] nArray = new int[]{-1};
            if (nArray == null) {
                HierarchicalReader.$$$reportNull$$$0(3);
            }
            return nArray;
        }
        List<HierarchicalColumnsDataGridModel.HierarchicalGridColumn> leafs = this.getLeafs();
        if (column >= leafs.size()) {
            int[] nArray = new int[]{-1};
            if (nArray == null) {
                HierarchicalReader.$$$reportNull$$$0(4);
            }
            return nArray;
        }
        int[] nArray = leafs.get(column).getPathFromRoot();
        if (nArray == null) {
            HierarchicalReader.$$$reportNull$$$0(5);
        }
        return nArray;
    }

    @Nullable
    public HierarchicalColumnsDataGridModel.HierarchicalGridColumn getAncestorAtDepth(@NotNull HierarchicalColumnsDataGridModel.HierarchicalGridColumn column, int depth) {
        if (column == null) {
            HierarchicalReader.$$$reportNull$$$0(6);
        }
        int[] pathToColumn = column.getPathFromRoot();
        assert (pathToColumn.length > 0);
        int rootIdx = pathToColumn[0];
        HierarchicalColumnsDataGridModel.HierarchicalGridColumn ancestor = this.getNodeByIndex(this.myRoots, rootIdx);
        for (int curDepth = 1; curDepth <= depth && ancestor != null; ++curDepth) {
            ancestor = this.getNodeByIndex(ancestor.getChildren(), pathToColumn[curDepth]);
        }
        return ancestor;
    }

    @Nullable
    private HierarchicalColumnsDataGridModel.HierarchicalGridColumn getNodeByIndex(List<HierarchicalColumnsDataGridModel.HierarchicalGridColumn> nodes, int index) {
        if (index < 0 || index >= nodes.size()) {
            return null;
        }
        return nodes.get(index);
    }

    @NotNull
    public List<HierarchicalColumnsDataGridModel.HierarchicalGridColumn> getAllLeafNodesInSubtree(@NotNull HierarchicalColumnsDataGridModel.HierarchicalGridColumn column) {
        if (column == null) {
            HierarchicalReader.$$$reportNull$$$0(7);
        }
        List<HierarchicalColumnsDataGridModel.HierarchicalGridColumn> list = ColumnHierarchyUtil.getAllLeafNodesInSubtree((JBTreeTraverser)this.hierarchy().withRoots(this.myRoots), column);
        if (list == null) {
            HierarchicalReader.$$$reportNull$$$0(8);
        }
        return list;
    }

    @NotNull
    public List<HierarchicalColumnsDataGridModel.HierarchicalGridColumn> getSiblings(@NotNull HierarchicalColumnsDataGridModel.HierarchicalGridColumn column) {
        if (column == null) {
            HierarchicalReader.$$$reportNull$$$0(9);
        }
        if (column.getPathFromRoot().length == 1) {
            List<HierarchicalColumnsDataGridModel.HierarchicalGridColumn> list = this.myRoots;
            if (list == null) {
                HierarchicalReader.$$$reportNull$$$0(10);
            }
            return list;
        }
        HierarchicalColumnsDataGridModel.HierarchicalGridColumn parent = column.getParent();
        List<Object> list = parent == null ? Collections.emptyList() : parent.getChildren();
        if (list == null) {
            HierarchicalReader.$$$reportNull$$$0(11);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 4, 5, 8, 10, 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "roots";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/datagrid/HierarchicalReader";
                break;
            }
            case 6: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "column";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/datagrid/HierarchicalReader";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "hierarchy";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getLeafs";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getColumnPath";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllLeafNodesInSubtree";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getSiblings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 10: 
            case 11: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getAncestorAtDepth";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getAllLeafNodesInSubtree";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getSiblings";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 4, 5, 8, 10, 11 -> new IllegalStateException(string);
        };
    }
}

