/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.swing.edt;

import java.lang.ref.WeakReference;
import javax.swing.JComponent;
import javax.swing.RepaintManager;
import javax.swing.SwingUtilities;
import org.assertj.core.util.Preconditions;
import org.assertj.swing.dependency.jsr305.Nonnull;

abstract class CheckThreadViolationRepaintManager
extends RepaintManager {
    private final boolean completeCheck;
    private WeakReference<JComponent> lastComponent;

    CheckThreadViolationRepaintManager() {
        this(true);
    }

    CheckThreadViolationRepaintManager(boolean completeCheck) {
        this.completeCheck = completeCheck;
    }

    @Override
    public synchronized void addInvalidComponent(JComponent component2) {
        this.checkThreadViolations((JComponent)Preconditions.checkNotNull((Object)component2));
        super.addInvalidComponent(component2);
    }

    @Override
    public void addDirtyRegion(JComponent component2, int x, int y2, int w, int h) {
        this.checkThreadViolations((JComponent)Preconditions.checkNotNull((Object)component2));
        super.addDirtyRegion(component2, x, y2, w, h);
    }

    private void checkThreadViolations(@Nonnull JComponent c) {
        if (!SwingUtilities.isEventDispatchThread() && (this.completeCheck || c.isShowing())) {
            StackTraceElement[] stackTrace;
            boolean imageUpdate = false;
            boolean repaint = false;
            boolean fromSwing = false;
            for (StackTraceElement st : stackTrace = Thread.currentThread().getStackTrace()) {
                if (repaint && st.getClassName().startsWith("javax.swing.") && !st.getClassName().startsWith("javax.swing.SwingWorker")) {
                    fromSwing = true;
                }
                if (repaint && "imageUpdate".equals(st.getMethodName())) {
                    imageUpdate = true;
                }
                if (!"repaint".equals(st.getMethodName())) continue;
                repaint = true;
                fromSwing = false;
            }
            if (imageUpdate) {
                return;
            }
            if (repaint && !fromSwing) {
                return;
            }
            if (this.lastComponent != null && c == this.lastComponent.get()) {
                return;
            }
            this.lastComponent = new WeakReference<JComponent>(c);
            this.violationFound(c, stackTrace);
        }
    }

    abstract void violationFound(@Nonnull JComponent var1, @Nonnull StackTraceElement[] var2);
}

