/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.swing.driver;

import java.util.ArrayList;
import javax.swing.JTree;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.assertj.core.util.Lists;
import org.assertj.core.util.Strings;
import org.assertj.swing.annotation.RunsInCurrentThread;
import org.assertj.swing.cell.JTreeCellReader;
import org.assertj.swing.dependency.jsr305.Nonnull;
import org.assertj.swing.dependency.jsr305.Nullable;
import org.assertj.swing.driver.BasicJTreeCellReader;
import org.assertj.swing.exception.LocationUnavailableException;

class JTreePathFinder {
    private static final String SEPARATOR = "/";
    private JTreeCellReader cellReader;
    private String separator;

    JTreePathFinder() {
        this.replaceCellReader(new BasicJTreeCellReader());
        this.replaceSeparator(SEPARATOR);
    }

    @Nonnull
    @RunsInCurrentThread
    TreePath findMatchingPath(@Nonnull JTree tree2, @Nonnull String path) {
        String[] pathStrings = this.splitPath(path);
        TreeModel model = tree2.getModel();
        ArrayList newPathValues = Lists.newArrayList();
        Object node = model.getRoot();
        int pathElementCount = pathStrings.length;
        for (int stringIndex = 0; stringIndex < pathElementCount; ++stringIndex) {
            String pathString = pathStrings[stringIndex];
            Object match = null;
            if (stringIndex == 0 && tree2.isRootVisible()) {
                if (!pathString.equals(this.value(tree2, node))) {
                    throw this.pathNotFound(path);
                }
                newPathValues.add(node);
                continue;
            }
            int childCount = model.getChildCount(node);
            for (int childIndex = 0; childIndex < childCount; ++childIndex) {
                Object child = model.getChild(node, childIndex);
                if (!pathString.equals(this.value(tree2, child))) continue;
                if (match != null) {
                    throw this.multipleMatchingNodes(pathString, this.value(tree2, node));
                }
                match = child;
            }
            if (match == null) {
                throw this.pathNotFound(path);
            }
            newPathValues.add(match);
            node = match;
        }
        return new TreePath(newPathValues.toArray());
    }

    @Nonnull
    private LocationUnavailableException pathNotFound(@Nonnull String path) {
        throw new LocationUnavailableException(String.format("Unable to find path %s", Strings.quote((String)path)));
    }

    @Nonnull
    private String[] splitPath(@Nonnull String path) {
        ArrayList result2 = Lists.newArrayList();
        int separatorSize = this.separator.length();
        int index = 0;
        int pathSize = path.length();
        while (index < pathSize) {
            int separatorPosition = path.indexOf(this.separator, index);
            if (separatorPosition == -1) {
                separatorPosition = pathSize;
            }
            result2.add(path.substring(index, separatorPosition));
            index = separatorPosition + separatorSize;
        }
        return result2.toArray(new String[result2.size()]);
    }

    @Nonnull
    private LocationUnavailableException multipleMatchingNodes(@Nonnull String matchingText, @Nullable Object parentText) {
        String msg = String.format("There is more than one node with value '%s' under", matchingText, Strings.quote((Object)parentText));
        throw new LocationUnavailableException(msg);
    }

    @Nullable
    private String value(@Nonnull JTree tree2, @Nullable Object modelValue) {
        return this.cellReader.valueAt(tree2, modelValue);
    }

    @Nonnull
    String separator() {
        return this.separator;
    }

    void replaceSeparator(@Nonnull String newSeparator) {
        this.separator = newSeparator;
    }

    void replaceCellReader(@Nonnull JTreeCellReader newCellReader) {
        this.cellReader = newCellReader;
    }

    @Nonnull
    JTreeCellReader cellReader() {
        return this.cellReader;
    }
}

