/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.swing.driver;

import java.awt.Point;
import javax.swing.JSplitPane;
import org.assertj.core.util.Preconditions;
import org.assertj.swing.annotation.RunsInCurrentThread;
import org.assertj.swing.annotation.RunsInEDT;
import org.assertj.swing.core.MouseButton;
import org.assertj.swing.core.Robot;
import org.assertj.swing.dependency.jsr305.Nonnull;
import org.assertj.swing.driver.ComponentPreconditions;
import org.assertj.swing.driver.JComponentDriver;
import org.assertj.swing.driver.JSplitPaneLocationCalculator;
import org.assertj.swing.driver.JSplitPaneSetDividerLocationTask;
import org.assertj.swing.edt.GuiActionRunner;
import org.assertj.swing.edt.GuiQuery;
import org.assertj.swing.internal.annotation.InternalApi;
import org.assertj.swing.util.GenericRange;

@InternalApi
public class JSplitPaneDriver
extends JComponentDriver {
    public JSplitPaneDriver(@Nonnull Robot robot) {
        super(robot);
    }

    @RunsInEDT
    public void moveDividerTo(@Nonnull JSplitPane splitPane, int location) {
        int newLocation = JSplitPaneLocationCalculator.locationToMoveDividerTo(splitPane, location);
        this.simulateMovingDivider(splitPane, newLocation);
        JSplitPaneSetDividerLocationTask.setDividerLocation(splitPane, newLocation);
        this.robot.waitForIdle();
    }

    @RunsInEDT
    private void simulateMovingDivider(@Nonnull JSplitPane split, int location) {
        if (split.getOrientation() == 0) {
            this.simulateMovingDividerVertically(split, location);
            return;
        }
        this.simulateMovingDividerHorizontally(split, location);
    }

    @RunsInEDT
    private void simulateMovingDividerVertically(@Nonnull JSplitPane splitPane, int location) {
        GenericRange<Point> whereToMove = JSplitPaneDriver.findWhereToMoveDividerVertically(splitPane, location);
        this.simulateMovingDivider(splitPane, whereToMove);
    }

    @Nonnull
    @RunsInEDT
    private static GenericRange<Point> findWhereToMoveDividerVertically(final @Nonnull JSplitPane splitPane, final int location) {
        GenericRange<Point> result2 = GuiActionRunner.execute(new GuiQuery<GenericRange<Point>>(){

            @Override
            protected GenericRange<Point> executeInEDT() {
                ComponentPreconditions.checkEnabledAndShowing(splitPane);
                return JSplitPaneDriver.whereToMoveDividerVertically(splitPane, location);
            }
        });
        return (GenericRange)Preconditions.checkNotNull(result2);
    }

    @Nonnull
    @RunsInCurrentThread
    private static GenericRange<Point> whereToMoveDividerVertically(@Nonnull JSplitPane splitPane, int location) {
        int x = splitPane.getWidth() / 2;
        int dividerLocation = splitPane.getDividerLocation();
        return new GenericRange<Point>(new Point(x, dividerLocation), new Point(x, location));
    }

    private void simulateMovingDividerHorizontally(@Nonnull JSplitPane splitPane, int location) {
        GenericRange<Point> whereToMove = JSplitPaneDriver.findWhereToMoveDividerHorizontally(splitPane, location);
        this.simulateMovingDivider(splitPane, whereToMove);
    }

    @Nonnull
    @RunsInEDT
    private static GenericRange<Point> findWhereToMoveDividerHorizontally(final @Nonnull JSplitPane splitPane, final int location) {
        GenericRange<Point> result2 = GuiActionRunner.execute(new GuiQuery<GenericRange<Point>>(){

            @Override
            protected GenericRange<Point> executeInEDT() {
                ComponentPreconditions.checkEnabledAndShowing(splitPane);
                return JSplitPaneDriver.whereToMoveDividerHorizontally(splitPane, location);
            }
        });
        return (GenericRange)Preconditions.checkNotNull(result2);
    }

    @Nonnull
    @RunsInCurrentThread
    private static GenericRange<Point> whereToMoveDividerHorizontally(@Nonnull JSplitPane splitPane, int location) {
        int y2 = splitPane.getHeight() / 2;
        int dividerLocation = splitPane.getDividerLocation();
        return new GenericRange<Point>(new Point(dividerLocation, y2), new Point(location, y2));
    }

    @RunsInEDT
    private void simulateMovingDivider(@Nonnull JSplitPane splitPane, @Nonnull GenericRange<Point> range) {
        try {
            this.robot.moveMouse(splitPane, range.from());
            this.robot.pressMouseWhileRunning(MouseButton.LEFT_BUTTON, () -> this.robot.moveMouse(splitPane, (Point)range.to()));
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }
}

