/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.swing.data;

import javax.swing.JTable;
import org.assertj.core.util.Objects;
import org.assertj.core.util.Preconditions;
import org.assertj.core.util.Strings;
import org.assertj.swing.annotation.RunsInCurrentThread;
import org.assertj.swing.annotation.RunsInEDT;
import org.assertj.swing.cell.JTableCellReader;
import org.assertj.swing.data.TableCell;
import org.assertj.swing.data.TableCellFinder;
import org.assertj.swing.dependency.jsr305.Nonnull;
import org.assertj.swing.edt.GuiActionRunner;
import org.assertj.swing.exception.ActionFailedException;
import org.assertj.swing.util.Arrays;

public class TableCellInRowByValue
implements TableCellFinder {
    private final String[] values;
    private final int column;

    @Nonnull
    public static TableCellBuilder rowWithValue(String ... values) {
        return new TableCellBuilder(values);
    }

    protected TableCellInRowByValue(@Nonnull String[] values, int column) {
        this.values = values;
        this.column = column;
    }

    @Override
    @Nonnull
    @RunsInEDT
    public TableCell findCell(@Nonnull JTable table, @Nonnull JTableCellReader cellReader) {
        int row2 = TableCellInRowByValue.findRowIndex(table, cellReader, this.values);
        if (row2 == -1) {
            throw ActionFailedException.actionFailure(Strings.concat((Object[])new Object[]{"Unable to find a row with values:<", Arrays.format(this.values), ">"}));
        }
        return new TableCell(row2, this.column);
    }

    @RunsInEDT
    private static int findRowIndex(@Nonnull JTable table, @Nonnull JTableCellReader cellReader, @Nonnull String[] values) {
        Integer result2 = GuiActionRunner.execute(() -> {
            TableCellInRowByValue.validateEqualSize(table, values);
            int rowCount = table.getRowCount();
            for (int row2 = 0; row2 < rowCount; ++row2) {
                if (!TableCellInRowByValue.matchingRow(table, cellReader, values, row2)) continue;
                return row2;
            }
            return -1;
        });
        return (Integer)Preconditions.checkNotNull((Object)result2);
    }

    @RunsInCurrentThread
    private static void validateEqualSize(@Nonnull JTable table, @Nonnull String[] values) {
        int columnCount = table.getColumnCount();
        if (values.length != columnCount) {
            throw new IllegalStateException(Strings.concat((Object[])new Object[]{"The array of values should have size:<", columnCount, ">"}));
        }
    }

    @RunsInCurrentThread
    private static boolean matchingRow(@Nonnull JTable table, @Nonnull JTableCellReader cellReader, @Nonnull String[] values, int row2) {
        int columnCount = table.getColumnCount();
        for (int col = 0; col < columnCount; ++col) {
            if (Objects.areEqual((Object)cellReader.valueAt(table, row2, col), (Object)values[col])) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return String.format("%s[values=%s, column=%d]", this.getClass().getName(), Arrays.format(this.values), this.column);
    }

    public static class TableCellBuilder {
        private final String[] values;

        TableCellBuilder(@Nonnull String[] values) {
            this.values = (String[])Preconditions.checkNotNull((Object)values);
        }

        @Nonnull
        public TableCellInRowByValue column(int column) {
            return new TableCellInRowByValue(this.values, column);
        }
    }
}

