/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.swing.data;

import javax.swing.JTable;
import org.assertj.core.util.Preconditions;
import org.assertj.core.util.Strings;
import org.assertj.swing.annotation.RunsInEDT;
import org.assertj.swing.cell.JTableCellReader;
import org.assertj.swing.data.TableCell;
import org.assertj.swing.data.TableCellFinder;
import org.assertj.swing.dependency.jsr305.Nonnull;
import org.assertj.swing.edt.GuiActionRunner;
import org.assertj.swing.exception.ActionFailedException;
import org.assertj.swing.query.JTableColumnByIdentifierQuery;

public class TableCellByColumnId
implements TableCellFinder {
    public final int row;
    public final Object columnId;

    public static TableCellBuilder row(int row2) {
        return new TableCellBuilder(row2);
    }

    protected TableCellByColumnId(int row2, @Nonnull Object columnId) {
        this.row = row2;
        this.columnId = columnId;
    }

    @Override
    @Nonnull
    @RunsInEDT
    public TableCell findCell(@Nonnull JTable table, @Nonnull JTableCellReader cellReader) {
        return TableCellByColumnId.findCell(table, this.row, this.columnId);
    }

    @Nonnull
    @RunsInEDT
    private static TableCell findCell(@Nonnull JTable table, int row2, @Nonnull Object columnId) {
        TableCell result2 = GuiActionRunner.execute(() -> {
            int column = JTableColumnByIdentifierQuery.columnIndexByIdentifier(table, columnId);
            if (column == -1) {
                TableCellByColumnId.failColumnIndexNotFound(columnId);
            }
            table.convertColumnIndexToView(table.getColumn(columnId).getModelIndex());
            return new TableCell(row2, column);
        });
        return (TableCell)Preconditions.checkNotNull((Object)result2);
    }

    private static ActionFailedException failColumnIndexNotFound(Object columnId) {
        throw ActionFailedException.actionFailure(Strings.concat((Object[])new Object[]{"Unable to find a column with id ", Strings.quote((Object)columnId)}));
    }

    public String toString() {
        return Strings.concat((Object[])new Object[]{this.getClass().getName(), "[row=", String.valueOf(this.row), ", columnId=", Strings.quote((Object)this.columnId), "]"});
    }

    public static class TableCellBuilder {
        private final int row;

        TableCellBuilder(int row2) {
            this.row = row2;
        }

        public TableCellByColumnId columnId(@Nonnull Object columnId) {
            return new TableCellByColumnId(this.row, columnId);
        }
    }
}

