/*
 * Decompiled with CFR 0.152.
 */
package git4idea.statistics;

import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.util.net.IdeHttpClientHelpers;
import git4idea.repo.GitRemote;
import git4idea.repo.GitRepository;
import git4idea.statistics.RepositoryAvailability;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.MatchGroup;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0007\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0002J\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\b0\f2\u0006\u0010\r\u001a\u00020\u000eJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\nH\u0002J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\n2\u0006\u0010\t\u001a\u00020\nH\u0007J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\nH\u0002J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0011\u001a\u00020\nH\u0002J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0011\u001a\u00020\nH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0019"}, d2={"Lgit4idea/statistics/GitAvailabilityChecker;", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "checkRemoteStatus", "Lgit4idea/statistics/RepositoryAvailability;", "remote", "", "checkRepoStatus", "", "gitRepository", "Lgit4idea/repo/GitRepository;", "createHttpClient", "Lorg/apache/http/impl/client/CloseableHttpClient;", "url", "getHttpUrlFromRemote", "getRequestConfigBuilder", "Lorg/apache/http/client/config/RequestConfig$Builder;", "parseGitRemoteUrl", "sendHeadRequest", "", "Companion", "intellij.vcs.git"})
@SourceDebugExtension(value={"SMAP\nGitAvailabilityChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitAvailabilityChecker.kt\ngit4idea/statistics/GitAvailabilityChecker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,89:1\n1549#2:90\n1620#2,3:91\n*S KotlinDebug\n*F\n+ 1 GitAvailabilityChecker.kt\ngit4idea/statistics/GitAvailabilityChecker\n*L\n21#1:90\n21#1:91,3\n*E\n"})
public final class GitAvailabilityChecker {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private static final Regex REGEXP = new Regex("^(?:(https?://)(?:.*?@)?(.*?)/|(ssh://)(?:.*@)?(.*?)(?::.*?)?(?:/|(?=~))|.*?@(.*?):)/?(.*)$");
    private static final int CONNECTION_TIMEOUT = 3000;
    @NotNull
    private static final Logger LOG;

    public GitAvailabilityChecker(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<RepositoryAvailability> checkRepoStatus(@NotNull GitRepository gitRepository) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)gitRepository, (String)"gitRepository");
        if (gitRepository.getRemotes().isEmpty()) {
            return CollectionsKt.listOf((Object)((Object)RepositoryAvailability.LOCAL));
        }
        Collection<GitRemote> collection = gitRepository.getRemotes();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"getRemotes(...)");
        Iterable $this$map$iv = CollectionsKt.take((Iterable)collection, (int)10);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            GitRemote gitRemote = (GitRemote)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(this.checkRemoteStatus(it.getFirstUrl()));
        }
        return (List)destination$iv$iv;
    }

    @TestOnly
    @Nullable
    public final String getHttpUrlFromRemote(@NotNull String remote) {
        Intrinsics.checkNotNullParameter((Object)remote, (String)"remote");
        return this.parseGitRemoteUrl(remote);
    }

    private final RepositoryAvailability checkRemoteStatus(String remote) {
        if (remote == null) {
            return RepositoryAvailability.LOCAL;
        }
        String string = this.parseGitRemoteUrl(remote);
        if (string == null) {
            return RepositoryAvailability.UNKNOWN_HOST;
        }
        String httpsUrl = string;
        boolean result2 = this.sendHeadRequest(httpsUrl);
        return result2 ? RepositoryAvailability.PUBLIC : RepositoryAvailability.PRIVATE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean sendHeadRequest(String url) {
        CloseableHttpClient httpClient = this.createHttpClient(url);
        Closeable closeable = (Closeable)httpClient;
        Throwable throwable = null;
        try {
            CloseableHttpClient it = (CloseableHttpClient)closeable;
            boolean bl = false;
            try {
                CloseableHttpResponse response = it.execute((HttpUriRequest)new HttpHead(url));
                boolean bl2 = response.getStatusLine().getStatusCode() == 200;
                return bl2;
            }
            catch (Exception e) {
                boolean bl3;
                try {
                    LOG.warn((Throwable)e);
                    bl3 = false;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                catch (Throwable throwable3) {
                    throw throwable3;
                }
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                return bl3;
            }
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    private final CloseableHttpClient createHttpClient(String url) {
        RequestConfig.Builder requestConfigBuilder = this.getRequestConfigBuilder(url);
        CloseableHttpClient builder = HttpClientBuilder.create().setDefaultRequestConfig(requestConfigBuilder.build()).build();
        Intrinsics.checkNotNull((Object)builder);
        return builder;
    }

    private final RequestConfig.Builder getRequestConfigBuilder(String url) {
        RequestConfig.Builder requestConfigBuilder = RequestConfig.custom().setConnectTimeout(3000).setSocketTimeout(3000);
        IdeHttpClientHelpers.ApacheHttpClient4.setProxyForUrlIfEnabled((RequestConfig.Builder)requestConfigBuilder, (String)url);
        Intrinsics.checkNotNull((Object)requestConfigBuilder);
        return requestConfigBuilder;
    }

    private final String parseGitRemoteUrl(String url) {
        Object object;
        Object protocol;
        MatchResult match2 = REGEXP.matchEntire((CharSequence)url);
        if (match2 == null) {
            return null;
        }
        Object object2 = match2.getGroups().get(1);
        if (object2 == null || (object2 = object2.getValue()) == null) {
            object2 = protocol = "https://";
        }
        if ((object = match2.getGroups().get(2)) == null || (object = object.getValue()) == null) {
            MatchGroup matchGroup = match2.getGroups().get(4);
            if (matchGroup != null) {
                object = matchGroup.getValue();
            } else {
                MatchGroup matchGroup2 = match2.getGroups().get(5);
                object = matchGroup2 != null ? matchGroup2.getValue() : null;
                if (object == null) {
                    return null;
                }
            }
        }
        Object host = object;
        Object object3 = match2.getGroups().get(6);
        if (object3 == null || (object3 = object3.getValue()) == null) {
            return null;
        }
        Object path = object3;
        return (String)protocol + (String)host + "/" + (String)path;
    }

    static {
        Logger logger = Logger.getInstance(GitAvailabilityChecker.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0005\u001a\u00070\u0006\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lgit4idea/statistics/GitAvailabilityChecker$Companion;", "", "()V", "CONNECTION_TIMEOUT", "", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "REGEXP", "Lkotlin/text/Regex;", "getInstance", "Lgit4idea/statistics/GitAvailabilityChecker;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.vcs.git"})
    @SourceDebugExtension(value={"SMAP\nGitAvailabilityChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitAvailabilityChecker.kt\ngit4idea/statistics/GitAvailabilityChecker$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,89:1\n31#2,2:90\n*S KotlinDebug\n*F\n+ 1 GitAvailabilityChecker.kt\ngit4idea/statistics/GitAvailabilityChecker$Companion\n*L\n82#1:90,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final GitAvailabilityChecker getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<GitAvailabilityChecker> serviceClass$iv = GitAvailabilityChecker.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (GitAvailabilityChecker)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

