/*
 * Decompiled with CFR 0.152.
 */
package git4idea.repo;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import git4idea.repo.GitConfig;
import java.io.File;
import java.io.IOException;
import java.nio.file.InvalidPathException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GitRepositoryFiles {
    private static final Logger LOG = Logger.getInstance(GitRepositoryFiles.class);
    public static final String GITIGNORE = ".gitignore";
    @NonNls
    private static final String CHERRY_PICK_HEAD = "CHERRY_PICK_HEAD";
    @NonNls
    public static final String COMMIT_EDITMSG = "COMMIT_EDITMSG";
    @NonNls
    private static final String CONFIG = "config";
    @NonNls
    private static final String HEAD = "HEAD";
    @NonNls
    private static final String INDEX = "index";
    @NonNls
    private static final String INFO = "info";
    @NonNls
    private static final String INFO_EXCLUDE = "info/exclude";
    @NonNls
    private static final String MERGE_HEAD = "MERGE_HEAD";
    @NonNls
    private static final String MERGE_MSG = "MERGE_MSG";
    @NonNls
    private static final String ORIG_HEAD = "ORIG_HEAD";
    @NonNls
    private static final String REBASE_APPLY = "rebase-apply";
    @NonNls
    private static final String REBASE_MERGE = "rebase-merge";
    @NonNls
    private static final String PACKED_REFS = "packed-refs";
    @NonNls
    private static final String REFS = "refs";
    @NonNls
    private static final String REVERT_HEAD = "REVERT_HEAD";
    @NonNls
    private static final String HEADS = "heads";
    @NonNls
    private static final String TAGS = "tags";
    @NonNls
    private static final String REMOTES = "remotes";
    @NonNls
    private static final String SQUASH_MSG = "SQUASH_MSG";
    @NonNls
    private static final String HOOKS = "hooks";
    @NonNls
    private static final String PRE_COMMIT_HOOK = "pre-commit";
    @NonNls
    private static final String PRE_PUSH_HOOK = "pre-push";
    @NonNls
    private static final String COMMIT_MSG_HOOK = "commit-msg";
    @NonNls
    private static final String SHALLOW = "shallow";
    @NonNls
    private static final String LOGS = "logs";
    @NonNls
    private static final String STASH = "stash";
    @NonNls
    private static final String WORKTREES_DIR = "worktrees";
    private final VirtualFile myRootDir;
    private final VirtualFile myMainDir;
    private final VirtualFile myWorktreeDir;
    @NonNls
    private final String myConfigFilePath;
    @NonNls
    private final String myHeadFilePath;
    @NonNls
    private final String myIndexFilePath;
    @NonNls
    private final String myMergeHeadPath;
    @NonNls
    private final String myCherryPickHeadPath;
    @NonNls
    private final String myRevertHeadPath;
    @NonNls
    private final String myOrigHeadPath;
    @NonNls
    private final String myRebaseApplyPath;
    @NonNls
    private final String myRebaseMergePath;
    @NonNls
    private final String myPackedRefsPath;
    @NonNls
    private final String myRefsHeadsDirPath;
    @NonNls
    private final String myRefsRemotesDirPath;
    @NonNls
    private final String myRefsTagsPath;
    @NonNls
    private final String myCommitMessagePath;
    @NonNls
    private final String myMergeMessagePath;
    @NonNls
    private final String myMergeSquashPath;
    @NonNls
    private final String myInfoDirPath;
    @NonNls
    private final String myExcludePath;
    @NonNls
    private final String myHooksDirPath;
    @NonNls
    private final String myShallow;
    @NonNls
    private final String myStashReflogPath;
    @NonNls
    private final String myWorktreesDirPath;
    @Nullable
    @NonNls
    private String myCustomHooksDirPath;

    private GitRepositoryFiles(@NotNull VirtualFile rootDir, @NotNull VirtualFile mainDir, @NotNull VirtualFile worktreeDir) {
        if (rootDir == null) {
            GitRepositoryFiles.$$$reportNull$$$0(0);
        }
        if (mainDir == null) {
            GitRepositoryFiles.$$$reportNull$$$0(1);
        }
        if (worktreeDir == null) {
            GitRepositoryFiles.$$$reportNull$$$0(2);
        }
        this.myRootDir = rootDir;
        this.myMainDir = mainDir;
        this.myWorktreeDir = worktreeDir;
        String mainPath = this.myMainDir.getPath();
        this.myConfigFilePath = mainPath + GitRepositoryFiles.slash(CONFIG);
        this.myPackedRefsPath = mainPath + GitRepositoryFiles.slash(PACKED_REFS);
        String refsPath = mainPath + GitRepositoryFiles.slash(REFS);
        this.myRefsHeadsDirPath = refsPath + GitRepositoryFiles.slash(HEADS);
        this.myRefsTagsPath = refsPath + GitRepositoryFiles.slash(TAGS);
        this.myRefsRemotesDirPath = refsPath + GitRepositoryFiles.slash(REMOTES);
        this.myInfoDirPath = mainPath + GitRepositoryFiles.slash(INFO);
        this.myExcludePath = mainPath + GitRepositoryFiles.slash(INFO_EXCLUDE);
        this.myHooksDirPath = mainPath + GitRepositoryFiles.slash(HOOKS);
        this.myShallow = mainPath + GitRepositoryFiles.slash(SHALLOW);
        this.myStashReflogPath = mainPath + GitRepositoryFiles.slash(LOGS) + GitRepositoryFiles.slash(REFS) + GitRepositoryFiles.slash(STASH);
        this.myWorktreesDirPath = mainPath + GitRepositoryFiles.slash(WORKTREES_DIR);
        String worktreePath = this.myWorktreeDir.getPath();
        this.myHeadFilePath = worktreePath + GitRepositoryFiles.slash(HEAD);
        this.myIndexFilePath = worktreePath + GitRepositoryFiles.slash(INDEX);
        this.myMergeHeadPath = worktreePath + GitRepositoryFiles.slash(MERGE_HEAD);
        this.myCherryPickHeadPath = worktreePath + GitRepositoryFiles.slash(CHERRY_PICK_HEAD);
        this.myRevertHeadPath = worktreePath + GitRepositoryFiles.slash(REVERT_HEAD);
        this.myOrigHeadPath = worktreePath + GitRepositoryFiles.slash(ORIG_HEAD);
        this.myCommitMessagePath = worktreePath + GitRepositoryFiles.slash(COMMIT_EDITMSG);
        this.myMergeMessagePath = worktreePath + GitRepositoryFiles.slash(MERGE_MSG);
        this.myMergeSquashPath = worktreePath + GitRepositoryFiles.slash(SQUASH_MSG);
        this.myRebaseApplyPath = worktreePath + GitRepositoryFiles.slash(REBASE_APPLY);
        this.myRebaseMergePath = worktreePath + GitRepositoryFiles.slash(REBASE_MERGE);
    }

    @NotNull
    public static GitRepositoryFiles createInstance(@NotNull VirtualFile rootDir, @NotNull VirtualFile gitDir) {
        VirtualFile gitDirForWorktree;
        if (rootDir == null) {
            GitRepositoryFiles.$$$reportNull$$$0(3);
        }
        if (gitDir == null) {
            GitRepositoryFiles.$$$reportNull$$$0(4);
        }
        VirtualFile mainDir = (gitDirForWorktree = GitRepositoryFiles.getMainGitDirForWorktree(gitDir)) == null ? gitDir : gitDirForWorktree;
        return new GitRepositoryFiles(rootDir, mainDir, gitDir);
    }

    @Nullable
    private static VirtualFile getMainGitDirForWorktree(@NotNull VirtualFile gitDir) {
        String pathToMain;
        File gitDirFile;
        File commonDir;
        if (gitDir == null) {
            GitRepositoryFiles.$$$reportNull$$$0(5);
        }
        if (!(commonDir = new File(gitDirFile = VfsUtilCore.virtualToIoFile((VirtualFile)gitDir), "commondir")).exists()) {
            return null;
        }
        try {
            pathToMain = FileUtil.loadFile((File)commonDir).trim();
        }
        catch (IOException e) {
            LOG.error("Couldn't load " + commonDir, (Throwable)e);
            return null;
        }
        String mainDir = FileUtil.toCanonicalPath((String)(gitDirFile.getPath() + File.separator + pathToMain), (boolean)true);
        LocalFileSystem lfs = LocalFileSystem.getInstance();
        VirtualFile mainDirVF = lfs.refreshAndFindFileByPath(mainDir);
        if (mainDirVF != null) {
            return mainDirVF;
        }
        return lfs.refreshAndFindFileByPath(pathToMain);
    }

    @NotNull
    private static String slash(@NotNull String s) {
        if (s == null) {
            GitRepositoryFiles.$$$reportNull$$$0(6);
        }
        String string = "/" + s;
        if (string == null) {
            GitRepositoryFiles.$$$reportNull$$$0(7);
        }
        return string;
    }

    @NotNull
    Collection<String> getPathsToWatch() {
        List<String> list2 = Arrays.asList(this.myRefsHeadsDirPath, this.myRefsRemotesDirPath, this.myRefsTagsPath, this.myInfoDirPath, this.myHooksDirPath, this.myStashReflogPath);
        if (list2 == null) {
            GitRepositoryFiles.$$$reportNull$$$0(8);
        }
        return list2;
    }

    @NotNull
    File getRefsHeadsFile() {
        return GitRepositoryFiles.file(this.myRefsHeadsDirPath);
    }

    @NotNull
    File getRefsRemotesFile() {
        return GitRepositoryFiles.file(this.myRefsRemotesDirPath);
    }

    @NotNull
    File getRefsTagsFile() {
        return GitRepositoryFiles.file(this.myRefsTagsPath);
    }

    @NotNull
    File getPackedRefsPath() {
        return GitRepositoryFiles.file(this.myPackedRefsPath);
    }

    @NotNull
    public File getHeadFile() {
        return GitRepositoryFiles.file(this.myHeadFilePath);
    }

    @NotNull
    public File getConfigFile() {
        return GitRepositoryFiles.file(this.myConfigFilePath);
    }

    @NotNull
    public File getRebaseMergeDir() {
        return GitRepositoryFiles.file(this.myRebaseMergePath);
    }

    @NotNull
    public File getRebaseApplyDir() {
        return GitRepositoryFiles.file(this.myRebaseApplyPath);
    }

    @NotNull
    public File getMergeHeadFile() {
        return GitRepositoryFiles.file(this.myMergeHeadPath);
    }

    @NotNull
    public File getCherryPickHead() {
        return GitRepositoryFiles.file(this.myCherryPickHeadPath);
    }

    @NotNull
    public File getRevertHead() {
        return GitRepositoryFiles.file(this.myRevertHeadPath);
    }

    @NotNull
    public File getMergeMessageFile() {
        return GitRepositoryFiles.file(this.myMergeMessagePath);
    }

    @NotNull
    public File getSquashMessageFile() {
        return GitRepositoryFiles.file(this.myMergeSquashPath);
    }

    public void updateCustomPaths(@NotNull GitConfig.Core core) {
        String hooksPath;
        if (core == null) {
            GitRepositoryFiles.$$$reportNull$$$0(9);
        }
        if ((hooksPath = core.getHooksPath()) != null) {
            try {
                this.myCustomHooksDirPath = this.myRootDir.toNioPath().resolve(hooksPath).toString();
            }
            catch (InvalidPathException e) {
                LOG.warn("Can't resolve custom hooks path: '" + hooksPath + "'");
                this.myCustomHooksDirPath = null;
            }
        } else {
            this.myCustomHooksDirPath = null;
        }
    }

    @NotNull
    public File getPreCommitHookFile() {
        return this.hook(PRE_COMMIT_HOOK);
    }

    @NotNull
    public File getPrePushHookFile() {
        return this.hook(PRE_PUSH_HOOK);
    }

    @NotNull
    public File getCommitMsgHookFile() {
        return this.hook(COMMIT_MSG_HOOK);
    }

    @NotNull
    public File getShallowFile() {
        return GitRepositoryFiles.file(this.myShallow);
    }

    @NotNull
    public File getExcludeFile() {
        return GitRepositoryFiles.file(this.myExcludePath);
    }

    @NotNull
    public File getStashReflogFile() {
        return GitRepositoryFiles.file(this.myStashReflogPath);
    }

    @NotNull
    public File getWorktreesDirFile() {
        return GitRepositoryFiles.file(this.myWorktreesDirPath);
    }

    @NotNull
    private File hook(@NotNull String filePath) {
        if (filePath == null) {
            GitRepositoryFiles.$$$reportNull$$$0(10);
        }
        return GitRepositoryFiles.file((String)ObjectUtils.chooseNotNull((Object)this.myCustomHooksDirPath, (Object)this.myHooksDirPath) + GitRepositoryFiles.slash(filePath));
    }

    @NotNull
    private static File file(@NotNull String filePath) {
        if (filePath == null) {
            GitRepositoryFiles.$$$reportNull$$$0(11);
        }
        return new File(FileUtil.toSystemDependentName((String)filePath));
    }

    public boolean isConfigFile(String filePath) {
        return filePath.equals(this.myConfigFilePath);
    }

    public boolean isIndexFile(String filePath) {
        return filePath.equals(this.myIndexFilePath);
    }

    public boolean isHeadFile(String file2) {
        return file2.equals(this.myHeadFilePath);
    }

    public boolean isOrigHeadFile(@NotNull String file2) {
        if (file2 == null) {
            GitRepositoryFiles.$$$reportNull$$$0(12);
        }
        return file2.equals(this.myOrigHeadPath);
    }

    public boolean isBranchFile(String filePath) {
        return filePath.startsWith(this.myRefsHeadsDirPath);
    }

    public boolean isBranchFile(@NotNull String filePath, @NotNull String fullBranchName) {
        if (filePath == null) {
            GitRepositoryFiles.$$$reportNull$$$0(13);
        }
        if (fullBranchName == null) {
            GitRepositoryFiles.$$$reportNull$$$0(14);
        }
        return FileUtil.pathsEqual((String)filePath, (String)(this.myMainDir.getPath() + GitRepositoryFiles.slash(fullBranchName)));
    }

    public boolean isRemoteBranchFile(String filePath) {
        return filePath.startsWith(this.myRefsRemotesDirPath);
    }

    public boolean isTagFile(@NotNull String path) {
        if (path == null) {
            GitRepositoryFiles.$$$reportNull$$$0(15);
        }
        return path.startsWith(this.myRefsTagsPath);
    }

    public boolean isRebaseFile(String path) {
        return path.equals(this.myRebaseApplyPath) || path.equals(this.myRebaseMergePath);
    }

    public boolean isMergeFile(String file2) {
        return file2.equals(this.myMergeHeadPath);
    }

    public boolean isPackedRefs(String file2) {
        return file2.equals(this.myPackedRefsPath);
    }

    public boolean isCommitMessageFile(@NotNull String file2) {
        if (file2 == null) {
            GitRepositoryFiles.$$$reportNull$$$0(16);
        }
        return file2.equals(this.myCommitMessagePath);
    }

    public boolean isExclude(@NotNull String path) {
        if (path == null) {
            GitRepositoryFiles.$$$reportNull$$$0(17);
        }
        return path.equals(this.myExcludePath);
    }

    public boolean isStashReflogFile(@NotNull String path) {
        if (path == null) {
            GitRepositoryFiles.$$$reportNull$$$0(18);
        }
        return path.equals(this.myStashReflogPath);
    }

    public void refresh() {
        VfsUtil.markDirtyAndRefresh((boolean)true, (boolean)true, (boolean)false, (VirtualFile[])new VirtualFile[]{this.myMainDir, this.myWorktreeDir});
    }

    public void refreshIndexFile() {
        VirtualFile indexFilePath = LocalFileSystem.getInstance().refreshAndFindFileByPath(this.myIndexFilePath);
        VfsUtil.markDirtyAndRefresh((boolean)true, (boolean)false, (boolean)false, (VirtualFile[])new VirtualFile[]{indexFilePath});
    }

    public void refreshTagsFiles() {
        VirtualFile tagsDir = LocalFileSystem.getInstance().refreshAndFindFileByPath(this.myRefsTagsPath);
        VirtualFile packedRefsFile = LocalFileSystem.getInstance().refreshAndFindFileByPath(this.myPackedRefsPath);
        VfsUtil.markDirtyAndRefresh((boolean)true, (boolean)true, (boolean)false, (VirtualFile[])new VirtualFile[]{tagsDir, packedRefsFile});
    }

    @NotNull
    Collection<VirtualFile> getRootDirs() {
        HashSet hashSet = ContainerUtil.newHashSet((Object[])new VirtualFile[]{this.myMainDir, this.myWorktreeDir});
        if (hashSet == null) {
            GitRepositoryFiles.$$$reportNull$$$0(19);
        }
        return hashSet;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7, 8, 19 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootDir";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mainDir";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "worktreeDir";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gitDir";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 7: 
            case 8: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/repo/GitRepositoryFiles";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "core";
                break;
            }
            case 10: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 12: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fullBranchName";
                break;
            }
            case 15: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/repo/GitRepositoryFiles";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "slash";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getPathsToWatch";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootDirs";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createInstance";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getMainGitDirForWorktree";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "slash";
                break;
            }
            case 7: 
            case 8: 
            case 19: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "updateCustomPaths";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "hook";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "file";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isOrigHeadFile";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isBranchFile";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isTagFile";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "isCommitMessageFile";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isExclude";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "isStashReflogFile";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7, 8, 19 -> new IllegalStateException(string);
        };
    }
}

