/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger.nashorn;

import com.intellij.debugger.DebuggerGlobalSearchScope;
import com.intellij.debugger.NoDataException;
import com.intellij.debugger.PositionManager;
import com.intellij.debugger.PositionManagerFactory;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebugProcessListener;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.PositionManagerEx;
import com.intellij.debugger.engine.SuspendContext;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.impl.DebuggerUtilsAsync;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.requests.ClassPrepareRequestor;
import com.intellij.execution.CommonProgramRunConfigurationParameters;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.javascript.debugger.JavaScriptDebuggerEvaluator;
import com.intellij.javascript.debugger.nashorn.NashornArray;
import com.intellij.javascript.debugger.nashorn.NashornCallFrame;
import com.intellij.javascript.debugger.nashorn.NashornCallFrameEvaluateContextKt;
import com.intellij.javascript.debugger.nashorn.NashornObject;
import com.intellij.javascript.debugger.nashorn.NashornPositionManagerFactory;
import com.intellij.javascript.debugger.nashorn.jdi.JavaDebuggerViewSupport;
import com.intellij.javascript.debugger.nashorn.jdi.JdiSuspendContext;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.CompilerModuleExtension;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.ThreeState;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.evaluation.XDebuggerEvaluator;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.frame.XValueNode;
import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.BooleanValue;
import com.sun.jdi.Location;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.request.ClassPrepareRequest;
import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.CallFrame;
import org.jetbrains.debugger.DebuggerViewSupport;
import org.jetbrains.debugger.SourceInfo;
import org.jetbrains.debugger.Variable;
import org.jetbrains.debugger.VariableContext;
import org.jetbrains.debugger.VariableView;
import org.jetbrains.debugger.frame.CallFrameView;
import org.jetbrains.debugger.values.ObjectValue;
import org.jetbrains.debugger.values.Value;
import org.jetbrains.debugger.values.ValueType;
import org.jetbrains.io.LocalFileFinder;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00072\u00020\u0001:\u0002\u0007\bB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\t"}, d2={"Lcom/intellij/javascript/debugger/nashorn/NashornPositionManagerFactory;", "Lcom/intellij/debugger/PositionManagerFactory;", "()V", "createPositionManager", "Lcom/intellij/debugger/PositionManager;", "process", "Lcom/intellij/debugger/engine/DebugProcess;", "Companion", "NashornPositionManager", "intellij.javascript.debugger.nashorn"})
public final class NashornPositionManagerFactory
extends PositionManagerFactory {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final Companion.DEBUGGER_VIEW_SUPPORT.1 DEBUGGER_VIEW_SUPPORT;

    @NotNull
    public PositionManager createPositionManager(@NotNull DebugProcess process) {
        Intrinsics.checkNotNullParameter((Object)process, (String)"process");
        return (PositionManager)new NashornPositionManager(process);
    }

    static {
        Logger logger = Logger.getInstance(NashornPositionManagerFactory.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
        DEBUGGER_VIEW_SUPPORT = new JavaDebuggerViewSupport(){

            public void computeObjectPresentation(@NotNull ObjectValue value, @NotNull Variable variable, @NotNull VariableContext context, @NotNull XValueNode node, @NotNull Icon icon) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                Intrinsics.checkNotNullParameter((Object)icon, (String)"icon");
                if (value instanceof NashornObject) {
                    VariableView.Companion.setObjectPresentation(value, icon, node);
                } else {
                    super.computeObjectPresentation(value, variable, context, node, icon);
                }
            }

            public void computeArrayPresentation(@NotNull Value value, @NotNull Variable variable, @NotNull VariableContext context, @NotNull XValueNode node, @NotNull Icon icon) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                Intrinsics.checkNotNullParameter((Object)icon, (String)"icon");
                if (value instanceof NashornArray) {
                    VariableView.Companion.setArrayPresentation(value, context, icon, node);
                } else {
                    super.computeArrayPresentation(value, variable, context, node, icon);
                }
            }

            @NotNull
            public XDebuggerEvaluator createFrameEvaluator(@NotNull CallFrameView frame) {
                Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
                return (XDebuggerEvaluator)new JavaScriptDebuggerEvaluator((VariableContext)frame);
            }
        };
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000+\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000*\u0001\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eR\u0010\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0005R\u0019\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000f"}, d2={"Lcom/intellij/javascript/debugger/nashorn/NashornPositionManagerFactory$Companion;", "", "()V", "DEBUGGER_VIEW_SUPPORT", "com/intellij/javascript/debugger/nashorn/NashornPositionManagerFactory$Companion$DEBUGGER_VIEW_SUPPORT$1", "Lcom/intellij/javascript/debugger/nashorn/NashornPositionManagerFactory$Companion$DEBUGGER_VIEW_SUPPORT$1;", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getLOG$intellij_javascript_debugger_nashorn", "()Lcom/intellij/openapi/diagnostic/Logger;", "isNashornApplicable", "", "position", "Lcom/intellij/debugger/SourcePosition;", "intellij.javascript.debugger.nashorn"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLOG$intellij_javascript_debugger_nashorn() {
            return LOG;
        }

        public final boolean isNashornApplicable(@NotNull SourcePosition position) {
            Intrinsics.checkNotNullParameter((Object)position, (String)"position");
            return position.getFile() instanceof JSFile;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u0002\u0018\u0000 ,2\u00020\u0001:\u0001,B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\"\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0002\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J(\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0016\u0010 \u001a\b\u0012\u0004\u0012\u00020\b0!2\u0006\u0010\"\u001a\u00020\u0011H\u0016J\u0010\u0010#\u001a\u00020\u000b2\u0006\u0010\u0002\u001a\u00020\u0016H\u0002J\u0014\u0010$\u001a\u0004\u0018\u00010\u00112\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0016J\u0012\u0010%\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u001a\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020\u001f2\b\u0010)\u001a\u0004\u0018\u00010\u0007H\u0002J\u001e\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00180!2\u0006\u0010+\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u0005\u001a\u001e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006j\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b`\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lcom/intellij/javascript/debugger/nashorn/NashornPositionManagerFactory$NashornPositionManager;", "Lcom/intellij/debugger/engine/PositionManagerEx;", "debugProcess", "Lcom/intellij/debugger/engine/DebugProcess;", "(Lcom/intellij/debugger/engine/DebugProcess;)V", "mapping", "Ljava/util/HashMap;", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lcom/sun/jdi/ReferenceType;", "Lkotlin/collections/HashMap;", "suspendContext", "Lcom/intellij/javascript/debugger/nashorn/jdi/JdiSuspendContext;", "createPrepareRequest", "Lcom/sun/jdi/request/ClassPrepareRequest;", "requestor", "Lcom/intellij/debugger/requests/ClassPrepareRequestor;", "position", "Lcom/intellij/debugger/SourcePosition;", "createStackFrame", "Lcom/intellij/xdebugger/frame/XStackFrame;", "jdiFrame", "Lcom/intellij/debugger/jdi/StackFrameProxyImpl;", "Lcom/intellij/debugger/engine/DebugProcessImpl;", "location", "Lcom/sun/jdi/Location;", "evaluateCondition", "Lcom/intellij/util/ThreeState;", "context", "Lcom/intellij/debugger/engine/evaluation/EvaluationContext;", "frame", "expression", "", "getAllClasses", "", "classPosition", "getOrCreateSuspendManager", "getSourcePosition", "getVirtualFile", "isInOutput", "", "vmPath", "sourceRootForFile", "locationsOfLine", "type", "Companion", "intellij.javascript.debugger.nashorn"})
    private static final class NashornPositionManager
    extends PositionManagerEx {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final DebugProcess debugProcess;
        @NotNull
        private final HashMap<VirtualFile, ReferenceType> mapping;
        @Nullable
        private JdiSuspendContext suspendContext;
        @NotNull
        private static final String NASHORN_SCRIPT_FQN = "jdk.nashorn.internal.scripts.Script";
        @NotNull
        private static final String NASHORN_SCRIPT_PREFIX = "jdk.nashorn.internal.scripts.Script$";
        @NotNull
        private static final String NASHORN_SCRIPT_NAME_PATTERN = "jdk.nashorn.internal.scripts.Script$*";

        public NashornPositionManager(@NotNull DebugProcess debugProcess) {
            Intrinsics.checkNotNullParameter((Object)debugProcess, (String)"debugProcess");
            this.debugProcess = debugProcess;
            this.mapping = new HashMap();
            this.debugProcess.addDebugProcessListener(new DebugProcessListener(){

                public void processDetached(@NotNull DebugProcess process, boolean closedByUser) {
                    Intrinsics.checkNotNullParameter((Object)process, (String)"process");
                    suspendContext = null;
                }

                public void resumed(@NotNull SuspendContext javaSuspendContext) {
                    Intrinsics.checkNotNullParameter((Object)javaSuspendContext, (String)"javaSuspendContext");
                    suspendContext = null;
                }
            });
        }

        private final VirtualFile getVirtualFile(Location location) {
            Module module;
            String vmPath = null;
            try {
                ReferenceType referenceType = location.declaringType();
                Intrinsics.checkNotNullExpressionValue((Object)referenceType, (String)"declaringType(...)");
                vmPath = NashornPositionManager.Companion.getNormalizedVmPath(referenceType);
            }
            catch (AbsentInformationException ignored) {
                return null;
            }
            if (vmPath == null) {
                return null;
            }
            VirtualFile file = null;
            GlobalSearchScope globalSearchScope = this.debugProcess.getSearchScope();
            Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"getSearchScope(...)");
            GlobalSearchScope searchScope = globalSearchScope;
            if (searchScope instanceof DebuggerGlobalSearchScope && (module = ((DebuggerGlobalSearchScope)searchScope).getModuleIfAny()) != null && (file = NashornPositionManager.Companion.getSourceFileByOutput(vmPath, module, null)) == null) {
                file = (VirtualFile)ReadAction.compute(() -> NashornPositionManager.getVirtualFile$lambda$0(module, vmPath));
            }
            if (file == null) {
                file = this.debugProcess.getProject().getBaseDir().findFileByRelativePath(vmPath);
            }
            if (file == null) {
                String workingDirectory;
                XDebugSession xDebugSession;
                DebugProcess debugProcess = this.debugProcess;
                DebugProcessImpl debugProcessImpl = debugProcess instanceof DebugProcessImpl ? (DebugProcessImpl)debugProcess : null;
                RunProfile runProfile = debugProcessImpl != null && (debugProcess = debugProcessImpl.getXdebugProcess()) != null && (xDebugSession = debugProcess.getSession()) != null ? xDebugSession.getRunProfile() : null;
                CommonProgramRunConfigurationParameters commonProgramRunConfigurationParameters = runProfile instanceof CommonProgramRunConfigurationParameters ? (CommonProgramRunConfigurationParameters)runProfile : null;
                String string = workingDirectory = commonProgramRunConfigurationParameters != null ? commonProgramRunConfigurationParameters.getWorkingDirectory() : null;
                if (workingDirectory != null) {
                    File javaFile = new File(workingDirectory, vmPath);
                    file = VfsUtil.findFileByIoFile((File)javaFile, (boolean)true);
                }
            }
            if (file == null) {
                return LocalFileFinder.findFile((String)vmPath);
            }
            return file;
        }

        @Nullable
        public XStackFrame createStackFrame(@NotNull StackFrameProxyImpl jdiFrame, @NotNull DebugProcessImpl debugProcess, @NotNull Location location) {
            Intrinsics.checkNotNullParameter((Object)jdiFrame, (String)"jdiFrame");
            Intrinsics.checkNotNullParameter((Object)debugProcess, (String)"debugProcess");
            Intrinsics.checkNotNullParameter((Object)location, (String)"location");
            if (!NashornPositionManager.Companion.isNashornScriptLocation(location)) {
                return null;
            }
            VirtualFile file = this.getVirtualFile(location);
            SourceInfo sourceInfo = file == null ? null : new SourceInfo(file, location.lineNumber() - 1, 0, 0, null, null, 60, null);
            if (sourceInfo == null) {
                return null;
            }
            SourceInfo sourceInfo2 = sourceInfo;
            NashornCallFrame frame = new NashornCallFrame(this.getOrCreateSuspendManager(debugProcess).getValueManager(), jdiFrame, sourceInfo2.getLine(), sourceInfo2.getColumn());
            return (XStackFrame)new CallFrameView((CallFrame)frame, (DebuggerViewSupport)DEBUGGER_VIEW_SUPPORT, null, sourceInfo2, null, null, null, 112, null);
        }

        private final JdiSuspendContext getOrCreateSuspendManager(DebugProcessImpl debugProcess) {
            JdiSuspendContext _suspendContext = this.suspendContext;
            if (_suspendContext == null) {
                this.suspendContext = _suspendContext = new JdiSuspendContext(debugProcess);
            }
            return _suspendContext;
        }

        @NotNull
        public ThreeState evaluateCondition(@NotNull EvaluationContext context, @NotNull StackFrameProxyImpl frame, @NotNull Location location, @NotNull String expression) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
            Intrinsics.checkNotNullParameter((Object)location, (String)"location");
            Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
            if (!NashornPositionManager.Companion.isNashornScriptLocation(location)) {
                return ThreeState.UNSURE;
            }
            DebuggerManagerThreadImpl.assertIsManagerThread();
            try {
                com.sun.jdi.Value jdiValue = frame.visibleValueByName(expression);
                if (jdiValue != null) {
                    if (jdiValue instanceof BooleanValue) {
                        return ((BooleanValue)jdiValue).booleanValue() ? ThreeState.YES : ThreeState.NO;
                    }
                    return ThreeState.UNSURE;
                }
                DebugProcess debugProcess = context.getDebugProcess();
                Intrinsics.checkNotNull((Object)debugProcess, (String)"null cannot be cast to non-null type com.intellij.debugger.engine.DebugProcessImpl");
                Value value = NashornCallFrameEvaluateContextKt.doEvaluate(expression, frame, this.getOrCreateSuspendManager((DebugProcessImpl)debugProcess).getValueManager(), context);
                if (value.getType() == ValueType.BOOLEAN) {
                    return Intrinsics.areEqual((Object)"true", (Object)value.getValueString()) ? ThreeState.YES : ThreeState.NO;
                }
                return ThreeState.UNSURE;
            }
            catch (Exception e) {
                Companion.getLOG$intellij_javascript_debugger_nashorn().warn((Throwable)e);
                return ThreeState.UNSURE;
            }
        }

        @Nullable
        public SourcePosition getSourcePosition(@Nullable Location location) throws NoDataException {
            PsiFile psiFile;
            if (location == null || !NashornPositionManager.Companion.isNashornScriptLocation(location)) {
                NoDataException noDataException = NoDataException.INSTANCE;
                Intrinsics.checkNotNullExpressionValue((Object)noDataException, (String)"INSTANCE");
                throw (Throwable)noDataException;
            }
            VirtualFile virtualFile = this.getVirtualFile(location);
            if (virtualFile != null && (psiFile = PsiManager.getInstance((Project)this.debugProcess.getProject()).findFile(virtualFile)) != null) {
                return SourcePosition.createFromLine((PsiFile)psiFile, (int)(location.lineNumber() - 1));
            }
            NoDataException noDataException = NoDataException.INSTANCE;
            Intrinsics.checkNotNullExpressionValue((Object)noDataException, (String)"INSTANCE");
            throw (Throwable)noDataException;
        }

        @NotNull
        public List<ReferenceType> getAllClasses(@NotNull SourcePosition classPosition) throws NoDataException {
            Intrinsics.checkNotNullParameter((Object)classPosition, (String)"classPosition");
            NashornPositionManager.Companion.checkJsFile(classPosition);
            ReferenceType referenceType = this.mapping.get(classPosition.getFile().getVirtualFile());
            if (referenceType == null) {
                NoDataException noDataException = NoDataException.INSTANCE;
                Intrinsics.checkNotNullExpressionValue((Object)noDataException, (String)"INSTANCE");
                throw (Throwable)noDataException;
            }
            ReferenceType type = referenceType;
            return CollectionsKt.listOf((Object)type);
        }

        @NotNull
        public List<Location> locationsOfLine(@NotNull ReferenceType type, @NotNull SourcePosition position) throws NoDataException {
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            Intrinsics.checkNotNullParameter((Object)position, (String)"position");
            NashornPositionManager.Companion.checkJsFile(position);
            try {
                List list = DebuggerUtilsAsync.locationsOfLineSync((ReferenceType)type, (String)"Java", null, (int)(position.getLine() + 1));
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"locationsOfLineSync(...)");
                return list;
            }
            catch (AbsentInformationException absentInformationException) {
                return CollectionsKt.emptyList();
            }
        }

        private final boolean isInOutput(String vmPath, VirtualFile sourceRootForFile) {
            GlobalSearchScope globalSearchScope = this.debugProcess.getSearchScope();
            DebuggerGlobalSearchScope debuggerGlobalSearchScope = globalSearchScope instanceof DebuggerGlobalSearchScope ? (DebuggerGlobalSearchScope)globalSearchScope : null;
            if (debuggerGlobalSearchScope == null) {
                return false;
            }
            DebuggerGlobalSearchScope searchScope = debuggerGlobalSearchScope;
            Module module = searchScope.getModuleIfAny();
            if (module != null) {
                return NashornPositionManager.Companion.getSourceFileByOutput(vmPath, module, sourceRootForFile) != null;
            }
            return false;
        }

        @Nullable
        public ClassPrepareRequest createPrepareRequest(@NotNull ClassPrepareRequestor requestor, @NotNull SourcePosition position) throws NoDataException {
            Intrinsics.checkNotNullParameter((Object)requestor, (String)"requestor");
            Intrinsics.checkNotNullParameter((Object)position, (String)"position");
            NashornPositionManager.Companion.checkJsFile(position);
            return this.debugProcess.getRequestsManager().createClassPrepareRequest((arg_0, arg_1) -> NashornPositionManager.createPrepareRequest$lambda$1(position, this, requestor, arg_0, arg_1), NASHORN_SCRIPT_NAME_PATTERN);
        }

        private static final VirtualFile getVirtualFile$lambda$0(Module $module, String $vmPath) {
            ModuleRootManager moduleRootManager = ModuleRootManager.getInstance((Module)$module);
            VirtualFile[] virtualFileArray = moduleRootManager.getSourceRoots();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"getSourceRoots(...)");
            VirtualFile f = NashornPositionManager.Companion.findFileByRelativePath($vmPath, virtualFileArray);
            if (f == null) {
                VirtualFile[] virtualFileArray2 = moduleRootManager.getContentRoots();
                Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray2, (String)"getContentRoots(...)");
                f = NashornPositionManager.Companion.findFileByRelativePath($vmPath, virtualFileArray2);
            }
            return f;
        }

        private static final void createPrepareRequest$lambda$1(SourcePosition $position, NashornPositionManager this$0, ClassPrepareRequestor $requestor, DebugProcess debuggerProcess, ReferenceType referenceType) {
            Intrinsics.checkNotNullParameter((Object)$position, (String)"$position");
            Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)$requestor, (String)"$requestor");
            String vmPath = null;
            try {
                Intrinsics.checkNotNull((Object)referenceType);
                vmPath = NashornPositionManager.Companion.getNormalizedVmPath(referenceType);
            }
            catch (AbsentInformationException ignored) {
                return;
            }
            if (vmPath != null && !Intrinsics.areEqual((Object)vmPath, (Object)"<eval>") && !StringsKt.startsWith$default((String)vmPath, (String)"nashorn:", (boolean)false, (int)2, null)) {
                VirtualFile positionFile = $position.getFile().getVirtualFile();
                VirtualFile sourceRootForFile = ProjectFileIndex.getInstance((Project)debuggerProcess.getProject()).getSourceRootForFile(positionFile);
                if (!this$0.isInOutput(vmPath, sourceRootForFile)) {
                    boolean subPath;
                    String string = positionFile.getPath();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
                    String path = string;
                    boolean bl = subPath = positionFile.isCaseSensitive() ? StringsKt.endsWith$default((String)path, (String)vmPath, (boolean)false, (int)2, null) : StringUtilRt.endsWithIgnoreCase((CharSequence)path, (CharSequence)vmPath);
                    if (!subPath) {
                        return;
                    }
                }
                this$0.mapping.put(positionFile, referenceType);
                $requestor.processClassPrepare(debuggerProcess, referenceType);
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J,\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00042\b\u0010\u0010\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J%\u0010\u0013\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0014\u001a\u00020\u00042\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\f0\u0016H\u0002\u00a2\u0006\u0002\u0010\u0017J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J$\u0010\u001b\u001a\u0004\u0018\u00010\f2\u0006\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0010\u001a\u0004\u0018\u00010\fH\u0002J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/intellij/javascript/debugger/nashorn/NashornPositionManagerFactory$NashornPositionManager$Companion;", "", "()V", "NASHORN_SCRIPT_FQN", "", "NASHORN_SCRIPT_NAME_PATTERN", "NASHORN_SCRIPT_PREFIX", "checkJsFile", "", "position", "Lcom/intellij/debugger/SourcePosition;", "compute", "Lcom/intellij/openapi/vfs/VirtualFile;", "compilerModuleExtension", "Lcom/intellij/openapi/roots/CompilerModuleExtension;", "vmPath", "sourceRootForFile", "module", "Lcom/intellij/openapi/module/Module;", "findFileByRelativePath", "path", "roots", "", "(Ljava/lang/String;[Lcom/intellij/openapi/vfs/VirtualFile;)Lcom/intellij/openapi/vfs/VirtualFile;", "getNormalizedVmPath", "referenceType", "Lcom/sun/jdi/ReferenceType;", "getSourceFileByOutput", "isNashornScriptLocation", "", "location", "Lcom/sun/jdi/Location;", "intellij.javascript.debugger.nashorn"})
        public static final class Companion {
            private Companion() {
            }

            private final void checkJsFile(SourcePosition position) throws NoDataException {
                if (!NashornPositionManagerFactory.Companion.isNashornApplicable(position)) {
                    NoDataException noDataException = NoDataException.INSTANCE;
                    Intrinsics.checkNotNullExpressionValue((Object)noDataException, (String)"INSTANCE");
                    throw (Throwable)noDataException;
                }
            }

            private final VirtualFile findFileByRelativePath(String path, VirtualFile[] roots) {
                for (VirtualFile root : roots) {
                    VirtualFile file = root.findFileByRelativePath(path);
                    if (file == null) continue;
                    return file;
                }
                return null;
            }

            private final String getNormalizedVmPath(ReferenceType referenceType) throws AbsentInformationException {
                String name;
                String string = name = StringUtil.nullize((String)referenceType.sourceName());
                return string == null ? null : FileUtil.toCanonicalPath((String)FileUtil.toSystemIndependentName((String)string), (char)'/');
            }

            private final boolean isNashornScriptLocation(Location location) {
                String string = location.declaringType().name();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"name(...)");
                return StringsKt.startsWith$default((String)string, (String)NashornPositionManager.NASHORN_SCRIPT_PREFIX, (boolean)false, (int)2, null);
            }

            private final VirtualFile getSourceFileByOutput(String vmPath, Module module, VirtualFile sourceRootForFile) {
                CompilerModuleExtension compilerModuleExtension = CompilerModuleExtension.getInstance((Module)module);
                if (compilerModuleExtension == null) {
                    return null;
                }
                CompilerModuleExtension compilerModuleExtension2 = compilerModuleExtension;
                return (VirtualFile)ReadAction.compute(() -> Companion.getSourceFileByOutput$lambda$0(compilerModuleExtension2, vmPath, sourceRootForFile, module));
            }

            private final VirtualFile compute(CompilerModuleExtension compilerModuleExtension, String vmPath, VirtualFile sourceRootForFile, Module module) {
                VirtualFile[] sourceRoots = null;
                VirtualFile[] virtualFileArray = compilerModuleExtension.getOutputRoots(true);
                Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"getOutputRoots(...)");
                for (VirtualFile outputRoot : virtualFileArray) {
                    String outputRootPath;
                    Intrinsics.checkNotNullExpressionValue((Object)outputRoot.getPath(), (String)"getPath(...)");
                    String relativePath = FileUtilRt.getRelativePath((String)outputRootPath, (String)vmPath, (char)'/');
                    if (relativePath == null) continue;
                    if (sourceRootForFile != null) {
                        VirtualFile file = sourceRootForFile.findFileByRelativePath(relativePath);
                        if (file == null) continue;
                        return file;
                    }
                    if (sourceRoots == null) {
                        sourceRoots = ModuleRootManager.getInstance((Module)module).getSourceRoots();
                    }
                    Iterator iterator = ArrayIteratorKt.iterator(sourceRoots);
                    while (iterator.hasNext()) {
                        VirtualFile sourceRoot = (VirtualFile)iterator.next();
                        VirtualFile file = sourceRoot.findFileByRelativePath(relativePath);
                        if (file == null) continue;
                        return file;
                    }
                }
                return null;
            }

            private static final VirtualFile getSourceFileByOutput$lambda$0(CompilerModuleExtension $compilerModuleExtension, String $vmPath, VirtualFile $sourceRootForFile, Module $module) {
                Intrinsics.checkNotNullParameter((Object)$compilerModuleExtension, (String)"$compilerModuleExtension");
                Intrinsics.checkNotNullParameter((Object)$vmPath, (String)"$vmPath");
                Intrinsics.checkNotNullParameter((Object)$module, (String)"$module");
                return Companion.compute($compilerModuleExtension, $vmPath, $sourceRootForFile, $module);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

