/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cmake.psi;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.TokenType;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.cmake.psi.CMakeArgument;
import com.jetbrains.cmake.psi.CMakeCommand;
import com.jetbrains.cmake.psi.CMakeCommandArgumentsMixin;
import com.jetbrains.cmake.psi.CMakeCommandName;
import com.jetbrains.cmake.psi.CMakeElementBase;
import com.jetbrains.cmake.psi.CMakeElementFactory;
import com.jetbrains.cmake.psi.CMakeEndFunctionCommand;
import com.jetbrains.cmake.psi.CMakeEndMacroCommand;
import com.jetbrains.cmake.psi.CMakeFunctionCommand;
import com.jetbrains.cmake.psi.CMakeMacroCommand;
import com.jetbrains.cmake.psi.CMakeTokenTypes;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CMakeCommandArgumentsImplMixin
extends CMakeElementBase
implements CMakeCommandArgumentsMixin {
    public CMakeCommandArgumentsImplMixin(@NotNull ASTNode node2) {
        if (node2 == null) {
            CMakeCommandArgumentsImplMixin.$$$reportNull$$$0(0);
        }
        super(node2);
    }

    @Override
    public boolean canAppendArguments() {
        return !PsiTreeUtil.hasErrorElements((PsiElement)this);
    }

    @NotNull
    private PsiElement getRParPsi() {
        ASTNode rpar = this.getNode().findChildByType(CMakeTokenTypes.RPAR);
        assert (rpar != null);
        PsiElement psiElement = rpar.getPsi();
        if (psiElement == null) {
            CMakeCommandArgumentsImplMixin.$$$reportNull$$$0(1);
        }
        return psiElement;
    }

    @NotNull
    private PsiElement getLParPsi() {
        ASTNode rpar = this.getNode().findChildByType(CMakeTokenTypes.LPAR);
        assert (rpar != null);
        PsiElement psiElement = rpar.getPsi();
        if (psiElement == null) {
            CMakeCommandArgumentsImplMixin.$$$reportNull$$$0(2);
        }
        return psiElement;
    }

    private void addWhitespaceIfNeeded(@NotNull PsiElement rPar) {
        PsiElement prev;
        if (rPar == null) {
            CMakeCommandArgumentsImplMixin.$$$reportNull$$$0(3);
        }
        if ((prev = rPar.getPrevSibling()).getNode().getElementType() != TokenType.WHITE_SPACE) {
            this.addWhitespace(rPar, CMakeElementFactory.WhitespaceKind.Space);
        }
    }

    private void addWhitespace(@NotNull PsiElement rPar, CMakeElementFactory.WhitespaceKind kind) {
        if (rPar == null) {
            CMakeCommandArgumentsImplMixin.$$$reportNull$$$0(4);
        }
        PsiElement ws = CMakeElementFactory.createWhitespace(this.getProject(), kind);
        this.addBefore(ws, rPar);
    }

    @Override
    public void appendArgument(@NotNull String argumentText, boolean onNewLine) {
        PsiElement ws;
        if (argumentText == null) {
            CMakeCommandArgumentsImplMixin.$$$reportNull$$$0(5);
        }
        assert (this.canAppendArguments());
        CMakeArgument lastArgOrLPar = this.getLastArgument();
        if (lastArgOrLPar == null) {
            lastArgOrLPar = this.getLParPsi();
        }
        Object object = onNewLine ? CMakeElementFactory.createWhitespace(this.getProject(), CMakeElementFactory.WhitespaceKind.NewLine) : (ws = lastArgOrLPar.getNode().getElementType() != CMakeTokenTypes.LPAR && lastArgOrLPar.getNextSibling().getNode().getElementType() != TokenType.WHITE_SPACE ? CMakeElementFactory.createWhitespace(this.getProject(), CMakeElementFactory.WhitespaceKind.Space) : null);
        if (ws != null) {
            this.addAfter(ws, lastArgOrLPar);
        }
        CMakeArgument argument = CMakeElementFactory.createArgument(this.getProject(), argumentText);
        this.addAfter(argument, (PsiElement)(ws != null ? lastArgOrLPar.getNextSibling() : lastArgOrLPar));
    }

    @Override
    public void appendArgumentRaw(@NotNull String rawText) {
        if (rawText == null) {
            CMakeCommandArgumentsImplMixin.$$$reportNull$$$0(6);
        }
        assert (this.canAppendArguments());
        PsiElement rParPsi = this.getRParPsi();
        this.addWhitespaceIfNeeded(rParPsi);
        CMakeArgument argument = CMakeElementFactory.createArgumentRaw(this.getProject(), rawText);
        this.addBefore(argument, rParPsi);
    }

    @Override
    public boolean isFunctionDeclarationParameters() {
        return this.getParent() instanceof CMakeFunctionCommand;
    }

    @Override
    public boolean isEndFunctionParameters() {
        return this.getParent() instanceof CMakeEndFunctionCommand;
    }

    @Override
    public boolean isMacroDeclarationParameters() {
        return this.getParent() instanceof CMakeMacroCommand;
    }

    @Override
    public boolean isEndMacroParameters() {
        return this.getParent() instanceof CMakeEndMacroCommand;
    }

    @Override
    public boolean isEndRoutineParameters() {
        return this.isEndFunctionParameters() || this.isEndMacroParameters();
    }

    @Override
    @Nullable
    public CMakeArgument getFirstArgument() {
        return (CMakeArgument)PsiTreeUtil.findChildOfType((PsiElement)this, CMakeArgument.class);
    }

    @Override
    @Nullable
    public CMakeArgument getLastArgument() {
        CMakeArgument currentArg = this.getFirstArgument();
        if (currentArg == null) {
            return null;
        }
        while (currentArg.getNextArgument() != null) {
            currentArg = currentArg.getNextArgument();
        }
        return currentArg;
    }

    @Override
    public CMakeCommand getCommand() {
        return (CMakeCommand)this.getParent();
    }

    @Override
    @Nullable
    public CMakeCommandName getCommandName() {
        CMakeCommand cMakeCommand = this.getCommand();
        return cMakeCommand.getCMakeCommandName();
    }

    @Override
    public boolean hasArguments() {
        return this.getFirstArgument() != null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cmake/psi/CMakeCommandArgumentsImplMixin";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rPar";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argumentText";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rawText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cmake/psi/CMakeCommandArgumentsImplMixin";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getRParPsi";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getLParPsi";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addWhitespaceIfNeeded";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addWhitespace";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "appendArgument";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "appendArgumentRaw";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2 -> new IllegalStateException(string);
        };
    }
}

