/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cmake.psi;

import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.AbstractElementManipulator;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.NotNullFunction;
import com.jetbrains.cmake.psi.CMakeArgument;
import com.jetbrains.cmake.psi.CMakeElementFactory;
import com.jetbrains.cmake.psi.util.CMakeFilePathPartsRenameHolder;
import com.jetbrains.cmake.psi.util.CMakeLiteralUtils;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CMakeArgumentManipulator
extends AbstractElementManipulator<CMakeArgument> {
    public static final NotNullFunction<String, String> ESCAPER = StringUtil.escaper((boolean)true, (String)"$;\"");
    private static final Pattern LINE_CONTINUATION = Pattern.compile("[\\\\]([\\\\][\\\\])*([\n]|([\r][\n]))");

    @Nullable
    @Contract(value="null->null;!null->!null")
    public static String getCMakeLiteralFromValue(@Nullable String pureTextValue) {
        if (pureTextValue == null) {
            return null;
        }
        if (CMakeLiteralUtils.shouldBeInsideQuotes(pureTextValue = (String)ESCAPER.fun((Object)pureTextValue))) {
            pureTextValue = StringUtil.wrapWithDoubleQuote((String)pureTextValue);
        }
        return pureTextValue;
    }

    @Nullable
    @Contract(value="null->null;!null->!null")
    public static String getValueFromCMakeLiteralNoEval(@Nullable String rawLiteralText) {
        if (rawLiteralText == null) {
            return null;
        }
        return StringUtil.unquoteString((String)StringUtil.unescapeStringCharacters((String)LINE_CONTINUATION.matcher(rawLiteralText).replaceAll("")), (char)'\"');
    }

    public CMakeArgument handleContentChange(@NotNull CMakeArgument argument, @NotNull TextRange range, String newContent) throws IncorrectOperationException {
        Object newFullContent;
        if (argument == null) {
            CMakeArgumentManipulator.$$$reportNull$$$0(0);
        }
        if (range == null) {
            CMakeArgumentManipulator.$$$reportNull$$$0(1);
        }
        CMakeFilePathPartsRenameHolder filePathHolder = new CMakeFilePathPartsRenameHolder().invoke(argument, range, newContent);
        String oldStart = filePathHolder.getOldStart();
        newContent = filePathHolder.getNewContent();
        String oldEnd = filePathHolder.getOldEnd();
        if (argument.isBracketArgument()) {
            newFullContent = oldStart + newContent + oldEnd;
        } else if (argument.isQuotedArgument()) {
            newFullContent = oldStart + (String)ESCAPER.fun((Object)newContent) + oldEnd;
            if (!((String)newFullContent).startsWith("\"")) {
                newFullContent = StringUtil.wrapWithDoubleQuote((String)newFullContent);
            }
        } else {
            newFullContent = oldStart + (String)ESCAPER.fun((Object)newContent) + oldEnd;
            if (!((String)newFullContent).startsWith("\"") && CMakeLiteralUtils.shouldBeInsideQuotes((String)newFullContent)) {
                newFullContent = StringUtil.wrapWithDoubleQuote((String)newFullContent);
            }
        }
        argument.replace(CMakeElementFactory.createArgumentRaw(argument.getProject(), (CharSequence)newFullContent));
        return argument;
    }

    @NotNull
    public TextRange getRangeInElement(@NotNull CMakeArgument element2) {
        if (element2 == null) {
            CMakeArgumentManipulator.$$$reportNull$$$0(2);
        }
        if (element2.isQuotedArgument()) {
            TextRange textRange = element2.getContentsRange().shiftRight(-1).grown(-1);
            if (textRange == null) {
                CMakeArgumentManipulator.$$$reportNull$$$0(3);
            }
            return textRange;
        }
        TextRange textRange = element2.getContentsRange();
        if (textRange == null) {
            CMakeArgumentManipulator.$$$reportNull$$$0(4);
        }
        return textRange;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argument";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cmake/psi/CMakeArgumentManipulator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cmake/psi/CMakeArgumentManipulator";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getRangeInElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "handleContentChange";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getRangeInElement";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4 -> new IllegalStateException(string);
        };
    }
}

