/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cmake.psi;

import com.intellij.lang.ASTNode;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.resolve.reference.ReferenceProvidersRegistry;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cmake.completion.CMakeCompletionUtils;
import com.jetbrains.cmake.editor.CMakeArgumentPresentation;
import com.jetbrains.cmake.interpreter.CMakeInterpreter;
import com.jetbrains.cmake.interpreter.CMakeScope;
import com.jetbrains.cmake.psi.CMakeArgument;
import com.jetbrains.cmake.psi.CMakeArgumentManipulator;
import com.jetbrains.cmake.psi.CMakeCommand;
import com.jetbrains.cmake.psi.CMakeCommandArguments;
import com.jetbrains.cmake.psi.CMakeElementBase;
import com.jetbrains.cmake.psi.CMakeLiteral;
import com.jetbrains.cmake.psi.CMakeRoutine;
import com.jetbrains.cmake.psi.CMakeTokenTypes;
import com.jetbrains.cmake.psi.util.CMakePsiUtils;
import com.jetbrains.cmake.psi.util.CMakeTargetUtils;
import com.jetbrains.cmake.refactoring.CMakeRenameUtils;
import com.jetbrains.cmake.resolve.command.CMakeCommandEndDefinitionPsiReference;
import com.jetbrains.cmake.resolve.target.CMakeTargetPsiReference;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CMakeArgumentImplMixin
extends CMakeElementBase
implements CMakeArgument {
    public CMakeArgumentImplMixin(@NotNull ASTNode node2) {
        if (node2 == null) {
            CMakeArgumentImplMixin.$$$reportNull$$$0(0);
        }
        super(node2);
    }

    @Override
    @NotNull
    public PsiElement getLiteralNotNull() {
        CMakeLiteral literal = this.getCMakeLiteral();
        assert (literal != null);
        CMakeLiteral cMakeLiteral = literal;
        if (cMakeLiteral == null) {
            CMakeArgumentImplMixin.$$$reportNull$$$0(1);
        }
        return cMakeLiteral;
    }

    @Override
    public boolean isBracketArgument() {
        return this.getFirstChild().getNode().getElementType() == CMakeTokenTypes.BRACKET_ARG_START;
    }

    @Override
    public boolean isQuotedArgument() {
        return this.getFirstChild().getNode().getElementType() == CMakeTokenTypes.QUOTE;
    }

    @Override
    public void expandIntoArgumentList(@NotNull List<String> result2, @NotNull CMakeScope scope) {
        if (result2 == null) {
            CMakeArgumentImplMixin.$$$reportNull$$$0(2);
        }
        if (scope == null) {
            CMakeArgumentImplMixin.$$$reportNull$$$0(3);
        }
        String literalText = this.getLiteralNotNull().getText();
        if (this.isBracketArgument()) {
            result2.add(literalText);
        } else {
            boolean isQuoted = this.isQuotedArgument();
            String value = scope.eval(literalText);
            if (value != null) {
                if (isQuoted) {
                    result2.add(value);
                } else {
                    CMakeInterpreter.expandListArgument(value, result2);
                }
            }
        }
    }

    @Override
    @Nullable
    public PsiPolyVariantReference getReference() {
        if (this.isEndCommandDefinitionName(false)) {
            return new CMakeCommandEndDefinitionPsiReference(this);
        }
        if (this.isCMakeTargetReferenceName()) {
            return new CMakeTargetPsiReference(this, new TextRange(0, this.getTextRange().getLength()));
        }
        return null;
    }

    public PsiReference @NotNull [] getReferences() {
        PsiPolyVariantReference reference = this.getReference();
        Object[] contributed = ReferenceProvidersRegistry.getReferencesFromProviders((PsiElement)this);
        if (reference == null) {
            if (contributed == null) {
                CMakeArgumentImplMixin.$$$reportNull$$$0(4);
            }
            return contributed;
        }
        PsiReference[] psiReferenceArray = (PsiReference[])ArrayUtil.prepend((Object)reference, (Object[])contributed);
        if (psiReferenceArray == null) {
            CMakeArgumentImplMixin.$$$reportNull$$$0(5);
        }
        return psiReferenceArray;
    }

    @Nullable
    public Icon getIcon(int flags) {
        Icon icon;
        if (this.isFunctionName() || this.isEndFunctionName()) {
            return CMakeCompletionUtils.getRoutineIcon(true);
        }
        if (this.isMacroName() || this.isEndMacroName()) {
            return CMakeCompletionUtils.getRoutineIcon(false);
        }
        if (this.isCMakeTargetDefinitionName() && (icon = CMakeTargetUtils.getTargetDefinitionIcon(this)) != null) {
            return icon;
        }
        return super.getIcon(flags);
    }

    @NotNull
    public String getName() {
        String string = this.getValue();
        if (string == null) {
            CMakeArgumentImplMixin.$$$reportNull$$$0(6);
        }
        return string;
    }

    public PsiElement setName(@NonNls @NotNull String name2) throws IncorrectOperationException {
        if (name2 == null) {
            CMakeArgumentImplMixin.$$$reportNull$$$0(7);
        }
        CMakeRenameUtils.renameArgument(this.getProject(), name2, this.getNode());
        return this;
    }

    @Override
    @NotNull
    public String getValue() {
        CMakeLiteral literal = this.getCMakeLiteral();
        if (literal == null) {
            return "";
        }
        String string = CMakeArgumentManipulator.getValueFromCMakeLiteralNoEval(literal.getText());
        if (string == null) {
            CMakeArgumentImplMixin.$$$reportNull$$$0(8);
        }
        return string;
    }

    @Override
    @NotNull
    public TextRange getContentsRange() {
        String text;
        PsiElement literal = this.getLiteralNotNull();
        int startOffset = literal.getStartOffsetInParent();
        TextRange range = new TextRange(startOffset, startOffset + literal.getTextLength());
        if (this.isBracketArgument() && (text = literal.getText()).startsWith("\"") && text.endsWith("\"")) {
            TextRange textRange = range.shiftRight(1).grown(-2);
            if (textRange == null) {
                CMakeArgumentImplMixin.$$$reportNull$$$0(9);
            }
            return textRange;
        }
        TextRange textRange = range;
        if (textRange == null) {
            CMakeArgumentImplMixin.$$$reportNull$$$0(10);
        }
        return textRange;
    }

    @Override
    public boolean isFunctionName() {
        CMakeCommandArguments arguments = this.getParentCommandArguments();
        return arguments.isFunctionDeclarationParameters() && arguments.getFirstArgument() == this;
    }

    @Override
    public boolean isEndFunctionName() {
        CMakeCommandArguments arguments = this.getParentCommandArguments();
        return arguments.isEndFunctionParameters() && arguments.getFirstArgument() == this;
    }

    @Override
    public boolean isMacroName() {
        CMakeCommandArguments arguments = this.getParentCommandArguments();
        return arguments.isMacroDeclarationParameters() && arguments.getFirstArgument() == this;
    }

    @Override
    public boolean isEndMacroName() {
        CMakeCommandArguments arguments = this.getParentCommandArguments();
        return arguments.isEndMacroParameters() && arguments.getFirstArgument() == this;
    }

    @Override
    public boolean isCommandDefinitionName() {
        return this.isFunctionName() || this.isMacroName();
    }

    @Override
    public boolean isEndCommandDefinitionName(boolean matchWithCommandDefinitionName) {
        if (this.isEndFunctionName() || this.isEndMacroName()) {
            if (!matchWithCommandDefinitionName) {
                return true;
            }
            CMakeRoutine routine = (CMakeRoutine)this.getParentCommandArguments().getParent().getParent();
            CMakeArgument firstArgument = routine.getFirstArgument();
            if (firstArgument == null) {
                return false;
            }
            return StringUtil.equals((CharSequence)CMakePsiUtils.getLiteralText(firstArgument), (CharSequence)CMakePsiUtils.getLiteralText(this));
        }
        return false;
    }

    @Override
    public boolean isCMakeTargetDefinitionName() {
        return this.checkForPattern(CMakeTargetUtils.TargetDefinitionCommandPatterns);
    }

    @Override
    public boolean isCMakeTargetReferenceName() {
        return this.checkForPattern(CMakeTargetUtils.TargetReferenceCommandPatterns);
    }

    private boolean checkForPattern(Map<String, CMakeTargetUtils.ITargetArgumentPattern[]> patterns) {
        CMakeCommandArguments arguments = this.getParentCommandArguments();
        PsiElement psiElement = arguments.getParent();
        if (psiElement instanceof CMakeCommand) {
            CMakeCommand command = (CMakeCommand)psiElement;
            String name2 = StringUtil.notNullize((String)StringUtil.toLowerCase((String)CMakePsiUtils.findCommandName(command)));
            return ContainerUtil.exists((Object[])patterns.getOrDefault(name2, new CMakeTargetUtils.ITargetArgumentPattern[0]), x -> x.isTargetReference(this));
        }
        return false;
    }

    @Override
    @Nullable
    public CMakeArgument getCommandDefinitionName() {
        CMakeRoutine cMakeCommand;
        CMakeArgument routineNameArgument;
        if (this.isCommandDefinitionName()) {
            return this;
        }
        if (this.isEndCommandDefinitionName(true) && this.getParentCommandArguments().isEndRoutineParameters() && (routineNameArgument = (cMakeCommand = (CMakeRoutine)this.getParentCommandArguments().getParent().getParent()).getFirstArgument()) != null) {
            return routineNameArgument;
        }
        return null;
    }

    @Override
    @Nullable
    public CMakeArgument getNextArgument() {
        return (CMakeArgument)PsiTreeUtil.getNextSiblingOfType((PsiElement)this, CMakeArgument.class);
    }

    @Override
    @Nullable
    public CMakeArgument getPreviousArgument() {
        return (CMakeArgument)PsiTreeUtil.getPrevSiblingOfType((PsiElement)this, CMakeArgument.class);
    }

    @Override
    @NotNull
    public CMakeCommandArguments getParentCommandArguments() {
        CMakeCommandArguments cMakeCommandArguments = (CMakeCommandArguments)PsiTreeUtil.getParentOfType((PsiElement)this, CMakeCommandArguments.class, (boolean)true);
        assert (cMakeCommandArguments != null);
        CMakeCommandArguments cMakeCommandArguments2 = cMakeCommandArguments;
        if (cMakeCommandArguments2 == null) {
            CMakeArgumentImplMixin.$$$reportNull$$$0(11);
        }
        return cMakeCommandArguments2;
    }

    @NotNull
    public ItemPresentation getPresentation() {
        return new CMakeArgumentPresentation(this);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 4, 5, 6, 8, 9, 10, 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cmake/psi/CMakeArgumentImplMixin";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cmake/psi/CMakeArgumentImplMixin";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getLiteralNotNull";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferences";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getValue";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getContentsRange";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getParentCommandArguments";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "expandIntoArgumentList";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 4, 5, 6, 8, 9, 10, 11 -> new IllegalStateException(string);
        };
    }
}

