/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cmake.highlighting;

import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.jetbrains.cmake.colors.CMakeColor;
import com.jetbrains.cmake.completion.contributors.providers.CMakeKnownLiteralsProvider;
import com.jetbrains.cmake.docsInfo.CMakeDocsInfoProvider;
import com.jetbrains.cmake.documentation.CMakeDocumentationUtilKt;
import com.jetbrains.cmake.psi.CMakeArgument;
import com.jetbrains.cmake.psi.CMakeCommand;
import com.jetbrains.cmake.psi.CMakeElement;
import com.jetbrains.cmake.psi.CMakeLiteral;
import com.jetbrains.cmake.psi.CMakeRoutine;
import com.jetbrains.cmake.psi.CMakeTokenTypes;
import com.jetbrains.cmake.psi.CMakeVariableName;
import com.jetbrains.cmake.psi.util.CMakePsiUtils;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \t2\u00020\u0001:\u0001\tB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\n"}, d2={"Lcom/jetbrains/cmake/highlighting/CMakeHighlighterAnnotator;", "Lcom/intellij/lang/annotation/Annotator;", "()V", "annotate", "", "element", "Lcom/intellij/psi/PsiElement;", "holder", "Lcom/intellij/lang/annotation/AnnotationHolder;", "Companion", "intellij.cmake.psi"})
public final class CMakeHighlighterAnnotator
implements Annotator {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public void annotate(@NotNull PsiElement element2, @NotNull AnnotationHolder holder) {
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        if (element2 instanceof LeafElement && (Intrinsics.areEqual((Object)((LeafElement)element2).getElementType(), (Object)CMakeTokenTypes.LITERAL) && Intrinsics.areEqual((Object)PsiTreeUtilKt.getElementType((PsiElement)element2.getParent()), (Object)CMakeTokenTypes.C_MAKE_LITERAL) && Companion.isStringLikeArgument(element2.getParent().getParent()) || Intrinsics.areEqual((Object)((LeafElement)element2).getElementType(), (Object)CMakeTokenTypes.QUOTE) && Companion.isStringLikeArgument(element2.getParent()))) {
            CMakeHighlighterAnnotator.Companion.highlight(holder, CMakeColor.ARGUMENT_STRING.getTextAttributesKey());
            return;
        }
        if ((element2 instanceof CMakeVariableName || element2 instanceof CMakeArgument && !Companion.isStringLikeArgument(element2)) && CMakeKnownLiteralsProvider.isNumeric(((PsiNamedElement)element2).getName())) {
            CMakeHighlighterAnnotator.Companion.highlight(holder, CMakeColor.ARGUMENT_NUMERIC.getTextAttributesKey());
            return;
        }
        if (element2 instanceof CMakeVariableName && CMakeKnownLiteralsProvider.isReserved(((CMakeVariableName)element2).getName())) {
            CMakeHighlighterAnnotator.Companion.highlight(holder, CMakeColor.ARGUMENT_LITERAL_CMAKE.getTextAttributesKey());
            return;
        }
        if (element2 instanceof CMakeArgument && !Companion.isStringLikeArgument(element2) && ((CMakeArgument)element2).getCMakeLiteral() != null) {
            String commandName;
            PsiElement grandParent;
            PsiElement psiElement = ((CMakeArgument)element2).getParent();
            Object object = grandParent = psiElement != null ? psiElement.getParent() : null;
            if ((grandParent instanceof CMakeCommand || grandParent instanceof CMakeRoutine) && (commandName = CMakePsiUtils.findCommandName((CMakeElement)grandParent)) != null) {
                CMakeLiteral cMakeLiteral = ((CMakeArgument)element2).getCMakeLiteral();
                Intrinsics.checkNotNull((Object)cMakeLiteral);
                if (CMakeHighlighterAnnotator.Companion.isKeywordInCommand(commandName, cMakeLiteral)) {
                    CMakeHighlighterAnnotator.Companion.highlight(holder, CMakeColor.ARGUMENT_KEYWORD.getTextAttributesKey());
                    return;
                }
            }
            if (CMakeDocumentationUtilKt.isProperty((CMakeArgument)element2)) {
                CMakeHighlighterAnnotator.Companion.highlight(holder, CMakeKnownLiteralsProvider.highlightAllCMakeDocumented() && CMakeKnownLiteralsProvider.isReserved(((CMakeArgument)element2).getName()) ? CMakeColor.ARGUMENT_PROPERTY_CMAKE.getTextAttributesKey() : CMakeColor.ARGUMENT_PROPERTY_GENERAL.getTextAttributesKey());
                return;
            }
            if (CMakeKnownLiteralsProvider.isReserved(((CMakeArgument)element2).getName())) {
                CMakeHighlighterAnnotator.Companion.highlight(holder, CMakeColor.ARGUMENT_LITERAL_CMAKE.getTextAttributesKey());
                return;
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u000f\u001a\u00020\n2\b\u0010\r\u001a\u0004\u0018\u00010\u0010\u00a8\u0006\u0011"}, d2={"Lcom/jetbrains/cmake/highlighting/CMakeHighlighterAnnotator$Companion;", "", "()V", "highlight", "", "holder", "Lcom/intellij/lang/annotation/AnnotationHolder;", "textAttributesKey", "Lcom/intellij/openapi/editor/colors/TextAttributesKey;", "isKeywordInCommand", "", "commandName", "", "element", "Lcom/jetbrains/cmake/psi/CMakeLiteral;", "isStringLikeArgument", "Lcom/intellij/psi/PsiElement;", "intellij.cmake.psi"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean isStringLikeArgument(@Nullable PsiElement element2) {
            if (element2 instanceof CMakeArgument) {
                return ((CMakeArgument)element2).isQuotedArgument() || ((CMakeArgument)element2).isBracketArgument();
            }
            return false;
        }

        private final boolean isKeywordInCommand(String commandName, CMakeLiteral element2) {
            String normalizedCommandName = StringUtil.toLowerCase((String)commandName);
            Map<String, List<String>> keywordsForBuiltinCommands = CMakeDocsInfoProvider.Companion.getInstance().getKeywordsForBuiltInCommands();
            List<String> list2 = keywordsForBuiltinCommands.get(normalizedCommandName);
            if (list2 == null) {
                return false;
            }
            List<String> keywords = list2;
            return keywords.contains(element2.getText());
        }

        private final void highlight(AnnotationHolder holder, TextAttributesKey textAttributesKey) {
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                String string = textAttributesKey.getExternalName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getExternalName(...)");
                String en = string;
                String string2 = en.substring(StringsKt.lastIndexOf$default((CharSequence)en, (String)".", (int)0, (boolean)false, (int)6, null) + 1);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                holder.newAnnotation(HighlightSeverity.INFORMATION, string2).textAttributes(textAttributesKey).create();
            } else {
                holder.newSilentAnnotation(HighlightSeverity.INFORMATION).textAttributes(textAttributesKey).create();
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

