/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cmake.editor;

import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.jetbrains.cmake.editor.CMakeFoldingBuilderKt;
import com.jetbrains.cmake.psi.CMakeArgument;
import com.jetbrains.cmake.psi.CMakeBlockCommand;
import com.jetbrains.cmake.psi.CMakeCommand;
import com.jetbrains.cmake.psi.CMakeElement;
import com.jetbrains.cmake.psi.CMakeEndIfCommand;
import com.jetbrains.cmake.psi.CMakeForeachCommand;
import com.jetbrains.cmake.psi.CMakeFunctionCommand;
import com.jetbrains.cmake.psi.CMakeIfCommand;
import com.jetbrains.cmake.psi.CMakeMacroCommand;
import com.jetbrains.cmake.psi.CMakeRoutine;
import com.jetbrains.cmake.psi.CMakeWhileCommand;
import com.jetbrains.cmake.psi.util.CMakePsiUtils;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\"\u001a\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u00028BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u001a\u0010\u0005\u001a\u0004\u0018\u00010\u0001*\u00020\u00028BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0004\"\u001a\u0010\u0007\u001a\u0004\u0018\u00010\u0001*\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\"\u0018\u0010\u000b\u001a\u00020\f*\u00020\u00028BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\"\u0018\u0010\u000f\u001a\u00020\f*\u00020\u00108BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0011\u00a8\u0006\u0012"}, d2={"closingCommandNameWithArgs", "", "Lcom/jetbrains/cmake/psi/CMakeElement;", "getClosingCommandNameWithArgs", "(Lcom/jetbrains/cmake/psi/CMakeElement;)Ljava/lang/String;", "commandName", "getCommandName", "foldedArguments", "Lcom/jetbrains/cmake/psi/CMakeCommand;", "getFoldedArguments", "(Lcom/jetbrains/cmake/psi/CMakeCommand;)Ljava/lang/String;", "hasTerminator", "", "getHasTerminator", "(Lcom/jetbrains/cmake/psi/CMakeElement;)Z", "isMultilineComment", "Lcom/intellij/psi/PsiComment;", "(Lcom/intellij/psi/PsiComment;)Z", "intellij.cmake.psi"})
@SourceDebugExtension(value={"SMAP\nCMakeFoldingBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CMakeFoldingBuilder.kt\ncom/jetbrains/cmake/editor/CMakeFoldingBuilderKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,227:1\n1#2:228\n*E\n"})
public final class CMakeFoldingBuilderKt {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isMultilineComment(PsiComment $this$isMultilineComment) {
        String string = $this$isMultilineComment.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        if (!StringsKt.startsWith$default((String)string, (String)"#[[", (boolean)false, (int)2, null)) return false;
        String string2 = $this$isMultilineComment.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
        if (!StringsKt.endsWith$default((String)string2, (String)"]]", (boolean)false, (int)2, null)) return false;
        return true;
    }

    private static final String getCommandName(CMakeElement $this$commandName) {
        PsiElement psiElement = $this$commandName.getFirstChild();
        return psiElement != null ? psiElement.getText() : null;
    }

    private static final String getClosingCommandNameWithArgs(CMakeElement $this$closingCommandNameWithArgs) {
        String string;
        CMakeCommand cMakeCommand;
        boolean bl = CMakeFoldingBuilderKt.getHasTerminator($this$closingCommandNameWithArgs);
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-CMakeFoldingBuilderKt$closingCommandNameWithArgs$22 = false;
            String $i$a$-assert-CMakeFoldingBuilderKt$closingCommandNameWithArgs$22 = "Should not be called on commands that end in a closing paren!";
            throw new AssertionError((Object)$i$a$-assert-CMakeFoldingBuilderKt$closingCommandNameWithArgs$22);
        }
        CMakeElement cMakeElement = $this$closingCommandNameWithArgs;
        if (cMakeElement instanceof CMakeFunctionCommand) {
            cMakeCommand = ((CMakeFunctionCommand)$this$closingCommandNameWithArgs).getCMakeEndFunctionCommand();
        } else if (cMakeElement instanceof CMakeMacroCommand) {
            cMakeCommand = ((CMakeMacroCommand)$this$closingCommandNameWithArgs).getCMakeEndMacroCommand();
        } else if (cMakeElement instanceof CMakeBlockCommand) {
            cMakeCommand = ((CMakeBlockCommand)$this$closingCommandNameWithArgs).getCMakeEndBlockCommand();
        } else if (cMakeElement instanceof CMakeForeachCommand) {
            cMakeCommand = ((CMakeForeachCommand)$this$closingCommandNameWithArgs).getCMakeEndForeachCommand();
        } else if (cMakeElement instanceof CMakeWhileCommand) {
            cMakeCommand = ((CMakeWhileCommand)$this$closingCommandNameWithArgs).getCMakeEndWhileCommand();
        } else if (cMakeElement instanceof CMakeIfCommand) {
            List<CMakeCommand> list2 = ((CMakeIfCommand)$this$closingCommandNameWithArgs).getCMakeCommandList();
            Intrinsics.checkNotNullExpressionValue(list2, (String)"getCMakeCommandList(...)");
            Object object = CollectionsKt.lastOrNull(list2);
            cMakeCommand = object instanceof CMakeEndIfCommand ? (CMakeEndIfCommand)object : null;
        } else {
            cMakeCommand = null;
        }
        if (cMakeCommand == null) {
            return null;
        }
        CMakeCommand endCommand = cMakeCommand;
        PsiElement psiElement = endCommand.getFirstChild();
        String string2 = psiElement != null ? psiElement.getText() : null;
        if (string2 == null) {
            return null;
        }
        String endCommandText = string2;
        List<CMakeArgument> list3 = endCommand.getCMakeArgumentList();
        if ((list3 != null && (list3 = (CMakeArgument)CollectionsKt.firstOrNull(list3)) != null ? list3.getText() : (string = null)) == null) {
            string = "";
        }
        String endCommandArgs = string;
        return endCommandText + "(" + endCommandArgs + ")";
    }

    private static final boolean getHasTerminator(CMakeElement $this$hasTerminator) {
        CMakeElement cMakeElement = $this$hasTerminator;
        return ((cMakeElement instanceof CMakeRoutine ? true : cMakeElement instanceof CMakeWhileCommand) ? true : cMakeElement instanceof CMakeIfCommand) ? true : cMakeElement instanceof CMakeForeachCommand;
    }

    private static final String getFoldedArguments(CMakeCommand $this$foldedArguments) {
        String string;
        if (CMakeFoldingBuilderKt.getHasTerminator($this$foldedArguments)) {
            List<CMakeArgument> list2 = $this$foldedArguments.getCMakeArgumentList();
            string = list2 != null ? CollectionsKt.joinToString$default((Iterable)list2, (CharSequence)" ", null, null, (int)0, null, (Function1)foldedArguments.1.INSTANCE, (int)30, null) : null;
        } else {
            Object object;
            List list3;
            string = CMakePsiUtils.isListCommand($this$foldedArguments) ? ((list3 = $this$foldedArguments.getCMakeArgumentList()) != null && (list3 = CollectionsKt.take((Iterable)list3, (int)2)) != null ? CollectionsKt.joinToString$default((Iterable)list3, (CharSequence)" ", null, null, (int)0, null, (Function1)foldedArguments.2.INSTANCE, (int)30, null) : null) : (CMakePsiUtils.isSetCommand($this$foldedArguments) ? ((object = $this$foldedArguments.getCMakeArgumentList()) != null && (object = (CMakeArgument)CollectionsKt.firstOrNull(object)) != null ? object.getText() : null) : null);
        }
        return string;
    }

    public static final /* synthetic */ boolean access$isMultilineComment(PsiComment $receiver) {
        return CMakeFoldingBuilderKt.isMultilineComment($receiver);
    }

    public static final /* synthetic */ boolean access$getHasTerminator(CMakeElement $receiver) {
        return CMakeFoldingBuilderKt.getHasTerminator($receiver);
    }

    public static final /* synthetic */ String access$getFoldedArguments(CMakeCommand $receiver) {
        return CMakeFoldingBuilderKt.getFoldedArguments($receiver);
    }

    public static final /* synthetic */ String access$getCommandName(CMakeElement $receiver) {
        return CMakeFoldingBuilderKt.getCommandName($receiver);
    }

    public static final /* synthetic */ String access$getClosingCommandNameWithArgs(CMakeElement $receiver) {
        return CMakeFoldingBuilderKt.getClosingCommandNameWithArgs($receiver);
    }
}

