/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cmake.documentation;

import com.intellij.openapi.editor.HighlighterColors;
import com.intellij.openapi.editor.colors.ColorKey;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.psi.tree.IElementType;
import com.intellij.ui.ColorUtil;
import com.intellij.util.ui.JBUI;
import com.jetbrains.cmake.CMakePsiLog;
import com.jetbrains.cmake.completion.contributors.providers.CMakeStandardCommands;
import com.jetbrains.cmake.documentation.CMakeDocumentationUtilKt;
import com.jetbrains.cmake.documentation.PropertyKind;
import com.jetbrains.cmake.documentation.PygmentsTokenAttribute;
import com.jetbrains.cmake.psi.CMakeArgument;
import com.jetbrains.cmake.psi.CMakeCommand;
import com.jetbrains.cmake.psi.CMakeSyntaxHighlighter;
import com.jetbrains.cmake.psi.util.CMakePsiUtils;
import java.awt.Color;
import java.io.IOException;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.Path;
import java.util.List;
import java.util.Locale;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000^\n\u0000\n\u0002\u0010\u000e\n\u0002\b\r\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0018\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002\u001a\u0018\u0010\u001f\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010 \u001a\u00020!H\u0002\u001a\u0010\u0010\"\u001a\u00020\u00012\u0006\u0010\u001b\u001a\u00020\u001cH\u0000\u001a\u001a\u0010#\u001a\u0004\u0018\u00010$2\u0006\u0010%\u001a\u00020\u00172\u0006\u0010&\u001a\u00020'H\u0002\u001a\u0012\u0010(\u001a\u0004\u0018\u00010$2\u0006\u0010%\u001a\u00020\u0017H\u0002\u001a\u001a\u0010\u0015\u001a\u0004\u0018\u00010$2\u0006\u0010%\u001a\u00020\u00172\u0006\u0010&\u001a\u00020'H\u0002\u001a\u001a\u0010)\u001a\u0004\u0018\u00010$2\u0006\u0010%\u001a\u00020\u00172\u0006\u0010&\u001a\u00020'H\u0002\u001a\u001a\u0010*\u001a\u0004\u0018\u00010$2\u0006\u0010%\u001a\u00020\u00172\u0006\u0010&\u001a\u00020'H\u0002\u001a\u001a\u0010+\u001a\u0004\u0018\u00010$2\u0006\u0010%\u001a\u00020\u00172\u0006\u0010&\u001a\u00020'H\u0002\u001a\b\u0010,\u001a\u00020\u0001H\u0000\u001a\u0012\u0010-\u001a\u0004\u0018\u00010\u00012\u0006\u0010.\u001a\u00020/H\u0000\u001a\u0018\u00100\u001a\u00020\u00102\u0006\u00101\u001a\u00020\u00012\u0006\u0010\u001d\u001a\u00020\u001eH\u0002\u001a\u0018\u00100\u001a\u00020\u00102\u0006\u00101\u001a\u00020\u00012\u0006\u0010 \u001a\u00020!H\u0002\u001a\u0018\u00100\u001a\u00020\u00102\u0006\u00102\u001a\u00020\u00012\u0006\u00103\u001a\u000204H\u0002\u001a\u000e\u00105\u001a\u0004\u0018\u00010\u0017*\u00020\u0017H\u0000\u001a\f\u00106\u001a\u0004\u0018\u00010$*\u00020\u0017\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0007\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\b\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\t\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\n\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000b\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\f\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\r\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"!\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0013\u0010\u0014\u001a\u0004\b\u0011\u0010\u0012\"\u0015\u0010\u0015\u001a\u00020\u0016*\u00020\u00178F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0018\u00a8\u00067"}, d2={"CMAKE_CACHE_PROPERTY_ARG", "", "CMAKE_DEFINITION_ARG", "CMAKE_DIRECTORY_PROPERTY_ARG", "CMAKE_FIND_PACKAGE_FILE_PREFIX", "CMAKE_GLOBAL_PROPERTY_ARG", "CMAKE_INSTALL_PROPERTY_ARG", "CMAKE_POLICY_ARGUMENT_GET", "CMAKE_POLICY_ARGUMENT_SET", "CMAKE_PROPERTIES_ARG", "CMAKE_PROPERTY_ARG", "CMAKE_SOURCE_PROPERTY_ARG", "CMAKE_TARGET_PROPERTY_ARG", "CMAKE_TEST_PROPERTY_ARG", "pygmentTokens", "", "Lcom/jetbrains/cmake/documentation/PygmentsTokenAttribute;", "getPygmentTokens", "()Ljava/util/List;", "pygmentTokens$delegate", "Lkotlin/Lazy;", "isProperty", "", "Lcom/jetbrains/cmake/psi/CMakeArgument;", "(Lcom/jetbrains/cmake/psi/CMakeArgument;)Z", "convertColorKey", "", "colorScheme", "Lcom/intellij/openapi/editor/colors/EditorColorsScheme;", "colorKey", "Lcom/intellij/openapi/editor/colors/ColorKey;", "convertTextAttributeKey", "textAttributeKey", "Lcom/intellij/openapi/editor/colors/TextAttributesKey;", "convertToPygments", "isDirectoryProperty", "Lcom/jetbrains/cmake/documentation/PropertyKind;", "argument", "command", "Lcom/jetbrains/cmake/psi/CMakeCommand;", "isGlobalProperty", "isSourceFileProperty", "isTargetProperty", "isTestProperty", "linkCss", "readFile", "path", "Ljava/nio/file/Path;", "token", "tokenName", "pygmentsToken", "cmakeToken", "Lcom/intellij/psi/tree/IElementType;", "findPreviousPropertiesArgument", "getPropertyKind", "intellij.cmake.psi"})
public final class CMakeDocumentationUtilKt {
    @NotNull
    public static final String CMAKE_POLICY_ARGUMENT_GET = "GET";
    @NotNull
    public static final String CMAKE_POLICY_ARGUMENT_SET = "SET";
    @NotNull
    public static final String CMAKE_GLOBAL_PROPERTY_ARG = "GLOBAL";
    @NotNull
    public static final String CMAKE_DIRECTORY_PROPERTY_ARG = "DIRECTORY";
    @NotNull
    public static final String CMAKE_TARGET_PROPERTY_ARG = "TARGET";
    @NotNull
    public static final String CMAKE_SOURCE_PROPERTY_ARG = "SOURCE";
    @NotNull
    public static final String CMAKE_INSTALL_PROPERTY_ARG = "INSTALL";
    @NotNull
    public static final String CMAKE_TEST_PROPERTY_ARG = "TEST";
    @NotNull
    public static final String CMAKE_CACHE_PROPERTY_ARG = "CACHE";
    @NotNull
    public static final String CMAKE_PROPERTY_ARG = "PROPERTY";
    @NotNull
    public static final String CMAKE_PROPERTIES_ARG = "PROPERTIES";
    @NotNull
    public static final String CMAKE_DEFINITION_ARG = "DEFINITION";
    @NotNull
    public static final String CMAKE_FIND_PACKAGE_FILE_PREFIX = "Find";
    @NotNull
    private static final Lazy pygmentTokens$delegate = LazyKt.lazy((Function0)pygmentTokens.2.INSTANCE);

    @Nullable
    public static final CMakeArgument findPreviousPropertiesArgument(@NotNull CMakeArgument $this$findPreviousPropertiesArgument) {
        Intrinsics.checkNotNullParameter((Object)$this$findPreviousPropertiesArgument, (String)"<this>");
        for (CMakeArgument propertiesArgument = $this$findPreviousPropertiesArgument.getPreviousArgument(); propertiesArgument != null; propertiesArgument = propertiesArgument.getPreviousArgument()) {
            if (StringsKt.equals((String)propertiesArgument.getText(), (String)CMAKE_PROPERTIES_ARG, (boolean)true)) {
                return propertiesArgument;
            }
            CMakeArgument cMakeArgument = propertiesArgument.getPreviousArgument();
            if (cMakeArgument == null) {
                return null;
            }
            propertiesArgument = cMakeArgument;
        }
        return null;
    }

    @Nullable
    public static final String readFile(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        try {
            return PathsKt.readText$default((Path)path, null, (int)1, null);
        }
        catch (FileSystemNotFoundException e) {
            CMakePsiLog.INSTANCE.getLOG().debug((Throwable)e);
            return null;
        }
        catch (SecurityException e) {
            CMakePsiLog.INSTANCE.getLOG().debug((Throwable)e);
            return null;
        }
        catch (IOException e) {
            CMakePsiLog.INSTANCE.getLOG().debug((Throwable)e);
            return null;
        }
    }

    @NotNull
    public static final String linkCss() {
        String string = ColorUtil.toHtmlColor((Color)JBUI.CurrentTheme.Link.Foreground.ENABLED);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toHtmlColor(...)");
        String linkColor = string;
        return "a { color: " + linkColor + "}";
    }

    @NotNull
    public static final String convertToPygments(@NotNull EditorColorsScheme colorScheme) {
        Intrinsics.checkNotNullParameter((Object)colorScheme, (String)"colorScheme");
        StringBuilder css = new StringBuilder();
        String string = ColorUtil.toHtmlColor((Color)colorScheme.getDefaultBackground());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toHtmlColor(...)");
        String defaultBackground = string;
        css.append(".highlight  { background: " + defaultBackground + "; }\n");
        for (PygmentsTokenAttribute token : CMakeDocumentationUtilKt.getPygmentTokens()) {
            CharSequence charSequence;
            ColorKey colorKey = token.getColorKey();
            TextAttributesKey textAttributesKey = token.getTextAttributeKey();
            if (colorKey != null) {
                charSequence = CMakeDocumentationUtilKt.convertColorKey(colorScheme, colorKey);
            } else {
                if (textAttributesKey == null) continue;
                charSequence = CMakeDocumentationUtilKt.convertTextAttributeKey(colorScheme, textAttributesKey);
            }
            CharSequence cssAttributes = charSequence;
            css.append(".highlight ." + token.getTokenName() + " { " + cssAttributes + " }\n");
        }
        String string2 = css.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        return string2;
    }

    private static final CharSequence convertColorKey(EditorColorsScheme colorScheme, ColorKey colorKey) {
        Color color = colorScheme.getColor(colorKey);
        if (color == null) {
            color = colorScheme.getDefaultForeground();
        }
        Color color2 = color;
        Intrinsics.checkNotNull((Object)color2);
        Color color3 = color2;
        String string = ColorUtil.toHtmlColor((Color)color3);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toHtmlColor(...)");
        return string;
    }

    private static final CharSequence convertTextAttributeKey(EditorColorsScheme colorScheme, TextAttributesKey textAttributeKey) {
        int fontType;
        Color backgroundColor;
        StringBuilder css = new StringBuilder();
        TextAttributes textAttributes = colorScheme.getAttributes(textAttributeKey);
        if (textAttributes == null) {
            return css;
        }
        TextAttributes textAttributes2 = textAttributes;
        Color foregroundColor = textAttributes2.getForegroundColor();
        if (foregroundColor != null) {
            css.append("color: " + ColorUtil.toHtmlColor((Color)foregroundColor) + "; ");
        }
        if ((backgroundColor = textAttributes2.getBackgroundColor()) != null) {
            css.append("background-color: " + ColorUtil.toHtmlColor((Color)backgroundColor) + "; ");
        }
        if ((fontType = textAttributes2.getFontType()) == 2) {
            css.append("font-style: italic; ");
        }
        if (fontType == 1) {
            css.append("font-weight: bold");
        }
        return css;
    }

    private static final PygmentsTokenAttribute token(String tokenName, TextAttributesKey textAttributeKey) {
        return new PygmentsTokenAttribute(tokenName, null, textAttributeKey);
    }

    private static final PygmentsTokenAttribute token(String tokenName, ColorKey colorKey) {
        return new PygmentsTokenAttribute(tokenName, colorKey, null);
    }

    private static final PygmentsTokenAttribute token(String pygmentsToken, IElementType cmakeToken) {
        TextAttributesKey textAttributesKey = CMakeSyntaxHighlighter.Companion.computeAttribute(cmakeToken);
        if (textAttributesKey == null) {
            textAttributesKey = HighlighterColors.TEXT;
        }
        TextAttributesKey attributesKey = textAttributesKey;
        Intrinsics.checkNotNull((Object)attributesKey);
        return CMakeDocumentationUtilKt.token(pygmentsToken, attributesKey);
    }

    private static final List<PygmentsTokenAttribute> getPygmentTokens() {
        Lazy lazy = pygmentTokens$delegate;
        return (List)lazy.getValue();
    }

    public static final boolean isProperty(@NotNull CMakeArgument $this$isProperty) {
        Intrinsics.checkNotNullParameter((Object)$this$isProperty, (String)"<this>");
        return CMakeDocumentationUtilKt.getPropertyKind($this$isProperty) != null;
    }

    @Nullable
    public static final PropertyKind getPropertyKind(@NotNull CMakeArgument $this$getPropertyKind) {
        PropertyKind propertyKind;
        CMakeCommand command;
        Intrinsics.checkNotNullParameter((Object)$this$getPropertyKind, (String)"<this>");
        CMakeArgument argument = $this$getPropertyKind;
        CMakeCommand cMakeCommand = CMakePsiUtils.getCommand($this$getPropertyKind);
        if (cMakeCommand == null) {
            return null;
        }
        CMakeCommand $this$getPropertyKind_u24lambda_u240 = command = cMakeCommand;
        boolean bl = false;
        if (CMakePsiUtils.isCommand($this$getPropertyKind_u24lambda_u240, CMakeStandardCommands.SET_PROPERTY_COMMAND_NAME) || CMakePsiUtils.isCommand($this$getPropertyKind_u24lambda_u240, CMakeStandardCommands.GET_PROPERTY) || CMakePsiUtils.isCommand($this$getPropertyKind_u24lambda_u240, CMakeStandardCommands.DEFINE_PROPERTY)) {
            propertyKind = CMakeDocumentationUtilKt.isProperty(argument, command);
        } else if (CMakePsiUtils.isCommand($this$getPropertyKind_u24lambda_u240, CMakeStandardCommands.GET_CMAKE_PROPERTY)) {
            propertyKind = CMakeDocumentationUtilKt.isGlobalProperty(argument);
        } else if (CMakePsiUtils.isCommand($this$getPropertyKind_u24lambda_u240, CMakeStandardCommands.SET_DIRECTORY_PROPERTIES) || CMakePsiUtils.isCommand($this$getPropertyKind_u24lambda_u240, CMakeStandardCommands.GET_DIRECTORY_PROPERTY)) {
            propertyKind = CMakeDocumentationUtilKt.isDirectoryProperty(argument, command);
        } else if (CMakePsiUtils.isCommand($this$getPropertyKind_u24lambda_u240, CMakeStandardCommands.SET_TARGET_PROPERTIES) || CMakePsiUtils.isCommand($this$getPropertyKind_u24lambda_u240, CMakeStandardCommands.GET_TARGET_PROPERTY)) {
            propertyKind = CMakeDocumentationUtilKt.isTargetProperty(argument, command);
        } else if (CMakePsiUtils.isCommand($this$getPropertyKind_u24lambda_u240, CMakeStandardCommands.SET_SOURCE_FILES_PROPERTIES_COMMAND_NAME) || CMakePsiUtils.isCommand($this$getPropertyKind_u24lambda_u240, CMakeStandardCommands.GET_SOURCE_FILE_PROPERTY)) {
            propertyKind = CMakeDocumentationUtilKt.isSourceFileProperty(argument, command);
        } else if (CMakePsiUtils.isCommand($this$getPropertyKind_u24lambda_u240, CMakeStandardCommands.SET_TESTS_PROPERTIES) || CMakePsiUtils.isCommand($this$getPropertyKind_u24lambda_u240, CMakeStandardCommands.GET_TEST_PROPERTY)) {
            propertyKind = CMakeDocumentationUtilKt.isTestProperty(argument, command);
        } else {
            return null;
        }
        return propertyKind;
    }

    private static final PropertyKind isProperty(CMakeArgument argument, CMakeCommand command) {
        CMakeCommand $this$isProperty_u24lambda_u241 = command;
        boolean bl = false;
        CMakeArgument kindArgument = CMakePsiUtils.isCommand($this$isProperty_u24lambda_u241, CMakeStandardCommands.SET_PROPERTY_COMMAND_NAME) ? command.getFirstArgument() : (CMakePsiUtils.isCommand($this$isProperty_u24lambda_u241, CMakeStandardCommands.GET_PROPERTY) || CMakePsiUtils.isCommand($this$isProperty_u24lambda_u241, CMakeStandardCommands.DEFINE_PROPERTY) ? CMakePsiUtils.secondArgument(command) : null);
        if (kindArgument == null) {
            return null;
        }
        String string = kindArgument.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        String string2 = string.toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toUpperCase(...)");
        PropertyKind kind = switch (string2) {
            case CMAKE_GLOBAL_PROPERTY_ARG -> PropertyKind.GLOBAL_PROPERTY;
            case CMAKE_DIRECTORY_PROPERTY_ARG -> PropertyKind.DIRECTORY_PROPERTY;
            case CMAKE_TARGET_PROPERTY_ARG -> PropertyKind.TARGET_PROPERTY;
            case CMAKE_SOURCE_PROPERTY_ARG -> PropertyKind.SOURCE_PROPERTY;
            case CMAKE_INSTALL_PROPERTY_ARG -> PropertyKind.INSTALL_PROPERTY;
            case CMAKE_TEST_PROPERTY_ARG -> PropertyKind.TEST_PROPERTY;
            case CMAKE_CACHE_PROPERTY_ARG -> PropertyKind.CACHE_PROPERTY;
            default -> null;
        };
        CMakeArgument prevArgument = argument.getPreviousArgument();
        if (prevArgument == null || !StringsKt.equals((String)prevArgument.getText(), (String)CMAKE_PROPERTY_ARG, (boolean)true)) {
            return null;
        }
        return kind;
    }

    private static final PropertyKind isGlobalProperty(CMakeArgument argument) {
        if (CMakePsiUtils.isNotLastArgument(argument)) {
            return null;
        }
        return PropertyKind.GLOBAL_PROPERTY;
    }

    private static final PropertyKind isDirectoryProperty(CMakeArgument argument, CMakeCommand command) {
        block6: {
            block8: {
                block7: {
                    block5: {
                        if (!CMakePsiUtils.isCommand(command, CMakeStandardCommands.SET_DIRECTORY_PROPERTIES)) break block5;
                        if (CMakeDocumentationUtilKt.findPreviousPropertiesArgument(argument) != null) {
                            return PropertyKind.DIRECTORY_PROPERTY;
                        }
                        break block6;
                    }
                    if (!CMakePsiUtils.isCommand(command, CMakeStandardCommands.GET_DIRECTORY_PROPERTY)) break block6;
                    if (CMakePsiUtils.isNotLastArgument(argument)) break block7;
                    CMakeArgument cMakeArgument = argument.getPreviousArgument();
                    if (!Intrinsics.areEqual((Object)(cMakeArgument != null ? cMakeArgument.getText() : null), (Object)CMAKE_DEFINITION_ARG) || argument.getParentCommandArguments().getCMakeArgumentList().size() != 5) break block8;
                }
                return null;
            }
            return PropertyKind.DIRECTORY_PROPERTY;
        }
        return null;
    }

    private static final PropertyKind isTargetProperty(CMakeArgument argument, CMakeCommand command) {
        if (CMakePsiUtils.isCommand(command, CMakeStandardCommands.SET_TARGET_PROPERTIES)) {
            if (CMakeDocumentationUtilKt.findPreviousPropertiesArgument(argument) != null) {
                return PropertyKind.TARGET_PROPERTY;
            }
        } else if (CMakePsiUtils.isCommand(command, CMakeStandardCommands.GET_TARGET_PROPERTY)) {
            if (CMakePsiUtils.isNotLastArgument(argument)) {
                return null;
            }
            return PropertyKind.TARGET_PROPERTY;
        }
        return null;
    }

    private static final PropertyKind isSourceFileProperty(CMakeArgument argument, CMakeCommand command) {
        if (CMakePsiUtils.isCommand(command, CMakeStandardCommands.SET_SOURCE_FILES_PROPERTIES_COMMAND_NAME)) {
            if (CMakeDocumentationUtilKt.findPreviousPropertiesArgument(argument) != null) {
                return PropertyKind.SOURCE_PROPERTY;
            }
        } else if (CMakePsiUtils.isCommand(command, CMakeStandardCommands.GET_SOURCE_FILE_PROPERTY)) {
            if (CMakePsiUtils.isNotLastArgument(argument)) {
                return null;
            }
            return PropertyKind.SOURCE_PROPERTY;
        }
        return null;
    }

    private static final PropertyKind isTestProperty(CMakeArgument argument, CMakeCommand command) {
        if (CMakePsiUtils.isCommand(command, CMakeStandardCommands.SET_TESTS_PROPERTIES)) {
            if (CMakeDocumentationUtilKt.findPreviousPropertiesArgument(argument) != null) {
                return PropertyKind.TEST_PROPERTY;
            }
        } else if (CMakePsiUtils.isCommand(command, CMakeStandardCommands.GET_TEST_PROPERTY)) {
            if (!CMakePsiUtils.isSecondArgument(argument)) {
                return null;
            }
            return PropertyKind.TEST_PROPERTY;
        }
        return null;
    }

    public static final /* synthetic */ PygmentsTokenAttribute access$token(String tokenName, ColorKey colorKey) {
        return CMakeDocumentationUtilKt.token(tokenName, colorKey);
    }

    public static final /* synthetic */ PygmentsTokenAttribute access$token(String tokenName, TextAttributesKey textAttributeKey) {
        return CMakeDocumentationUtilKt.token(tokenName, textAttributeKey);
    }

    public static final /* synthetic */ PygmentsTokenAttribute access$token(String pygmentsToken, IElementType cmakeToken) {
        return CMakeDocumentationUtilKt.token(pygmentsToken, cmakeToken);
    }
}

