/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cmake.completion;

import com.intellij.application.options.CodeStyle;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.util.ParenthesesInsertHandler;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cmake.completion.contributors.providers.CMakeStandardCommands;
import com.jetbrains.cmake.psi.CMakeArgument;
import com.jetbrains.cmake.psi.util.CMakePsiUtils;
import com.jetbrains.cmake.settings.CMakeCodeStyleSettings;
import com.jetbrains.cmake.settings.Case;
import com.jetbrains.cmake.symbols.CMakeCommandCompletionSymbol;
import icons.CMakeIcons;
import java.util.List;
import java.util.Locale;
import javax.swing.Icon;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CMakeCompletionUtils {
    @Nullable
    public static PsiElement getNearestParentOfType(@Nullable PsiElement element2, @NotNull List<Class> aClasses) {
        if (aClasses == null) {
            CMakeCompletionUtils.$$$reportNull$$$0(0);
        }
        if (element2 == null) {
            return null;
        }
        if (element2 instanceof PsiFile) {
            return null;
        }
        for (element2 = element2.getParent(); element2 != null; element2 = element2.getParent()) {
            @Nullable PsiElement finalElement = element2;
            if (aClasses.stream().anyMatch(a -> a.isInstance(finalElement))) {
                return element2;
            }
            if (!(element2 instanceof PsiFile)) continue;
            return null;
        }
        return null;
    }

    @NotNull
    public static LookupElementBuilder createArgumentItem(@NotNull String argumentText) {
        if (argumentText == null) {
            CMakeCompletionUtils.$$$reportNull$$$0(1);
        }
        LookupElementBuilder lookupElementBuilder = LookupElementBuilder.create((String)argumentText).withBoldness(true);
        if (lookupElementBuilder == null) {
            CMakeCompletionUtils.$$$reportNull$$$0(2);
        }
        return lookupElementBuilder;
    }

    public static LookupElement createArgumentItem(@NotNull String argumentText, @NotNull String filename, @Nullable Icon icon) {
        if (argumentText == null) {
            CMakeCompletionUtils.$$$reportNull$$$0(3);
        }
        if (filename == null) {
            CMakeCompletionUtils.$$$reportNull$$$0(4);
        }
        LookupElementBuilder lookupElementBuilder = CMakeCompletionUtils.createArgumentItem(argumentText).withIcon(icon);
        return lookupElementBuilder.appendTailText(CMakeCompletionUtils.getStandardCMakeCompletionTailText(filename), true);
    }

    @NotNull
    public static LookupElementBuilder createStandardCommandItem(@NotNull String command, boolean boldCompletion, boolean putCaretInsideParentheses, @NotNull List<CMakeArgument> argumentList, @Nullable CommonCodeStyleSettings codeStyleSettings) {
        if (command == null) {
            CMakeCompletionUtils.$$$reportNull$$$0(5);
        }
        if (argumentList == null) {
            CMakeCompletionUtils.$$$reportNull$$$0(6);
        }
        return CMakeCompletionUtils.createStandardCommandItem(command, boldCompletion, true, putCaretInsideParentheses, argumentList, null, false, codeStyleSettings);
    }

    @NotNull
    private static LookupElementBuilder createStandardCommandItem(@NotNull String command, boolean boldCompletion, boolean addParentheses, boolean putCaretInsideParentheses, @NotNull List<CMakeArgument> argumentList, @Nullable String fileName, boolean isFunctionName, @Nullable CommonCodeStyleSettings codeStyleSettings) {
        LookupElementBuilder lookupElementBuilder;
        if (command == null) {
            CMakeCompletionUtils.$$$reportNull$$$0(7);
        }
        if (argumentList == null) {
            CMakeCompletionUtils.$$$reportNull$$$0(8);
        }
        if (addParentheses || putCaretInsideParentheses) {
            List arguments = ContainerUtil.map(argumentList, it -> it.getLiteralNotNull().getText());
            StringBuilder argumentsBuilder = new StringBuilder();
            argumentsBuilder.append('(');
            for (String argument : arguments) {
                argumentsBuilder.append(argument).append(' ');
            }
            if (!argumentList.isEmpty()) {
                argumentsBuilder.deleteCharAt(argumentsBuilder.length() - 1);
            }
            argumentsBuilder.append(')');
            CMakeCommandCompletionSymbol symbol = new CMakeCommandCompletionSymbol(command, arguments, fileName != null ? fileName : "", isFunctionName, addParentheses);
            lookupElementBuilder = LookupElementBuilder.create(symbol.createPointer(), (String)command).withTailText(argumentsBuilder.toString());
        } else {
            lookupElementBuilder = LookupElementBuilder.create(new CMakeCommandCompletionSymbol(command).createPointer(), (String)command);
        }
        if (boldCompletion) {
            lookupElementBuilder = lookupElementBuilder.bold();
        }
        if (addParentheses) {
            boolean spaceBeforeParentheses = CMakeCompletionUtils.getSpaceBeforeParentheses(command, codeStyleSettings);
            boolean spaceBetweenParentheses = CMakeCompletionUtils.getSpaceWithinParentheses(command, codeStyleSettings);
            lookupElementBuilder = putCaretInsideParentheses || !argumentList.isEmpty() ? lookupElementBuilder.withInsertHandler((InsertHandler)new MyHandler(spaceBeforeParentheses, spaceBetweenParentheses, true, false, true, CMakeCompletionUtils.isEndCommand(command))) : lookupElementBuilder.withInsertHandler((InsertHandler)new MyHandler(spaceBeforeParentheses, spaceBetweenParentheses, true, false, false, CMakeCompletionUtils.isEndCommand(command)));
        }
        LookupElementBuilder lookupElementBuilder2 = lookupElementBuilder;
        if (lookupElementBuilder2 == null) {
            CMakeCompletionUtils.$$$reportNull$$$0(9);
        }
        return lookupElementBuilder2;
    }

    private static boolean isEndCommand(@NotNull String commandName) {
        if (commandName == null) {
            CMakeCompletionUtils.$$$reportNull$$$0(10);
        }
        return CMakeStandardCommands.isCommand(CMakeStandardCommands.ENDMACRO, commandName) || CMakeStandardCommands.isCommand(CMakeStandardCommands.ENDFUNCTION, commandName) || CMakeStandardCommands.isCommand(CMakeStandardCommands.ENDWHILE, commandName) || CMakeStandardCommands.isCommand(CMakeStandardCommands.ENDFOREACH, commandName) || CMakeStandardCommands.isCommand(CMakeStandardCommands.ENDIF, commandName) || CMakeStandardCommands.isCommand(CMakeStandardCommands.ENDBLOCK, commandName) || CMakeStandardCommands.isCommand(CMakeStandardCommands.ELSEIF, commandName) || CMakeStandardCommands.isCommand(CMakeStandardCommands.ELSE, commandName);
    }

    private static boolean getSpaceBeforeParentheses(@NotNull String command, @Nullable CommonCodeStyleSettings codeStyleSettings) {
        if (command == null) {
            CMakeCompletionUtils.$$$reportNull$$$0(11);
        }
        if (codeStyleSettings == null) {
            return false;
        }
        return codeStyleSettings.SPACE_BEFORE_METHOD_CALL_PARENTHESES && !CMakePsiUtils.isIfSetCommand(command) && !CMakePsiUtils.isWhileSetCommand(command) && !CMakePsiUtils.isForeachSetCommand(command) && !CMakePsiUtils.isMethodSetCommand(command) || CMakePsiUtils.isIfSetCommand(command) && codeStyleSettings.SPACE_BEFORE_IF_PARENTHESES || CMakePsiUtils.isWhileSetCommand(command) && codeStyleSettings.SPACE_BEFORE_WHILE_PARENTHESES || CMakePsiUtils.isForeachSetCommand(command) && codeStyleSettings.SPACE_BEFORE_FOR_PARENTHESES || CMakePsiUtils.isMethodSetCommand(command) && codeStyleSettings.SPACE_BEFORE_METHOD_PARENTHESES;
    }

    private static boolean getSpaceWithinParentheses(@NotNull String command, @Nullable CommonCodeStyleSettings codeStyleSettings) {
        if (command == null) {
            CMakeCompletionUtils.$$$reportNull$$$0(12);
        }
        if (codeStyleSettings == null) {
            return false;
        }
        return codeStyleSettings.SPACE_WITHIN_METHOD_CALL_PARENTHESES && !CMakePsiUtils.isIfSetCommand(command) && !CMakePsiUtils.isWhileSetCommand(command) && !CMakePsiUtils.isForeachSetCommand(command) && !CMakePsiUtils.isMethodSetCommand(command) || CMakePsiUtils.isIfSetCommand(command) && codeStyleSettings.SPACE_WITHIN_IF_PARENTHESES || CMakePsiUtils.isWhileSetCommand(command) && codeStyleSettings.SPACE_WITHIN_WHILE_PARENTHESES || CMakePsiUtils.isForeachSetCommand(command) && codeStyleSettings.SPACE_WITHIN_FOR_PARENTHESES || CMakePsiUtils.isMethodSetCommand(command) && codeStyleSettings.SPACE_WITHIN_METHOD_PARENTHESES;
    }

    @NotNull
    public static String convertCommandToProperCase(@NotNull PsiFile file, @NotNull String textToComplete) {
        if (file == null) {
            CMakeCompletionUtils.$$$reportNull$$$0(13);
        }
        if (textToComplete == null) {
            CMakeCompletionUtils.$$$reportNull$$$0(14);
        }
        CMakeCodeStyleSettings cMakeSettings = (CMakeCodeStyleSettings)CodeStyle.getCustomSettings((PsiFile)file, CMakeCodeStyleSettings.class);
        if (cMakeSettings.FORCE_COMMANDS_CASE == Case.DO_NOT_CHANGE.getValue()) {
            String string = textToComplete;
            if (string == null) {
                CMakeCompletionUtils.$$$reportNull$$$0(15);
            }
            return string;
        }
        if (cMakeSettings.FORCE_COMMANDS_CASE == Case.TO_LOWER.getValue()) {
            String string = textToComplete.toLowerCase(Locale.getDefault());
            if (string == null) {
                CMakeCompletionUtils.$$$reportNull$$$0(16);
            }
            return string;
        }
        if (cMakeSettings.FORCE_COMMANDS_CASE == Case.TO_UPPER.getValue()) {
            String string = textToComplete.toUpperCase(Locale.getDefault());
            if (string == null) {
                CMakeCompletionUtils.$$$reportNull$$$0(17);
            }
            return string;
        }
        return "";
    }

    @NotNull
    public static LookupElement createCommandItem(@NotNull String textToComplete, @NotNull String filename, @NotNull List<CMakeArgument> argumentsInCompletion, boolean isFunctionName, boolean addParentheses, @Nullable CommonCodeStyleSettings codeStyleSettings) {
        if (textToComplete == null) {
            CMakeCompletionUtils.$$$reportNull$$$0(18);
        }
        if (filename == null) {
            CMakeCompletionUtils.$$$reportNull$$$0(19);
        }
        if (argumentsInCompletion == null) {
            CMakeCompletionUtils.$$$reportNull$$$0(20);
        }
        Icon icon = CMakeCompletionUtils.getRoutineIcon(isFunctionName);
        LookupElementBuilder lookupElementBuilder = CMakeCompletionUtils.createStandardCommandItem(textToComplete, false, addParentheses, false, argumentsInCompletion, filename, isFunctionName, codeStyleSettings).withIcon(icon);
        LookupElementBuilder lookupElementBuilder2 = lookupElementBuilder.appendTailText(CMakeCompletionUtils.getStandardCMakeCompletionTailText(filename), true);
        if (lookupElementBuilder2 == null) {
            CMakeCompletionUtils.$$$reportNull$$$0(21);
        }
        return lookupElementBuilder2;
    }

    @NonNls
    @NotNull
    @Contract(pure=true)
    private static String getStandardCMakeCompletionTailText(@NotNull String filename) {
        if (filename == null) {
            CMakeCompletionUtils.$$$reportNull$$$0(22);
        }
        String string = " (in " + filename + ")";
        if (string == null) {
            CMakeCompletionUtils.$$$reportNull$$$0(23);
        }
        return string;
    }

    @NotNull
    public static Icon getRoutineIcon(boolean isFunctionName) {
        return isFunctionName ? CMakeCompletionUtils.getFunctionIcon() : CMakeCompletionUtils.getMacroIcon();
    }

    @Contract(pure=true)
    @NotNull
    public static Icon getMacroIcon() {
        Icon icon = CMakeIcons.CMake_Macro;
        if (icon == null) {
            CMakeCompletionUtils.$$$reportNull$$$0(24);
        }
        return icon;
    }

    @Contract(pure=true)
    @NotNull
    public static Icon getFunctionIcon() {
        Icon icon = CMakeIcons.CMake_Function;
        if (icon == null) {
            CMakeCompletionUtils.$$$reportNull$$$0(25);
        }
        return icon;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 9, 15, 16, 17, 21, 23, 24, 25 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClasses";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argumentText";
                break;
            }
            case 2: 
            case 9: 
            case 15: 
            case 16: 
            case 17: 
            case 21: 
            case 23: 
            case 24: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cmake/completion/CMakeCompletionUtils";
                break;
            }
            case 4: 
            case 19: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filename";
                break;
            }
            case 5: 
            case 7: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argumentList";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandName";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 14: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textToComplete";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argumentsInCompletion";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cmake/completion/CMakeCompletionUtils";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createArgumentItem";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createStandardCommandItem";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "convertCommandToProperCase";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "createCommandItem";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getStandardCMakeCompletionTailText";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getMacroIcon";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getFunctionIcon";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getNearestParentOfType";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createArgumentItem";
                break;
            }
            case 2: 
            case 9: 
            case 15: 
            case 16: 
            case 17: 
            case 21: 
            case 23: 
            case 24: 
            case 25: {
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createStandardCommandItem";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isEndCommand";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getSpaceBeforeParentheses";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getSpaceWithinParentheses";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "convertCommandToProperCase";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "createCommandItem";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getStandardCMakeCompletionTailText";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 9, 15, 16, 17, 21, 23, 24, 25 -> new IllegalStateException(string);
        };
    }

    private static class MyHandler
    extends ParenthesesInsertHandler {
        private final Boolean myHasParameters;
        private final Boolean myFormat;

        private MyHandler(boolean spaceBeforeParentheses, boolean spaceBetweenParentheses, boolean mayInsertRightParenthesis, boolean allowParametersOnNextLine, boolean hasParameters, boolean format) {
            super(spaceBeforeParentheses, spaceBetweenParentheses, mayInsertRightParenthesis, allowParametersOnNextLine);
            this.myHasParameters = hasParameters;
            this.myFormat = format;
        }

        protected boolean placeCaretInsideParentheses(InsertionContext context2, LookupElement item) {
            return this.myHasParameters;
        }

        public void handleInsert(@NotNull InsertionContext context2, @NotNull LookupElement item) {
            if (context2 == null) {
                MyHandler.$$$reportNull$$$0(0);
            }
            if (item == null) {
                MyHandler.$$$reportNull$$$0(1);
            }
            if (this.myFormat.booleanValue()) {
                int lineNumber = context2.getDocument().getLineNumber(context2.getTailOffset());
                Document doc = context2.getDocument();
                CodeStyleManager.getInstance((Project)context2.getProject()).adjustLineIndent(context2.getFile(), TextRange.create((int)doc.getLineStartOffset(lineNumber), (int)doc.getLineEndOffset(lineNumber)));
            }
            super.handleInsert(context2, item);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "item";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/cmake/completion/CMakeCompletionUtils$MyHandler";
            objectArray[2] = "handleInsert";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

