/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.system.downloading;

import com.intellij.openapi.components.Service;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.jetbrains.cidr.system.HostMachine;
import com.jetbrains.cidr.system.RemoteHostUtil;
import com.jetbrains.cidr.system.RemoteUtil;
import com.jetbrains.cidr.system.SystemUtil;
import com.jetbrains.cidr.system.downloading.Downloader;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service
public final class RemoteFSCacheDownloadService {
    @NotNull
    private final @NotNull ConcurrentMap<Pair<@NotNull String, @NotNull String>, @NotNull Path> myDownloadCache = new ConcurrentHashMap<Pair<String, String>, Path>();

    public void download(@NotNull @NlsSafe String path, @NotNull HostMachine host, @NotNull Downloader downloader, @NotNull File directory) {
        if (path == null) {
            RemoteFSCacheDownloadService.$$$reportNull$$$0(0);
        }
        if (host == null) {
            RemoteFSCacheDownloadService.$$$reportNull$$$0(1);
        }
        if (downloader == null) {
            RemoteFSCacheDownloadService.$$$reportNull$$$0(2);
        }
        if (directory == null) {
            RemoteFSCacheDownloadService.$$$reportNull$$$0(3);
        }
        this.myDownloadCache.computeIfAbsent((Pair<String, String>)Pair.pair((Object)host.getHostId(), (Object)path), key -> {
            Path result2;
            Path possibleDestination = RemoteFSCacheDownloadService.toLocalPath(path, directory);
            if (Files.exists(possibleDestination, new LinkOption[0])) {
                return possibleDestination;
            }
            Path path2 = result2 = Downloader.isDownloadFoldersToCacheRoot() && SystemUtil.isDirectory(host, (String)key.second) ? downloader.downloadFolderWithResolvedSymlinks((String)key.second, directory.getAbsolutePath()) : downloader.downloadFile((String)key.second, directory.getAbsolutePath());
            if (result2 == null) {
                RemoteHostUtil.LOG.warn("Failed to download '" + key + "'");
            } else {
                FileUtil.createIfDoesntExist((File)result2.toFile());
            }
            return result2;
        });
    }

    @Nullable
    public Path get(@NotNull HostMachine host, @NotNull @NlsSafe String path) {
        if (host == null) {
            RemoteFSCacheDownloadService.$$$reportNull$$$0(4);
        }
        if (path == null) {
            RemoteFSCacheDownloadService.$$$reportNull$$$0(5);
        }
        return (Path)this.myDownloadCache.get(Pair.pair((Object)host.getHostId(), (Object)path));
    }

    public void invalidate() {
        this.myDownloadCache.clear();
    }

    @NotNull
    public static Path toLocalPath(@NotNull String remotePath, @NotNull File cacheDirectory) {
        if (remotePath == null) {
            RemoteFSCacheDownloadService.$$$reportNull$$$0(6);
        }
        if (cacheDirectory == null) {
            RemoteFSCacheDownloadService.$$$reportNull$$$0(7);
        }
        Path path = Path.of(FileUtil.join((String[])new String[]{cacheDirectory.getAbsolutePath(), RemoteUtil.suggestLocalPathName(remotePath)}), new String[0]);
        if (path == null) {
            RemoteFSCacheDownloadService.$$$reportNull$$$0(8);
        }
        return path;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "host";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "downloader";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remotePath";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cacheDirectory";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/system/downloading/RemoteFSCacheDownloadService";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/system/downloading/RemoteFSCacheDownloadService";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "toLocalPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "download";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "get";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "toLocalPath";
                break;
            }
            case 8: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 8 -> new IllegalStateException(string);
        };
    }
}

