/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.system;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.BaseProcessHandler;
import com.intellij.execution.process.OSProcessUtil;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.OSAgnosticPathUtil;
import com.intellij.remote.RemoteProcess;
import com.intellij.ssh.nio.UnixSshFileSysProvider;
import com.intellij.util.PathMapper;
import com.jetbrains.cidr.system.HostMachine;
import com.jetbrains.cidr.system.MappedHost;
import com.jetbrains.cidr.system.RemoteHostUtil;
import com.jetbrains.cidr.toolchains.CidrToolsUtil;
import com.jetbrains.cidr.toolchains.OSType;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SystemUtil {
    private SystemUtil() {
    }

    public static String toLocalPath(@NotNull MappedHost host, @Nullable File localBaseDir, @NotNull String absoluteOrRelativeEnvPath) {
        if (host == null) {
            SystemUtil.$$$reportNull$$$0(0);
        }
        if (absoluteOrRelativeEnvPath == null) {
            SystemUtil.$$$reportNull$$$0(1);
        }
        PathMapper pathMapper = host.getPathMapper();
        Object path = absoluteOrRelativeEnvPath;
        if (localBaseDir != null && !FileUtil.isUnixAbsolutePath((String)absoluteOrRelativeEnvPath)) {
            String remotePath = SystemUtil.toEnvPath(host, localBaseDir.toString());
            path = remotePath + "/" + absoluteOrRelativeEnvPath;
        }
        String result2 = pathMapper.convertToLocal((String)path);
        if (RemoteHostUtil.LOG.isTraceEnabled()) {
            RemoteHostUtil.LOG.trace("convertToLocal: " + (String)path + " -> " + result2);
        }
        return result2;
    }

    @NotNull
    public static String toEnvPath(@NotNull MappedHost host, @NotNull String localPath) {
        if (host == null) {
            SystemUtil.$$$reportNull$$$0(2);
        }
        if (localPath == null) {
            SystemUtil.$$$reportNull$$$0(3);
        }
        PathMapper pathMapper = host.getPathMapper();
        String result2 = pathMapper.convertToRemote(localPath);
        if (RemoteHostUtil.LOG.isTraceEnabled()) {
            RemoteHostUtil.LOG.trace("convertToRemote: " + localPath + " -> " + result2);
        }
        String string = host.getOSType() != OSType.WIN ? FileUtil.toSystemIndependentName((String)result2) : result2;
        if (string == null) {
            SystemUtil.$$$reportNull$$$0(4);
        }
        return string;
    }

    public static List<String> removeRedundant(@NotNull List<String> pathList) {
        if (pathList == null) {
            SystemUtil.$$$reportNull$$$0(5);
        }
        if (pathList.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> paths = new ArrayList<String>(pathList);
        ArrayList<String> result2 = new ArrayList<String>(paths.size());
        Collections.sort(paths);
        String cur = (String)paths.get(0);
        result2.add(cur);
        for (String path : paths) {
            if (FileUtil.isAncestor((String)cur, (String)path, (boolean)false)) continue;
            cur = path;
            result2.add(cur);
        }
        return result2;
    }

    public static void killProcessTree(@NotNull BaseProcessHandler<?> processHandler) {
        Process process2;
        if (processHandler == null) {
            SystemUtil.$$$reportNull$$$0(6);
        }
        if ((process2 = processHandler.getProcess()) instanceof RemoteProcess) {
            ((RemoteProcess)process2).killProcessTree();
        } else {
            OSProcessUtil.killProcessTree((Process)process2);
        }
    }

    public static boolean isAbsolute(@NotNull HostMachine host, @NotNull String path) {
        if (host == null) {
            SystemUtil.$$$reportNull$$$0(7);
        }
        if (path == null) {
            SystemUtil.$$$reportNull$$$0(8);
        }
        return host.getOSType() != OSType.WIN ? FileUtil.isUnixAbsolutePath((String)FileUtil.toSystemIndependentName((String)path)) : OSAgnosticPathUtil.isAbsoluteDosPath((String)path) || OSAgnosticPathUtil.isUncPath((String)path);
    }

    public static boolean isExecutable(@NotNull HostMachine host, @NotNull String path) throws ExecutionException {
        GeneralCommandLine command;
        ProcessOutput output2;
        if (host == null) {
            SystemUtil.$$$reportNull$$$0(9);
        }
        if (path == null) {
            SystemUtil.$$$reportNull$$$0(10);
        }
        return (output2 = host.runProcess(command = new GeneralCommandLine(new String[]{"test", "-x", path}), CidrToolsUtil.DEFAULT_COMMAND_TIMEOUT)).getExitCode() == 0;
    }

    public static boolean isDirectory(@NotNull HostMachine host, @NotNull String path) {
        ProcessOutput output2;
        if (host == null) {
            SystemUtil.$$$reportNull$$$0(11);
        }
        if (path == null) {
            SystemUtil.$$$reportNull$$$0(12);
        }
        GeneralCommandLine command = new GeneralCommandLine(new String[]{"test", "-d", path});
        try {
            output2 = host.runProcess(command, CidrToolsUtil.DEFAULT_COMMAND_TIMEOUT);
        }
        catch (ExecutionException e) {
            RemoteHostUtil.LOG.warn("Cannot check if '" + path + "' is directory", (Throwable)e);
            return false;
        }
        return output2.getExitCode() == 0;
    }

    public static String patchMessage(@NotNull String message, @NotNull Path path, @Nullable String originalMessage) {
        if (message == null) {
            SystemUtil.$$$reportNull$$$0(13);
        }
        if (path == null) {
            SystemUtil.$$$reportNull$$$0(14);
        }
        if (UnixSshFileSysProvider.isRemotePath((Path)path) && originalMessage != null) {
            return message + ": " + originalMessage;
        }
        return message;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "host";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "absoluteOrRelativeEnvPath";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localPath";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/system/SystemUtil";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathList";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processHandler";
                break;
            }
            case 8: 
            case 10: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/system/SystemUtil";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "toEnvPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "toLocalPath";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "toEnvPath";
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "removeRedundant";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "killProcessTree";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isAbsolute";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isExecutable";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isDirectory";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "patchMessage";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4 -> new IllegalStateException(string);
        };
    }
}

