/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.system;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.BaseProcessHandler;
import com.intellij.execution.process.ProcessInfo;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remote.RemoteCredentials;
import com.intellij.remote.RemoteCredentialsHolder;
import com.intellij.ssh.SshException;
import com.intellij.ssh.attach.SshAttachHost;
import com.intellij.ssh.config.unified.SshConfig;
import com.intellij.ssh.config.unified.SshConfigManager;
import com.intellij.ssh.nio.UnixSshFileSysProvider;
import com.intellij.ssh.ui.unified.SshUiData;
import com.intellij.util.PathMapper;
import com.intellij.util.PathMappingSettings;
import com.intellij.util.concurrency.SynchronizedClearableLazy;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBTreeTraverser;
import com.intellij.util.io.PathKt;
import com.jetbrains.cidr.NamedPipe;
import com.jetbrains.cidr.cpp.ToolchainsBundle;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerPathManager;
import com.jetbrains.cidr.system.CidrProcessBuilder;
import com.jetbrains.cidr.system.CidrRSyncUtil;
import com.jetbrains.cidr.system.HostMachine;
import com.jetbrains.cidr.system.MappedHost;
import com.jetbrains.cidr.system.PathMapperWithRemoteFSCacheLookup;
import com.jetbrains.cidr.system.PathMapperWrapper;
import com.jetbrains.cidr.system.RemoteDeployment;
import com.jetbrains.cidr.system.RemoteDeploymentHelper;
import com.jetbrains.cidr.system.RemoteFSCache;
import com.jetbrains.cidr.system.RemoteHostUtil;
import com.jetbrains.cidr.system.RemoteUnixPipe;
import com.jetbrains.cidr.system.RemoteUtil;
import com.jetbrains.cidr.system.TarUtil;
import com.jetbrains.cidr.system.downloading.Downloader;
import com.jetbrains.cidr.toolchains.CidrToolsUtil;
import com.jetbrains.cidr.toolchains.OSType;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class RemoteHost
implements MappedHost,
HostMachine {
    @NotNull
    private final String myId;
    @Nullable
    private final SshConfig mySshConfig;
    @NotNull
    private final OSType myOSType;
    @NotNull
    private final RemoteCredentials myCredentials;
    @NotNull
    private final PathMapper myPathMapper;
    @NotNull
    private final FileSystem myFS;
    @NotNull
    private final RemoteFSCache myRemoteFSCache;
    @Nullable
    private final Project myProject;
    private Path myTempDirectory;
    private Boolean myIsTarAvailable;
    private final SynchronizedClearableLazy<Boolean> myIsPigzAvailable;

    public RemoteHost(@Nullable String hostId, @NotNull SshConfig sshConfig, @NotNull OSType osType, @NotNull PathMapper pathMapper, @Nullable Project project) {
        if (sshConfig == null) {
            RemoteHost.$$$reportNull$$$0(0);
        }
        if (osType == null) {
            RemoteHost.$$$reportNull$$$0(1);
        }
        if (pathMapper == null) {
            RemoteHost.$$$reportNull$$$0(2);
        }
        this(hostId, sshConfig, RemoteHost.getCredentials(sshConfig), osType, pathMapper, project);
    }

    @TestOnly
    public RemoteHost(@Nullable String hostId, @NotNull RemoteCredentials credentials, @NotNull OSType osType, @NotNull PathMapper pathMapper, @Nullable Project project) {
        if (credentials == null) {
            RemoteHost.$$$reportNull$$$0(3);
        }
        if (osType == null) {
            RemoteHost.$$$reportNull$$$0(4);
        }
        if (pathMapper == null) {
            RemoteHost.$$$reportNull$$$0(5);
        }
        this(hostId, null, credentials, osType, pathMapper, project);
    }

    @NotNull
    RemoteCredentials getCredentials() {
        RemoteCredentials remoteCredentials = this.myCredentials;
        if (remoteCredentials == null) {
            RemoteHost.$$$reportNull$$$0(6);
        }
        return remoteCredentials;
    }

    @NotNull
    private static RemoteCredentials getCredentials(@NotNull SshConfig sshConfig) {
        SshUiData data2;
        if (sshConfig == null) {
            RemoteHost.$$$reportNull$$$0(7);
        }
        Object object = (data2 = SshConfigManager.getInstance(null).findCurrentDataById(sshConfig.getId())) == null ? new SshUiData(sshConfig) : data2.copyToCredentials();
        if (object == null) {
            RemoteHost.$$$reportNull$$$0(8);
        }
        return object;
    }

    private RemoteHost(@Nullable String hostId, @Nullable SshConfig sshConfig, @NotNull RemoteCredentials credentials, @NotNull OSType osType, @NotNull PathMapper pathMapper, @Nullable Project project) {
        if (credentials == null) {
            RemoteHost.$$$reportNull$$$0(9);
        }
        if (osType == null) {
            RemoteHost.$$$reportNull$$$0(10);
        }
        if (pathMapper == null) {
            RemoteHost.$$$reportNull$$$0(11);
        }
        this.myTempDirectory = null;
        this.myIsTarAvailable = null;
        this.myIsPigzAvailable = new SynchronizedClearableLazy(() -> RemoteUtil.isPigzInstalled(this.getCredentials()));
        this.myId = hostId != null ? hostId : RemoteCredentialsHolder.getCredentialsString((RemoteCredentials)credentials);
        this.myOSType = osType;
        this.mySshConfig = sshConfig;
        this.myCredentials = credentials;
        try {
            URI stub = new URI("ssh:///");
            this.myFS = new UnixSshFileSysProvider(credentials).newFileSystem(stub, Collections.emptyMap());
        }
        catch (IOException | URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
        String hostName = credentials.getHost().replace(":", "-") + "_" + credentials.getPort();
        Object presentableId = hostId != null ? hostId : hostName;
        File cacheDirectory = Paths.get(PathManager.getSystemPath(), new String[]{".remote", hostName, presentableId}).toFile();
        this.myRemoteFSCache = new RemoteFSCache(cacheDirectory, pathMapper, new RemoteDownloader(), this);
        this.myPathMapper = new PathMapperWithRemoteFSCacheLookup(pathMapper, this.myRemoteFSCache);
        this.myProject = project;
    }

    public boolean isRemote() {
        return true;
    }

    public boolean hasRemoteFS() {
        return true;
    }

    @NotNull
    public OSType getOSType() {
        OSType oSType = this.myOSType;
        if (oSType == null) {
            RemoteHost.$$$reportNull$$$0(12);
        }
        return oSType;
    }

    @NotNull
    public CidrProcessBuilder createProcessBuilder() {
        CidrProcessBuilder cidrProcessBuilder = RemoteUtil.createRemoteProcess(this.myCredentials, this.myPathMapper);
        if (cidrProcessBuilder == null) {
            RemoteHost.$$$reportNull$$$0(13);
        }
        return cidrProcessBuilder;
    }

    public void destroyProcess(@NotNull BaseProcessHandler handler2) {
        if (handler2 == null) {
            RemoteHost.$$$reportNull$$$0(14);
        }
        handler2.destroyProcess();
        String command = handler2.getCommandLine();
        GeneralCommandLine cmd = new GeneralCommandLine(new String[]{"pkill", "-9", "-f", command});
        try {
            this.runProcess(cmd, 0);
        }
        catch (ExecutionException e) {
            RemoteHostUtil.LOG.warn("Cannot destroy remote process: " + command, (Throwable)e);
        }
    }

    public void killProcessTree(@NotNull BaseProcessHandler handler2) {
        if (handler2 == null) {
            RemoteHost.$$$reportNull$$$0(15);
        }
        if (RemoteHostUtil.LOG.isDebugEnabled()) {
            RemoteHostUtil.LOG.debug("RemoteHost: kill process tree: " + handler2.getCommandLine());
        }
        RemoteUtil.killProcessTree(handler2);
    }

    @NotNull
    public List<ProcessInfo> getProcessList() throws ExecutionException {
        List list2 = new SshAttachHost(this.myCredentials).getProcessList();
        if (list2 == null) {
            RemoteHost.$$$reportNull$$$0(16);
        }
        return list2;
    }

    public int sendSignal(int pid, @NotNull String signalName) {
        if (signalName == null) {
            RemoteHost.$$$reportNull$$$0(17);
        }
        if (RemoteHostUtil.LOG.isDebugEnabled()) {
            RemoteHostUtil.LOG.debug("RemoteHost: send signal: " + signalName + " to pid: " + pid);
        }
        return CidrToolsUtil.sendUnixSignal((HostMachine)this, (int)pid, (String)signalName);
    }

    @NotNull
    public Path getPath(@NotNull String first, String ... more) {
        if (first == null) {
            RemoteHost.$$$reportNull$$$0(18);
        }
        String[] others = new String[more.length];
        for (int i = 0; i < more.length; ++i) {
            others[i] = this.myPathMapper.convertToRemote(more[i]);
        }
        Path path = this.myFS.getPath(this.myPathMapper.convertToRemote(first), others);
        if (path == null) {
            RemoteHost.$$$reportNull$$$0(19);
        }
        return path;
    }

    @NotNull
    public @NotNull String @NotNull [] toCanonicalPath(@NotNull List<@NonNls String> paths, boolean resolveSymlink) {
        if (paths == null) {
            RemoteHost.$$$reportNull$$$0(20);
        }
        String[] stringArray = this.myRemoteFSCache.toCanonicalPathAndResolveSymlink(paths);
        if (stringArray == null) {
            RemoteHost.$$$reportNull$$$0(21);
        }
        return stringArray;
    }

    @NotNull
    public PathMapper getPathMapper() {
        PathMapper pathMapper = this.myPathMapper;
        if (pathMapper == null) {
            RemoteHost.$$$reportNull$$$0(22);
        }
        return pathMapper;
    }

    @NotNull
    public Path getTempDirectory() {
        if (this.myTempDirectory == null) {
            try {
                String tempFileName = CidrToolsUtil.generateTempFileName((HostMachine)this);
                this.myTempDirectory = this.getPath(tempFileName, new String[0]).getParent();
            }
            catch (Exception e) {
                RemoteHostUtil.LOG.warn("Cannot get temp file name", (Throwable)e);
                this.myTempDirectory = this.getPath("/tmp/", new String[0]);
            }
        }
        Path path = this.myTempDirectory;
        if (path == null) {
            RemoteHost.$$$reportNull$$$0(23);
        }
        return path;
    }

    @NotNull
    public Path createTempDirectory(@NotNull String prefix, @Nullable String suffix) throws IOException {
        if (prefix == null) {
            RemoteHost.$$$reportNull$$$0(24);
        }
        prefix = (String)prefix + StringUtil.notNullize((String)suffix);
        Path path = Files.createTempDirectory(this.getTempDirectory(), (String)prefix, new FileAttribute[0]);
        if (path == null) {
            RemoteHost.$$$reportNull$$$0(25);
        }
        return path;
    }

    @NotNull
    public NamedPipe openNamedPipe() throws ExecutionException {
        return new SshRemoteUnixPipe(this);
    }

    @NotNull
    public String getHostId() {
        String string = this.myId;
        if (string == null) {
            RemoteHost.$$$reportNull$$$0(26);
        }
        return string;
    }

    @NotNull
    public File resolvePath(@NotNull Path remoteFile) throws IOException {
        if (remoteFile == null) {
            RemoteHost.$$$reportNull$$$0(27);
        }
        String remotePath = remoteFile.toString();
        String localPath = this.myPathMapper.convertToLocal(remotePath);
        return this.syncToLocal(remotePath, localPath, false);
    }

    @NotNull
    public File resolvePath(@NotNull File localFile) throws IOException {
        if (localFile == null) {
            RemoteHost.$$$reportNull$$$0(28);
        }
        String localPath = localFile.getPath();
        String remotePath = this.myPathMapper.convertToRemote(localPath);
        return this.syncToLocal(remotePath, localPath, false);
    }

    @NotNull
    public List<String> resolveAndCache(@NotNull List<String> remotePaths) {
        if (remotePaths == null) {
            RemoteHost.$$$reportNull$$$0(29);
        }
        List<String> list2 = this.myRemoteFSCache.resolveAndCache(remotePaths);
        if (list2 == null) {
            RemoteHost.$$$reportNull$$$0(30);
        }
        return list2;
    }

    public void invalidateCache() {
        this.myRemoteFSCache.invalidateCache();
    }

    public void markCacheInvalid() {
        this.myRemoteFSCache.markInvalidated();
    }

    @NotNull
    public List<Path> findFilesWithExtension(@NotNull Path rootPath, Boolean recursive, String ... extensions) throws ExecutionException {
        if (rootPath == null) {
            RemoteHost.$$$reportNull$$$0(31);
        }
        if (!Files.exists(rootPath, new LinkOption[0])) {
            List<Path> list2 = Collections.emptyList();
            if (list2 == null) {
                RemoteHost.$$$reportNull$$$0(32);
            }
            return list2;
        }
        List<Path> list3 = this.doFindFilesWithExtension(rootPath, recursive, extensions);
        if (list3 == null) {
            RemoteHost.$$$reportNull$$$0(33);
        }
        return list3;
    }

    @RequiresBackgroundThread
    public void waitForFilesSync() {
        ThreadingAssertions.assertBackgroundThread();
        RemoteDeployment remoteDeployment = (RemoteDeployment)ApplicationManager.getApplication().getService(RemoteDeployment.class);
        if (remoteDeployment == null || this.myProject == null) {
            return;
        }
        if (!remoteDeployment.waitForFilesSync(this.myProject, this.getHostId())) {
            ProgressIndicator indicator = ProgressIndicatorProvider.getGlobalProgressIndicator();
            if (indicator != null && indicator.isCanceled()) {
                RemoteHostUtil.LOG.warn("Sync cancelled");
            } else {
                RemoteHostUtil.LOG.warn("Maximum sync timeout exceeded");
            }
        }
    }

    private List<Path> doFindFilesWithExtension(@NotNull Path rootPath, boolean recursive, String ... extensions) throws ExecutionException {
        if (rootPath == null) {
            RemoteHost.$$$reportNull$$$0(34);
        }
        if (extensions == null) {
            RemoteHost.$$$reportNull$$$0(35);
        }
        GeneralCommandLine find = new GeneralCommandLine(new String[]{"find", rootPath.toString()});
        boolean isFirstElement = true;
        for (String extension : extensions) {
            if (isFirstElement) {
                isFirstElement = false;
            } else {
                find.addParameter("-or");
            }
            find.addParameter("-type");
            find.addParameter("f");
            find.addParameter("-name");
            find.addParameter("*" + extension);
        }
        find.setWorkDirectory(rootPath.toString());
        ProcessOutput output2 = this.runProcess(find, 60000);
        if (!CidrToolsUtil.checkSuccess((GeneralCommandLine)find, (ProcessOutput)output2, (Logger)RemoteHostUtil.LOG)) {
            throw new ExecutionException(ToolchainsBundle.message("remote.exception.cannot.find.files.with.extensions", new Object[0]));
        }
        List filesWithExtension = ContainerUtil.mapNotNull((Collection)output2.getStdoutLines(), path -> this.getPath((String)path, new String[0]));
        return recursive ? filesWithExtension : ContainerUtil.filter((Collection)filesWithExtension, path -> rootPath.equals(path.getParent()));
    }

    @NotNull
    private File syncToLocal(@NotNull String remotePath, @NotNull String localPath, boolean downloadingToRoot) throws IOException {
        if (remotePath == null) {
            RemoteHost.$$$reportNull$$$0(36);
        }
        if (localPath == null) {
            RemoteHost.$$$reportNull$$$0(37);
        }
        if (!RemoteDeploymentHelper.isSyncNeeded(this.myId, this.myProject, remotePath, localPath)) {
            return new File(localPath);
        }
        BasicFileAttributes attributes = PathKt.basicAttributesIfExists((Path)this.getPath(remotePath, new String[0]));
        if (attributes != null && attributes.isSymbolicLink()) {
            String resolvedPath = RemoteHostUtil.resolveSymlink((HostMachine)this, (String)remotePath);
            attributes = PathKt.basicAttributesIfExists((Path)this.getPath(resolvedPath, new String[0]));
        }
        if (attributes != null && attributes.isDirectory()) {
            return this.syncDirToLocal(this.myId, this.myProject, remotePath, localPath, downloadingToRoot);
        }
        return this.syncToLocal(this.myId, this.myProject, remotePath, localPath);
    }

    @NotNull
    private File syncDirToLocal(@NotNull String hostId, Project project, @NotNull String remotePath, @NotNull String localPath, boolean downloadingToRoot) throws IOException {
        if (hostId == null) {
            RemoteHost.$$$reportNull$$$0(38);
        }
        if (remotePath == null) {
            RemoteHost.$$$reportNull$$$0(39);
        }
        if (localPath == null) {
            RemoteHost.$$$reportNull$$$0(40);
        }
        if (CidrRSyncUtil.canUseRSync(hostId)) {
            File file = CidrRSyncUtil.rsyncDirToLocal(this, remotePath, localPath, downloadingToRoot);
            if (file == null) {
                RemoteHost.$$$reportNull$$$0(41);
            }
            return file;
        }
        if (this.isTarAvailable() && Registry.is((String)"clion.remote.compress.tar")) {
            return this.tarDirAndSyncToLocal(hostId, project, remotePath, localPath, downloadingToRoot);
        }
        if (downloadingToRoot) {
            RemoteHostUtil.LOG.warn("fallback implementation does not support download to local root, please install tar or rsync on a remote host");
            localPath = FileUtil.join((String[])new String[]{localPath, RemoteUtil.suggestLocalPathName(remotePath)});
        }
        return this.syncToLocal(hostId, project, remotePath, localPath);
    }

    private boolean isTarAvailable() {
        if (this.myIsTarAvailable == null) {
            this.myIsTarAvailable = RemoteUtil.isTarInstalled(this.myCredentials);
        }
        return this.myIsTarAvailable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private File tarDirAndSyncToLocal(String hostId, Project project, @NotNull String remotePath, @NotNull String localPath, boolean downloadingToRoot) throws IOException {
        String remoteArchivePath;
        File localDir;
        block8: {
            if (remotePath == null) {
                RemoteHost.$$$reportNull$$$0(42);
            }
            if (localPath == null) {
                RemoteHost.$$$reportNull$$$0(43);
            }
            ProgressManager.checkCanceled();
            localDir = new File(localPath);
            remoteArchivePath = null;
            File archive = null;
            try {
                String localArchivePath = FileUtil.createTempFile((String)"clion_remote_archive", (String)".tar.gz", (boolean)false).getPath();
                remoteArchivePath = TarUtil.tar(this, remotePath, RemoteUtil.isTextFilesSyncEnabled(), (Boolean)this.myIsPigzAvailable.getValue(), downloadingToRoot);
                archive = this.syncToLocal(hostId, project, remoteArchivePath, localArchivePath);
                TarUtil.decompress(archive, localDir);
                if (archive == null) break block8;
            }
            catch (Throwable throwable) {
                if (archive != null) {
                    Files.delete(archive.toPath());
                }
                if (remoteArchivePath != null) {
                    Files.delete(this.getPath(remoteArchivePath, new String[0]));
                }
                throw throwable;
            }
            Files.delete(archive.toPath());
        }
        if (remoteArchivePath != null) {
            Files.delete(this.getPath(remoteArchivePath, new String[0]));
        }
        File file = localDir;
        if (file == null) {
            RemoteHost.$$$reportNull$$$0(44);
        }
        return file;
    }

    @NotNull
    private File syncToLocal(String hostId, Project project, @NotNull String remotePath, @NotNull String localPath) {
        if (remotePath == null) {
            RemoteHost.$$$reportNull$$$0(45);
        }
        if (localPath == null) {
            RemoteHost.$$$reportNull$$$0(46);
        }
        ProgressManager.checkCanceled();
        File result2 = new File(localPath);
        try {
            if (RemoteHostUtil.LOG.isDebugEnabled()) {
                RemoteHostUtil.LOG.debug("RemoteHost: download: " + remotePath + " -> " + localPath);
            }
            assert (this.mySshConfig != null);
            RemoteDeploymentHelper.download(hostId, this.mySshConfig, project, remotePath, localPath);
            if (!result2.exists()) {
                RemoteHostUtil.LOG.warn("cannot download file: remote (" + remotePath + ") -> local (" + localPath + ")");
            }
        }
        catch (IOException e) {
            RemoteHostUtil.LOG.error("cannot download file: remote (" + remotePath + ") -> local (" + localPath + ")", (Throwable)e);
        }
        File file = result2;
        if (file == null) {
            RemoteHost.$$$reportNull$$$0(47);
        }
        return file;
    }

    @NotNull
    public File getCacheDirectory() {
        File file = this.myRemoteFSCache.getCacheDirectory();
        if (file == null) {
            RemoteHost.$$$reportNull$$$0(48);
        }
        return file;
    }

    public void installDependencies() {
        this.installPrettyPrinters();
    }

    private void installPrettyPrinters() {
        Path remoteCache = this.getTempDirectory().resolve(this.getHostId()).resolve(".clion.resources");
        PathMappingSettings.PathMapping prettyPrinterMapping = new PathMappingSettings.PathMapping(CidrDebuggerPathManager.getBundledGDBSTLPrettyPrinters().getAbsolutePath(), remoteCache.resolve("pretty_printers/gdb").toString());
        String localPath = prettyPrinterMapping.getLocalRoot();
        String remotePath = prettyPrinterMapping.getRemoteRoot();
        try {
            if (this.myProject != null && !this.prettyPrinterFilesExist(prettyPrinterMapping)) {
                RemoteDeploymentHelper.upload(this.getHostId(), this.myProject, localPath, remotePath);
            }
            RemoteHost.addPathMapping(this.myPathMapper, prettyPrinterMapping);
        }
        catch (IOException e) {
            RemoteHostUtil.LOG.warn("Uploading of `" + localPath + "` was failed", (Throwable)e);
        }
    }

    private boolean prettyPrinterFilesExist(@NotNull PathMappingSettings.PathMapping prettyPrinterMapping) {
        if (prettyPrinterMapping == null) {
            RemoteHost.$$$reportNull$$$0(49);
        }
        try {
            File localPrettyPrintersRoot = new File(prettyPrinterMapping.getLocalRoot());
            List localPrettyPrinterFiles = ((JBTreeTraverser)FileUtil.fileTraverser((File)localPrettyPrintersRoot).filter(it -> it.isFile())).toList();
            List remotePrettyPrinterPaths = ContainerUtil.map((Collection)localPrettyPrinterFiles, it -> prettyPrinterMapping.mapToRemote(it.getAbsolutePath()));
            String tests = remotePrettyPrinterPaths.stream().map(it -> "test -e \"" + it + "\"").collect(Collectors.joining(" && "));
            GeneralCommandLine command = new GeneralCommandLine(new String[]{"sh", "-c", tests});
            ProcessOutput output2 = RemoteUtil.runRemoteProcess(command, this.myCredentials, CidrToolsUtil.DEFAULT_COMMAND_TIMEOUT);
            return output2.getExitCode() == 0;
        }
        catch (ExecutionException e) {
            RemoteHostUtil.LOG.warn("Failed to check if file exists: " + prettyPrinterMapping.getRemoteRoot(), (Throwable)e);
            return false;
        }
    }

    private static void addPathMapping(@NotNull PathMapper pathMapper, @NotNull PathMappingSettings.PathMapping pathMapping) {
        PathMapperWithRemoteFSCacheLookup mapper2;
        if (pathMapper == null) {
            RemoteHost.$$$reportNull$$$0(50);
        }
        if (pathMapping == null) {
            RemoteHost.$$$reportNull$$$0(51);
        }
        if (pathMapper instanceof PathMapperWithRemoteFSCacheLookup) {
            mapper2 = (PathMapperWithRemoteFSCacheLookup)pathMapper;
            pathMapper = mapper2.getDelegateMapper();
        }
        if (pathMapper instanceof PathMapperWrapper) {
            mapper2 = (PathMapperWrapper)pathMapper;
            pathMapper = mapper2.getOriginal();
        }
        if (pathMapper instanceof PathMappingSettings) {
            mapper2 = (PathMappingSettings)pathMapper;
            List original = mapper2.getPathMappings();
            ArrayList<PathMappingSettings.PathMapping> mappings = new ArrayList<PathMappingSettings.PathMapping>(original);
            mappings.add(pathMapping);
            mapper2.setPathMappings(mappings);
        } else {
            RemoteHostUtil.LOG.warn("Cannot add path mapping " + pathMapping);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 8, 12, 13, 16, 19, 21, 22, 23, 25, 26, 30, 32, 33, 41, 44, 47, 48 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sshConfig";
                break;
            }
            case 1: 
            case 4: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "osType";
                break;
            }
            case 2: 
            case 5: 
            case 11: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathMapper";
                break;
            }
            case 3: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "credentials";
                break;
            }
            case 6: 
            case 8: 
            case 12: 
            case 13: 
            case 16: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 26: 
            case 30: 
            case 32: 
            case 33: 
            case 41: 
            case 44: 
            case 47: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/system/RemoteHost";
                break;
            }
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "signalName";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "first";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paths";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remoteFile";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localFile";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remotePaths";
                break;
            }
            case 31: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootPath";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extensions";
                break;
            }
            case 36: 
            case 39: 
            case 42: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remotePath";
                break;
            }
            case 37: 
            case 40: 
            case 43: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localPath";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hostId";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prettyPrinterMapping";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathMapping";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/system/RemoteHost";
                break;
            }
            case 6: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getCredentials";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getOSType";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "createProcessBuilder";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getProcessList";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getPath";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "toCanonicalPath";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getPathMapper";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getTempDirectory";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "createTempDirectory";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getHostId";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveAndCache";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "findFilesWithExtension";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "syncDirToLocal";
                break;
            }
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "tarDirAndSyncToLocal";
                break;
            }
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "syncToLocal";
                break;
            }
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "getCacheDirectory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: 
            case 8: 
            case 12: 
            case 13: 
            case 16: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 26: 
            case 30: 
            case 32: 
            case 33: 
            case 41: 
            case 44: 
            case 47: 
            case 48: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getCredentials";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "destroyProcess";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "killProcessTree";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "sendSignal";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getPath";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "toCanonicalPath";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "createTempDirectory";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "resolvePath";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "resolveAndCache";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "findFilesWithExtension";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "doFindFilesWithExtension";
                break;
            }
            case 36: 
            case 37: 
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "syncToLocal";
                break;
            }
            case 38: 
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "syncDirToLocal";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "tarDirAndSyncToLocal";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "prettyPrinterFilesExist";
                break;
            }
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "addPathMapping";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 8, 12, 13, 16, 19, 21, 22, 23, 25, 26, 30, 32, 33, 41, 44, 47, 48 -> new IllegalStateException(string);
        };
    }

    private class RemoteDownloader
    extends Downloader {
        private RemoteDownloader() {
        }

        @Override
        public Path downloadFile(@NotNull String remotePath, @NotNull String localRoot) {
            if (remotePath == null) {
                RemoteDownloader.$$$reportNull$$$0(0);
            }
            if (localRoot == null) {
                RemoteDownloader.$$$reportNull$$$0(1);
            }
            localRoot = FileUtil.join((String[])new String[]{localRoot, RemoteUtil.suggestLocalPathName(remotePath)});
            if (RemoteHostUtil.LOG.isDebugEnabled()) {
                RemoteHostUtil.LOG.debug("RemoteHost: resolve and cache: " + remotePath + " -> " + localRoot);
            }
            try {
                File result2 = RemoteHost.this.syncToLocal(remotePath, localRoot, false);
                return result2.toPath();
            }
            catch (IOException e) {
                RemoteHostUtil.LOG.error("Download failed: " + remotePath, (Throwable)e);
                return null;
            }
        }

        @Override
        public Path downloadFolderWithResolvedSymlinks(@NotNull String remotePath, @NotNull String localRoot) {
            if (remotePath == null) {
                RemoteDownloader.$$$reportNull$$$0(2);
            }
            if (localRoot == null) {
                RemoteDownloader.$$$reportNull$$$0(3);
            }
            if (RemoteHostUtil.LOG.isDebugEnabled()) {
                RemoteHostUtil.LOG.debug("RemoteHost: downloadToLocalRoot: " + remotePath + " -> " + localRoot);
            }
            try {
                File result2 = RemoteHost.this.syncToLocal(remotePath, localRoot, true);
                return result2.toPath().resolve(RemoteUtil.suggestLocalPathName(remotePath));
            }
            catch (IOException e) {
                RemoteHostUtil.LOG.error("Download failed: " + remotePath, (Throwable)e);
                return null;
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "remotePath";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "localRoot";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/cidr/system/RemoteHost$RemoteDownloader";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "downloadFile";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "downloadFolderWithResolvedSymlinks";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class SshRemoteUnixPipe
    extends RemoteUnixPipe {
        private SshRemoteUnixPipe(@NotNull HostMachine host) throws ExecutionException {
            if (host == null) {
                SshRemoteUnixPipe.$$$reportNull$$$0(0);
            }
            super(host);
        }

        @NotNull
        public OutputStream getOutputStream() throws IOException {
            OutputStream outputStream;
            try {
                outputStream = super.getOutputStream();
            }
            catch (SshException e) {
                throw new IOException(e);
            }
            if (outputStream == null) {
                SshRemoteUnixPipe.$$$reportNull$$$0(1);
            }
            return outputStream;
        }

        @NotNull
        public InputStream getInputStream() throws IOException {
            InputStream inputStream;
            try {
                inputStream = super.getInputStream();
            }
            catch (SshException e) {
                throw new IOException(e);
            }
            if (inputStream == null) {
                SshRemoteUnixPipe.$$$reportNull$$$0(2);
            }
            return inputStream;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "host";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/system/RemoteHost$SshRemoteUnixPipe";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/system/RemoteHost$SshRemoteUnixPipe";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getOutputStream";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getInputStream";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2 -> new IllegalStateException(string);
            };
        }
    }
}

