/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.dfa;

import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.rml.dfa.AnalysisOptions;
import com.intellij.rml.dfa.DfaAnalysisRmlResult;
import com.intellij.rml.dfa.DfaSessionProvider;
import com.intellij.rml.dfa.DfaSummarySession;
import com.intellij.rml.dfa.PathSensitiveMode;
import com.intellij.rml.dfa.attributes.Attribute;
import com.intellij.rml.dfa.attributes.DfaTuple;
import com.intellij.rml.dfa.devtools.DfaDebugProvider;
import com.intellij.rml.dfa.devtools.DfaSessionDebugRegistrar;
import com.intellij.rml.dfa.ir.IrLocation;
import com.intellij.rml.dfa.ir.ast.IrFunctionID;
import com.intellij.rml.dfa.utils.Cancellation;
import com.intellij.rml.dfa.utils.FormatHelperKt;
import com.intellij.rml.dfa.utils.RMLOptions;
import com.intellij.rml.dfa.utils.graph.Graph;
import com.intellij.rml.dfa.utils.measurements.DfaMeasurementRunner;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.cidr.lang.OCInspectionsBundle;
import com.jetbrains.cidr.lang.OCLanguage;
import com.jetbrains.cidr.lang.daemon.clang.ClangUtils;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageService;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageServiceProvider;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangIdeFacade;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangIndexerCommand;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangUrlConverter;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangdIndexerService;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionClangDFAConfigParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.registry.ClangParseResponse;
import com.jetbrains.cidr.lang.dfa.DFATuplesParserKt;
import com.jetbrains.cidr.lang.dfa.OCContextSensitiveBuilder;
import com.jetbrains.cidr.lang.dfa.OCDFAInput;
import com.jetbrains.cidr.lang.dfa.OCSourceGliderService;
import com.jetbrains.cidr.lang.dfa.statistics.DfaStatisticsMeasurement;
import com.jetbrains.cidr.lang.inspections.dfa.OCDFAInspectionConfigUtil;
import com.jetbrains.cidr.util.CidrConcurrentUtilsKt;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kotlin.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OCDFAInspectionBaseRunner {
    protected static final Logger LOG = Logger.getInstance((String)OCDFAInspectionBaseRunner.class.getName());
    public static final Key<ProblemsHolder> TEST_PROBLEMS_HOLDER = Key.create((String)"TEST_PROBLEMS_HOLDER");
    public static final Key<List<VirtualFile>> TEST_SCOPE = Key.create((String)"TEST_SCOPE");
    public static final Key<String> GENERATE_IR = Key.create((String)"GENERATE_IR");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Pair<List<DfaTuple>, Map<Attribute, IrLocation>> getDFAInput(@NotNull VirtualFile file, boolean isBatchMode, ClangLanguageService languageService) {
        if (file == null) {
            OCDFAInspectionBaseRunner.$$$reportNull$$$0(0);
        }
        if (isBatchMode && languageService.isIndexer()) {
            ClangdIndexerService indexer = (ClangdIndexerService)languageService;
            ClangUrlConverter urlConverter = languageService.getUrlConverter();
            Ref parsedTuples = Ref.create();
            ClionClangDFAConfigParams dfaOptions = (ClionClangDFAConfigParams)ReadAction.compute(() -> indexer.getClangIdeFacade().getDFAOptions(indexer.getContext().getProject(), file));
            indexer.getDfaInput(file, dfaOptions, tuplesFuture -> {
                try {
                    Stream tuplesStream = (Stream)tuplesFuture.waitForResult();
                    if (tuplesStream == null) {
                        return;
                    }
                    parsedTuples.set(DFATuplesParserKt.parseDFATuples(tuplesStream.collect(Collectors.toList()), urlConverter));
                }
                catch (ExecutionException e) {
                    ClangUtils.logServerException((Logger)LOG, (String)e.getMessage(), (ExecutionException)e);
                }
                catch (Exception ex) {
                    if (ex instanceof ControlFlowException) {
                        ExceptionUtil.rethrow((Throwable)ex);
                    }
                    LOG.error((Throwable)ex);
                }
            });
            return (Pair)parsedTuples.get();
        }
        long timeStart = System.currentTimeMillis();
        ClangUrlConverter urlConverter = languageService.getUrlConverter();
        try {
            Pair dfaOptions = (Pair)languageService.computeWithOpenedAndParsed(file, response -> {
                if (response == null) {
                    return null;
                }
                CompletableFuture dfaInputFuture = response.getDFAInput();
                ClangUtils.warnClangd((Logger)LOG, (String)("Starting clangd DFA: " + file.getName()));
                Supplier result2 = (Supplier)CidrConcurrentUtilsKt.waitCancelAndWriteActionAware((Future)dfaInputFuture, (long)Long.MAX_VALUE, (String)"dfaInput");
                if (result2 == null) {
                    return null;
                }
                int origDFAUsageInBytes = ClangParseResponse.getOriginalDFAMemoryUsage((CompletableFuture)dfaInputFuture);
                int compressedDFAUsageInBytes = ClangParseResponse.getCompressedDFAMemoryUsage((CompletableFuture)dfaInputFuture);
                ClangUtils.warnClangd((Logger)LOG, (String)("Received " + ClangUtils.renderHumanReadableSize((long)origDFAUsageInBytes) + " (compressed to " + ClangUtils.renderHumanReadableSize((long)compressedDFAUsageInBytes) + ") DFA inputs"));
                return DFATuplesParserKt.parseDFATuples((List)result2.get(), urlConverter);
            });
            return dfaOptions;
        }
        catch (CancellationException e) {
            ClangUtils.warnClangd((Logger)LOG, (String)("clangd DFA cancelled by service: " + e.getMessage()));
            Pair<List<DfaTuple>, Map<Attribute, IrLocation>> pair = null;
            return pair;
        }
        catch (TimeoutException e) {
            ClangUtils.warnClangd((Logger)LOG, (String)("clangd DFA timeout: " + file.getName()));
            Pair<List<DfaTuple>, Map<Attribute, IrLocation>> pair = null;
            return pair;
        }
        catch (ExecutionException e) {
            ClangUtils.logServerException((Logger)LOG, (String)e.getMessage(), (ExecutionException)e);
            Pair<List<DfaTuple>, Map<Attribute, IrLocation>> pair = null;
            return pair;
        }
        catch (Exception e) {
            if (!(e instanceof ControlFlowException)) {
                ClangUtils.warnClangd((Logger)LOG, (Throwable)e);
            }
            Pair<List<DfaTuple>, Map<Attribute, IrLocation>> pair = null;
            return pair;
        }
        finally {
            long timeEnd = System.currentTimeMillis();
            ClangUtils.warnClangd((Logger)LOG, (String)("clangd DFA input builder finished: " + file.getName() + " - " + (double)(timeEnd - timeStart) / 1000.0 + " sec"));
        }
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static DfaAnalysisRmlResult computeDFA(@NotNull OCDFAInput dfaInput, Project project, long timeLimit, long perFunctionTimeLimit, int maxTasksPerTime, RMLOptions rMLOptions, @Nullable VirtualFile virtualFile) {
        void file;
        void options;
        if (dfaInput == null) {
            OCDFAInspectionBaseRunner.$$$reportNull$$$0(1);
        }
        return OCDFAInspectionBaseRunner.computeDFA(dfaInput, project, timeLimit, perFunctionTimeLimit, maxTasksPerTime, (RMLOptions)options, null, (VirtualFile)file);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static DfaAnalysisRmlResult computeDFA(@NotNull OCDFAInput dfaInput, Project project, long timeLimit, long perFunctionTimeLimit, int maxTasksPerTime, RMLOptions options, @Nullable DfaMeasurementRunner dfaMeasurementRunner, @Nullable VirtualFile virtualFile) {
        void benchmarkRunner;
        void file;
        if (dfaInput == null) {
            OCDFAInspectionBaseRunner.$$$reportNull$$$0(2);
        }
        long start2 = System.currentTimeMillis();
        DfaDebugProvider debugProvider = DfaDebugProvider.Companion.getInstance((Language)OCLanguage.getInstance());
        options.set(AnalysisOptions.INSTANCE.getAnalysisTimeLimitMs(), (Object)timeLimit);
        options.set(AnalysisOptions.INSTANCE.getFunctionEvaluationTimeLimitMs(), (Object)perFunctionTimeLimit);
        if (maxTasksPerTime == -1) {
            maxTasksPerTime = (Integer)AnalysisOptions.INSTANCE.getMaxTasksPerTime().getDefaultValue();
        }
        options.set(AnalysisOptions.INSTANCE.getMaxTasksPerTime(), (Object)maxTasksPerTime);
        options.set(AnalysisOptions.INSTANCE.getEnableLogging(), (Object)debugProvider.getLogEnabled());
        if (file == null) {
            options.set(AnalysisOptions.INSTANCE.getUseDiskProvidersStorage(), (Object)true);
        }
        DfaSummarySession session = DfaSessionProvider.Companion.getInstance().createSummarySession(OCSourceGliderService.getInstance().getDescription(), options);
        DfaSessionDebugRegistrar.Companion.getInstance().registerSession(session, (Language)OCLanguage.getInstance(), project);
        if (file != null && Registry.is((String)"cidr.inspection.dfa.enable.fus")) {
            DfaStatisticsMeasurement statisticsMeasurement = new DfaStatisticsMeasurement(maxTasksPerTime, (VirtualFile)file);
            statisticsMeasurement.setHasErrors(ContainerUtil.exists((Iterable)dfaInput.getAllFunctionTuples().values(), tuple -> tuple.getRelation().equals("HasErrors")));
            session.registerMeasurement((DfaMeasurementRunner)statisticsMeasurement);
        }
        if (benchmarkRunner != null) {
            session.registerMeasurement((DfaMeasurementRunner)benchmarkRunner);
        }
        List<DfaTuple> globalTuples = OCContextSensitiveBuilder.Companion.getGlobalTuples(dfaInput.getCommonTuples());
        List<DfaTuple> predefinedTuples = OCContextSensitiveBuilder.Companion.getPredefinedTuples();
        Graph<Attribute> callGraph = OCContextSensitiveBuilder.Companion.buildCallGraph(dfaInput.getCommonTuples());
        HashMap<IrFunctionID, Map<PathSensitiveMode, List<DfaTuple>>> functions = new HashMap<IrFunctionID, Map<PathSensitiveMode, List<DfaTuple>>>();
        for (Attribute function2 : callGraph.nodes()) {
            if (function2 == null) continue;
            functions.put(new IrFunctionID(function2), OCDFAInspectionBaseRunner.preprocessTuples(function2, dfaInput.getFunctionTuples(function2).stream().toList()));
        }
        DfaAnalysisRmlResult result2 = session.runDfaForProject(functions, globalTuples, predefinedTuples, callGraph, dfaInput.getLocations());
        if (debugProvider.getLogEnabled()) {
            LOG.warn("DFA finished in " + FormatHelperKt.formatDuration((long)(System.currentTimeMillis() - start2)) + "; total files size: " + FormatHelperKt.formatMemorySize((long)dfaInput.getFilesSize()));
        }
        return result2;
    }

    private static Map<PathSensitiveMode, List<DfaTuple>> preprocessTuples(Attribute function2, List<DfaTuple> tuples) {
        HashMap<PathSensitiveMode, List<DfaTuple>> result2 = new HashMap<PathSensitiveMode, List<DfaTuple>>();
        OCContextSensitiveBuilder builder2 = new OCContextSensitiveBuilder(function2, tuples, new Cancellation(){

            public void checkCancelled() throws CancellationException {
                ProgressManager.checkCanceled();
            }
        });
        for (PathSensitiveMode mode : PathSensitiveMode.getEntries()) {
            List<DfaTuple> list2 = builder2.getTuples(mode == PathSensitiveMode.PathSensitive);
            if (list2 == null) continue;
            result2.put(mode, list2);
        }
        return result2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static OCDFAInput getDFAInput(@NotNull List<VirtualFile> files2, Project project, boolean isBatchMode) {
        ClangdIndexerService languageService;
        if (files2 == null) {
            OCDFAInspectionBaseRunner.$$$reportNull$$$0(3);
        }
        ClangLanguageServiceProvider provider2 = Objects.requireNonNull(ClangLanguageServiceProvider.getProvider((Project)project));
        Object object = languageService = isBatchMode ? provider2.getOrStartStatelessIndexer() : provider2.getOrStart();
        if (isBatchMode && languageService == null) {
            languageService = provider2.getOrStart();
        }
        if (languageService == null) {
            return null;
        }
        ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
        ClionClangDFAConfigParams batchModeClangParams = new ClionClangDFAConfigParams(OCDFAInspectionConfigUtil.isInspectHeaderFunctionsMode(null), -1);
        if (isBatchMode && languageService.isIndexer()) {
            ClangdIndexerService indexer = languageService;
            ClangUrlConverter urlConverter = languageService.getUrlConverter();
            DfaInputBuilder builder2 = new DfaInputBuilder();
            AtomicInteger processedFiles = new AtomicInteger(0);
            List futures = ContainerUtil.map((Iterable)ContainerUtil.zip(files2, (Iterable)indexer.getDfaInput(files2, batchModeClangParams)), it -> {
                VirtualFile file = (VirtualFile)it.first;
                @Nullable CompletableFuture resultFuture = (CompletableFuture)it.second;
                return ((CompletableFuture)resultFuture.thenApply(tuples -> tuples != null ? DFATuplesParserKt.parseDFATuples(tuples.collect(Collectors.toList()), urlConverter) : null)).thenAccept(input2 -> {
                    indicator.setText(OCInspectionsBundle.message((String)"dfa.message.preparing", (Object[])new Object[]{file.getName()}));
                    indicator.setFraction((double)processedFiles.incrementAndGet() / (double)(files2.size() * 3));
                    if (input2 != null) {
                        builder2.addInput((Pair<List<DfaTuple>, Map<Attribute, IrLocation>>)input2, file);
                    }
                });
            });
            try {
                for (CompletableFuture future : futures) {
                    CidrConcurrentUtilsKt.waitCancelAware((Future)future, (String)"get dfa input");
                }
                OCDFAInput oCDFAInput = builder2.build();
                return oCDFAInput;
            }
            catch (ExecutionException e) {
                OCDFAInput oCDFAInput = null;
                return oCDFAInput;
            }
            finally {
                if (ContainerUtil.exists((Iterable)futures, it -> !it.isDone())) {
                    indexer.executeCommand(ClangIndexerCommand.Companion.getCANCEL());
                }
            }
        }
        DfaInputBuilder builder3 = new DfaInputBuilder();
        try {
            if (isBatchMode) {
                project.putUserData(ClangIdeFacade.CLANG_DFA_CONFIG, Optional.of(batchModeClangParams));
            }
            for (int i = 0; i < files2.size(); ++i) {
                VirtualFile file = files2.get(i);
                Pair<List<DfaTuple>, Map<Attribute, IrLocation>> curInput = OCDFAInspectionBaseRunner.getDFAInput(file, isBatchMode, (ClangLanguageService)languageService);
                indicator.setText(OCInspectionsBundle.message((String)"dfa.message.preparing", (Object[])new Object[]{file.getName()}));
                indicator.setFraction((double)i / (double)(files2.size() * 3));
                indicator.checkCanceled();
                builder3.addInput(curInput, file);
            }
        }
        finally {
            if (isBatchMode) {
                project.putUserData(ClangIdeFacade.CLANG_DFA_CONFIG, null);
            }
        }
        return builder3.build();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dfaInput";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/cidr/lang/dfa/OCDFAInspectionBaseRunner";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getDFAInput";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "computeDFA";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class DfaInputBuilder {
        private final MultiMap<Attribute, DfaTuple> functionTuples = new MultiMap();
        private final List<DfaTuple> commonTuples = new ArrayList<DfaTuple>();
        private final Set<Attribute> processedFunctions = new HashSet<Attribute>();
        private final Map<Attribute, IrLocation> locations = new HashMap<Attribute, IrLocation>();
        long totalSize = 0L;

        private DfaInputBuilder() {
        }

        public void addInput(@Nullable Pair<List<DfaTuple>, Map<Attribute, IrLocation>> input2, VirtualFile file) {
            if (input2 == null) {
                return;
            }
            HashSet<Attribute> curFunctions = new HashSet<Attribute>();
            this.totalSize += new File(file.getPath()).length();
            this.locations.putAll((Map)input2.component2());
            for (DfaTuple tuple : (List)input2.component1()) {
                Attribute function2 = tuple.getFunction();
                if (function2 != null && this.processedFunctions.contains(function2)) continue;
                curFunctions.add(function2);
                if (function2 == null) {
                    this.commonTuples.add(tuple);
                    continue;
                }
                this.functionTuples.putValue((Object)function2, (Object)tuple);
            }
            this.processedFunctions.addAll(curFunctions);
        }

        public OCDFAInput build() {
            return new OCDFAInput(this.functionTuples, this.commonTuples, this.locations, this.totalSize);
        }
    }
}

