/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.cidr.cpp.actions.CLionShowAssemblyFuncInfoProvider;
import com.jetbrains.cidr.lang.psi.OCFunctionDefinition;
import com.jetbrains.cidr.lang.symbols.OCQualifiedName;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lcom/jetbrains/cidr/lang/OCShowAssemblyFuncInfoProvider;", "Lcom/jetbrains/cidr/cpp/actions/CLionShowAssemblyFuncInfoProvider;", "()V", "getFuncInfo", "Lcom/jetbrains/cidr/cpp/actions/CLionShowAssemblyFuncInfoProvider$FuncInfo;", "editor", "Lcom/intellij/openapi/editor/Editor;", "offset", "", "intellij.clion.oc"})
public final class OCShowAssemblyFuncInfoProvider
implements CLionShowAssemblyFuncInfoProvider {
    @Override
    @Nullable
    public CLionShowAssemblyFuncInfoProvider.FuncInfo getFuncInfo(@NotNull Editor editor, int offset) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Project project = editor.getProject();
        if (project == null) {
            return null;
        }
        Project project2 = project;
        return (CLionShowAssemblyFuncInfoProvider.FuncInfo)ApplicationManager.getApplication().runReadAction(() -> OCShowAssemblyFuncInfoProvider.getFuncInfo$lambda$0(editor, project2, offset));
    }

    private static final CLionShowAssemblyFuncInfoProvider.FuncInfo getFuncInfo$lambda$0(Editor $editor, Project $project, int $offset) {
        PsiElement psiElement;
        Intrinsics.checkNotNullParameter((Object)$editor, (String)"$editor");
        Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
        Document document = $editor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        Document document2 = document;
        PsiFile file = PsiDocumentManager.getInstance((Project)$project).getPsiFile(document2);
        try {
            PsiFile psiFile = file;
            psiElement = psiFile != null ? psiFile.findElementAt($offset) : null;
        }
        catch (ProcessCanceledException e) {
            psiElement = null;
        }
        PsiElement element2 = psiElement;
        OCFunctionDefinition definition = (OCFunctionDefinition)PsiTreeUtil.getParentOfType((PsiElement)element2, OCFunctionDefinition.class);
        if (definition == null) {
            return null;
        }
        OCFunctionSymbol symbol = definition.getSymbol();
        if (symbol != null) {
            String name2;
            OCResolveContext oCResolveContext = OCResolveContext.forSymbol((OCSymbol)((OCSymbol)symbol), (Project)$project);
            Intrinsics.checkNotNullExpressionValue((Object)oCResolveContext, (String)"forSymbol(...)");
            OCResolveContext ctx = oCResolveContext;
            OCQualifiedName oCQualifiedName = symbol.getResolvedQualifiedName(ctx);
            String string = name2 = oCQualifiedName != null ? oCQualifiedName.getFullName(ctx) : null;
            if (name2 != null) {
                TextRange definitionTextRange = definition.getTextRange();
                int startLine0 = document2.getLineNumber(definitionTextRange.getStartOffset());
                int endLine0 = document2.getLineNumber(definitionTextRange.getEndOffset()) + 1;
                return new CLionShowAssemblyFuncInfoProvider.FuncInfo(name2, new IntRange(startLine0 + 1, endLine0 + 1));
            }
        }
        return null;
    }
}

